from qgis.PyQt.QtCore import QCoreApplication

def tr(text):
    return QCoreApplication.translate("GestionForestiere", text)

TYPE_PARC_LIBELLES = {
    1: tr("Pré"),
    2: tr("Semis (jusque 2m)"),
    3: tr("Gaulis (2 à 6m)"),
    4: tr("Jeune futaie (diam 11 à 25)"),
    5: tr("Futaie adulte (diam > 25)"),
    6: tr("Vieille Futaie"),
    7: tr("Futaie Irrégulière"),
    8: tr("Taillis"),
    9: tr("Friche bouleaux"),
    10: tr("Régénération naturelle"),
    11: tr("Vente en cours"),
    12: tr("Achat en cours"),
    13: tr("Echanges"),
    14: tr("Friche Feuillus"),
    15: tr("Perchis (diam 6 à 10)"),
}

# Références cadastres étrangers

CADASTRE_FORMATS = sorted([
    "Luxembourg",
    "Belgique",
    "Suisse",
    "Sénégal",
    "Côte d’Ivoire",
    "Bénin",
    "Burkina Faso",
    "Togo",
    "Mali",
    "Niger",
    "Suisse",
])


def get_type_parc_libelle(code):
    return TYPE_PARC_LIBELLES.get(code, "")

# 🔥 Nouveau : dictionnaire qui décrit le nombre de combobox par onglet - Variables globales
SAISIE_COMBO_COUNTS = {
    "plant": 4,
    "Tvx": 6,
    "Trait": 6,
    "Prev": 4,
}

# 🔧 Paramètres pour remplir les combos de saisie (prefix, nom du combo, index de colonne)
SAISIE_COMBO_SETTINGS = [
    ("plant","comboPlant",0),
    ("Tvx", "comboTvx", 1),
    ("Trait", "comboTrait", 2),
    ("Prev", "comboPrev", 1),
]

# Version en cours
PLUGIN_VERSION = "1.5.7"