# Changelog

## [1.5.5] - 2026-02-01
- Fixed a bug that caused multiple child entity creation. Only the first one was visible.
- Corrected the Lat.Long text to Long/Lat in the main window.
- Added a parcel grouping button that allows you to easily group several parcels as well as elements from the old parcel table.

## [1.5.4] - 2025-11-24
- Fixed an issue where the currency symbol was not displaying correctly in the income/expense input field.
- Improved the child entity creation tool, which now uses the snapping tool on the parent entity's vertex with a tolerance. The cursor changing as you approach the vertex indicates that the vertex will be used.

## [1.5.3] - 2025-11-17
- Moved the total number of parcels in the municipality to the General Data tab.
- Removed meadows and pending purchases from the various calculations of area and number of parcels.
- Right-aligned the Rate field.
- Added a prixAct field allowing users to enter an updated parcel price, with automatic creation of the new field if necessary.
- Setting up currency symbols according to local Qgis parameters.
- Removed the message during updates indicating that a reconfiguration was required for versions prior to 1.3.0.
- Minor corrections to English translations.

##[1.5.2] - 2025-11-10
- Added QGIS4 compatibility information.
- Added a tab for analyzing current purchases and trades, including a list and total.
- Corrected and added English translations.

##[1.5.1] - 2025-11-03
- QGIS Qt6 compatibility validation.
- Improved Excel export functionality:
automatic column adjustment, ability to create multiple sheets within the same workbook.
More precise control and a message if the Excel file is already open.
- Added several translations.

## [1.5.0] - 2025-10-28
- Experimental version compatible with Qt5/QGIS 3.x and Qt6/QGIS 3.99
- Corrections and adaptations of Qt constants for Qt5/QT6 compatibility
- Minor adjustments to deprecated Python functions
- Functional tests on forms, TableWidgets, and QMessageBox
- This version is still in the testing phase; some features may change.

## [1.4.5] - 2025-10-26
- Fixed a bug that prevented deleting a child feature after exiting QGIS. You had to recreate a child feature to enable the geometry cache.
- Added a plantation type list when creating a child feature in the creation form.

## [1.4.4] - 2025-08-31
- Improved alert handling for layers incompatible with the plugin, limiting alert boxes and silently exiting the plugin on incompatible layers.
- More control over layer compatibility when switching to other QGIS tools.
- Visual improvements to the "About" and "Search" buttons.

## [1.4.3] - 2025-07-22
- Dynamic layer change management. Now, if you change layers, the information updates dynamically.
- Improved code to eliminate lags at startup and when saving new data to table_data.
- Return to the QGIS cursor each time the plugin is loaded.
- Updated the Analysis tab and calculations at the same time as layer changes.
- Fixed a silent error causing QGIS to crash if the user loads the plugin without validating a layer, plus an informational message.
- Message indicating "calculations in progress" if the user changes layers during analysis calculations.

## [1.4.2] - 2025-07-14
- Added an Excel export of owned plots with area, value, acquisition date, totals, and subtotals by type.
- Fixed Qdate fields with the current date.
- Fixed a legend display issue for the "meadow" type.
- Fixed various minor bugs.
- Improved tooltips and translation.
- Fix bug exporting work, processing, forecasts to Excel
- Changed the 'prix' field to integer format.
- Modified the financial file to add one file per layer.
- Added a button to open the financial file (*.csv) to delete the required lines.
- Fixed a bug in the financial file if it didn't exist initially.

## [1.4.1] - 2025-07-10
- Changed the location of the table_data.csv file in the data directory to R/W.
- Added a Financial tab to display your income and expenses.
- Added a plot price field.
- Created a specific configuration for the following countries:
"Luxembourg", "Belgium", "Switzerland", "Senegal", "Ivory Coast", "Benin", "Burkina Faso", "Togo", "Mali", "Niger".
- Mandatory passage through the configuration mode of V1.3.3 --> V1.4.x.

## [1.3.3] - 2025-07-01
- Added a function to automatically create section and number fields if they do not exist in the layer (EDIGEO format).
- Added a box to deactivate the section field during configuration (Swiss land registry compatibility).
- Modified configuration help files V1.3

## [1.3.2] - 2025-06-28
- Improved setup time with dynamic hourglass.
- Added a message if the layer name already exists when converting a layer to .gpkg.

## [1.3.1] - 2025-06-26
- Added a button to search for a plot in the layer.
- Minor fixes to text fields, labels, and buttons.
- Fixed hourglass not appearing when creating fields and automatic closing of the conversion window at the end of the configuration.

## [1.3.0] - 2025-06-18
- Added a button to delete a child entity with a D566a index.
- English translation
- Help updated
- Created a "resources" directory to store the table_data.csv file and symbilogy files fr ans en.

## [1.2.1] - 2025-06-13
- Added validation to ensure the "indice" field is unique when creating an entity within a parcel.
- Added a Cancel button in the dialog window to allow aborting the entity creation.

## [1.2.0] - 2025-06-11
- Added automatic conversion of the required layer to .gpkg format.
- Improved compatibility with Python versions earlier than 3.11 (itertools.batched).
- Various minor adjustments.

## [1.01] - 2025-06-11
### Fixed
- Fixed the size of the "Remarks" text area in the interface.
- Added an "About" window in the main window.

## [1.0] - 2025-06-09
### Initial release
- First functional version of the "Gestion forestière" plugin.
- Main interface with tabs and input fields.
- Basic features implemented.