from PyQt5.QtWidgets import QDialog
from .create_fields import Ui_FieldCreate

class CreateFieldsDialog(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.ui = Ui_FieldCreate()
        self.ui.setupUi(self)
        self.resultat = None  # "remplir", "vide", ou None si annulé
        self.no_section = False  # True si case cochée

        # Connexions des boutons
        self.ui.btnFieldFull.clicked.connect(self.choix_plein)
        self.ui.btnFieldEmpty.clicked.connect(self.choix_vide)
        self.ui.btnCancel.clicked.connect(self.annuler)

    def choix_plein(self):
        self.resultat = "remplir"
        self.no_section = self.ui.checkNoSection.isChecked()
        self.accept()

    def choix_vide(self):
        self.resultat = "vide"
        self.no_section = self.ui.checkNoSection.isChecked()
        self.accept()

    def annuler(self):
        self.resultat = None
        self.reject()
