# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeovitaProcessingPlugin
                                 A QGIS plugin
 This plugin adds different geovita processing plugins
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-02
        copyright            : (C) 2022 by DPE
        email                : dpe@geovita.no
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

__author__ = 'DPE'
__date__ = '2024-01-17'
__copyright__ = '(C) 2024 by DPE'

import sys
import configparser
from pathlib import Path
from importlib import metadata


PACKAGE_NAME = 'geovita-processing-plugin'
_FALLBACK_VERSION = '0.0.0'
_PLUGIN_DIR = Path(__file__).resolve().parent
_PYPROJECT_CANDIDATES = (
    _PLUGIN_DIR / 'pyproject.toml',
    _PLUGIN_DIR.parent / 'pyproject.toml',
)
_METADATA_FILE = _PLUGIN_DIR / 'metadata.txt'


def _read_version_from_pyproject() -> str | None:
    """Return the version declared in pyproject.toml if available."""

    try:
        import tomllib  # type: ignore[attr-defined]
    except ModuleNotFoundError:  # pragma: no cover - only on Python <3.11 without tomli
        try:
            import tomli as tomllib  # type: ignore[no-redef]
        except ModuleNotFoundError:
            return None

    for candidate in _PYPROJECT_CANDIDATES:
        if not candidate.is_file():
            continue
        with candidate.open('rb') as fh:
            data = tomllib.load(fh)
        return data.get('project', {}).get('version')
    return None


def _read_version_from_metadata() -> str | None:
    """Return the version declared in metadata.txt if available."""

    if not _METADATA_FILE.is_file():
        return None

    parser = configparser.ConfigParser()
    parser.optionxform = str
    parser.read(_METADATA_FILE, encoding='utf-8')
    try:
        return parser.get('general', 'version')
    except (configparser.NoSectionError, configparser.NoOptionError):
        return None


def _determine_version() -> str:
    """Resolve the plugin version from packaging metadata or local files."""

    try:
        return metadata.version(PACKAGE_NAME)
    except metadata.PackageNotFoundError:  # type: ignore[attr-defined]
        pass

    for reader in (_read_version_from_pyproject, _read_version_from_metadata):
        version = reader()
        if version:
            return version
    return _FALLBACK_VERSION


__version__ = _determine_version()


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load GeovitaProcessingPlugin class from file GeovitaProcessingPlugin.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    # Directory of the current file (__init__.py)
    plugin_dir = Path(__file__).parent

    # Add the plugin directory to sys.path if not already there
    if str(plugin_dir) not in sys.path:
        sys.path.append(str(plugin_dir))

    # If you need to add the submodule directory to sys.path
    submodule_dir = plugin_dir / "REMEDY_GIS_RiskTool"
    if str(submodule_dir) not in sys.path:
        sys.path.append(str(submodule_dir))

    # The styles are provided in a styles.zip archive. 
    # It is neccessary to extract them the first time the plugin is loaded
    styles_dir = plugin_dir / "styles"
    if not styles_dir.is_dir():
        import zipfile
        import os
        # Ensure the styles directory exists
        # styles_dir.mkdir(parents=True, exist_ok=True)
        with zipfile.ZipFile(plugin_dir / 'styles.zip', 'r') as zip_ref:
            zip_ref.extractall(plugin_dir)
        os.remove(plugin_dir / 'styles.zip')

    # Now you can import your main plugin class
    from .geovita_processing_plugin import GeovitaProcessingPluginPlugin
    return GeovitaProcessingPluginPlugin(iface, __version__)