# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoValleCVC
                                 A QGIS plugin
 PlugIn para QGIS - Modelo Geoidal CVC del Valle del Cauca v2
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-01-10
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Andres Herrera
        email                : fandresherrera@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
from PyQt5.QtCore import *
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon,QValidator
from PyQt5.QtGui import  QDoubleValidator
from qgis.PyQt.QtWidgets import QAction, QMessageBox, QTableWidgetItem, QHeaderView, QAbstractItemView, QProgressBar, QProgressDialog
from qgis._core import Qgis, QgsRasterLayer, QgsProject,QgsMessageLog
from osgeo.gdal import *  
from osgeo.gdalnumeric import *  
from osgeo.gdalconst import * 

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .geovallecvc_dialog import GeoValleCVCDialog
import os.path

from .com.utils import *
import ogr, osr

from string import Template
from string import capwords
import datetime
import codecs
import struct


class GeoValleCVC:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'GeoValleCVC_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&GeoValleCVC')

        self.dlg = GeoValleCVCDialog()
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('GeoValleCVC', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/geovallecvc/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'GeoValleCVC'),
            callback=self.run,
            parent=self.iface.mainWindow())

        self.dlg.close_btn.clicked.connect(self.closeDlg)
        
        self.dlg.calcCoordPlanas.clicked.connect(self.calcCoordPlanasAction)
        self.dlg.calcCoordArena.clicked.connect(self.calcCoordArenaAction)
        self.dlg.calcCoordDMS.clicked.connect(self.calcCoordDMSAction)
        self.dlg.calcCoordDeg.clicked.connect(self.calcCoordDegAction)
        
        self.dlg.clearForm1Btn.clicked.connect(self.clearForm1)
        self.dlg.clearForm2Btn.clicked.connect(self.clearForm2)
        self.dlg.clearForm3Btn.clicked.connect(self.clearForm3)
        self.dlg.clearForm4Btn.clicked.connect(self.clearForm4)
        
        # will be set False in run()
        self.first_start = True
    
    def closeDlg(self):
        self.dlg.close()

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&GeoValleCVC'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        self.dlg.show()
        result = self.dlg.exec_()
        if result:
            pass

    def calcCoordPlanasAction(self):
        if self.dlg.cp_n.text().strip() and self.dlg.cp_e.text().strip():
            self.readRaster_Planas()
        else:
            QMessageBox.critical(None,"Mensaje", u"Debe indicar unas coordenadas !")

    def calcCoordArenaAction(self):
        if self.dlg.ca_n.text().strip() and self.dlg.ca_e.text().strip():
            self.readRaster_Arena()
        else:
            QMessageBox.critical( None,"Mensaje", u"Debe indicar unas coordenadas !")

    def calcCoordDegAction(self):
        if self.dlg.cgd_w.text().strip() and self.dlg.cgd_n.text().strip():
            self.readRaster_GeograficasDecimales()
        else:
            QMessageBox.critical( None,"Mensaje", u"Debe indicar unas coordenadas !")

    def calcCoordDMSAction(self):
        if self.dlg.cgms_lon_g.text().strip() and self.dlg.cgms_lon_m.text().strip() and self.dlg.cgms_lon_s.text().strip() and self.dlg.cgms_lat_g.text().strip() and self.dlg.cgms_lat_m.text().strip() and self.dlg.cgms_lat_s.text().strip():
            self.readRaster_GeograficasGMS()
        else:
            QMessageBox.critical( None,"Mensaje", u"Debe indicar unas coordenadas !")

    def clearForm1(self):
        self.dlg.cp_e.setText("")
        self.dlg.cp_n.setText("")
        self.dlg.cp_r.setText("")

    def clearForm2(self):
        self.dlg.ca_e.setText("")
        self.dlg.ca_n.setText("")
        self.dlg.ca_r.setText("")

    def clearForm3(self):
        self.dlg.cgms_lon_g.setText("")
        self.dlg.cgms_lon_m.setText("")
        self.dlg.cgms_lon_s.setText("")
        self.dlg.cgms_lat_g.setText("")
        self.dlg.cgms_lat_m.setText("")
        self.dlg.cgms_lat_s.setText("")
        self.dlg.cgms_r.setText("")

    def clearForm4(self):
        self.dlg.cgd_w.setText("")
        self.dlg.cgd_n.setText("")
        self.dlg.cgd_r.setText("")
        
    def coordsCalculator(self,x,y,iepsg,oepsg):
        self.plugin_dir = os.path.dirname(__file__)
        fileName=os.path.join(self.plugin_dir, 'geoid','geoide_1mm_w.tif')
        QgsMessageLog.logMessage(fileName)
        ds = gdal.Open(fileName, GA_ReadOnly ) 
        if ds is None:
            QMessageBox.critical( None,"Error", "No se pudo abrir el Geoide !")
        pointX = float(x) 
        pointY = float(y)
        QgsMessageLog.logMessage(str(pointX)+","+str(pointY))
        # Spatial Reference System
        inputEPSG = iepsg
        outputEPSG = oepsg
        # create a geometry from coordinates
        point = ogr.Geometry(ogr.wkbPoint)
        point.AddPoint(pointY,pointX)
        # create coordinate transformation
        inSpatialRef = osr.SpatialReference()
        inSpatialRef.ImportFromEPSG(inputEPSG)
        outSpatialRef = osr.SpatialReference()
        outSpatialRef.ImportFromEPSG(outputEPSG)
        coordTransform = osr.CoordinateTransformation(inSpatialRef, outSpatialRef)
        # transform point
        point.Transform(coordTransform)
        # print point in EPSG 4326
        x=point.GetY()
        y=point.GetX()
        #QgsMessageLog.logMessage("x:"+str(x)+",y:"+str(y))
        transf = ds.GetGeoTransform()
        #QgsMessageLog.logMessage("transf:"+str(transf))
        cols = ds.RasterXSize
        rows = ds.RasterYSize
        bands = ds.RasterCount #1
        band = ds.GetRasterBand(1)
        bandtype = gdal.GetDataTypeName(band.DataType) #Int16
        driver = ds.GetDriver().LongName #'GeoTIFF'
        # set a default NDV if none specified
        if (band.GetNoDataValue() == None):
            band.SetNoDataValue(-9999)
        ndv = band.GetNoDataValue()
        cellSizeX = transf[1]
        cellSizeY = -1 * transf[5]
        minx = transf[0]
        maxy = transf[3]
        maxx = minx + (cols * cellSizeX)
        miny = maxy - (rows * cellSizeY)
        if ((x < minx) or (x > maxx) or (y < miny) or (y > maxy)):
            QMessageBox.critical( None,"Error", "El punto indicado no se encuentra dentro del Geoide del Valle!")
            QgsMessageLog.logMessage('given point does not fall within grid')
            return ndv
        # calc point location in pixels
        xLoc = (x - minx) / cellSizeX
        xLoc = int(xLoc)
        yLoc = (maxy - y) / cellSizeY
        yLoc = int(yLoc)
        if ((xLoc < 0.5) or (xLoc > cols - 0.5)):
            return ndv
        if ((yLoc < 0.5) or (yLoc > rows - 0.5)):
            return ndv
        structval = band.ReadRaster(xLoc, yLoc, 1, 1, 1, 1, buf_type = band.DataType )
        if (bandtype == 'Int16'):
            dblValue = struct.unpack('h', structval)
        elif (bandtype == 'Float32'):
            dblValue = struct.unpack('f', structval)
        elif (bandtype == 'Byte'):
            dblValue = struct.unpack('B', structval)
        else:
            QMessageBox.critical( None,"Error", 'unrecognized DataType: ' +bandtype  )
            return ndv
        return dblValue[0] 
    
    def readRaster_Planas(self):
        QgsMessageLog.logMessage("Calcular Ondulacion Geoidal - Coordenadas planas MAGNA")
        self.dlg.cp_e.setValidator(QDoubleValidator())
        self.dlg.cp_n.setValidator(QDoubleValidator())
        pointX = float(self.dlg.cp_e.text()) 
        pointY = float(self.dlg.cp_n.text())
        inputEPSG = 3115
        outputEPSG = 4326
        result=self.coordsCalculator(pointX,pointY,inputEPSG,outputEPSG)
        QgsMessageLog.logMessage("Result: "+str( result ) )
        self.dlg.cp_r.setText(  str( result )   )
        QMessageBox.information( None,"Resultado", u"Ondulación geoidal calculada !")
    
    def readRaster_Arena(self):
        QgsMessageLog.logMessage("Calcular Ondulacion Geoidal - Coordenadas planas ARENA")
        self.dlg.ca_e.setValidator(QDoubleValidator())
        self.dlg.ca_n.setValidator(QDoubleValidator())
        pointX = float(self.dlg.ca_e.text()) 
        pointY = float(self.dlg.ca_n.text())
        inputEPSG = 21896
        outputEPSG = 4326
        result=self.coordsCalculator(pointX,pointY,inputEPSG,outputEPSG)
        QgsMessageLog.logMessage("Result: "+str( result ) )
        self.dlg.ca_r.setText(  str( result )   )
        QMessageBox.information( None,"Resultado", u"Ondulación geoidal calculada !")
    
    def readRaster_GeograficasGMS(self):
        QgsMessageLog.logMessage("Calcular Ondulacion Geoidal - Coordenadas Geograficas DMS")
        self.dlg.cgms_lon_g.setValidator(QDoubleValidator())
        self.dlg.cgms_lon_m.setValidator(QDoubleValidator())
        self.dlg.cgms_lon_s.setValidator(QDoubleValidator())
        self.dlg.cgms_lat_g.setValidator(QDoubleValidator())
        self.dlg.cgms_lat_m.setValidator(QDoubleValidator())
        self.dlg.cgms_lat_s.setValidator(QDoubleValidator())
        lon_g=float(self.dlg.cgms_lon_g.text())
        lon_m=float(self.dlg.cgms_lon_m.text())
        lon_s=float(self.dlg.cgms_lon_s.text())
        lat_g=float(self.dlg.cgms_lat_g.text())
        lat_m=float(self.dlg.cgms_lat_m.text())
        lat_s=float(self.dlg.cgms_lat_s.text())
        x=(abs(lon_g) + (abs(lon_m)/60)+(abs(lon_s)/3600))*-1;
        y=(abs(lat_g) + (abs(lat_m)/60)+(abs(lat_s)/3600));
        pointX = float(x) 
        pointY = float(y)
        inputEPSG = 4326
        outputEPSG = 4326
        result=self.coordsCalculator(pointX,pointY,inputEPSG,outputEPSG)
        QgsMessageLog.logMessage("Result: "+str( result ) )
        self.dlg.cgms_r.setText(  str( result )   )
        QMessageBox.information( None,"Resultado", u"Ondulación geoidal calculada !")
        
    def readRaster_GeograficasDecimales(self):
        QgsMessageLog.logMessage("Calcular Ondulacion Geoidal - Coordenadas Geograficas DMS")
        self.dlg.cgd_w.setValidator(QDoubleValidator())
        self.dlg.cgd_n.setValidator(QDoubleValidator())
        x=float(self.dlg.cgd_w.text())
        y=float(self.dlg.cgd_n.text())
        pointX = float(x) 
        pointY = float(y)
        inputEPSG = 4326
        outputEPSG = 4326
        result=self.coordsCalculator(pointX,pointY,inputEPSG,outputEPSG)
        QgsMessageLog.logMessage("Result: "+str( result ) )
        self.dlg.cgd_r.setText(  str( result )   )
        QMessageBox.information( None,"Resultado", u"Ondulación geoidal calculada !")

