#! python3  # noqa: E265

"""
Authentication dialog logic.
"""

# standard
from pathlib import Path

# PyQGIS
from pyplugin_installer.installer import QgsPluginInstaller
from qgis.PyQt import uic
from qgis.PyQt.QtGui import QIcon, QPixmap
from qgis.PyQt.QtWidgets import QDialog

# Plugin
from geotuileur.__about__ import DIR_PLUGIN_ROOT, __icon_path__


class DeprecationDialog(QDialog):
    def __init__(self, parent=None):
        """Dialog to display geotuileur deprecation message..

        :param parent: parent widget, defaults to None
        :type parent: QObject, optional
        """
        # init module and ui
        super().__init__(parent)
        uic.loadUi(Path(__file__).parent / "{}.ui".format(Path(__file__).stem), self)

        self.setWindowIcon(QIcon(str(__icon_path__)))

        deprecation_message = self.tr(
            """Back in 2022, this plugin was backed by [the geotuileur portal](https://geoservices.ign.fr/actualites/2022-10-06-geotuileur),
            which foreshadowed the ambitious Geoplatform project integrating the redesign
            of the Entrepôt API on the backend and the cartes.gouv.fr portal on the frontend.
            Now it is time for this plugin to make way for [the Géoplateforme plugin](https://plugins.qgis.org/plugins/geoplateforme/),
            built on its technical foundations, honoring the project's open source license.
            Click below to install the new Geoplateforme plugin and uninstall Geotuileur.
            """
        )

        self.txt_deprecation_message.setMarkdown(deprecation_message)
        self.txt_deprecation_message.setStyleSheet(
            "background: transparent; border: 0px solid gray;"
        )

        self.qgis_plugin_installer = QgsPluginInstaller()
        pixmap = QPixmap(
            str(
                DIR_PLUGIN_ROOT
                / "resources"
                / "images"
                / "logo_plugin_geoplateforme.svg"
            )
        )  # chemin vers ton image
        self.lbl_geoplateforme_logo.setPixmap(pixmap)
        self.lbl_geoplateforme_logo.setFixedSize(200, 200)
        self.btn_install.clicked.connect(self.install_new_plugin)

    def install_new_plugin(self):
        self.deleteLater()
        self.close()
        self.qgis_plugin_installer.exportPluginsToManager()
        self.qgis_plugin_installer.fetchAvailablePlugins(0)  # 0 = ReloadAll
        self.qgis_plugin_installer.installPlugin("geoplateforme", stable=False)
        self.qgis_plugin_installer.uninstallPlugin("geotuileur")
