<div id="top"></div>
<!-- PROJECT SHIELDS -->
<!--
*** See the bottom of this document for the declaration of the reference variables
*** https://www.markdownguide.org/basic-syntax/#reference-style-links
-->


<!-- PROJECT LOGO -->
<br />
<p align="center">
  <a href="https://github.com/earthdaily">
<img src="https://raw.githubusercontent.com/GEOSYS/qgis-plugin-doc/master/pictures/EarthDaily.png">
  </a>

  <h1 align="center">QGIS Plugin</h3>

  <p align="center">
    To be able to discover, request and use imagery products based on virtual constellation within QGIS, using the EarthDaily API.
    <br />
    <a href="https://earthdaily.com/?utm_medium=developer&utm_source=landing-page&utm_campaign=qgis-plugin-edagro&utm_content=geosys-qgis-description"><strong>Who we are</strong></a>
    <br />
    <br />
    <a href="https://github.com/earthdaily/qgis-plugin">Project description</a>
    ·
    <a href="https://github.com/earthdaily/qgis-plugin/issues">Report Bug</a>
    ·
    <a href="https://github.com/earthdaily/qgis-plugin/issues">Request Feature</a>
  </p>
</p>

<div align="center">
  
[![LinkedIn][linkedin-shield]](https://www.linkedin.com/company/earthdailyanalytics?utm_medium=developer&utm_source=linkedin&utm_campaign=qgis-plugin-edagro&utm_content=geosys-qgis-description)
[![Twitter][twitter-shield]](https://x.com/earthdailya?utm_medium=developer&utm_source=twitter&utm_campaign=qgis-plugin-edagro&utm_content=geosys-qgis-description)
[![languages][language-python-shiedl]][issues-url]
[![CITest][CITest-shield]][CITest-url]
[![Issues][issues-shield]][issues-url]
[![MIT License][license-shield]][license-url]
[![pages-build-deployment][Documentationstatus]][CIDocumentation]
  
</div>

<!--[![Stargazers][GitStars-shield]][GitStars-url]-->
<!--[![Forks][forks-shield]][forks-url]-->
<!--[![Stargazers][stars-shield]][stars-url]-->

<!-- TABLE OF CONTENTS -->
<details open>
  <summary>Table of Contents</summary>
  <ol>
    <li>
      <a href="#about-the-project">About The Project</a>
    </li>
    <li>
      <a href="#getting-started">Getting Started</a>
      <ul>
        <li><a href="#prerequisites">Prerequisites</a></li>
        <li><a href="#installation">Installation</a></li>
      </ul>
    </li>
    <li><a href="#features">Features</a></li>
    <li><a href="#use-cases">Use cases</a></li>
    <li><a href="#resources">Resources</a></li>
    <li><a href="#support-development">Support development</a></li>
    <li><a href="#license">License</a></li>
    <li><a href="#contact">Contact</a></li>
    <li><a href="#copyrights">Copyrights</a></li>
  </ol>
</details>

<!-- ABOUT THE PROJECT -->
## About The Project

### EarthDaily is a global leader in Earth observation, delivering unparalleled geospatial insights across industries such as Agriculture, water management, and forest planning. 

With a team of world-class agronomists, data scientists, and Earth observation specialists, EarthDaily transforms the highest-quality satellite imagery into actionable solutions. 

By combining advanced analytics and superior signal-to-noise ratio data, EarthDaily empowers organizations to mitigate risk, optimize operations, and achieve sustainable outcomes. Explore how EarthDaily's innovative platforms support the vital sectors shaping our world at [earthdaily.com](http://earthdaily.com/). 

<p align="center">
  <a href="https://earthdailyagro.com/geosys/">
    <img src="https://raw.githubusercontent.com/GEOSYS/qgis-plugin-doc/master/pictures/EarthDaily.png">
  </a>
</p>

 <p align="left">
Throught our EarthDaily® platform, we make geospatial analytics easily accessible for you to be browsed or analyzed, within our cloud or within your own environment. We provide developers and data scientists both flexibility and extensibility with analytic ready data and digital agriculture ready development blocks. We empower your team to enrich your systems with information at the field, regional or continent level via our API or Apps.
</p>

We have a team of experts around the world that understand local crops and ag industry, as well as advanced analytics to support your business.

We have established a developer community to provide you with plug-ins and integrations to be able to discover, request and use aggregate imagery products based on Landsat, Sentinel, Modis and many other open and commercial satellite sensors.

The QGIS plugin project aims to provide an easy and ready to use connector allowign any QGIS users to quickly experience EarthDaily capabilities.


### The EarthDaily® plugin for QGIS is the easiest way to leverage the powerful capabilities of the EarthDaily® Platform directly within your QGIS workflows. 

Designed for Earth observation professionals, it enables seamless access to field-level analytics, eliminating the need for coding while providing actionable geospatial insights. 

Key Features: 

- Historical and In-Season Maps: Analyze past trends and current conditions with EarthDaily® field-level data. 
- Multi-Index Maps: Visualize indices such as NDVI, GNDVI, EVI, CVI, S2REP, NDWI, and NDMI to unlock deeper insights into vegetation health, moisture, and more. 
- Multi-Sensor Integration: Utilize data from Sentinel-2, Landsat-8, Landsat-9, Gaofen, Huanjing, and the upcoming EarthDaily Constellation (2025). 
- Advanced Processing Tools: Create polygon-based maps and access robust spectral visualizations for precision analysis. 
- EarthDaily’s QGIS Plugin bridges the gap between data and decision-making, empowering users in agriculture, water management, forest planning, and beyond to make informed choices. 
 
Explore the plugin today and revolutionize how you interact with Earth Observation data. 

<p align="right">(<a href="#top">back to top</a>)</p>


<!-- GETTING STARTED -->
## Getting Started

### Prerequisites

To be able to get maps within QGIS, please make sure you have valid credentials. If you need to get trial access, please register [here](https://earthdailyagro.com/geosys-api/#get-started).

This project has been testes with QGIS 3.26.3

### Installation

1. Within the QGIS plugin manager as described [here](https://earthdaily.github.io/qgis-plugin/2.%20Installation.html)
   
2. Manual install by download a zip of the project and use the manual plugin install from QGIS. Please see https://docs.qgis.org/3.4/en/docs/user_manual/plugins/plugins.html#the-install-from-zip-tab


Documentation about development setup can be found here https://github.com/earthdaily/qgis-plugin/blob/develop/docs/development.md
<p align="right">(<a href="#top">back to top</a>)</p>
   
<!-- FEATURES -->
## Features

The plugin once configured provides an easy way to get satelitte imagery derived map on polygon of interest. User can select one or multiple polygon object on the map canvas and request maps creation. For more detailed information, please see the [user documentation](https://earthdaily.github.io/qgis-plugin/Readme.html). 

Here is an example of QGIS with field level maps
<p align="center">
  <a href="https://earthdailyagro.com/geosys/">
    <img src="https://raw.githubusercontent.com/GEOSYS/qgis-plugin-doc/master/pictures/doc17.png" alt="Logo" width="800" height="500">
  </a>
</p>

<p align="right">(<a href="#top">back to top</a>)</p>

<!-- USAGE EXAMPLES -->
## Use cases
This project is used by prospect interested to create field level maps in few clicks to better understand the interest and benefits of maps available trought the EarthDaily® APIs. It has been also used to support various innovation projects on precison agriculture and regeneratice Ag with Organic matter maps used to optimize in field sampling.


<!-- RESOURCES -->
## Resources 
The following links will provide access to more information:
- [EarthDaily developer portal  ](https://developer.geosys.com/)
- [QGIS website  ](https://www.qgis.org/en/site/)

<p align="right">(<a href="#top">back to top</a>)</p>

<!-- CONTRIBUTING -->
## Support development

If this project has been useful, that it helped you or your business to save precious time, don't hesitate to give it a star.

<p align="right">(<a href="#top">back to top</a>)</p>

<!-- LICENSE -->
## License

Distributed under the [GPL 3.0 License](https://www.gnu.org/licenses/gpl-3.0.en.html). 

<p align="right">(<a href="#top">back to top</a>)</p>

<!-- CONTACT -->
## Contact

For any additonal information, please <a href="mailto: sales@earthdaily.com">email us</a>

<p align="right">(<a href="#top">back to top</a>)</p>

<!-- COPYRIGHT -->
## Copyrights

© 2024 Geosys Holdings ULC, an Antarctica Capital portfolio company | All Rights Reserved.

<p align="right">(<a href="#top">back to top</a>)</p>

<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->
<!-- List of available shields https://shields.io/category/license -->
<!-- List of available shields https://simpleicons.org/ -->
[contributors-shield]: https://img.shields.io/github/contributors/github_username/repo.svg?style=social
[contributors-url]: https://github.com/github_username/repo/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/github_username/repo.svg?style=plastic&logo=appveyor
[forks-url]: https://github.com/github_username/repo/network/members
[stars-shield]: https://img.shields.io/github/stars/qgis-plugin/repo.svg?style=plastic&logo=appveyor
[stars-url]: https://github.com/github_username/repo/stargazers
[issues-shield]: https://img.shields.io/github/issues/GEOSYS/qgis-plugin/repo.svg?style=social
[issues-url]: https://github.com/github_username/repo/issues
[license-shield]: https://img.shields.io/github/license/GEOSYS/qgis-plugin
[license-url]: https://www.gnu.org/licenses/gpl-3.0.en.html
[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=social&logo=linkedin
[linkedin-url]: https://www.linkedin.com/company/earthdailyagro/mycompany/
[twitter-shield]: https://img.shields.io/twitter/follow/EarthDailyAgro?style=social
[twitter-url]: https://img.shields.io/twitter/follow/EarthDailyAgro?style=social
[youtube-shield]: https://img.shields.io/youtube/channel/views/UCy4X-hM2xRK3oyC_xYKSG_g?style=social
[youtube-url]: https://img.shields.io/youtube/channel/views/UCy4X-hM2xRK3oyC_xYKSG_g?style=social
[language-python-shiedl]: https://img.shields.io/badge/python-3.7-green?logo=python
[language-python-url]: https://pypi.org/ 
[GitStars-shield]: https://img.shields.io/github/stars/GEOSYS?style=social
[GitStars-url]: https://img.shields.io/github/stars/GEOSYS?style=social
[CITest-shield]: https://img.shields.io/github/workflow/status/GEOSYS/qgis-plugin/Continous%20Integration
[CITest-url]: https://img.shields.io/github/workflow/status/GEOSYS/qgis-plugin/Continous%20Integration
[CIDocumentation]: https://github.com/earthdaily/QGIS-plugin/actions/workflows/pages/pages-build-deployment
[Documentationstatus]: https://github.com/earthdaily/QGIS-plugin/actions/workflows/pages/pages-build-deployment/badge.svg?branch=gh-pages  
