# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GeosquareGrid
                                 A QGIS plugin
 Geosquare Grid
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-17
        copyright            : (C) 2025 by PT Geo Innovasi Nussantara
        email                : admin@geosquare.ai
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'PT Geo Inovasi Nussantara'
__date__ = '2025-04-17'
__copyright__ = '(C) 2025 by PT Geo Inovasi Nussantara'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterEnum,
                       QgsProcessingParameterField,
                       QgsRasterLayer,
                       QgsProcessingParameterNumber,
                       QgsProcessingUtils)
from .geosquare_grid import GeosquareGrid
from qgis.core import QgsField, QgsFields, QgsCoordinateReferenceSystem, QgsWkbTypes, QgsCoordinateTransform
from PyQt5.QtCore import QVariant
from qgis import processing
from qgis.core import QgsGeometry, QgsFeature, QgsVectorLayer
import os


class OpenGeosquareAlgorithm(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    geosquare_grid = GeosquareGrid()
    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'
    FIELD = 'FIELD'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        # We add the input vector features source. It can have any kind of
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('Input table (CSV or Parquet)'),
                [QgsProcessing.TypeVector],  # Accept any vector layer including non-spatial tables
                defaultValue=None,
                optional=False
            )
        )

        self.addParameter(
            QgsProcessingParameterField(
                self.FIELD,
                self.tr('GID field'),
                parentLayerParameterName=self.INPUT,
                defaultValue='gid',
                optional=False
            )
        )
        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('Geosquare layer')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        source = self.parameterAsSource(parameters, self.INPUT, context)
        crs = QgsCoordinateReferenceSystem('EPSG:4326')
        field = self.parameterAsFields(parameters, self.FIELD, context)[0]
        fields = source.fields()
        
        (sink, dest_id) = self.parameterAsSink(parameters, self.OUTPUT,
            context, fields, QgsWkbTypes.Polygon, crs)

        count_features = source.featureCount()
        total = 100 / count_features if count_features else 0
        current = 0
        for feature in source.getFeatures():
            # Check if the feature has a valid geometry
            if feedback.isCanceled():
                break
            gid = feature[field]
            try:
                geom = self.geosquare_grid.gid_to_geometry(gid)
            except Exception as e:
                feedback.reportError(self.tr(f'GID is not valid: {gid}'))
                break
            
            # Create a new feature with the same geometry and attributes
            new_feature = QgsFeature()
            new_feature.setGeometry(geom)
            new_feature.setAttributes(feature.attributes())
            
            # Add the new feature to the sink
            sink.addFeature(new_feature, QgsFeatureSink.FastInsert)
            
            current += 1
            feedback.setProgress(int(current * total))
      
        feedback.setProgress(100)
        feedback.pushInfo(self.tr('Processing completed.'))
        return {self.OUTPUT: dest_id}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Geosquare grid - Open Geosquare Data'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'vector'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)
    
    def shortHelpString(self):
        return self.tr("""
            This algorithm converts tabular data (CSV or Parquet) containing Geosquare GIDs into a spatial layer with polygon geometries.
            
            Input:
            - A CSV or Parquet file that contains Geosquare GID values but no geometries
            - The field name containing the Geosquare GID values
            
            Output:
            - A polygon vector layer where each feature has geometry derived from its Geosquare GID
            - All original attributes from the input table are preserved
            
            Use this when you have geospatial data referenced by Geosquare GIDs and need to 
            visualize or analyze it spatially in QGIS.
        """)

    def createInstance(self):
        return OpenGeosquareAlgorithm()
