

class TopographicProfile:

    def __init__(self, distances, elevations):
        self.distances = distances
        self.elevations = elevations


class LithologicalSegment:

    def __init__(self, distances, elevations, name, color):
        self.distances = distances
        self.elevations = elevations
        self.name = name
        self.__color = color

    @property
    def color(self):
        return self.__color.name()


class StructuralPoint:

    def __init__(self, distance, elevation, name, color):
        self.distance = distance
        self.elevation = elevation
        self.name = name
        self.__color = color

    @property
    def color(self):
        return self.__color.name()


class BeddingPoint:

    def __init__(self, distance, elevation, dip_inclination, apparent_dip):
        self.distance = distance
        self.elevation = elevation
        self.dip_inclination = dip_inclination
        self.apparent_dip = apparent_dip


class GeologicalProfile:

    def __init__(self, lithologies, structures=None, bedding=None):
        self.lithologies = lithologies
        self.structures = structures
        self.bedding = bedding

    def getXLimits(self):

        x_minimus = []
        x_maximus = []
        for lithology in self.lithologies:
            x_minimus.append(min(lithology.distances))
            x_maximus.append(max(lithology.distances))

        return min(x_minimus), max(x_maximus)

    def getElevationLimits(self):

        z_minimus = []
        z_maximus = []
        for lithology in self.lithologies:
            z_minimus.append(min(lithology.elevations))
            z_maximus.append(max(lithology.elevations))

        return min(z_minimus), max(z_maximus)

