# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AsterConvertion
                                 A QGIS plugin
 This plugin allows you to import ASTER L1T image in .hdf format and apply
 radiometric and atmospheric correction.
                              -------------------
        begin                : 2025-01-20
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Silver Piedra
        email                : silverpiedraherrera@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QLocale, QLibraryInfo

import os

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .GeoProfileDialog import GeoProfileDialog


class GeoProfilePlugin:
    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # Initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # Initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'GeoProfile_{}.qm'.format(locale)
        )
        if os.path.exists(locale_path):
            # Plugin translator
            self.plugin_translator = QTranslator()
            self.plugin_translator.load(locale_path)
            QCoreApplication.installTranslator(self.plugin_translator)
        # Default translator
        self.translator = QTranslator()
        self.translator.load("qtbase_" + QLocale.system().name(),
                             QLibraryInfo.location(QLibraryInfo.TranslationsPath))
        QCoreApplication.installTranslator(self.translator)

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.window = None

    def tr(self, message):
        return QCoreApplication.translate('GeoProfilePlugin', message)

    def initGui(self):
        # create action that will start plugin configuration
        icon_path = ":/plugins/geoprofile/icon/icon.png"
        self.action = QAction(QIcon(icon_path),
                              "GeoProfile",
                              self.iface.mainWindow())
        self.action.setObjectName("GeoProfile")
        self.action.setWhatsThis(self.tr("GeoProfile Plugin"))
        self.action.setStatusTip(self.tr("Plugin for generating geological profiles."))
        self.action.triggered.connect(self.run)

        # add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&GeoProfile", self.action)

    def unload(self):
        self.iface.removePluginMenu("&GeoProfile", self.action)
        self.iface.removeToolBarIcon(self.action)

    def run(self):
        if self.window is None:
            self.window = GeoProfileDialog(iface=self.iface, tr=self.tr, parent=self.iface.mainWindow())

        self.window.show()

