# GeoProfile - QGIS Plugin

![icon](icon/icon.png)

GeoProfile is a QGIS plugin that allows you to create a geological profile using 2D vectorial information (lines, lithology, structural and bedding layers) and DEM (Digital Elevation Model) raster. This plugin is useful for obtaining a topographic profile with the necessary information to create a geological section either by hand or using vector editing software.

## Features

- **User-friendly Interface**: An easy and intuitive interface for selecting layers and entering the necessary values.
- **Preview**: Allows users to preview the profile before exporting the result.
- **Error Handling**: Provides error handling for invalid input and output parameters to ensure smooth operation.

## Usage

1. Load the necessary layers into QGIS. The DEM raster, section line, and lithology layers are required to create the profile, while structural and bedding data are optional.
2. Click on the GeoProfile button in the toolbar.
3. In the topography tab, select the **DEM** raster layer and the profile **depth** (This value is used to define the lower area by subtracting the minimum elevation of the topographic profile from the depth), Also select the vector layer that contains the **section line**, and choose it using either the feature ID or the value of a specific field. You can also invert the direction of the profile by activating the **"invert line"** checkbox.

![load](https://drive.google.com/uc?export=view&id=1bpII7Axh5ndcwtfCl2LxpiJWduE55mmX)

4. (Optional) Click the **preview topography** button to see how the topographic profile would look.

![load](https://drive.google.com/uc?export=view&id=15s3FE0A9CBwZnWTs_Po66cfFqZDAvlFe)

5. In the Geology tab, select a polygon layer containing the **lithology** and the field that contains the lithological **classification**. If you want the color of each lithological unit to match the map, edit them by clicking the **colors** button. A window will open where you can manually select each color. Click on a specific color and use the *color picker* tool for precision.

![load](https://drive.google.com/uc?export=view&id=1f5zp_wmzOEU8KWHTrmZf6Tq_3pomy6bj)

6. In the Geology tab, you can optionally add **structural** data (line layer) and **bedding** data (point layer). In the case of structural information, you can choose which field will be displayed as a label and the color of the symbology. For bedding, you must select the field containing the **azimuth** (a value that must follow the *right-hand rule - RHR*) and the field containing the **dip**. You can also modify the length of the line representing the bedding plane using the **line length** parameter, and define the area on either side of the section line that will be used to select the bedding data projected onto the profile using the **buffer** parameter.

7. (Optional) Click the **preview** button to see how the geology profile would look.

![load](https://drive.google.com/uc?export=view&id=1zBDOCest4h-B5wvIC5FhCXnQ1XVjGAGi)

8. In the Export tab, you can set a **title** for the profile, the **start label** and **end label**, the **figure size**, and its orientation using the **landscape** radio button. You must also choose the **path** and name under which the profile will be exported.

![load](https://drive.google.com/uc?export=view&id=1BKhVNdQmmM9PpOw_nk8XJrR_Mx6rU6un)

9. Finally, click the **save** button to export the geological profile.

![load](https://drive.google.com/uc?export=view&id=1gT9-dYWkRfAPtnVGeRIQpqeZ_q0cdpdt)

## License

This plugin is licensed under the GNU General Public License v3.0.

## Contribution

Contributions are welcome! Please visit the GitHub Repository to report issues or suggest features.

## Support

For support and further information, please contact Silver Piedra at silverpiedraherrera@gmail.com