# Related to the declared ports in the GitLab OAuth2 Application settings
OAUTH_DECLARED_REDIRECT_PORTS: list[int] = [
    7070,
]  # priority order


GPF_PLUGIN_LIST: list[str] = [
    "french_locator_filter",
    "gpf_isochrone_isodistance_itineraire",
    "bd_topo_extractor",
    "qgireferentiels",
]

cartes_gouv_template_url = {
    "document": "https://cartes.gouv.fr/entrepot/{datastore_id}/donnees/{dataset_name}?activeTab=documents",
    "view_style": "https://cartes.gouv.fr/entrepot/{datastore_id}/service/{offering_id}/visualisation?datasheetName={dataset_name}",
    "create_style": "https://cartes.gouv.fr/entrepot/{datastore_id}/service/{offering_id}/style/ajout?datasheetName={dataset_name}",
}

metadata_topic_categories = {
    "biota": "Biologie, faune et flore",
    "boundaries": "Limites politiques et administratives",
    "climatologyMeteorologyAtmosphere": "Climatologie, météorologie, atmosphère",
    "economy": "Economie",
    "elevation": "Altimétrie",
    "environment": "Environnement",
    "farming": "Agriculture",
    "geoscientificInformation": "Sciences de la terre, géosciences",
    "health": "Santé",
    "imageryBaseMapsEarthCover": "Carte de référence de la couverture terrestre",
    "intelligenceMilitary": "Infrastructures militaires",
    "inlandWaters": "Eaux intérieures, Hydrographie",
    "location": "Localisation",
    "oceans": "Océans",
    "planningCadastre": "Cadastre, aménagement",
    "society": "Société",
    "structure": "Constructions et ouvrages",
    "transportation": "Infrastructures de transport",
    "utilitiesCommunication": "Télécommunication, approvisionnement et énergie",
}

metadata_encoding_values = [
    "8859part1",
    "8859part10",
    "8859part11",
    "8859part13",
    "8859part14",
    "8859part15",
    "8859part16",
    "8859part2",
    "8859part3",
    "8859part4",
    "8859part5",
    "8859part6",
    "8859part7",
    "8859part8",
    "8859part9",
    "GB2312",
    "big5",
    "ebcdic",
    "eucJP",
    "eucKR",
    "jis",
    "shiftJIS",
    "ucs2",
    "ucs4",
    "usAscii",
    "utf16",
    "utf7",
    "utf8",
]

metadata_languages = {
    "aar": "afar",
    "abk": "abkhaze",
    "ace": "aceh",
    "ach": "acoli",
    "ada": "adangme",
    "ady": "adyghé",
    "afa": "afro-asiatiques, langues",
    "afh": "afrihili",
    "afr": "afrikaans",
    "ain": "aïnou",
    "aka": "akan",
    "akk": "akkadien",
    "sqi": "albanais",
    "ale": "aléoute",
    "alg": "algonquines, langues",
    "alt": "altai du Sud",
    "amh": "amharique",
    "ang": "anglo-saxon (ca.450-1100)",
    "anp": "angika",
    "apa": "apaches, langues",
    "ara": "arabe",
    "arc": "araméen d'empire (700-300 BCE)",
    "arg": "aragonais",
    "hye": "arménien",
    "arn": "mapudungun",
    "arp": "arapaho",
    "art": "artificielles, langues",
    "arw": "arawak",
    "asm": "assamais",
    "ast": "asturien",
    "ath": "athapascanes, langues",
    "aus": "australiennes, langues",
    "ava": "avar",
    "ave": "avestique",
    "awa": "awadhi",
    "aym": "aymara",
    "aze": "azéri",
    "bad": "banda, langues",
    "bai": "bamiléké, langues",
    "bak": "bachkir",
    "bal": "baloutchi",
    "bam": "bambara",
    "ban": "balinais",
    "eus": "basque",
    "bas": "basa",
    "bat": "baltes, langues",
    "bej": "bedja",
    "bel": "biélorusse",
    "bem": "bemba",
    "ben": "bengali",
    "ber": "berbères, langues",
    "bho": "bhojpuri",
    "bih": "langues biharis",
    "bik": "bikol",
    "bin": "bini",
    "bis": "bichlamar",
    "bla": "blackfoot",
    "bnt": "bantou, langues",
    "tib": "tibétain",
    "bos": "bosniaque",
    "bra": "braj",
    "bre": "breton",
    "btk": "batak, langues",
    "bua": "bouriate",
    "bug": "bugi",
    "bul": "bulgare",
    "mya": "birman",
    "byn": "blin",
    "cad": "caddo",
    "cai": "amérindiennes de l'Amérique centrale,  langues",
    "car": "karib",
    "cat": "catalan",
    "cau": "caucasiennes, langues",
    "ceb": "cebuano",
    "cel": "celtiques, langues",
    "cze": "tchèque",
    "cha": "chamorro",
    "chb": "chibcha",
    "che": "tchétchène",
    "chg": "djaghataï",
    "zho": "chinois",
    "chk": "chuuk",
    "chm": "mari",
    "chn": "chinook, jargon",
    "cho": "choctaw",
    "chp": "chipewyan",
    "chr": "cherokee",
    "chu": "slavon d'église",
    "chv": "tchouvache",
    "chy": "cheyenne",
    "cmc": "chames, langues",
    "cop": "copte",
    "cor": "cornique",
    "cos": "corse",
    "cpe": "créoles et pidgins basés sur l'anglais",
    "cpf": "créoles et pidgins basés sur le français",
    "cpp": "créoles et pidgins basés sur le portugais",
    "cre": "cree",
    "crh": "tatar de Crimé",
    "crp": "créoles et pidgins",
    "csb": "kachoube",
    "cus": "couchitiques,  langues",
    "wel": "gallois",
    "dak": "dakota",
    "dan": "danois",
    "dar": "dargwa",
    "day": "dayak, langues",
    "del": "delaware",
    "den": "esclave (athapascan)",
    "ger": "allemand",
    "dgr": "dogrib",
    "din": "dinka",
    "div": "maldivien",
    "doi": "dogri",
    "dra": "dravidiennes,  langues",
    "dsb": "bas-sorabe",
    "dua": "douala",
    "dum": "néerlandais moyen (ca. 1050-1350)",
    "nld": "néerlandais",
    "dyu": "dioula",
    "dzo": "dzongkha",
    "efi": "efik",
    "egy": "égyptien",
    "eka": "ekajuk",
    "gre": "grec moderne (après 1453)",
    "elx": "élamite",
    "eng": "anglais",
    "enm": "anglais moyen (1100-1500)",
    "epo": "espéranto",
    "est": "estonien",
    "ewe": "éwé",
    "ewo": "éwondo",
    "fan": "fang",
    "fao": "féroïen",
    "per": "persan",
    "fat": "fanti",
    "fij": "fidjien",
    "fil": "filipino",
    "fin": "finnois",
    "fiu": "finno-ougriennes,  langues",
    "fon": "fon",
    "fre": "français",
    "frm": "français moyen (1400-1600)",
    "fro": "français ancien (842-ca.1400)",
    "frr": "frison septentrional",
    "frs": "frison oriental",
    "fry": "frison occidental",
    "ful": "peul",
    "fur": "frioulan",
    "gaa": "ga",
    "gay": "gayo",
    "gba": "gbaya",
    "gem": "germaniques, langues",
    "kat": "géorgien",
    "gez": "guèze",
    "gil": "kiribati",
    "gla": "gaélique",
    "gle": "irlandais",
    "glg": "galicien",
    "glv": "manx",
    "gmh": "allemand, moyen haut (ca. 1050-1500)",
    "goh": "allemand, vieux haut (ca. 750-1050)",
    "gon": "gond",
    "gor": "gorontalo",
    "got": "gothique",
    "grb": "grebo",
    "grc": "grec ancien (jusqu'à 1453)",
    "grn": "guarani",
    "gsw": "suisse alémanique",
    "guj": "goudjrati",
    "gwi": "gwich'in",
    "hai": "haida",
    "hat": "haïtien",
    "hau": "haoussa",
    "haw": "hawaïen",
    "heb": "hébreu",
    "her": "herero",
    "hil": "hiligaynon",
    "him": "langues himachalis",
    "hin": "hindi",
    "hit": "hittite",
    "hmn": "hmong",
    "hmo": "hiri motu",
    "hrv": "croate",
    "hsb": "haut-sorabe",
    "hun": "hongrois",
    "hup": "hupa",
    "iba": "iban",
    "ibo": "igbo",
    "isl": "islandais",
    "ido": "ido",
    "iii": "yi de Sichuan",
    "ijo": "ijo, langues",
    "iku": "inuktitut",
    "ile": "interlingue",
    "ilo": "ilocano",
    "ina": "interlingua (langue auxiliaire internationale)",
    "inc": "indo-aryennes, langues",
    "ind": "indonésien",
    "ine": "indo-européennes, langues",
    "inh": "ingouche",
    "ipk": "inupiaq",
    "ira": "iraniennes, langues",
    "iro": "iroquoises, langues",
    "ita": "italien",
    "jav": "javanais",
    "jbo": "lojban",
    "jpn": "japonais",
    "jpr": "judéo-persan",
    "jrb": "judéo-arabe",
    "kaa": "karakalpak",
    "kab": "kabyle",
    "kac": "kachin",
    "kal": "groenlandais",
    "kam": "kamba",
    "kan": "kannada",
    "kar": "karen, langues",
    "kas": "kashmiri",
    "kau": "kanouri",
    "kaw": "kawi",
    "kaz": "kazakh",
    "kbd": "kabardien",
    "kha": "khasi",
    "khi": "khoïsan, langues",
    "khm": "khmer central",
    "kho": "khotanais",
    "kik": "kikuyu",
    "kin": "rwanda",
    "kir": "kirghiz",
    "kmb": "kimbundu",
    "kok": "konkani",
    "kom": "kom",
    "kon": "kongo",
    "kor": "coréen",
    "kos": "kosrae",
    "kpe": "kpellé",
    "krc": "karatchai balkar",
    "krl": "carélien",
    "kro": "krou, langues",
    "kru": "kurukh",
    "kua": "kuanyama",
    "kum": "koumyk",
    "kur": "kurde",
    "kut": "kutenai",
    "lad": "judéo-espagnol",
    "lah": "lahnda",
    "lam": "lamba",
    "lao": "lao",
    "lat": "latin",
    "lav": "letton",
    "lez": "lezghien",
    "lim": "limbourgeois",
    "lin": "lingala",
    "lit": "lituanien",
    "lol": "mongo",
    "loz": "lozi",
    "ltz": "luxembourgeois",
    "lua": "luba-lulua",
    "lub": "luba-katanga",
    "lug": "ganda",
    "lui": "luiseno",
    "lun": "lunda",
    "luo": "luo (Kenya et Tanzanie)",
    "lus": "lushai",
    "mkd": "macédonien",
    "mad": "madourais",
    "mag": "magahi",
    "mah": "marshall",
    "mai": "maithili",
    "mak": "makassar",
    "mal": "malayalam",
    "man": "mandingue",
    "mri": "maori",
    "map": "austronésiennes, langues",
    "mar": "marathe",
    "mas": "massaï",
    "msa": "malais",
    "mdf": "moksa",
    "mdr": "mandar",
    "men": "mendé",
    "mga": "irlandais moyen (900-1200)",
    "mic": "mi'kmaq",
    "min": "minangkabau",
    "mis": "langues non codées",
    "mkh": "môn-khmer, langues",
    "mlg": "malgache",
    "mlt": "maltais",
    "mnc": "mandchou",
    "mni": "manipuri",
    "mno": "manobo, langues",
    "moh": "mohawk",
    "mon": "mongol",
    "mos": "moré",
    "mul": "multilingue",
    "mun": "mounda, langues",
    "mus": "muskogee",
    "mwl": "mirandais",
    "mwr": "marvari",
    "myn": "maya, langues",
    "myv": "erza",
    "nah": "nahuatl, langues",
    "nai": "nord-amérindiennes, langues",
    "nap": "napolitain",
    "nau": "nauruan",
    "nav": "navaho",
    "nbl": "ndébélé du Sud",
    "nde": "ndébélé du Nord",
    "ndo": "ndonga",
    "nds": "bas allemand",
    "nep": "népalais",
    "new": "nepal bhasa",
    "nia": "nias",
    "nic": "nigéro-kordofaniennes, langues",
    "niu": "niué",
    "nno": "norvégien nynorsk",
    "nob": "norvégien bokmål",
    "nog": "nogaï",
    "non": "norrois, vieux",
    "nor": "norvégien",
    "nqo": "n'ko",
    "nso": "pedi",
    "nub": "nubiennes, langues",
    "nwc": "newari classique",
    "nya": "chichewa",
    "nym": "nyamwezi",
    "nyn": "nyankolé",
    "nyo": "nyoro",
    "nzi": "nzema",
    "oci": "occitan (après 1500)",
    "oji": "ojibwa",
    "ori": "oriya",
    "orm": "galla",
    "osa": "osage",
    "oss": "ossète",
    "ota": "turc ottoman (1500-1928)",
    "oto": "otomi, langues",
    "paa": "papoues, langues",
    "pag": "pangasinan",
    "pal": "pahlavi",
    "pam": "pampangan",
    "pan": "pendjabi",
    "pap": "papiamento",
    "pau": "palau",
    "peo": "perse, vieux (ca. 600-400 av. J.-C.)",
    "phi": "philippines, langues",
    "phn": "phénicien",
    "pli": "pali",
    "pol": "polonais",
    "pon": "pohnpei",
    "por": "portugais",
    "pra": "prâkrit, langues",
    "pro": "provençal ancien (jusqu'à 1500)",
    "pus": "pachto",
    "que": "quechua",
    "raj": "rajasthani",
    "rap": "rapanui",
    "rar": "rarotonga",
    "roa": "romanes, langues",
    "roh": "romanche",
    "rom": "tsigane",
    "rum": "roumain",
    "run": "rundi",
    "rup": "aroumain",
    "rus": "russe",
    "sad": "sandawe",
    "sag": "sango",
    "sah": "iakoute",
    "sai": "sud-amérindiennes, langues",
    "sal": "salishennes, langues",
    "sam": "samaritain",
    "san": "sanskrit",
    "sas": "sasak",
    "sat": "santal",
    "scn": "sicilien",
    "sco": "écossais",
    "sel": "selkoupe",
    "sem": "sémitiques, langues",
    "sga": "irlandais ancien (jusqu'à 900)",
    "sgn": "langues des signes",
    "shn": "chan",
    "sid": "sidamo",
    "sin": "singhalais",
    "sio": "sioux, langues",
    "sit": "sino-tibétaines, langues",
    "sla": "slaves, langues",
    "slo": "slovaque",
    "slv": "slovène",
    "sma": "sami du Sud",
    "sme": "sami du Nord",
    "smi": "sames, langues",
    "smj": "sami de Lule",
    "smn": "sami d'Inari",
    "smo": "samoan",
    "sms": "sami skolt",
    "sna": "shona",
    "snd": "sindhi",
    "snk": "soninké",
    "sog": "sogdien",
    "som": "somali",
    "son": "songhai, langues",
    "sot": "sotho du Sud",
    "spa": "espagnol",
    "srd": "sarde",
    "srn": "sranan tongo",
    "srp": "serbe",
    "srr": "sérère",
    "ssa": "nilo-sahariennes, langues",
    "ssw": "swati",
    "suk": "sukuma",
    "sun": "soundanais",
    "sus": "soussou",
    "sux": "sumérien",
    "swa": "swahili",
    "swe": "suédois",
    "syc": "syriaque classique",
    "syr": "syriaque",
    "tah": "tahitien",
    "tai": "tai, langues",
    "tam": "tamoul",
    "tat": "tatar",
    "tel": "télougou",
    "tem": "temne",
    "ter": "tereno",
    "tet": "tetum",
    "tgk": "tadjik",
    "tgl": "tagalog",
    "tha": "thaï",
    "tig": "tigré",
    "tir": "tigrigna",
    "tiv": "tiv",
    "tkl": "tokelau",
    "tlh": "klingon",
    "tli": "tlingit",
    "tmh": "tamacheq",
    "tog": "tonga (Nyasa)",
    "ton": "tongan (Îles Tonga)",
    "tpi": "tok pisin",
    "tsi": "tsimshian",
    "tsn": "tswana",
    "tso": "tsonga",
    "tuk": "turkmène",
    "tum": "tumbuka",
    "tup": "tupi, langues",
    "tur": "turc",
    "tut": "altaïques, langues",
    "tvl": "tuvalu",
    "twi": "twi",
    "tyv": "touva",
    "udm": "oudmourte",
    "uga": "ougaritique",
    "uig": "ouïgour",
    "ukr": "ukrainien",
    "umb": "umbundu",
    "und": "indéterminée",
    "urd": "ourdou",
    "uzb": "ouszbek",
    "vai": "vaï",
    "ven": "venda",
    "vie": "vietnamien",
    "vol": "volapük",
    "vot": "vote",
    "wak": "wakashanes, langues",
    "wal": "wolaitta",
    "war": "waray",
    "was": "washo",
    "wen": "sorabes, langues",
    "wln": "wallon",
    "wol": "wolof",
    "xal": "kalmouk",
    "xho": "xhosa",
    "yao": "yao",
    "yap": "yapois",
    "yid": "yiddish",
    "yor": "yoruba",
    "ypk": "yupik, langues",
    "zap": "zapotèque",
    "zbl": "symboles Bliss",
    "zen": "zenaga",
    "zgh": "amazighe standard marocain",
    "zha": "zhuang",
    "znd": "zandé, langues",
    "zul": "zoulou",
    "zun": "zuni",
    "zxx": "pas de contenu linguistique",
    "zza": "zaza",
}

metadata_inspire_keyword = [
    "Adresse",
    "Descripteur postal",
    "Dénomination d'unité administrative",
    "Dénomination de voie",
    "Dénomination de zone d'adresse",
    "Élément d'adresse",
    "Cote d’altitude",
    "Courbe de niveau",
    "Couverture en grille altimétrique",
    "Ligne de rupture",
    "Objet vectoriel altimétrique",
    "TIN altimétrique",
    "Zone isolée",
    "Zone vide",
    "Bâtiment",
    "Bâtiment abstrait",
    "Construction abstraite",
    "Partie de bâtiment",
    "Lieu nommé",
    "Aquiclude",
    "Aquifère",
    "Aquitard",
    "Campagne",
    "Collection géologique",
    "Ensemble d'objets géophysiques",
    "Entité cartographique",
    "Entité géologique",
    "Entité géomorphologique",
    "Entité géomorphologique anthropique",
    "Entité géomorphologique naturelle",
    "Faisceau géophysique",
    "Forage",
    "Intervalle cartographique",
    "Masse d'eau souterraine",
    "Mesure géophysique",
    "Objet géophysique",
    "Objet hydrogéologique",
    "Objet hydrogéologique artificiel",
    "Objet hydrogéologique naturel",
    "Pli",
    "Profil géophysique",
    "Puits de pompage en activité",
    "Station géophysique",
    "Structure de déplacement cisaillante",
    "Structure géologique",
    "Système d'aquifères",
    "Unité géologique",
    "Unité hydrogéologique",
    "Événement géologique",
    "Habitat",
    "Barrage ou seuil en rivière",
    "Bassin hydrographique",
    "Bassin versant",
    "Chutes",
    "Construction de rivage",
    "Cours d'eau",
    "Digue",
    "Déversoir",
    "Eaux de surface",
    "Eaux stagnantes",
    "Franchissement",
    "Franchissement entre deux cours d'eau",
    "Gué",
    "Limite terre-eau",
    "Nœud hydrographique",
    "Objet artificiel",
    "Objet hydrographique",
    "Point d'intérêt hydrographique",
    "Point fluvial",
    "Rapides",
    "Rivage",
    "Séquence de tronçons de cours d'eau",
    "Tronçon de cours d'eau",
    "Zone humide",
    "Écluse",
    "Exploitation",
    "Site",
    "Activité de suivi environnemental",
    "Capacité d’observation",
    "Entité de suivi abstraite",
    "Installation de suivi environnemental",
    "Objet de suivi abstrait",
    "Programme de suivi environnemental",
    "Réseau de suivi environnemental",
    "Bâtiment de production",
    "Installation de production",
    "Parcelle de production",
    "Partie d’installation de production",
    "Site de production",
    "Unité de production",
    "Couverture en grille de couverture du sol",
    "Série de données de couverture du sol",
    "Unité de couverture du sol",
    "Couverture d’ortho-imagerie",
    "Élément de mosaïque",
    "Élément de mosaïque agrégé",
    "Élément de mosaïque simple",
    "Limite cadastrale",
    "Parcelle cadastrale",
    "Unité foncière de base",
    "Zonage cadastral",
    "Activité d'exploration",
    "Activité minière",
    "Entité minière",
    "Mine",
    "Occurrence d'entité minière",
    "Occurrence minérale",
    "Ressource terrestre",
    "Substance",
    "Région biogéographique",
    "Couche marine",
    "Courbe de niveau marine",
    "Ligne de rivage",
    "Mer",
    "Trait de côte",
    "Tronçon de ligne de rivage",
    "Zone de circulation marine",
    "Zone de fond marin",
    "Zone de surface de la mer",
    "Zone intertidale",
    "Zone marine",
    "Répartition statistique",
    "Série de données sur la répartition des espèces",
    "Unité de répartition des espèces",
    "Aide à la navigation",
    "Aire d'aérodrome",
    "Aire de circulation",
    "Aire de circulation des véhicules",
    "Aire de dispositif de séparation du trafic",
    "Aire de gare de triage",
    "Aire de gare ferroviaire",
    "Aire de piste",
    "Aire de prise de contact et d'envol",
    "Aire de route",
    "Aire de service routier",
    "Aire de trafic",
    "Aire de transport",
    "Aire de voie ferrée",
    "Aire portuaire",
    "Altitude du terrain",
    "Arrivée normalisée aux instruments",
    "Autorité propriétaire",
    "Autorité responsable de la maintenance",
    "Balise",
    "Borne",
    "Bouée",
    "Catégorie d'aérodrome",
    "Catégorie de revêtement de route",
    "Chenal de navigation",
    "Classe CEMT",
    "Classe fonctionnelle de route",
    "Code de gare ferroviaire",
    "Composition de la surface",
    "Croisement de dispositif de séparation du trafic",
    "Direction du flux du trafic",
    "Direction du flux du trafic de transport par voie navigable",
    "Dispositif de séparation du trafic",
    "Dénomination de route",
    "Départ normalisé aux instruments",
    "Largeur de l'élément",
    "Largeur de route",
    "Ligne de voie ferrée",
    "Limitation de vitesse",
    "Limite d'altitude inférieure",
    "Limite d'altitude supérieure",
    "Longueur de l'élément",
    "Nature de voie",
    "Nombre de voies",
    "Nombre de voies",
    "Nœud d'aérodrome",
    "Nœud de gare de triage",
    "Nœud de gare ferroviaire",
    "Nœud de port",
    "Nœud de route",
    "Nœud de transport",
    "Nœud de transport par voie navigable",
    "Nœud de voie aérienne",
    "Nœud de voie câblée",
    "Nœud de voie ferrée",
    "Nœud de voie navigable",
    "Objet de transport",
    "Point d'axe de piste",
    "Point de transport",
    "Point déterminé",
    "Position verticale",
    "Procédure d'approche aux instruments",
    "Propriété du transport",
    "Restriction d'accès",
    "Restriction pour les véhicules",
    "Restriction pour les véhicules de transport par eau",
    "Restriction à l'utilisation",
    "Rond-point de dispositif de séparation du trafic",
    "Route",
    "Route aérienne",
    "Route «E»",
    "Réseau de transport",
    "Séparateur de dispositif de séparation du trafic",
    "Séquence de tronçons de route",
    "Séquence de tronçons de transport",
    "Séquence de tronçons de transport par voie navigable",
    "Séquence de tronçons de voie aérienne",
    "Séquence de tronçons de voie câblée",
    "Séquence de tronçons de voie ferrée",
    "Série de tronçons de transport",
    "Série de tronçons de voie câblée",
    "Traversée par bac",
    "Tronçon de procédure",
    "Tronçon de route",
    "Tronçon de route aérienne",
    "Tronçon de transport",
    "Tronçon de voie aérienne",
    "Tronçon de voie câblée",
    "Tronçon de voie ferrée",
    "Tronçon de voie navigable",
    "Type d'aérodrome",
    "Type de service routier",
    "Type de voie ferrée",
    "Utilisation de la voie ferrée",
    "Utilisation du bac",
    "Vitesse nominale",
    "Voie de dispositif de séparation du trafic",
    "Voie navigable",
    "Voie navigable intérieure",
    "Voie navigable maritime",
    "Zone d'espace aérien",
    "Écartement nominal des voies",
    "Électrification d'une voie ferrée",
    "État de l'équipement",
    "État de l'équipement aérien",
    "État de l'équipement de transport par voie navigable",
    "Aire de réseau",
    "Collection d’observations ponctuelles",
    "Complexe d’activité",
    "Connexion de réseaux",
    "Couverture",
    "Couverture (Représentation du domaine et du domaine de définition)",
    "Couverture en grille rectifiée",
    "Couverture en grille référençable",
    "Ensemble d’observations",
    "Franchissement à niveaux séparés",
    "Nœud",
    "Observation de série temporelle en un point",
    "Observation par grille",
    "Observation par séries de grilles",
    "Observation ponctuelle",
    "Observation selon un profil",
    "Observation selon une trajectoire",
    "Observations ponctuelles multiples",
    "Processus",
    "Propriété du réseau",
    "Référence croisée",
    "Réseau",
    "Séquence de tronçons",
    "Série de tronçons",
    "Tronçon",
    "Tronçon générique",
    "Élément de réseau",
    "Biomarqueur",
    "Données statistiques d'un déterminant de santé environnementale",
    "Données statistiques en matière de santé",
    "Maladie",
    "Mesure d'un déterminant de santé environnementale",
    "Statistiques de santé générale",
    "Statistiques des services de santé",
    "Armoire",
    "Canalisation",
    "Canalisation d'assainissement",
    "Canalisation d'eau",
    "Canalisation d'hydrocarbures ou de produits chimiques",
    "Canalisation de transport de chaleur",
    "Conduite",
    "Conteneur de nœuds de services d'utilité publique",
    "Câble",
    "Câble électrique",
    "Installation de gestion environnementale",
    "Nœud de services d'utilité publique",
    "Poteau",
    "Pylône",
    "Regard",
    "Réseau de services d'utilité publique",
    "Services publics",
    "Séquence de tronçons de services d'utilité publique",
    "Série de tronçons de services d'utilité publique",
    "Tronçon de services d'utilité publique",
    "Élément de réseau de services d'utilité publique",
    "Équipement",
    "Site protégé",
    "Couche de sol",
    "Couverture descriptive pour le thème de sol",
    "Couverture pour le thème de sol",
    "Horizon de sol",
    "Objet dérivé de sol",
    "Parcelle de sol",
    "Profil de sol",
    "Profil de sol dérivé",
    "Profil de sol observé",
    "Site de sol",
    "Unité de sol",
    "Élément de profil",
    "Couverture du potentiel des ressources renouvelables ou issues de déchets",
    "Ressources en combustibles fossiles",
    "Ressources renouvelables et ressources issues de déchets",
    "Sources d'énergie – mode vecteur",
    "Condominium",
    "Ligne de base",
    "Limite administrative",
    "Limite maritime",
    "Unité administrative",
    "Zone maritime",
    "Cellule de grille statistique",
    "Grille statistique",
    "Partition statistique",
    "Région NUTS",
    "Unité statistique",
    "Unité statistique surfacique",
    "Unité statistique vectorielle",
    "Évolution",
    "Document de planification spatiale",
    "Documentation officielle",
    "Grille de l’usage existant des sols",
    "Objet «usage existant des sols»",
    "Réglementation supplémentaire",
    "Série de données «usage existant des sols en mode échantillonné»",
    "Série de données «usage existant des sols»",
    "Échantillon de l’usage existant des sols",
    "Élément du zonage",
    "Eaux côtières DCE",
    "Eaux de transition DCE",
    "Lac DCE",
    "Masse d'eau de surface DCE",
    "Masse d'eau souterraine DCE",
    "Rivière DCE",
    "Rivière ou lac DCE",
    "Zone de gestion, de restriction ou de réglementation",
    "Couverture de l'aléa",
    "Couverture de l'événement observé",
    "Couverture de l’élément exposé",
    "Couverture du risque",
    "Zone d'aléa",
    "Zone d'aléa abstraite",
    "Zone à risque",
    "Zone à risque abstraite",
    "Élément exposé",
    "Élément exposé abstrait",
    "Événement observé",
    "Événement observé abstrait",
]

metadata_maintenance_frequency = {
    "continual": "En continu",
    "daily": "Journalière",
    "weekly": "Hebdomadaire",
    "fortnightly": "Bimensuelle",
    "monthly": "Mensuelle",
    "quaterly": "Trimestrielle",
    "biannually": "Biannuelle",
    "annually": "Annuelle",
    "asNeeded": "En fonction du besoin",
    "irregular": "Irrégulière",
    "notPlanned": "Non planifiée",
    "unknown": "Inconnue",
}
