import json


def profile_url(
    geojson: str, resource_id: str, profile_mode: str, sampling: int = 1000
) -> tuple[str, dict[str, str]]:
    base_url: str = "https://data.geopf.fr/altimetrie/1.0/calcul/alti/rest/elevationLine.json"
    lon_list: list[str] = []
    lat_list: list[str] = []
    delimiter: str = "|"

    geojson = json.loads(geojson)
    for lon, lat in geojson["coordinates"]:
        lon_list.append(str(lon))
        lat_list.append(str(lat))

    base_params = {
        "lon": delimiter.join(lon_list),
        "lat": delimiter.join(lat_list),
        "resource": resource_id,
        "delimiter": delimiter,
        "indent": "false",
        "measures": "false",
        "zonly": "true",
        "profile_mode": profile_mode,
        "sampling": str(sampling),
    }
    return base_url, base_params
