import json

from qgis.core import QgsFeedback, QgsNetworkAccessManager
from qgis.PyQt.QtCore import QUrl
from qgis.PyQt.QtNetwork import QNetworkRequest

import geopf_altimetrie.toolbelt.log_handler as log_hdlr


def get_ressources() -> list:
    result = []
    network_access_manager = QgsNetworkAccessManager.instance()

    url = "https://data.geopf.fr/altimetrie/resources"

    req = QNetworkRequest(QUrl(url))
    reply = network_access_manager.blockingGet(req, feedback=QgsFeedback())
    if reply.error():
        result = {"error": reply.errorString()}
    else:
        content = reply.content()
        try:
            result = json.loads(str(content, "utf-8"))
        except json.decoder.JSONDecodeError as e:
            log_hdlr.PlgLogger.log(
                message=f"Unable to parse results from resources. Details: {e.msg}",
                log_level=2,
                push=True,
            )

    if "error" in result.keys():
        log_hdlr.PlgLogger.log(
            message=f"Error while requesting resources: {result["error"]}",
            log_level=2,
            push=True,
        )
        return []
    elif "resources" in result.keys() and result["resources"]:
        return result["resources"]
    else:
        log_hdlr.PlgLogger.log(
            message="No ressource found!",
            log_level=1,
            push=True,
        )
        return []
