# -*- coding: utf-8 -*-
"""
/***************************************************************************
 inSALMOPlugin
                                 A QGIS plugin
 Makes the geometry file for inSALMO
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-07-29
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Peter N. Dudley
        email                : pndphd@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject
from qgis.gui import *
from qgis.analysis import *
import qgis.utils
import processing
from osgeo import *
import sys
import os
import shutil


# Initialize Qt resources from file namedS resources.py
from .resources import *
# Import the code for the dialog
from .geometry_generator_dialog import inSALMOPluginDialog
import os.path


class inSALMOPlugin:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'inSALMOPlugin_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&inSALMO')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('inSALMOPlugin', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=False,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/geometry_generator/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Geometry Generator'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&inSALMO'),
                action)
            self.iface.removeToolBarIcon(action)
            
    def select_output_file(self):
        filename, _filter  = QFileDialog.getSaveFileName(self.dlg, "Select output file ","", '*.Data')
        self.dlg.lineEdit.setText(filename)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = inSALMOPluginDialog()
            self.dlg.lineEdit.clear()
            self.dlg.pushButton.clicked.connect(self.select_output_file)
            
        #layers = QgsProject.instance().layerTreeRoot().children()
        
        #Load the vector layers into ther combo box
        layerIDs = QgsProject.instance().layerTreeRoot().findLayerIds()
        initLayerList = []
        for layerID in layerIDs:
            initLayerList.append(QgsProject.instance().mapLayer(layerID))
        layers = initLayerList
        
        layer_list = []
        self.dlg.comboBox.clear()
        for layer in layers:
            layer_list.append(layer.name())
        self.dlg.comboBox.addItems(layer_list)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # get the layer that is selected form ther drop down menu
            selectedLayerIndex = self.dlg.comboBox.currentIndex()
            layer = layers[selectedLayerIndex]
            # get ther output file name from ther box
            fileName = self.dlg.lineEdit.text()
            outputFile = open(fileName, 'w')
            # make a blank string called coords
            coords = ''
            # get the list of features from ther layer
            features = layer.getFeatures()

            # itterate over the features
            for feature in features:
                geom = feature.geometry()
                # get the vertices
                pt = geom.asGeometryCollection()[0].asPolygon()
                
                # check if the list is populated
                check = 1
                # try:
                    # trash = pt[0]
                # except IndexError:
                    # check = 0
                
                if check:
                    #get the number of vertices
                    length = len(pt[0])
                    # get the feature id
                    number = feature.id()+1
                    # write the feature ID
                    coords = coords + str(number) + "\t" + "111" +"\t" + "222\n"
                    #write out the coordinated
                    for i in range(0, (length-1)):
                        coords = coords + "\t" + str(pt[0][i].x())+ "\t" + str(pt[0][i].y()) + "\n"
                    coords = coords + "END\n"
            coords = coords + "END\n"
            #write to the file
            #unicodeLine = coords.encode('utf-8')
            outputFile.write(coords)
            outputFile.close()
