# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Geology
                                 A QGIS plugin
 Tools for QGIS 3.x to generate the Geological Units from the drawing of the geological boundaries with the points containing the geological information inside (ID code of the Geological Units)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-01-10
        copyright            : (C) 2025 by Giuseppe Cosentino
        email                : giuseppe.cosentino@cnr.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Giuseppe Cosentino'
__date__ = '2025-01-15'
__copyright__ = '(C) 2025 by Giuseppe Cosentino'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsExpression
import processing


class GeologyAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource('points_with_geological_information_centroid', 'Points with geological information (centroid)', types=[QgsProcessing.TypeVectorPoint], defaultValue=None))
        self.addParameter(QgsProcessingParameterField('geological_attribute_input', 'Geological Attribute INPUT', type=QgsProcessingParameterField.Any, parentLayerParameterName='points_with_geological_information_centroid', allowMultiple=False, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('line_drawing_geological_contacts', 'Line drawing (geological contacts)', types=[QgsProcessing.TypeVectorLine], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Polygons', 'Polygons', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))
        self.addParameter(QgsProcessingParameterFeatureSink('CleanPoints', 'clean points', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))
        self.addParameter(QgsProcessingParameterFeatureSink('SegmentsOfTheDrawingOfGeologicalContacts', 'Segments of the drawing of geological contacts', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))
        self.addParameter(QgsProcessingParameterFeatureSink('GeologicalPolygons', 'Geological polygons', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))
        self.addParameter(QgsProcessingParameterFeatureSink('GeologyContactsPointAttributes', 'Geology contacts (point attributes)', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue='TEMPORARY_OUTPUT'))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(10, model_feedback)
        results = {}
        outputs = {}

        # Elimina geometrie duplicate dei punti
        alg_params = {
            'INPUT': parameters['points_with_geological_information_centroid'],
            'OUTPUT': parameters['CleanPoints']
        }
        outputs['EliminaGeometrieDuplicateDeiPunti'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['CleanPoints'] = outputs['EliminaGeometrieDuplicateDeiPunti']['OUTPUT']

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Poligonizza
        alg_params = {
            'INPUT': parameters['line_drawing_geological_contacts'],
            'KEEP_FIELDS': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Poligonizza'] = processing.run('native:polygonize', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Elimina geometrie duplicate dei poligoni
        alg_params = {
            'INPUT': outputs['Poligonizza']['OUTPUT'],
            'OUTPUT': parameters['Polygons']
        }
        outputs['EliminaGeometrieDuplicateDeiPoligoni'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Polygons'] = outputs['EliminaGeometrieDuplicateDeiPoligoni']['OUTPUT']

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Unisci attributi per posizione
        alg_params = {
            'DISCARD_NONMATCHING': True,
            'INPUT': outputs['EliminaGeometrieDuplicateDeiPoligoni']['OUTPUT'],
            'JOIN': outputs['EliminaGeometrieDuplicateDeiPunti']['OUTPUT'],
            'JOIN_FIELDS': QgsExpression(' @Elimina_geometrie_duplicate_dei_punti_OUTPUT ').evaluate(),
            'METHOD': 0,  # Crea elementi separati per ciascun elemento corrispondente (uno-a-molti)
            'PREDICATE': [0],  # interseca
            'PREFIX': '',
            'OUTPUT': parameters['GeologicalPolygons']
        }
        outputs['UnisciAttributiPerPosizione'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['GeologicalPolygons'] = outputs['UnisciAttributiPerPosizione']['OUTPUT']

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Da poligoni a linee
        alg_params = {
            'INPUT': outputs['UnisciAttributiPerPosizione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DaPoligoniALinee'] = processing.run('native:polygonstolines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Rimuovi i vertici duplicati
        alg_params = {
            'INPUT': outputs['DaPoligoniALinee']['OUTPUT'],
            'TOLERANCE': 1e-06,
            'USE_Z_VALUE': False,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RimuoviIVerticiDuplicati'] = processing.run('native:removeduplicatevertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Esplodi linee
        alg_params = {
            'INPUT': outputs['RimuoviIVerticiDuplicati']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EsplodiLinee'] = processing.run('native:explodelines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Elimina geometrie duplicate linee
        alg_params = {
            'INPUT': outputs['EsplodiLinee']['OUTPUT'],
            'OUTPUT': parameters['SegmentsOfTheDrawingOfGeologicalContacts']
        }
        outputs['EliminaGeometrieDuplicateLinee'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['SegmentsOfTheDrawingOfGeologicalContacts'] = outputs['EliminaGeometrieDuplicateLinee']['OUTPUT']

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Dissolvi
        alg_params = {
            'FIELD': parameters['geological_attribute_input'],
            'INPUT': outputs['EliminaGeometrieDuplicateLinee']['OUTPUT'],
            'SEPARATE_DISJOINT': False,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Da multi parte a parti singole segmenti valore punti
        alg_params = {
            'INPUT': outputs['Dissolvi']['OUTPUT'],
            'OUTPUT': parameters['GeologyContactsPointAttributes']
        }
        outputs['DaMultiParteAPartiSingoleSegmentiValorePunti'] = processing.run('native:multiparttosingleparts', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['GeologyContactsPointAttributes'] = outputs['DaMultiParteAPartiSingoleSegmentiValorePunti']['OUTPUT']
        return results

    def name(self):
        return 'Geology from point and line'

    def displayName(self):
        return 'Geology from point and line'

    def group(self):
        return 'Geological drawing'

    def groupId(self):
        return ''

    def shortHelpString(self):
        return """<html><body><p><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN" "http://www.w3.org/TR/REC-html40/strict.dtd">
<html><head><meta name="qrichtext" content="1" /><style type="text/css">
</style></head><body style=" font-family:'MS Shell Dlg 2'; font-size:9.5pt; font-weight:400; font-style:normal;">
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" font-size:12pt;">This method allows for the creation of a digital geological map starting from point and line data, automating the process of generating geological units and simplifying the creation of detailed geological maps. Geoprocessing tools for QGIS 3.x to generate Geological Units from the drawing of geological boundaries, with points containing geological information (ID code of the Geological Units).</span></p></body></html></p>
<h2>Esempi</h2>
<p><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN" "http://www.w3.org/TR/REC-html40/strict.dtd">
<html><head><meta name="qrichtext" content="1" /><style type="text/css">
</style></head><body style=" font-family:'MS Shell Dlg 2'; font-size:9.5pt; font-weight:400; font-style:normal;">
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#00008c;">1) Create the lines: Use QGIS editing tools to draw the lines (geological contacts) that define the boundaries of the future polygons. Ensure that the lines intersect or touch correctly to form closed areas.</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#00008c;">2) Insert the points: Add the points that represent geological information you want to use to create the polygons.</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#00008c;">3) Generate the polygons and lines (geological contacts): Use the plugin 'Geology from points and lines' to generate polygons and geological contacts. This tool connects the points and lines to create enclosed areas and attributes the geological information contained in the points.</span></p>
<p style="-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; color:#000000;"><br /></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><a href="https://private-user-images.githubusercontent.com/30177622/402270573-58548c20-a1e8-4a49-a04e-689e8d75cd3a.png?jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJnaXRodWIuY29tIiwiYXVkIjoicmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSIsImtleSI6ImtleTUiLCJleHAiOjE3MzY5NDIzNTksIm5iZiI6MTczNjk0MjA1OSwicGF0aCI6Ii8zMDE3NzYyMi80MDIyNzA1NzMtNTg1NDhjMjAtYTFlOC00YTQ5LWEwNGUtNjg5ZThkNzVjZDNhLnBuZz9YLUFtei1BbGdvcml0aG09QVdTNC1ITUFDLVNIQTI1NiZYLUFtei1DcmVkZW50aWFsPUFLSUFWQ09EWUxTQTUzUFFLNFpBJTJGMjAyNTAxMTUlMkZ1cy1lYXN0LTElMkZzMyUyRmF3czRfcmVxdWVzdCZYLUFtei1EYXRlPTIwMjUwMTE1VDExNTQxOVomWC1BbXotRXhwaXJlcz0zMDAmWC1BbXotU2lnbmF0dXJlPTM5YWQ3Y2NiMWFjMWIyMmFkZjgxMDc5YWExZTBiYWZhMWZjM2QzNjMwOTQ1MmM0ZjM2NjczNTVkZjViZTUyMGEmWC1BbXotU2lnbmVkSGVhZGVycz1ob3N0In0.FsBO5tCTydQ3mY2scWD89ynhSxiLGcCsqT3kkGRJ4NY"><span style=" text-decoration: underline; color:#0000ff;">Schema link </span></a></p></body></html></p><br><p align="right">Autore algoritmo: Giuseppe Cosentino (Pino)</p><p align="right">Versione algoritmo: Version 0.2 20250116</p></body></html>"""

    def helpUrl(self):
        return 'https://private-user-images.githubusercontent.com/30177622/402270573-58548c20-a1e8-4a49-a04e-689e8d75cd3a.png?jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJnaXRodWIuY29tIiwiYXVkIjoicmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSIsImtleSI6ImtleTUiLCJleHAiOjE3MzY5NDIzNTksIm5iZiI6MTczNjk0MjA1OSwicGF0aCI6Ii8zMDE3NzYyMi80MDIyNzA1NzMtNTg1NDhjMjAtYTFlOC00YTQ5LWEwNGUtNjg5ZThkNzVjZDNhLnBuZz9YLUFtei1BbGdvcml0aG09QVdTNC1ITUFDLVNIQTI1NiZYLUFtei1DcmVkZW50aWFsPUFLSUFWQ09EWUxTQTUzUFFLNFpBJTJGMjAyNTAxMTUlMkZ1cy1lYXN0LTElMkZzMyUyRmF3czRfcmVxdWVzdCZYLUFtei1EYXRlPTIwMjUwMTE1VDExNTQxOVomWC1BbXotRXhwaXJlcz0zMDAmWC1BbXotU2lnbmF0dXJlPTM5YWQ3Y2NiMWFjMWIyMmFkZjgxMDc5YWExZTBiYWZhMWZjM2QzNjMwOTQ1MmM0ZjM2NjczNTVkZjViZTUyMGEmWC1BbXotU2lnbmVkSGVhZGVycz1ob3N0In0.FsBO5tCTydQ3mY2scWD89ynhSxiLGcCsqT3kkGRJ4NY'

    def createInstance(self):
        return GeologyAlgorithm()
