# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Geology
                                 A QGIS plugin
 Tools for QGIS 3.x to generate the Geological Units from the drawing of the geological boundaries with the points containing the geological information inside (ID code of the Geological Units)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-01-10
        copyright            : (C) 2025 by Giuseppe Cosentino
        email                : giuseppe.cosentino@cnr.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Giuseppe Cosentino'
__date__ = '2025-01-10'
__copyright__ = '(C) 2025 by Giuseppe Cosentino'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsExpression
import processing


class GeologyAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('lines_geological_contacts_', 'Lines (Geological Contacts )', types=[QgsProcessing.TypeVectorLine], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSource('points_with_geological_information_centroid', 'Points with geological information (centroid)', types=[QgsProcessing.TypeVectorPoint], defaultValue=None))
        self.addParameter(QgsProcessingParameterField('geological_attribute_input', 'Geological Attribute INPUT', type=QgsProcessingParameterField.Any, parentLayerParameterName='points_with_geological_information_centroid', allowMultiple=False, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('CleanPolygons', 'clean polygons', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))
        self.addParameter(QgsProcessingParameterFeatureSink('CleanPoints', 'clean points', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))
        self.addParameter(QgsProcessingParameterFeatureSink('GeologicalContacts', 'Geological Contacts', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))
        self.addParameter(QgsProcessingParameterFeatureSink('GeologicalPolygons', 'Geological Polygons', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(8, model_feedback)
        results = {}
        outputs = {}

        # Elimina geometrie duplicate dei punti
        alg_params = {
            'INPUT': parameters['points_with_geological_information_centroid'],
            'OUTPUT': parameters['CleanPoints']
        }
        outputs['EliminaGeometrieDuplicateDeiPunti'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['CleanPoints'] = outputs['EliminaGeometrieDuplicateDeiPunti']['OUTPUT']

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Poligonizza
        alg_params = {
            'INPUT': parameters['lines_geological_contacts_'],
            'KEEP_FIELDS': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Poligonizza'] = processing.run('native:polygonize', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Elimina geometrie duplicate dei poligoni
        alg_params = {
            'INPUT': outputs['Poligonizza']['OUTPUT'],
            'OUTPUT': parameters['CleanPolygons']
        }
        outputs['EliminaGeometrieDuplicateDeiPoligoni'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['CleanPolygons'] = outputs['EliminaGeometrieDuplicateDeiPoligoni']['OUTPUT']

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Unisci attributi per posizione
        alg_params = {
            'DISCARD_NONMATCHING': True,
            'INPUT': outputs['EliminaGeometrieDuplicateDeiPoligoni']['OUTPUT'],
            'JOIN': outputs['EliminaGeometrieDuplicateDeiPunti']['OUTPUT'],
            'JOIN_FIELDS': QgsExpression(' @Elimina_geometrie_duplicate_dei_punti_OUTPUT ').evaluate(),
            'METHOD': 0,  # Crea elementi separati per ciascun elemento corrispondente (uno-a-molti)
            'PREDICATE': [0],  # interseca
            'PREFIX': '',
            'OUTPUT': parameters['GeologicalPolygons']
        }
        outputs['UnisciAttributiPerPosizione'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['GeologicalPolygons'] = outputs['UnisciAttributiPerPosizione']['OUTPUT']

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Da poligoni a linee
        alg_params = {
            'INPUT': outputs['UnisciAttributiPerPosizione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DaPoligoniALinee'] = processing.run('native:polygonstolines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Rimuovi i vertici duplicati
        alg_params = {
            'INPUT': outputs['DaPoligoniALinee']['OUTPUT'],
            'TOLERANCE': 1e-06,
            'USE_Z_VALUE': False,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RimuoviIVerticiDuplicati'] = processing.run('native:removeduplicatevertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Esplodi linee
        alg_params = {
            'INPUT': outputs['RimuoviIVerticiDuplicati']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EsplodiLinee'] = processing.run('native:explodelines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Elimina geometrie duplicate
        alg_params = {
            'INPUT': outputs['EsplodiLinee']['OUTPUT'],
            'OUTPUT': parameters['GeologicalContacts']
        }
        outputs['EliminaGeometrieDuplicate'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['GeologicalContacts'] = outputs['EliminaGeometrieDuplicate']['OUTPUT']
        return results

    def name(self):
        return 'Geology_from_point_and_line'

    def displayName(self):
        return 'Geology_from_point_and_line'

    def group(self):
        return 'Geology'

    def groupId(self):
        return 'Geology'

    def shortHelpString(self):
        return """<html><body><p><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN" "http://www.w3.org/TR/REC-html40/strict.dtd">
<html><head><meta name="qrichtext" content="1" /><style type="text/css">
p, li { white-space: pre-wrap; }
</style></head><body style=" font-family:'MS Shell Dlg 2'; font-size:9.5pt; font-weight:400; font-style:normal;">
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" font-family:'Helvetica','Helvetica Neue','Arial','sans-serif'; font-size:8.3pt; font-weight:600; color:#1f00b4; background-color:#ffffff;">Tools for QGIS 3.x to generate the Geological Units from the drawing </span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" font-family:'Helvetica','Helvetica Neue','Arial','sans-serif'; font-size:8.3pt; font-weight:600; color:#1f00b4; background-color:#ffffff;">of the geological boundaries with the points containing the geological </span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" font-family:'Helvetica','Helvetica Neue','Arial','sans-serif'; font-size:8.3pt; font-weight:600; color:#1f00b4; background-color:#ffffff;">information inside (ID code of the Geological Units)</span></p></body></html></p>
<h2>Esempi</h2>
<p><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN" "http://www.w3.org/TR/REC-html40/strict.dtd">
<html><head><meta name="qrichtext" content="1" /><style type="text/css">
p, li { white-space: pre-wrap; }
</style></head><body style=" font-family:'MS Shell Dlg 2'; font-size:9.5pt; font-weight:400; font-style:normal;">
<p style="-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; font-size:8.3pt;"><br /></p></body></html></p><br><p align="right">Autore algoritmo: Giuseppe Cosentino</p><p align="right">Versione algoritmo: Version 1.1 202501</p></body></html>"""

    def createInstance(self):
        return GeologyAlgorithm()
