# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Geo2ENVImet
                                 A QGIS plugin
 This plugin generates ENVI-met model areas from geodata
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-12-10
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Helge Simon
        email                : helge.simon@envi-met.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

# TODO
# only use rotate is angle is less than x (currently 1) deg
# add path to "run ENVI-met"
# check finalKK / k-grids tag and compare in SPACES

from typing import Any

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QVariant, QThread, pyqtSignal
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QProgressBar
from qgis.core import QgsProject, Qgis, QgsField, QgsMapLayerProxyModel, QgsPoint, QgsVectorLayer, QgsRectangle, \
    QgsFeatureRequest, QgsFieldProxyModel, QgsMessageLog, QgsRasterLayer

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .geodata2ENVImet_dialog import Geo2ENVImetDialog
import os.path
import os
import processing
from processing.tools import dataobjects
import tempfile
from pyproj import Proj, transform
import pyproj
from osgeo import gdal, gdal_array
import numpy as np
import sys
from math import inf, asin, degrees, floor, trunc, sqrt, acos
import xml.etree.ElementTree as ET
import requests
from requests.adapters import HTTPAdapter
from qgis.gui import QgsMessageBar
from time import sleep
from datetime import datetime
import random
from .ENVImet_DB_loader import *
from qgis.PyQt.QtCore import *
import subprocess


class TreeInList:
    def __init__(self, idx, enviID, obs):
        self.idx = idx
        self.enviID = enviID
        self.obs = obs

class IDlookUP:
    def __init__(self, idx, enviID):
        self.idx = idx
        self.enviID = enviID

class Cell:
    def __init__(self, i, j, k):
        self.i = i
        self.j = j
        self.k = k


class BLevel:
    def __init__(self, bNumber):
        self.bNumber = bNumber
        self.cellList = []


class Worker(QThread):
    finished = pyqtSignal()  # create a pyqtSignal for when task is finished
    progress = pyqtSignal(int)  # create a pyqtSignal to report the progress to progressbar

    def __init__(self):
        super(QThread, self).__init__()
        # print('workerinit')
        self.stopworker = False  # initialize the stop variable

        self.filename = ""
        self.II = 0
        self.JJ = 0
        self.KK = 0
        self.finalKK = 0
        self.dx = 3.0
        self.dy = 3.0
        self.dz = 3.0
        self.dzAr = np.zeros(1, dtype=float)
        self.zLvl_bot = np.zeros(1, dtype=float)
        self.zLvl_center = np.zeros(1, dtype=float)

        self.xMeters = 0.0
        self.yMeters = 0.0
        self.s_buildingList = []
        self.s_treeList = []
        self.s_recList = []
        self.model_rot = 0.0
        self.model_rot_center = QgsPoint(0, 0)
        self.subAreaLayer = QgsVectorLayer("Polygon", "notAvail", "memory")
        self.subAreaLayer_nonRot = QgsVectorLayer("Polygon", "notAvail", "memory")
        self.subAreaExtent = QgsRectangle(0, 0, 0, 0)

        self.bLayer = QgsVectorLayer("Polygon", "notAvail", "memory")
        self.bLayer_rot = QgsVectorLayer("Polygon", "notAvail", "memory")
        self.bTop = QgsField("notAvail", QVariant.Int)
        self.bBot = QgsField("notAvail", QVariant.Int)
        self.bName = QgsField("notAvail", QVariant.String)
        self.bWall = QgsField("notAvail", QVariant.String)
        self.bRoof = QgsField("notAvail", QVariant.String)
        self.bGreenWall = QgsField("notAvail", QVariant.String)
        self.bGreenRoof = QgsField("notAvail", QVariant.String)
        self.bBPS = QgsField("notAvail", QVariant.String)
        # custom fields
        self.bTop_custom = -999
        self.bBot_custom = -999
        self.bName_custom = "notAvail"
        self.bWall_custom = "notAvail"
        self.bRoof_custom = "notAvail"
        self.bGreenWall_custom = "notAvail"
        self.bGreenRoof_custom = "notAvail"
        self.bTop_UseCustom = False
        self.bBot_UseCustom = False
        self.bName_UseCustom = False
        self.bWall_UseCustom = False
        self.bRoof_UseCustom = False
        self.bGreenWall_UseCustom = False
        self.bGreenRoof_UseCustom = False
        self.bBPS_disabled = False


        self.surfLayer = QgsVectorLayer("Polygon", "notAvail", "memory")
        self.surfLayer_rot = QgsVectorLayer("Polygon", "notAvail", "memory")
        self.surfID = QgsField("notAvail", QVariant.String)
        self.surfID_custom = "notAvail"
        self.surfID_UseCustom = False

        self.plant1dLayer = QgsVectorLayer("Polygon", "notAvail", "memory")
        self.plant1dLayer_rot = QgsVectorLayer("Polygon", "notAvail", "memory")
        self.plant1dID = QgsField("notAvail", QVariant.String)
        self.plant1dID_custom = "notAvail"
        self.plant1dID_UseCustom = False

        self.plant3dLayer = QgsVectorLayer("Point", "notAvail", "memory")
        self.plant3dLayer_rot = QgsVectorLayer("Point", "notAvail", "memory")
        self.plant3dID = QgsField("notAvail", QVariant.String)
        self.plant3dAddOut = QgsField("notAvail", QVariant.String)
        self.plant3dAddOut_disabled = False
        self.plant3dID_custom = "notAvail"
        self.plant3dID_UseCustom = False

        self.recLayer = QgsVectorLayer("Point", "notAvail", "memory")
        self.recLayer_rot = QgsVectorLayer("Point", "notAvail", "memory")
        self.recID = QgsField("notAvail", QVariant.String)
        self.recID_custom = "notAvail"
        self.recID_UseCustom = False

        self.srcPLayer = QgsVectorLayer("Point", "notAvail", "memory")
        self.srcPLayer_rot = QgsVectorLayer("Point", "notAvail", "memory")
        self.srcPID = QgsField("notAvail", QVariant.String)
        self.srcPID_custom = "notAvail"
        self.srcPID_UseCustom = False

        self.srcLLayer = QgsVectorLayer("Line", "notAvail", "memory")
        self.srcLLayer_rot = QgsVectorLayer("Line", "notAvail", "memory")
        self.srcLID = QgsField("notAvail", QVariant.String)
        self.srcLID_custom = "notAvail"
        self.srcLID_UseCustom = False

        self.srcALayer = QgsVectorLayer("Polygon", "notAvail", "memory")
        self.srcALayer_rot = QgsVectorLayer("Polygon", "notAvail", "memory")
        self.srcAID = QgsField("notAvail", QVariant.String)
        self.srcAID_custom = "notAvail"
        self.srcAID_UseCustom = False

        self.dEMLayer = QgsRasterLayer("", "notAvail")
        self.dEMBand = -1

        self.lon = 0.0
        self.lat = 0.0
        self.UTMZone = -1
        self.timeZoneName = ""
        self.timeZoneLonRef = 0.0
        self.elevation = -999
        self.refHeightDEM = 0
        self.maxHeightDEM = 0
        self.maxHeightB = 0
        self.maxHeightTotal = 0
        self.useSplitting = True
        self.useTelescoping = False
        self.teleStart = 0
        self.teleStretch = 0

        self.defaultRoof = "000000"
        self.defaultWall = "000000"
        self.removeBBorder = 5
        self.bLeveled = True
        self.startSurfID = "0100PP"
        self.removeVegBuild = True
    """
    def test(self):
        #self.buildBInfo()
        wait_time = self.time / 100.0  # calculate the waste time
        for i in range(self.total):  # just do something
            sleep(wait_time)  # just waste some time
            self.progress.emit(int((i + 1) / self.total * 100))  # report the current progress via pyqt signal to reportProgress method of TaskTest-Class
            if self.stopworker == True:  # if cancel button has been pressed the stop method is called and stopworker set to True. If so, break the loop so the thread can be stopped
                print('break req')
                break
    """

    def rotateLayer(self, lay: QgsVectorLayer, isSubAreaLayer: bool):
        if lay is None:
            return ""
        if lay.name() == "notAvail":
            return ""

        # lay = self.dlg.cb_subArea.currentLayer();
        xMin_s = self.model_rot_center.x()
        yMin_s = self.model_rot_center.y()
        epsg_s = lay.sourceCrs().authid()
        anch = str(xMin_s) + "," + str(yMin_s) + " [" + epsg_s + "]"
        # print(anch)
        context = dataobjects.createContext()
        context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
        rlayer = processing.run("native:rotatefeatures",
                                {"INPUT": lay,
                                 "ANGLE": self.model_rot,
                                 "ANCHOR": anch,
                                 "OUTPUT": 'TEMPORARY_OUTPUT'},
                                context=context)  # "D:\\tmp\\absss.shp"})
        rlayerFN = rlayer['OUTPUT']
        # print(rlayerFN)

        if isSubAreaLayer:
            # write layer to global var
            self.subAreaLayer = rlayerFN
            # calculate extent of first feature
            spFeats = self.subAreaLayer.getFeatures()
            for f in spFeats:
                if f.hasGeometry():
                    f_geo = f.geometry()
                    self.subAreaExtent = f_geo.boundingBox()
                    #print("bBox extent")
                    #print(self.subAreaExtent)

        return rlayerFN

    def getModelrot(self):
        if self.subAreaLayer.name() == "notAvail":
            self.model_rot = 0
            return 0
        # QgsMessageLog.logMessage("Calculating Model Rotation...", 'ENVI-met', level=Qgis.Info)

        spFeats = self.subAreaLayer.getFeatures()

        for f in spFeats:
            if f.hasGeometry():
                f_geo = f.geometry()
                numVert = 0

                # check that there are at least 3 vertices
                for v in f_geo.vertices():
                    numVert = numVert + 1

        if f_geo is None:
            self.iface.messageBar().pushMessage("Error", "Please provide a layer featuring a single rectangluar polygon.", level=Qgis.Warning)
        else:
            if numVert > 3:
                """
                R1---------------R2
                |                |
                |                |
                |                |
                R0---------------R3
                """
                R0 = f_geo.vertexAt(0)
                R1 = f_geo.vertexAt(1)          # second vertex
                R2 = f_geo.vertexAt(2)          # third vertex
                R3 = f_geo.vertexAt(3)          # last vertrex
                # R1 to R3 will define the base line for ENVI-met

                """
                print('R0:')
                print(R0)
                print('R1:')
                print(R1)
                print('R2:')
                print(R2)
                print('R3:')
                print(R3)
                """
                model_rot = 0
                # save the lower left point as the model rotation center point
                self.model_rot_center = R0


                # we now have 3 cases
                # if the y coord of B is lower than A than the angle is negative
                # if the y coord of B is higher than it is positive
                # if the y coord is the same, than the rotation is 0
                # the rotation center is always A
                RX = QgsPoint(R3.x(), R0.y())
                if R3.y() < R0.y(): # is this the case where the rotation is negative????
                    #print("R3.y() < R0.y()")
                    if R3.x() >= R0.x():
                        #print("R3.x() >= R0.x()")
                        a = RX.y() - R3.y()
                        b = RX.x() - R0.x()
                        c = sqrt((a)**2 + (b)**2)    # length hypo c
                        #print(str(c))
                        model_rot = -1 * (degrees(acos(b/c)))
                        #print(str(model_rot))
                    if R3.x() < R0.x():
                        #print("R3.x() < R0.x()")
                        a = RX.y() - R3.y()
                        b = R0.x() - RX.x()
                        c = sqrt((a)**2 + (b)**2)    # length hypo c
                        #print(str(c))
                        model_rot = -1 * (180 - degrees(acos(b/c)))
                        #print(str(model_rot))
                if R3.y() > R0.y():
                    if R3.x() >= R0.x():
                        #print("R3.x() >= R0.x()")
                        a = R3.y() - RX.y()
                        b = RX.x() - R0.x()
                        c = sqrt((a)**2 + (b)**2)    # length hypo c
                        #print(str(c))
                        model_rot = degrees(acos(b/c))
                        #print(str(model_rot))
                    if R3.x() < R0.x():
                        #print("R3.x() < R0.x()")
                        a = R3.y() - RX.y()
                        b = R0.x() - RX.x()
                        c = sqrt((a)**2 + (b)**2)    # length hypo c
                        #print(str(c))
                        model_rot = 180 - degrees(acos(b/c))
                        #print(str(model_rot))

                #print(str(model_rot))
                self.model_rot = model_rot
                self.rotateLayer(self.subAreaLayer, True)
                return model_rot

            else:
                # write a msg to the user
                self.iface.messageBar().pushMessage("Error", "Please provide a layer featuring a single rectangluar polygon.", level=Qgis.Warning)

    def getTimeZoneGeonames(self):
        QgsMessageLog.logMessage("Getting Timezone...", 'ENVI-met', level=Qgis.Info)
        try:
            response = requests.get('http://api.geonames.org/timezone?lat=' + str(self.lat) + '&lng=' + str(self.lon) + '&username=envi_met')
            if response.status_code == 200:
                s = response.text
                tree = ET.ElementTree(ET.fromstring(s))
                root = tree.getroot()
                for tz in root:
                    for data in tz:
                        if data.tag == "gmtOffset":
                            return data.text
            else:
                s = round(self.lat / 15)
                return str(s)
        except:
            s = round(self.lat / 15)
            return str(s)

    def getElevationGeonames(self):
        QgsMessageLog.logMessage("Getting Elevation...", 'ENVI-met', level=Qgis.Info)
        try:
            response = requests.get('http://api.geonames.org/srtm1XML?lat=' + str(self.lat) + '&lng=' + str(self.lon) + '&username=envi_met')
            if response.status_code == 200:
                s = response.text
                tree = ET.ElementTree(ET.fromstring(s))
                root = tree.getroot()
                for data in root:
                    if data.tag == "srtm1":
                        elev = int(data.text)
                        if elev >= 0:
                            return elev
                        else:
                            return self.refHeightDEM
            else:
                return self.refHeightDEM
        except:
            return self.refHeightDEM

    def calcVertExt(self):
        if (self.subAreaLayer.name() == "notAvail"):
            return

        self.getModelrot()

        self.II = round((self.subAreaExtent.xMaximum() - self.subAreaExtent.xMinimum()) / self.dx)
        self.JJ = round((self.subAreaExtent.yMaximum() - self.subAreaExtent.yMinimum()) / self.dy)

        if (self.bLayer.name() == "notAvail") or (self.bTop == "notAvail") or (self.bLayer.name() == "") or (self.bTop == ""):
            self.maxHeightB = 0
        else:
            # now rotate the bLayer
            bLayer = self.rotateLayer(self.bLayer, False)

            layer_provider = bLayer.dataProvider()


            # get all items in the vector layer BUILDINGS
            if bLayer.getFeatures() is None:
                self.maxHeightB = 0
            else:
                bFeats = bLayer.getFeatures()

                for f in bFeats:
                    if f.geometry().intersects(self.subAreaExtent):
                        bHeight = f[self.bTop]
                        if bHeight > self.maxHeightB:
                            self.maxHeightB = bHeight

        if self.bTop_UseCustom:
            self.maxHeightB = self.bTop_custom

        # now get the terrain max height
        if (self.dEMLayer.name() == "notAvail") or (self.dEMBand < 1):
            self.maxHeightDEM = 0
        else:
            self.getDEM()  #self.maxHeightDEM is now filled

        self.maxHeightTotal = self.maxHeightB + self.maxHeightDEM

        self.finished.emit()

    def previewdxy(self):
        if self.subAreaLayer.name() == "notAvail":
            self.finished.emit()
            return
        else:
            self.getModelrot()
            self.II = round((self.subAreaExtent.xMaximum() - self.subAreaExtent.xMinimum()) / self.dx)
            self.JJ = round((self.subAreaExtent.yMaximum() - self.subAreaExtent.yMinimum()) / self.dy)
            self.xMeters = round(self.subAreaExtent.xMaximum() - self.subAreaExtent.xMinimum())
            self.yMeters = round(self.subAreaExtent.yMaximum() - self.subAreaExtent.yMinimum())
            self.finished.emit()

    def previewdz(self):
        if self.useSplitting:
            self.finalKK = self.KK + 4
        else:
            self.finalKK = self.KK

        self.dzAr = np.zeros(self.finalKK, dtype=float)
        self.zLvl_bot = np.zeros(self.finalKK, dtype=float)
        self.zLvl_center = np.zeros(self.finalKK, dtype=float)
        if not self.useTelescoping:
            if self.useSplitting:
                for k in range(5):
                    self.dzAr[k] = self.dz / 5
                for k in range(5, self.finalKK):
                    self.dzAr[k] = self.dz
                for k in range(self.finalKK):
                    self.zLvl_bot[k] = 0
                for k in range(1, self.finalKK):
                    self.zLvl_bot[k] = self.zLvl_bot[k - 1] + self.dzAr[k - 1]
            else:
                for k in range(self.finalKK):
                    self.dzAr[k] = self.dz
                for k in range(self.finalKK):
                    self.zLvl_bot[k] = 0
                for k in range(1, self.finalKK):
                    self.zLvl_bot[k] = self.zLvl_bot[k - 1] + self.dzAr[k - 1]
        else:
            if self.useSplitting:
                self.dzAr = np.zeros((self.finalKK), dtype=float)
                self.zLvl_bot = np.zeros((self.finalKK), dtype=float)
                self.zLvl_center = np.zeros((self.finalKK), dtype=float)
                for k in range(5):
                    self.dzAr[k] = self.dz / 5
                for k in range(5, self.finalKK):
                    self.dzAr[k] = self.dz
                for k in range(self.finalKK):
                    self.zLvl_bot[k] = 0
                for k in range(1, self.finalKK):
                    self.zLvl_bot[k] = self.zLvl_bot[k - 1] + self.dzAr[k - 1]
                # now overwrite with telescoped grid
                for k in range(1, self.finalKK):
                    if self.zLvl_bot[k] >= self.teleStart:
                        self.dzAr[k] = self.dzAr[k - 1] * (1 + self.teleStretch / 100)
                for k in range(self.finalKK):
                    self.zLvl_bot[k] = 0
                for k in range(1, self.finalKK):
                    self.zLvl_bot[k] = self.zLvl_bot[k - 1] + self.dzAr[k - 1]
            else:
                for k in range(self.finalKK):
                    self.dzAr[k] = self.dz
                for k in range(self.finalKK):
                    self.zLvl_bot[k] = 0
                for k in range(1, self.finalKK):
                    self.zLvl_bot[k] = self.zLvl_bot[k - 1] + self.dzAr[k - 1]
                # now overwrite with telescoped grid
                for k in range(1, self.finalKK):
                    if self.zLvl_bot[k] >= self.teleStart:
                        self.dzAr[k] = self.dzAr[k - 1] * (1 + self.teleStretch / 100)
                for k in range(self.finalKK):
                    self.zLvl_bot[k] = 0
                for k in range(1, self.finalKK):
                    self.zLvl_bot[k] = self.zLvl_bot[k - 1] + self.dzAr[k - 1]
        # calc zLvl center
        for k in range(self.finalKK):
            self.zLvl_center[k] = self.zLvl_bot[k] + 0.5 * self.dzAr[k]
        self.finished.emit()

    def getUTMZone(self, lon: int):
        UTMZone_calc = trunc((floor(lon + 180) / 6) + 1)
        return UTMZone_calc

    def buildBInfo(self):
        self.s_buildingList.clear()
        if (self.bLayer.name() == "notAvail"):
            self.s_buildingList.clear()
            return self.s_buildingList

        if (self.bTop_UseCustom == False) and (self.bTop == ""):
            self.s_buildingList.clear()
            return self.s_buildingList

        QgsMessageLog.logMessage("Started: Generating Building Info section...", 'ENVI-met', level=Qgis.Info)

        # get all items in the vector layer
        if self.bLayer.getFeatures() is None:
            self.s_buildingList.clear()
            return self.s_buildingList.clear()

        self.bLayer_rot = self.rotateLayer(self.bLayer, False)

        bFeats = self.bLayer_rot.getFeatures()

        # start editing
        self.bLayer_rot.startEditing()
        bNumber_int = 'bNum_int'
        self.bLayer_rot.addAttribute(QgsField(bNumber_int, QVariant.Int))
        self.bLayer_rot.commitChanges()

        for a in self.bLayer_rot.attributeList():
            # print(a)
            # print(bLayer.attributeDisplayName(a))
            if self.bLayer_rot.attributeDisplayName(a) == bNumber_int:
                fieldID = a

        i = 1
        # start editing
        self.bLayer_rot.startEditing()
        for f in self.bLayer_rot.getFeatures():
            # only to that for the buildings in extent
            """
            if f.geometry().intersects(ext):
                featID = f.id()
                bLayer.changeAttributeValue(featID,fieldID,i,0,False)
                i = i + 1
            """
            # do it for all buildings
            featID = f.id()
            self.bLayer_rot.changeAttributeValue(featID, fieldID, i, 0, False)
            i = i + 1

        self.bLayer_rot.commitChanges()

        # we now have building numbers for all elements but we should only write the ones that are in our extend

        # get fields for building name; wallmaterial; roofmaterial; facadeGreening; wallGreening
        bName = self.bName
        bWall = self.bWall
        bRoof = self.bRoof
        bGWall = self.bGreenWall
        bGRoof = self.bGreenRoof

        # we only rotate the layer once
        ext = self.subAreaExtent

        self.s_buildingList.clear()
        for f in self.bLayer_rot.getFeatures():
            if f.geometry().intersects(ext):
                s_bNumber = f.attribute(bNumber_int)
                if (self.bName_UseCustom) or (self.bName == ""):
                    s_bName = str(self.bName_custom.replace("NULL", ""))
                else:
                    s_bName = str(f.attribute(self.bName)).replace("NULL", "")

                if (self.bWall_UseCustom) or (self.bWall == ""):
                    s_bWall = str(self.bWall_custom.replace("NULL", ""))
                else:
                    s_bWall = str(f.attribute(self.bWall)).replace("NULL", "")

                if (self.bRoof_custom) or (self.bRoof == ""):
                    s_bRoof = str(self.bRoof_custom.replace("NULL", ""))
                else:
                    s_bRoof = str(f.attribute(self.bRoof)).replace("NULL", "")

                if (self.bGreenWall_UseCustom) or (self.bGreenWall == ""):
                    s_bGWall = str(self.bGreenWall_custom.replace("NULL", ""))
                else:
                    s_bGWall = str(f.attribute(self.bGreenWall)).replace("NULL", "")

                if (self.bGreenRoof_UseCustom) or (self.bGreenRoof == ""):
                    s_bGRoof = str(self.bGreenRoof_custom.replace("NULL", ""))
                else:
                    s_bGRoof = str(f.attribute(self.bGreenRoof)).replace("NULL", "")

                if (self.bBPS_disabled) or (self.bBPS == ""):
                    s_bBPS = "0"
                else:
                    if str(f.attribute(self.bBPS)).replace("NULL", "") == '1':
                        s_bBPS = '1'
                    else:
                        s_bBPS = '0'

                newBuild = dict(BuildingInternalNr=s_bNumber, BuildingName=s_bName, BuildingWallMaterial=s_bWall,
                                BuildingRoofMaterial=s_bRoof, BuildingFacadeGreening=s_bGWall,
                                BuildingRoofGreening=s_bGRoof, BuildingBPS=s_bBPS, BuildingInModelArea=True)
                self.s_buildingList.append(newBuild)

                # print(s_Info)
        QgsMessageLog.logMessage("Finished: Generating Building Info section.", 'ENVI-met', level=Qgis.Info)
        # Change the data type to string for easy printing
        #print(self.s_buildingList)
        return self.s_buildingList

    def rasterBNumber(self):
        if (self.bLayer_rot.name() == "notAvail") is None:
            tmpAr = np.zeros(shape=(self.JJ, self.II), dtype=int)
            return tmpAr

        #bLayer = self.bLayer

        bNumber_int = 'bNum_int'

        #bLayer = self.BLayer_rot
        #bLayer = self.rotateLayer(bLayer, False)

        ext = self.subAreaExtent
        QgsMessageLog.logMessage("Started: Gridding Building Numbers...", 'ENVI-met', level=Qgis.Info)

        # os.system = "gdal_rasterize -l buildings -a enviHeight -tr 2.0 1.0 -a_nodata 0.0 -te 445941.5765 5537973.3545 448654.2682 5541029.0338 -ot Int32 -of GTiff -co COMPRESS=NONE -co BIGTIFF=IF_NEEDED E:/enviprojects/BVOC_mz/buildings.shp my123.tif"
        context = dataobjects.createContext()
        context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
        rlayer = processing.run("gdal:rasterize",
                                {"INPUT": self.bLayer_rot,
                                 "FIELD": bNumber_int,
                                 "UNITS": 1,
                                 "WIDTH": self.dx,
                                 "HEIGHT": self.dy,
                                 "EXTENT": ext,
                                 "NO_DATA": 0,
                                 "DATA_TYPE": 4,
                                 "INVERT": False,
                                 "OUTPUT": 'TEMPORARY_OUTPUT'},
                                context=context)
        rlayerFN = rlayer['OUTPUT']

        # Open the current layer
        grid1 = gdal.Open(rlayerFN)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the print options to maximum to print whole arrays of all following print functions
        np.set_printoptions(threshold=sys.maxsize)

        # Get values of model area
        width = grid1.RasterXSize
        height = grid1.RasterYSize
        z_value = grid1_band.GetMaximum()

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]

        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None

        QgsMessageLog.logMessage("Finished: Gridding Building Numbers", 'ENVI-met', level=Qgis.Info)
        # Change the data type to string for easy printing
        return grid1_int_array

    def rasterBTop(self):
        if (self.bLayer_rot.name() == "notAvail") is None:
            tmpAr = np.zeros(shape=(self.JJ, self.II), dtype=int)
            return tmpAr

        QgsMessageLog.logMessage("Started: Gridding Building Tops...", 'ENVI-met', level=Qgis.Info)

        # layer was already rotated in buildBNumbers
        #bLayer = self.BLayer_rot
        #bLayer = self.rotateLayer(bLayer, False)

        ext = self.subAreaExtent

        if self.bTop_UseCustom:
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.bLayer_rot,
                                     "BURN": self.bTop_custom,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']
        else:
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.bLayer_rot,
                                     "FIELD": self.bTop,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']
        # print(rlayer)
        # Open the current layer
        grid1 = gdal.Open(rlayerFN)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the printoptions to maximum to print whole arrays of all following print funtions
        np.set_printoptions(threshold=sys.maxsize)

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]

        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None
        QgsMessageLog.logMessage("Finished: Gridding Building Tops.", 'ENVI-met', level=Qgis.Info)
        return grid1_int_array

    def rasterBBot(self):
        if (self.bLayer_rot.name() == "notAvail") is None:
            tmpAr = np.zeros(shape=(self.JJ, self.II), dtype=int)
            return tmpAr

        QgsMessageLog.logMessage("Started: Gridding Building Bottoms...", 'ENVI-met', level=Qgis.Info)
        #bLayer = self.bLayer

        #bLayer = self.BLayer_rot
        #bLayer = self.rotateLayer(bLayer, False)
        ext = self.subAreaExtent

        # os.system = "gdal_rasterize -l buildings -a enviHeight -tr 2.0 1.0 -a_nodata 0.0 -te 445941.5765 5537973.3545 448654.2682 5541029.0338 -ot Int32 -of GTiff -co COMPRESS=NONE -co BIGTIFF=IF_NEEDED E:/enviprojects/BVOC_mz/buildings.shp my123.tif"
        if self.bBot_UseCustom:
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.bLayer_rot,
                                     "BURN": self.bBot_custom,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']
        else:
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.bLayer_rot,
                                     "FIELD": self.bBot,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']

        # Open the current layer
        grid1 = gdal.Open(rlayerFN)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the printoptions to maximum to print whole arrays of all following print funtions
        np.set_printoptions(threshold=sys.maxsize)

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]

        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None

        # Change the data type to string for easy printing
        QgsMessageLog.logMessage("Finished: Gridding Building Bottoms.", 'ENVI-met', level=Qgis.Info)
        return grid1_int_array

    def rasterSurf(self):
        if (self.surfLayer.name() == "notAvail") is None:
            tmpAr = np.zeros(shape=(self.JJ, self.II), dtype=int)
            grid1_str_array = tmpAr.astype(str)
            # print(grid1_str_array)
            # print(len(grid1_str_array[0]))
            # print(len(grid1_str_array[1]))
            # print(grid1_str_array)
            for i in range(tmpAr.shape[0]):
                for j in range(tmpAr.shape[1]):
                    if tmpAr[i, j] == 0:
                        grid1_str_array[i, j] = self.startSurfID
            return grid1_str_array

        QgsMessageLog.logMessage("Started: Gridding Surfaces...", 'ENVI-met', level=Qgis.Info)
        #self.SurfLayer_rot = self.rotateLayer(surfLayer, False)
        #surfLayer = self.SurfLayer_rot
        self.surfLayer_rot = self.rotateLayer(self.surfLayer, False)

        # QgsProject.instance().addMapLayer(surfLayer)
        ext = self.subAreaExtent


        # get all items in the vector layer
        surfFeats = self.surfLayer_rot.getFeatures()

        aTmpList = []


        # fill the with key(ENVIID) and value(int) pairs
        for f in surfFeats:
            surfID_str = f[self.surfID]
            if surfID_str and not surfID_str.isspace():
                # check if list is empty, if so: add first item
                if len(aTmpList) == 0:
                    eID = IDlookUP(1, surfID_str)
                    aTmpList.append(eID)
                # check if we need to add item
                isItemInList = False
                for x in aTmpList:
                    if x.enviID == surfID_str:
                        isItemInList = True
                        break

                # depending on isItemInList, add new key value pair
                if not isItemInList:
                    eID = IDlookUP(len(aTmpList) + 1, surfID_str)
                    aTmpList.append(eID)

        # start editing
        self.surfLayer_rot.startEditing()
        ID_int = 'ID_int'
        self.surfLayer_rot.addAttribute(QgsField(ID_int, QVariant.Int))

        for f in self.surfLayer_rot.getFeatures():
            # get enviID in string
            surfID_str = f[self.surfID]
            surfID_int = -1
            for x in aTmpList:
                if x.enviID == surfID_str:
                    surfID_int = x.idx
                    # print("found_data: "+ str(surfID_int))
                    break
            f[ID_int] = surfID_int
            self.surfLayer_rot.updateFeature(f)  # do we need that?

        self.surfLayer_rot.commitChanges()

        #QgsMessageLog.logMessage("*****Started: RASTER Surfaces...", 'ENVI-met', level=Qgis.Info)
        context = dataobjects.createContext()
        context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
        rlayer = processing.run("gdal:rasterize",
                                {"INPUT": self.surfLayer_rot,
                                 "FIELD": ID_int,
                                 "UNITS": 1,
                                 "WIDTH": self.dx,
                                 "HEIGHT": self.dy,
                                 "EXTENT": ext,
                                 "NO_DATA": 0,
                                 "DATA_TYPE": 4,
                                 "INVERT": False,
                                 "OUTPUT": 'TEMPORARY_OUTPUT'},
                                context=context)
        rlayerFN = rlayer['OUTPUT']
        # self.iface.addRasterLayer(rlayerFN,"surf_debug")

        # Open the current layer
        grid1 = gdal.Open(rlayerFN)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the printoptions to maximum to print whole arrays of all following print functions
        np.set_printoptions(threshold=sys.maxsize)

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]
        # print(self.II)
        # print(self.JJ)

        grid1_str_array = grid1_int_array.astype(str)
        # print(grid1_str_array)
        # print(len(grid1_str_array[0]))
        # print(len(grid1_str_array[1]))
        # print(grid1_str_array)
        for i in range(grid1_int_array.shape[0]):
            for j in range(grid1_int_array.shape[1]):
                if grid1_int_array[i, j] <= 0:
                    grid1_str_array[i, j] = self.startSurfID
                for x in aTmpList:
                    if grid1_int_array[i, j] == x.idx:
                        grid1_str_array[i, j] = x.enviID

        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None
        aTmpList.clear()
        QgsMessageLog.logMessage("Finished: Gridding Surfaces.", 'ENVI-met', level=Qgis.Info)
        # Change the data type to string for easy printing
        return grid1_str_array

    def rasterSimplePlants(self):
        if (self.plant1dLayer.name() == "notAvail") is None:
            tmpAr = np.zeros(shape=(self.JJ, self.II), dtype=int)
            grid1_str_array = tmpAr.astype(str)
            # print(grid1_str_array)
            # print(len(grid1_str_array[0]))
            # print(len(grid1_str_array[1]))
            # print(grid1_str_array)
            for i in range(tmpAr.shape[0]):
                for j in range(tmpAr.shape[1]):
                    if tmpAr[i, j] == 0:
                        grid1_str_array[i, j] = ""
            return grid1_str_array

        QgsMessageLog.logMessage("Started: Gridding Simple Plants...", 'ENVI-met', level=Qgis.Info)
        self.plant1dLayer_rot = self.rotateLayer(self.plant1dLayer, False)
        ext = self.subAreaExtent

        if not self.plant1dID_UseCustom:
            # get all items in the vector layer
            spFeats = self.plant1dLayer_rot.getFeatures()

            # create an empty list
            aTmpList = []

            # fill the with key(ENVIID) and value(int) pairs
            for f in spFeats:
                surfID_str = f[self.plant1dID]
                if surfID_str and not surfID_str.isspace():
                    # check if list is empty, if so: add first item
                    if len(aTmpList) == 0:
                        eID = IDlookUP(1,surfID_str)
                        aTmpList.append(eID)
                    # check if we need to add item
                    isItemInList = False
                    for x in aTmpList:
                        if x.enviID == surfID_str:
                            isItemInList = True
                            break

                    # depending on isItemInList, add new key value pair
                    if not isItemInList:
                        eID = IDlookUP(len(aTmpList) + 1, surfID_str)
                        aTmpList.append(eID)

            # start editing
            self.plant1dLayer_rot.startEditing()
            ID_int = 'ID_int'
            self.plant1dLayer_rot.addAttribute(QgsField(ID_int, QVariant.Int))

            for f in self.plant1dLayer_rot.getFeatures():
                # get enviID in string
                surfID_str = f[self.plant1dID]
                surfID_int = -1
                for x in aTmpList:
                    if x.enviID == surfID_str:
                        surfID_int = x.idx
                        # print("found_data: "+ str(surfID_int))
                        break
                f[ID_int] = surfID_int
                self.plant1dLayer_rot.updateFeature(f)

            self.plant1dLayer_rot.commitChanges()

            # os.system = "gdal_rasterize -l buildings -a enviHeight -tr 2.0 1.0 -a_nodata 0.0 -te 445941.5765 5537973.3545 448654.2682 5541029.0338 -ot Int32 -of GTiff -co COMPRESS=NONE -co BIGTIFF=IF_NEEDED E:/enviprojects/BVOC_mz/buildings.shp my123.tif"
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.plant1dLayer_rot,
                                     "FIELD": ID_int,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)

            rlayerFN = rlayer['OUTPUT']
        else:
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.plant1dLayer_rot,
                                     "BURN": 999,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']

        # Open the current layer
        grid1 = gdal.Open(rlayerFN)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the printoptions to maximum to print whole arrays of all following print funtions
        np.set_printoptions(threshold=sys.maxsize)

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]
        # print(self.II)
        # print(self.JJ)

        grid1_str_array = grid1_int_array.astype(str)
        # print(len(grid1_str_array[0]))
        # print(len(grid1_str_array[1]))
        # print(grid1_str_array)
        for i in range(grid1_int_array.shape[0]):
            for j in range(grid1_int_array.shape[1]):
                if grid1_int_array[i, j] <= 0:
                    grid1_str_array[i, j] = ""
                if not self.plant1dID_UseCustom:
                    for x in aTmpList:
                        if grid1_int_array[i, j] == x.idx:
                            grid1_str_array[i, j] = x.enviID
                else:
                    if grid1_int_array[i, j] == 999:
                        grid1_str_array[i, j] = self.plant1dID_custom

        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None
        if not self.plant1dID_UseCustom:
            aTmpList.clear()
        # Change the data type to string for easy printing

        QgsMessageLog.logMessage("Finished: Gridding Simple Plants.", 'ENVI-met', level=Qgis.Info)
        return grid1_str_array

    def buildPlants3d(self):
        if (self.plant3dLayer.name() == "notAvail"):
            self.s_treeList.clear()
            return self.s_treeList

        if (self.plant3dID == ""):
            self.s_treeList.clear()
            return self.s_treeList

        QgsMessageLog.logMessage("Started: Gridding 3D Plants...", 'ENVI-met', level=Qgis.Info)
        self.plant3dLayer_rot = self.rotateLayer(self.plant3dLayer, False)
        ext = self.subAreaExtent

        # get all items in the vector layer
        if self.plant3dLayer_rot.getFeatures() is None:
            self.s_treeList.clear()
            return self.s_treeList

        # user wants a const value for Trees
        if self.plant3dID_UseCustom:
            ENVI_ID = self.plant3dID_custom

            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.plant3dLayer_rot,
                                     "BURN": 999,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']
        else:  # User wants to use an attribute field: get field where the ID string is stored
            self.plant3dLayer_rot.startEditing()
            ID_int = 'ID_int'
            self.plant3dLayer_rot.addAttribute(QgsField(ID_int, QVariant.Int))

            # add a unique number to each tree
            plantID_idx = 1
            for f in self.plant3dLayer_rot.getFeatures():
                f[ID_int] = plantID_idx
                self.plant3dLayer_rot.updateFeature(f)
                plantID_idx = plantID_idx + 1

            self.plant3dLayer_rot.commitChanges()


            # create an empty list
            aTmpList = []

            spFeats = self.plant3dLayer_rot.getFeatures()

            for f in spFeats:
                plantID_str = "000000"
                plantID_str = f[self.plant3dID]

                if plantID_str and not plantID_str.isspace():
                    plantID_idx = f[ID_int]
                    #print(plantID_str)
                    if self.plant3dAddOut_disabled or (self.plant3dAddOut == ""):
                        obs_str = '0'
                    else:
                        #obs_str = f[self.plant3dAddOut]
                        if str(f[self.plant3dAddOut]).replace("NULL", "0") == '1':
                            obs_str = '1'
                            #print('obs_str = 1')
                            #print(str(f.attribute(self.plant3dAddOut)).replace("NULL", "0"))
                        else:
                            obs_str = '0'
                            #print('obs_str = 0')
                            #print(str(f.attribute(self.plant3dAddOut)).replace("NULL", "0"))

                    eID = TreeInList(plantID_idx, plantID_str, obs_str)
                    #print('eID: ' + str(eID.idx) + ' ' + eID.enviID + ' ' + eID.obs)
                    aTmpList.append(eID)
            #print('-------')
            #print(aTmpList)
            #print('-------')


            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.plant3dLayer_rot,
                                     "FIELD": ID_int,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']

        # self.iface.addRasterLayer(rlayerFN,"tree_debug")

        # Open the current layer
        grid1 = gdal.Open(rlayerFN)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the print options to maximum to print whole arrays of all following print functions
        np.set_printoptions(threshold=sys.maxsize)

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]
        # print("tree:II")
        # print(self.II)
        # print("tree:JJ")
        # print(self.JJ)

        # reconvert to XML tags
        self.s_treeList.clear()

        grid1_str_array = grid1_int_array.astype(str)
        # print(len(grid1_str_array[0]))
        # print(len(grid1_str_array[1]))
        # print(grid1_str_array)
        if self.plant3dID_UseCustom:
            for i in range(grid1_int_array.shape[0]):
                for j in range(grid1_int_array.shape[1]):
                    if grid1_int_array[i, j] <= 0:
                        grid1_str_array[i, j] = ""
                    if grid1_int_array[i, j] == 999:
                        grid1_str_array[i, j] = ENVI_ID
                        newTree = dict(rootcell_i=j, rootcell_j=self.JJ - i, rootcell_k=0, plantID=str(ENVI_ID),
                                       name='Imported Plant', observe=0)
                        self.s_treeList.append(newTree)
        else:
            for i in range(grid1_int_array.shape[0]):
                for j in range(grid1_int_array.shape[1]):
                    if grid1_int_array[i, j] <= 0:
                        grid1_str_array[i, j] = ""
                    else:
                        for x in aTmpList:
                            if grid1_int_array[i, j] == x.idx:
                                grid1_str_array[i, j] = x.enviID
                                newTree = dict(rootcell_i=j, rootcell_j=self.JJ - i, rootcell_k=0,
                                               plantID=x.enviID.replace("NULL", ""), name='Imported Plant',
                                               observe=x.obs)
                                self.s_treeList.append(newTree)
            aTmpList.clear()
        #print(grid1_str_array)
        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None

        QgsMessageLog.logMessage("Finished: Gridding 3D Plants.", 'ENVI-met', level=Qgis.Info)
        return self.s_treeList

    def getDEM(self):
        # first clip the raster based on the NON rotated subArea (maybe add some margins - only if raster is bigger than subArea)
        # get non-rotated extend of subArea
        subAreaLayer_nonRot = self.subAreaLayer_nonRot
        # calculate extent of first feature
        spFeats = subAreaLayer_nonRot.getFeatures()
        for f in spFeats:
            if f.hasGeometry():
                f_geo = f.geometry()
                subArea_nonRot_Extent = f_geo.boundingBox()
                # print("bBox extent")
                # print(subArea_nonRot_Extent)

        # now clip the raster to that extent
        # transform the coordinate system of subArea_nonRot_Extent to the ones of the DEM
        # subArea_nonRot_Extent = QgsRectangle(-73.99290836344986,40.77707305651126,-73.96828332218108,40.76350771117235)
        # print(subArea_nonRot_Extent)
        context = dataobjects.createContext()
        context.setInvalidGeometryCheck(
            QgsFeatureRequest.GeometryNoCheck)  # #"OVERCRS":False a NEW parameter for QGIS > 3.18
        rlayer_clip = processing.run("gdal:cliprasterbyextent",
                                     {"INPUT": self.dEMLayer,
                                      "PROJWIN": subArea_nonRot_Extent,
                                      "OVERCRS": False,
                                      "OUTPUT": 'TEMPORARY_OUTPUT'},
                                     context=context)
        rlayerFN_clip = rlayer_clip['OUTPUT']
        # self.iface.addRasterLayer(rlayerFN_clip, "clip_debug")

        # then vectorize using: raster pixels to points
        context = dataobjects.createContext()
        context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
        rlayer_vec = processing.run("native:pixelstopolygons",
                                    {"INPUT_RASTER": rlayerFN_clip,
                                     "RASTER_BAND": self.dEMBand,
                                     "FIELD_NAME": "HEIGHT",
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
        rlayerFN_vec = rlayer_vec['OUTPUT']
        # QgsProject.instance().addMapLayer(rlayerFN_vec)

        # then rotate the result
        spLayer = self.rotateLayer(rlayerFN_vec, False)
        # QgsProject.instance().addMapLayer(spLayer)

        # then grid the result
        ext = self.subAreaExtent
        context = dataobjects.createContext()
        context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
        rlayer_grid = processing.run("gdal:rasterize",
                                     {"INPUT": spLayer,
                                      "FIELD": 'HEIGHT',
                                      "UNITS": 1,
                                      "WIDTH": self.dx,
                                      "HEIGHT": self.dy,
                                      "EXTENT": ext,
                                      "NO_DATA": -999,
                                      "INIT": -999,
                                      "DATA_TYPE": 4,
                                      "INVERT": False,
                                      "OUTPUT": 'TEMPORARY_OUTPUT'},
                                     context=context)
        rlayerFN_grid = rlayer_grid['OUTPUT']
        # self.iface.addRasterLayer(rlayerFN_grid, "grid_debug")

        # Open the current layer
        grid1 = gdal.Open(rlayerFN_grid)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the printoptions to maximum to print whole arrays of all following print functions
        np.set_printoptions(threshold=sys.maxsize)

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)
        # print(grid1_int_array)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]
        # print(self.II)
        # print(self.JJ)

        # fill empty cells (-999)
        for i in range(grid1_int_array.shape[0]):
            for j in range(grid1_int_array.shape[1]):
                if grid1_int_array[i, j] == -999:
                    # print("in - 999")
                    nextNeigh = False
                    neighCnt = 0
                    neighSum = 0
                    srchRad = 1
                    # check left and top
                    while nextNeigh == False:
                        # test left
                        if i - srchRad > 0:
                            if grid1_int_array[i - srchRad, j] != -999:
                                nextNeigh = True
                                neighSum += grid1_int_array[i - srchRad, j]
                                neighCnt += 1
                        # test right
                        if i + srchRad < grid1_int_array.shape[0]:
                            if grid1_int_array[i + srchRad, j] != -999:
                                nextNeigh = True
                                neighSum += grid1_int_array[i + srchRad, j]
                                neighCnt += 1
                        # test up
                        if j - srchRad > 0:
                            if grid1_int_array[i, j - srchRad] != -999:
                                nextNeigh = True
                                neighSum += grid1_int_array[i, j - srchRad]
                                neighCnt += 1
                        # test down
                        if j + srchRad > grid1_int_array.shape[1]:
                            if grid1_int_array[i, j + srchRad] != -999:
                                nextNeigh = True
                                neighSum += grid1_int_array[i, j + srchRad]
                                neighCnt += 1
                        # test diagonal left up
                        if i - srchRad > 0 and j - srchRad > 0:
                            if grid1_int_array[i - srchRad, j - srchRad] != -999:
                                nextNeigh = True
                                neighSum += grid1_int_array[i - srchRad, j - srchRad]
                                neighCnt += 1
                        # test diagonal left down
                        if i - srchRad > 0 and j + srchRad > grid1_int_array.shape[1]:
                            if grid1_int_array[i - srchRad, j + srchRad] != -999:
                                nextNeigh = True
                                neighSum += grid1_int_array[i - srchRad, j + srchRad]
                                neighCnt += 1
                        # test diagonal right down
                        if i + srchRad < grid1_int_array.shape[0] and j + srchRad > grid1_int_array.shape[1]:
                            if grid1_int_array[i + srchRad, j + srchRad] != -999:
                                nextNeigh = True
                                neighSum += grid1_int_array[i + srchRad, j + srchRad]
                                neighCnt += 1
                        # test diagonal right up
                        if i + srchRad < grid1_int_array.shape[0] and j - srchRad > 0:
                            if grid1_int_array[i + srchRad, j - srchRad] != -999:
                                nextNeigh = True
                                neighSum += grid1_int_array[i + srchRad, j - srchRad]
                                neighCnt += 1
                        # not found yet... increase srchRadius.....
                        if nextNeigh == False:
                            srchRad = srchRad + 1
                        if nextNeigh:
                            grid1_int_array[i, j] = round(neighSum / neighCnt)

        # find lowest DEM
        minHeight = 9999999
        for i in range(grid1_int_array.shape[0]):
            for j in range(grid1_int_array.shape[1]):
                if grid1_int_array[i, j] < minHeight:
                    minHeight = grid1_int_array[i, j]

        maxHeight = -9999999
        # then remove the level by the lowest number in the grid and save the DEM max height
        for i in range(grid1_int_array.shape[0]):
            for j in range(grid1_int_array.shape[1]):
                grid1_int_array[i, j] = grid1_int_array[i, j] - minHeight
                if grid1_int_array[i, j] > maxHeight:
                    maxHeight = grid1_int_array[i, j]

        self.refHeightDEM = minHeight
        self.maxHeightDEM = maxHeight - minHeight

        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None

        return grid1_int_array

    def rasterSrcP(self):
        if (self.srcPLayer.name() == "notAvail") is None:
            tmpAr = np.zeros(shape=(self.JJ, self.II), dtype=int)
            grid1_str_array = tmpAr.astype(str)
            # print(grid1_str_array)
            # print(len(grid1_str_array[0]))
            # print(len(grid1_str_array[1]))
            # print(grid1_str_array)
            for i in range(tmpAr.shape[0]):
                for j in range(tmpAr.shape[1]):
                    if tmpAr[i, j] == 0:
                        grid1_str_array[i, j] = ""
            return grid1_str_array

        QgsMessageLog.logMessage("Started: Gridding Sources (Points)...", 'ENVI-met', level=Qgis.Info)
        self.srcPLayer_rot = self.rotateLayer(self.srcPLayer, False)
        ext = self.subAreaExtent

        if not self.srcPID_UseCustom:
            # get all items in the vector layer
            spFeats = self.srcPLayer_rot.getFeatures()

            # create an empty list
            aTmpList = []

            # fill the with key(ENVIID) and value(int) pairs
            for f in spFeats:
                sID_str = f[self.srcPID]
                if sID_str and not sID_str.isspace():
                    # check if list is empty, if so: add first item
                    if len(aTmpList) == 0:
                        eID = IDlookUP(1,sID_str)
                        aTmpList.append(eID)
                    # check if we need to add item
                    isItemInList = False
                    for x in aTmpList:
                        if x.enviID == sID_str:
                            isItemInList = True
                            break

                    # depending on isItemInList, add new key value pair
                    if not isItemInList:
                        eID = IDlookUP(len(aTmpList) + 1, sID_str)
                        aTmpList.append(eID)

            # start editing
            self.srcPLayer_rot.startEditing()
            ID_int = 'ID_int'
            self.srcPLayer_rot.addAttribute(QgsField(ID_int, QVariant.Int))

            for f in self.srcPLayer_rot.getFeatures():
                # get enviID in string
                sID_str = f[self.srcPID]
                sID_int = -1
                for x in aTmpList:
                    if x.enviID == sID_str:
                        sID_int = x.idx
                        # print("found_data: "+ str(sID_int))
                        break
                f[ID_int] = sID_int
                self.srcPLayer_rot.updateFeature(f)

            self.srcPLayer_rot.commitChanges()

            # os.system = "gdal_rasterize -l buildings -a enviHeight -tr 2.0 1.0 -a_nodata 0.0 -te 445941.5765 5537973.3545 448654.2682 5541029.0338 -ot Int32 -of GTiff -co COMPRESS=NONE -co BIGTIFF=IF_NEEDED E:/enviprojects/BVOC_mz/buildings.shp my123.tif"
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.srcPLayer_rot,
                                     "FIELD": ID_int,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']
        else:
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.srcPLayer_rot,
                                     "BURN": 999,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']

        # Open the current layer
        grid1 = gdal.Open(rlayerFN)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the printoptions to maximum to print whole arrays of all following print functions
        np.set_printoptions(threshold=sys.maxsize)

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]
        # print(self.II)
        # print(self.JJ)

        grid1_str_array = grid1_int_array.astype(str)
        # print(len(grid1_str_array[0]))
        # print(len(grid1_str_array[1]))
        # print(grid1_str_array)
        for i in range(grid1_int_array.shape[0]):
            for j in range(grid1_int_array.shape[1]):
                if grid1_int_array[i, j] <= 0:
                    grid1_str_array[i, j] = ""
                if not self.srcPID_UseCustom:
                    for x in aTmpList:
                        if grid1_int_array[i, j] == x.idx:
                            grid1_str_array[i, j] = x.enviID
                else:
                    if grid1_int_array[i, j] == 999:
                        grid1_str_array[i, j] = self.srcPID_custom

        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None
        if not self.srcPID_UseCustom:
            aTmpList.clear()
        # Change the data type to string for easy printing

        QgsMessageLog.logMessage("Finished: Gridding Sources (Points).", 'ENVI-met', level=Qgis.Info)
        return grid1_str_array

    def rasterSrcL(self):
        if (self.srcLLayer.name() == "notAvail") is None:
            tmpAr = np.zeros(shape=(self.JJ, self.II), dtype=int)
            grid1_str_array = tmpAr.astype(str)
            # print(grid1_str_array)
            # print(len(grid1_str_array[0]))
            # print(len(grid1_str_array[1]))
            # print(grid1_str_array)
            for i in range(tmpAr.shape[0]):
                for j in range(tmpAr.shape[1]):
                    if tmpAr[i, j] == 0:
                        grid1_str_array[i, j] = ""
            return grid1_str_array


        if self.srcLID_UseCustom and (self.srcLID_custom == "notAvail"):
            tmpAr = np.zeros(shape=(self.JJ, self.II), dtype=int)
            grid1_str_array = tmpAr.astype(str)
            # print(len(grid1_str_array[0]))
            # print(len(grid1_str_array[1]))
            # print(grid1_str_array)
            for i in range(tmpAr.shape[0]):
                for j in range(tmpAr.shape[1]):
                    if tmpAr[i, j] == 0:
                        grid1_str_array[i, j] = ""
            return grid1_str_array

        QgsMessageLog.logMessage("Started: Gridding Sources (Lines)...", 'ENVI-met', level=Qgis.Info)
        self.srcLLayer_rot = self.rotateLayer(self.srcLLayer, False)
        ext = self.subAreaExtent

        if not self.srcLID_UseCustom:
            # get all items in the vector layer
            spFeats = self.srcLLayer_rot.getFeatures()

            # create an empty list
            aTmpList = []

            # fill the with key(ENVIID) and value(int) pairs
            for f in spFeats:
                sID_str = f[self.srcLID]
                #print(sID_str)
                if sID_str and not sID_str.isspace():
                    # check if list is empty, if so: add first item
                    if len(aTmpList) == 0:
                        eID = IDlookUP(1,sID_str)
                        aTmpList.append(eID)
                    # check if we need to add item
                    isItemInList = False
                    for x in aTmpList:
                        if x.enviID == sID_str:
                            isItemInList = True
                            break

                    # depending on isItemInList, add new key value pair
                    if not isItemInList:
                        eID = IDlookUP(len(aTmpList) + 1, sID_str)
                        aTmpList.append(eID)
            #print(aTmpList)
            # start editing
            self.srcLLayer_rot.startEditing()
            ID_int = 'ID_int'
            self.srcLLayer_rot.addAttribute(QgsField(ID_int, QVariant.Int))

            for f in self.srcLLayer_rot.getFeatures():
                # get enviID in string
                sID_str = f[self.srcLID]
                sID_int = -1
                for x in aTmpList:
                    if x.enviID == sID_str:
                        sID_int = x.idx
                        #print("found_data: " + sID_str + " - " + str(sID_int))
                        break
                f[ID_int] = sID_int
                #print(str(f[ID_int]))
                self.srcLLayer_rot.updateFeature(f)

            self.srcLLayer_rot.commitChanges()

            # os.system = "gdal_rasterize -l buildings -a enviHeight -tr 2.0 1.0 -a_nodata 0.0 -te 445941.5765 5537973.3545 448654.2682 5541029.0338 -ot Int32 -of GTiff -co COMPRESS=NONE -co BIGTIFF=IF_NEEDED E:/enviprojects/BVOC_mz/buildings.shp my123.tif"
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.srcLLayer_rot,
                                     "FIELD": ID_int,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']
        else:
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.srcLLayer_rot,
                                     "BURN": 999,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']

        #print(rlayerFN)

        # Open the current layer
        grid1 = gdal.Open(rlayerFN)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the printoptions to maximum to print whole arrays of all following print functions
        np.set_printoptions(threshold=sys.maxsize)

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]
        # print(self.II)
        # print(self.JJ)

        grid1_str_array = grid1_int_array.astype(str)
        # print(len(grid1_str_array[0]))
        # print(len(grid1_str_array[1]))
        # print(grid1_str_array)
        for i in range(grid1_int_array.shape[0]):
            for j in range(grid1_int_array.shape[1]):
                if grid1_int_array[i, j] <= 0:
                    grid1_str_array[i, j] = ""
                if not self.srcLID_UseCustom:
                    for x in aTmpList:
                        if grid1_int_array[i, j] == x.idx:
                            grid1_str_array[i, j] = x.enviID
                else:
                    if grid1_int_array[i, j] == 999:
                        grid1_str_array[i, j] = self.srcLID_custom

        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None
        if not self.srcLID_UseCustom:
            aTmpList.clear()
        # Change the data type to string for easy printing

        QgsMessageLog.logMessage("Finished: Gridding Sources (Lines).", 'ENVI-met', level=Qgis.Info)
        return grid1_str_array

    def rasterSrcA(self):
        if (self.srcALayer.name() == "notAvail") is None:
            tmpAr = np.zeros(shape=(self.JJ, self.II), dtype=int)
            grid1_str_array = tmpAr.astype(str)
            # print(grid1_str_array)
            # print(len(grid1_str_array[0]))
            # print(len(grid1_str_array[1]))
            # print(grid1_str_array)
            for i in range(tmpAr.shape[0]):
                for j in range(tmpAr.shape[1]):
                    if tmpAr[i, j] == 0:
                        grid1_str_array[i, j] = ""
            return grid1_str_array

        QgsMessageLog.logMessage("Started: Gridding Sources (Areas)...", 'ENVI-met', level=Qgis.Info)
        self.srcALayer_rot = self.rotateLayer(self.srcALayer, False)
        ext = self.subAreaExtent

        if not self.srcAID_UseCustom:
            # get all items in the vector layer
            spFeats = self.srcALayer_rot.getFeatures()

            # create an empty list
            aTmpList = []

            # fill the with key(ENVIID) and value(int) pairs
            for f in spFeats:
                sID_str = f[self.srcAID]
                if sID_str and not sID_str.isspace():
                    # check if list is empty, if so: add first item
                    if len(aTmpList) == 0:
                        eID = IDlookUP(1,sID_str)
                        aTmpList.append(eID)
                    # check if we need to add item
                    isItemInList = False
                    for x in aTmpList:
                        if x.enviID == sID_str:
                            isItemInList = True
                            break

                    # depending on isItemInList, add new key value pair
                    if not isItemInList:
                        eID = IDlookUP(len(aTmpList) + 1, sID_str)
                        aTmpList.append(eID)

            # start editing
            self.srcALayer_rot.startEditing()
            ID_int = 'ID_int'
            self.srcALayer_rot.addAttribute(QgsField(ID_int, QVariant.Int))

            for f in self.srcALayer_rot.getFeatures():
                # get enviID in string
                sID_str = f[self.srcAID]
                sID_int = -1
                for x in aTmpList:
                    if x.enviID == sID_str:
                        sID_int = x.idx
                        # print("found_data: "+ str(sID_int))
                        break
                f[ID_int] = sID_int
                self.srcALayer_rot.updateFeature(f)

            self.srcALayer_rot.commitChanges()

            # os.system = "gdal_rasterize -l buildings -a enviHeight -tr 2.0 1.0 -a_nodata 0.0 -te 445941.5765 5537973.3545 448654.2682 5541029.0338 -ot Int32 -of GTiff -co COMPRESS=NONE -co BIGTIFF=IF_NEEDED E:/enviprojects/BVOC_mz/buildings.shp my123.tif"
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.srcALayer_rot,
                                     "FIELD": ID_int,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']
        else:
            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.srcALayer_rot,
                                     "BURN": 999,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']

        # Open the current layer
        grid1 = gdal.Open(rlayerFN)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the printoptions to maximum to print whole arrays of all following print functions
        np.set_printoptions(threshold=sys.maxsize)

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]
        # print(self.II)
        # print(self.JJ)

        grid1_str_array = grid1_int_array.astype(str)
        # print(len(grid1_str_array[0]))
        # print(len(grid1_str_array[1]))
        # print(grid1_str_array)
        for i in range(grid1_int_array.shape[0]):
            for j in range(grid1_int_array.shape[1]):
                if grid1_int_array[i, j] <= 0:
                    grid1_str_array[i, j] = ""
                if not self.srcAID_UseCustom:
                    for x in aTmpList:
                        if grid1_int_array[i, j] == x.idx:
                            grid1_str_array[i, j] = x.enviID
                else:
                    if grid1_int_array[i, j] == 999:
                        grid1_str_array[i, j] = self.srcAID_custom

        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None
        if not self.srcAID_UseCustom:
            aTmpList.clear()
        # Change the data type to string for easy printing

        QgsMessageLog.logMessage("Finished: Gridding Sources (Areas).", 'ENVI-met', level=Qgis.Info)
        return grid1_str_array

    def buildReceptors(self):
        #
        if (self.recLayer.name() == "notAvail"):
            self.s_recList.clear()
            return self.s_recList

        QgsMessageLog.logMessage("Started: Gridding Receptors...", 'ENVI-met', level=Qgis.Info)
        self.recLayer_rot = self.rotateLayer(self.recLayer, False)
        ext = self.subAreaExtent

        # get all items in the vector layer
        if self.recLayer_rot.getFeatures() is None:
            self.s_recList.clear()
            return self.s_recList
        spFeats = self.recLayer_rot.getFeatures()

        # user wants a const value for Trees
        if self.recID_UseCustom:
            ENVI_ID = self.recID_custom

            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.recLayer_rot,
                                     "BURN": 999,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']
        else:  # User wants to use an attribute field: get field where the ID string is stored
            # create an empty list
            aTmpList = []

            # fill the list with key(ENVIID) and value(int) pairs
            for f in spFeats:
                surfID_str = f[self.recID]
                if surfID_str and not surfID_str.isspace():
                    # check if list is empty, if so: add first item
                    if len(aTmpList) == 0:
                        eID = IDlookUP(1, surfID_str)
                        aTmpList.append(eID)
                    # check if we need to add item
                    isItemInList = False
                    for x in aTmpList:
                        if x.enviID == surfID_str:
                            isItemInList = True
                            break

                    # depending on isItemInList, add new key value pair
                    if not isItemInList:
                        eID = IDlookUP(len(aTmpList) + 1, surfID_str)
                        aTmpList.append(eID)

            # start editing
            self.recLayer_rot.startEditing()
            ID_int = 'ID_int'
            self.recLayer_rot.addAttribute(QgsField(ID_int, QVariant.Int))

            for f in self.recLayer_rot.getFeatures():
                # get enviID in string
                surfID_str = f[self.recID]
                surfID_int = -1
                for x in aTmpList:
                    if x.enviID == surfID_str:
                        surfID_int = x.idx
                        # print("found_data: "+ str(surfID_int))
                        break
                f[ID_int] = surfID_int
                self.recLayer_rot.updateFeature(f)

            self.recLayer_rot.commitChanges()

            context = dataobjects.createContext()
            context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
            rlayer = processing.run("gdal:rasterize",
                                    {"INPUT": self.recLayer_rot,
                                     "FIELD": ID_int,
                                     "UNITS": 1,
                                     "WIDTH": self.dx,
                                     "HEIGHT": self.dy,
                                     "EXTENT": ext,
                                     "NO_DATA": 0,
                                     "DATA_TYPE": 4,
                                     "INVERT": False,
                                     "OUTPUT": 'TEMPORARY_OUTPUT'},
                                    context=context)
            rlayerFN = rlayer['OUTPUT']

        # self.iface.addRasterLayer(rlayerFN,"tree_debug")

        # Open the current layer
        grid1 = gdal.Open(rlayerFN)

        # Get the first raster band of the layer
        grid1_band = grid1.GetRasterBand(1)

        # Set the print options to maximum to print whole arrays of all following print functions
        np.set_printoptions(threshold=sys.maxsize)

        # Read the raster band as an numpy array
        grid1_array = grid1_band.ReadAsArray()

        # Change the data type of array from floating numbers to integers
        grid1_int_array = grid1_array.astype(int)

        # fill grids cnt
        self.II = grid1_int_array.shape[1]
        self.JJ = grid1_int_array.shape[0]
        # print("tree:II")
        # print(self.II)
        # print("tree:JJ")
        # print(self.JJ)

        # reconvert to XML tags
        self.s_recList.clear()

        grid1_str_array = grid1_int_array.astype(str)
        # print(len(grid1_str_array[0]))
        # print(len(grid1_str_array[1]))
        # print(grid1_str_array)
        ENVI_ID_int = -1
        if self.recID_UseCustom:
            for i in range(grid1_int_array.shape[0]):
                for j in range(grid1_int_array.shape[1]):
                    if grid1_int_array[i, j] <= 0:
                        grid1_str_array[i, j] = ""
                    if grid1_int_array[i, j] == 999:
                        ENVI_ID_int = ENVI_ID_int + 1
                        grid1_str_array[i, j] = ENVI_ID + str(ENVI_ID_int).zfill(5)
                        newRec = dict(cell_i=j, cell_j=self.JJ - i, name=str(ENVI_ID))
                        self.s_recList.append(newRec)
        else:
            for i in range(grid1_int_array.shape[0]):
                for j in range(grid1_int_array.shape[1]):
                    if grid1_int_array[i, j] <= 0:
                        grid1_str_array[i, j] = ""
                    else:
                        for x in aTmpList:
                            if grid1_int_array[i, j] == x.idx:
                                grid1_str_array[i, j] = x.enviID
                                newRec = dict(cell_i=j, cell_j=self.JJ - i, name=x.enviID.replace("NULL", ""))
                                self.s_recList.append(newRec)
            aTmpList.clear()

        # Remove the whole cache
        grid1_band.FlushCache()
        grid1_band = None
        grid1 = None

        QgsMessageLog.logMessage("Finished: Gridding Receptors.", 'ENVI-met', level=Qgis.Info)
        return self.s_recList

    def saveINX(self):
        QgsMessageLog.logMessage("--- Started Exporting INX-File ---", 'ENVI-met', level=Qgis.Info)
        self.getModelrot()

        # fill data
        self.II = round((self.subAreaExtent.xMaximum() - self.subAreaExtent.xMinimum()) / self.dx)
        self.JJ = round((self.subAreaExtent.yMaximum() - self.subAreaExtent.yMinimum()) / self.dy)
        if self.useSplitting:
            self.finalKK = self.KK + 4
        else:
            self.finalKK = self.KK

        # recalc to long lat
        extCRS = self.subAreaLayer.crs()
        proj = pyproj.Transformer.from_crs(extCRS.authid(), 4326, always_xy=True)
        x1, y1 = (self.subAreaExtent.xMinimum(), self.subAreaExtent.yMinimum())
        lon, lat = proj.transform(x1, y1)

        self.lon = lon
        self.lat = lat
        self.UTMZone = self.getUTMZone(lon)

        timeZone = float(self.getTimeZoneGeonames())

        if timeZone < 0:
            self.timeZoneName = "UTC-" + str(abs(timeZone))
        else:
            self.timeZoneName = "UTC+" + str(abs(timeZone))
        self.timeZoneLonRef = timeZone * 15

        self.progress.emit(5)  # report the current progress via pyqt signal to reportProgress method of TaskTest-Class
        # convert data
        # first buildingInfo so that we have building numbers
        self.buildBInfo()
        # print(bInfo_str)
        self.progress.emit(10)

        # bNumberarray and bTop
        if (self.bTop_UseCustom) or (self.bLayer.name() == "notAvail") or (self.bTop == "notAvail") or (self.bTop == ""):
            bTop_int_array = np.zeros(shape=(self.JJ, self.II), dtype=int)
            bNumber_int_array = np.zeros(shape=(self.JJ, self.II), dtype=int)
            if (self.bTop_UseCustom):
                bNumber_int_array = self.rasterBNumber()
                bTop_int_array = self.rasterBTop()
        else:
            bNumber_int_array = self.rasterBNumber()
            bTop_int_array = self.rasterBTop()

        self.progress.emit(15)
        # then bBottom
        if (self.bBot_UseCustom) or (self.bLayer.name() == "notAvail") or (self.bBot == "notAvail")or (self.bBot == ""):
            bBot_int_array = np.zeros(shape=(self.JJ, self.II), dtype=int)
            if (self.bBot_UseCustom):
                bBot_int_array = self.rasterBBot()
        else:
            bBot_int_array = self.rasterBBot()

        # fixed height tag not supported yet
        tmpAr = np.zeros(shape=(self.JJ, self.II), dtype=int)
        bFixHeight_str_matrix = np.array2string(tmpAr, max_line_width=1000000, separator=",")
        bFixHeight_str_matrix = bFixHeight_str_matrix.replace(" ", "").replace("[", "").replace("]", "")
        self.progress.emit(20)

        # then plants1d
        if (self.plant1dID_UseCustom) or (self.plant1dLayer.name() == "notAvail") or (self.plant1dID == "notAvail") or (self.plant1dID == ""):
            simplePlant_int_array = np.zeros(shape=(self.JJ, self.II), dtype=int)
            simplePlant_str_array = simplePlant_int_array.astype(str)
            if (self.plant1dID_UseCustom):
                simplePlant_str_array = self.rasterSimplePlants()
            for i in range(simplePlant_str_array.shape[0]):
                for j in range(simplePlant_str_array.shape[1]):
                    if simplePlant_str_array[i, j] == "0":
                        simplePlant_str_array[i, j] = ""
        else:
            simplePlant_str_array = self.rasterSimplePlants()

        self.progress.emit(30)

        # plants3d
        self.buildPlants3d()
        self.progress.emit(40)

        # surfaces
        if (self.surfID_UseCustom) or (self.surfLayer.name() == "notAvail") or (self.surfID == "notAvail") or (self.surfID == ""):
            surf_int_array = np.zeros(shape=(self.JJ, self.II), dtype=int)
            surf_str_array = surf_int_array.astype(str)
            for i in range(surf_str_array.shape[0]):
                for j in range(surf_str_array.shape[1]):
                    if surf_str_array[i, j] == "0":
                        surf_str_array[i, j] = "0100PP"
            if self.surfID_UseCustom:
                for i in range(surf_str_array.shape[0]):
                    for j in range(surf_str_array.shape[1]):
                        surf_str_array[i, j] = self.surfID_custom
        else:
            surf_str_array = self.rasterSurf()

        self.progress.emit(50)

        # receptors
        self.buildReceptors()

        # sources Points
        if (self.srcPID_UseCustom) or (self.srcPLayer.name() == "notAvail") or (self.srcPID == "notAvail") or (self.srcPID == ""):
            srcP_int_array = np.zeros(shape=(self.JJ, self.II), dtype=int)
            srcP_str_array = srcP_int_array.astype(str)
            if self.srcPID_UseCustom:
                srcP_str_array = self.rasterSrcP()
            for i in range(srcP_str_array.shape[0]):
                for j in range(srcP_str_array.shape[1]):
                    if srcP_str_array[i, j] == "0":
                        srcP_str_array[i, j] = ""
        else:
            srcP_str_array = self.rasterSrcP()

        # sources Lines
        if (self.srcLID_UseCustom) or (self.srcLLayer.name() == "notAvail") or (self.srcLID == "notAvail") or (self.srcLID == ""):
            srcL_int_array = np.zeros(shape=(self.JJ, self.II), dtype=int)
            srcL_str_array = srcL_int_array.astype(str)
            if self.srcLID_UseCustom:
                srcL_str_array= self.rasterSrcL()
            for i in range(srcL_str_array.shape[0]):
                for j in range(srcL_str_array.shape[1]):
                    if srcL_str_array[i, j] == "0":
                        srcL_str_array[i, j] = ""
        else:
            srcL_str_array = self.rasterSrcL()

        # sources Areas
        if (self.srcAID_UseCustom) or (self.srcALayer.name() == "notAvail") or (self.srcAID == "notAvail") or (self.srcAID == ""):
            srcA_int_array = np.zeros(shape=(self.JJ, self.II), dtype=int)
            srcA_str_array = srcA_int_array.astype(str)
            if self.srcAID_UseCustom:
                srcA_str_array = self.rasterSrcA()
            for i in range(srcA_str_array.shape[0]):
                for j in range(srcA_str_array.shape[1]):
                    if srcA_str_array[i, j] == "0":
                        srcA_str_array[i, j] = ""
        else:
            srcA_str_array = self.rasterSrcA()

        # now handle srcArray P > L > A
        src_int_array = np.zeros(shape=(self.JJ, self.II), dtype=int)   # create a new array that holds all sources
        src_str_array = src_int_array.astype(str)
        for i in range(srcA_str_array.shape[0]):
            for j in range(srcA_str_array.shape[1]):
                src_str_array[i, j] = ""
                if not srcA_str_array[i, j] == "":
                    src_str_array[i, j] = srcA_str_array[i, j]
                if not srcL_str_array[i, j] == "":
                    src_str_array[i, j] = srcL_str_array[i, j]
                if not srcP_str_array[i, j] == "":
                    src_str_array[i, j] = srcP_str_array[i, j]

        self.progress.emit(60)

        # DEM
        if (self.dEMLayer.name() == "notAvail") or (self.dEMBand <= 0):
            dem_int_array = np.zeros(shape=(self.JJ, self.II), dtype=int)
        else:
            QgsMessageLog.logMessage("Started: Gridding Terrain...", 'ENVI-met', level=Qgis.Info)
            dem_int_array = self.getDEM()
            QgsMessageLog.logMessage("Finished: Gridding Terrain.", 'ENVI-met', level=Qgis.Info)

        self.elevation = self.getElevationGeonames()

        self.progress.emit(70)

        QgsMessageLog.logMessage("Preparing Model Border...", 'ENVI-met', level=Qgis.Info)
        # empty cells at border -> only for buildings
        if self.removeBBorder > 0:
            bRemSet = set(())
            for i in range(bTop_int_array.shape[0]):
                for j in range(bTop_int_array.shape[1]):
                    # bTop; bBot; bNumber2d
                    if (i < self.removeBBorder) or (j < self.removeBBorder) or (
                            i > (bTop_int_array.shape[0] - self.removeBBorder)) or (
                            j > (bTop_int_array.shape[1] - self.removeBBorder)):
                        if bNumber_int_array[i, j] > 0:
                            bRemSet.add(bNumber_int_array[i, j])
                        bTop_int_array[i, j] = 0
                        bBot_int_array[i, j] = 0
                        bNumber_int_array[i, j] = 0
            # now update bList
            for bRem in bRemSet:
                bCanBeRemoved = True
                for i in range(bNumber_int_array.shape[0]):
                    for j in range(bNumber_int_array.shape[1]):
                        if bNumber_int_array[i, j] == bRem:
                            bCanBeRemoved = False
                if bCanBeRemoved:
                    for b in self.s_buildingList:
                        if bRem == b.get("BuildingInternalNr"):
                            self.s_buildingList.remove(b)

        # check if buildings should be leveled with DEM
        QgsMessageLog.logMessage("Preparing Buildings in DEM...", 'ENVI-met', level=Qgis.Info)
        if not (self.dEMLayer.name() == "notAvail") and not (self.dEMBand <= 0) and (self.bLeveled):
            # create a new temp empty list of buildings that also holds a list of cells
            bListDEM = []
            # first get all cells that belong to a building and put them in a list
            for i in range(bNumber_int_array.shape[0]):
                for j in range(bNumber_int_array.shape[1]):
                    newBuild = True
                    if bNumber_int_array[i, j] > 0:
                        for b in bListDEM:
                            if b.bNumber == bNumber_int_array[i, j]:
                                cell = Cell(i, j, 0)
                                b.cellList.append(cell)
                                newBuild = False
                                break
                        if newBuild:
                            bLevel = BLevel(bNumber_int_array[i, j])
                            cell = Cell(i, j, 0)
                            bLevel.cellList.append(cell)
                            bListDEM.append(bLevel)

            # now go through the list and find the lowest terrain below a building
            for b in bListDEM:
                minDEM = 99999999
                for c in b.cellList:
                    if dem_int_array[c.i, c.j] < minDEM:
                        minDEM = dem_int_array[c.i, c.j]
                # now check if a terrain is higher and by how much, then, reduce the terrain by that amount
                for c in b.cellList:
                    hCorr = dem_int_array[c.i, c.j] - minDEM
                    if hCorr > 0:
                        dem_int_array[c.i, c.j] = dem_int_array[c.i, c.j] - hCorr

        # check if vegetation on buildings should be removed
        QgsMessageLog.logMessage("Check if Vegetation on Buildings should be removed...", 'ENVI-met', level=Qgis.Info)
        if self.removeVegBuild:
            for i in range(bNumber_int_array.shape[0]):
                for j in range(bNumber_int_array.shape[1]):
                    if (bNumber_int_array[i, j] > 0):
                        # remove simple plants
                        if (simplePlant_str_array[i, j] != ""):
                            simplePlant_str_array[i, j] = ""
                        # remove trees
                        for tree in self.s_treeList:
                            if (tree.get("rootcell_i") == j) and (tree.get("rootcell_j") == self.JJ - i):
                                self.s_treeList.remove(tree)

        self.progress.emit(80)
        QgsMessageLog.logMessage("Converting Data to ENVI-met model area...", 'ENVI-met', level=Qgis.Info)
        # finally convert to matrix
        bTop_str_matrix = np.array2string(bTop_int_array, max_line_width=1000000, separator=",")
        bTop_str_matrix = bTop_str_matrix.replace(" ", "").replace("[", "").replace("]", "")
        bBot_str_matrix = np.array2string(bBot_int_array, max_line_width=1000000, separator=",")
        bBot_str_matrix = bBot_str_matrix.replace(" ", "").replace("[", "").replace("]", "")
        bNumber_str_matrix = np.array2string(bNumber_int_array, max_line_width=1000000, separator=",")
        bNumber_str_matrix = bNumber_str_matrix.replace(" ", "").replace("[", "").replace("]", "")

        # terrain
        dem_str_matrix = np.array2string(dem_int_array, max_line_width=1000000, separator=",")
        dem_str_matrix = dem_str_matrix.replace(" ", "").replace("[", "").replace("]", "")

        # plants
        simplePlant_str_matrix = np.array2string(simplePlant_str_array, max_line_width=1000000, separator=",")
        simplePlant_str_matrix = simplePlant_str_matrix.replace(" ", "").replace("[", "").replace("]", "").replace("'","").replace("NULL", "")

        # surfaces
        surf_str_matrix = np.array2string(surf_str_array, max_line_width=1000000, separator=",")
        surf_str_matrix = surf_str_matrix.replace(" ", "").replace("[", "").replace("]", "").replace("'", "").replace("NULL", "")

        # sources
        src_str_matrix = np.array2string(src_str_array, max_line_width=1000000, separator=",")
        src_str_matrix = src_str_matrix.replace(" ", "").replace("[", "").replace("]", "").replace("'", "").replace("NULL", "")

        self.progress.emit(90)
        QgsMessageLog.logMessage("Writing file...", 'ENVI-met', level=Qgis.Info)
        with open(self.filename, 'w') as output_file:
            # Print functions
            print("<ENVI-MET_Datafile>", file=output_file)
            print("  <Header>", file=output_file)
            print("    <filetype>INPX ENVI-met Area Input File</filetype>", file=output_file)
            print("    <version>4</version>", file=output_file)
            print("    <revisiondate>  </revisiondate>", file=output_file)
            print("    <remark> model created by QGIS plugin, additional settings: def roof material: " + self.defaultWall + "; def wall material: " + self.defaultRoof + "; clear buildings cells at border: " + str(self.removeBBorder) + "; leveled buildings in DEM: " + str(self.bLeveled) + "; starting surface: " + self.startSurfID + "; remove veg from buildings: " + str(self.removeVegBuild) + " </remark>", file=output_file)
            print("    <encryptionlevel>0</encryptionlevel>", file=output_file)
            print("  </Header>", file=output_file)
            print("  <baseData>", file=output_file)
            print("    <modelDescription> generated by geodata2ENVI-met </modelDescription>", file=output_file)
            print("    <modelAuthor>  </modelAuthor>", file=output_file)
            print("  </baseData>", file=output_file)
            print("  <modelGeometry>", file=output_file)
            print("    <grids-I> " + str(self.II) + " </grids-I>", file=output_file)
            print("    <grids-J> " + str(self.JJ) + " </grids-J>", file=output_file)
            print("    <grids-Z> " + str(self.KK) + " </grids-Z>", file=output_file)
            print("    <dx> " + str(self.dx) + " </dx>", file=output_file)
            print("    <dy> " + str(self.dy) + " </dy>", file=output_file)
            print("    <dz-base> " + str(self.dz) + " </dz-base>", file=output_file)
            if self.useTelescoping:
                print("    <useTelescoping_grid> 1 </useTelescoping_grid>", file=output_file)
            else:
                print("    <useTelescoping_grid> 0 </useTelescoping_grid>", file=output_file)
            if self.useSplitting:
                print("    <useSplitting> 1 </useSplitting>", file=output_file)
            else:
                print("    <useSplitting> 0 </useSplitting>", file=output_file)
            print("    <verticalStretch> " + str(self.teleStretch) + " </verticalStretch>", file=output_file)
            print("    <startStretch> " + str(self.teleStart) + " </startStretch>", file=output_file)
            print("    <has3DModel> 1 </has3DModel>", file=output_file)
            print("    <isFull3DDesign> 0 </isFull3DDesign>", file=output_file)
            print("  </modelGeometry>", file=output_file)

            print("  <nestingArea>", file=output_file)
            print("    <numberNestinggrids> 0 </numberNestinggrids>", file=output_file)
            print("    <soilProfileA> 0100LO </soilProfileA>", file=output_file)
            print("    <soilProfileB> 0100LO </soilProfileB>", file=output_file)
            print("  </nestingArea>", file=output_file)

            print("  <locationData>", file=output_file)
            print("    <modelRotation> " + str(-self.model_rot) + " </modelRotation>", file=output_file)
            print("    <projectionSystem> " + str(extCRS.authid()) + " </projectionSystem>", file=output_file)
            print("    <UTMZone> " + str(self.UTMZone) + " </UTMZone>", file=output_file)
            print("    <realworldLowerLeft_X> " + str(self.subAreaExtent.xMinimum()) + " </realworldLowerLeft_X>",
                  file=output_file)
            print("    <realworldLowerLeft_Y> " + str(self.subAreaExtent.yMinimum()) + " </realworldLowerLeft_Y>",
                  file=output_file)
            print("    <locationName> data export from QGIS </locationName>", file=output_file)
            print("    <location_Longitude> " + str(self.lon) + " </location_Longitude>", file=output_file)
            print("    <location_Latitude> " + str(self.lat) + " </location_Latitude>", file=output_file)
            print("    <locationTimeZone_Name> " + self.timeZoneName + " </locationTimeZone_Name>", file=output_file)
            print("    <locationTimeZone_Longitude> " + str(self.timeZoneLonRef) + " </locationTimeZone_Longitude>",
                  file=output_file)
            print("    <elevation> " + str(self.elevation) + " </elevation>", file=output_file)
            print("  </locationData>", file=output_file)

            print("  <defaultSettings>", file=output_file)
            print("    <commonWallMaterial> " + self.defaultWall +"</commonWallMaterial>", file=output_file)
            print("    <commonRoofMaterial> " + self.defaultRoof + "</commonRoofMaterial>", file=output_file)
            print("  </defaultSettings>", file=output_file)

            print("  <buildings2D>", file=output_file)
            print("    <zTop type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(self.JJ) + "\">",
                  file=output_file)
            print(bTop_str_matrix, file=output_file)
            print("     </zTop>", file=output_file)
            print("     <zBottom type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(self.JJ) + "\">",
                  file=output_file)
            print(bBot_str_matrix, file=output_file)
            print("     </zBottom>", file=output_file)
            print(
                "     <buildingNr type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(self.JJ) + "\">",
                file=output_file)
            print(bNumber_str_matrix, file=output_file)
            print("     </buildingNr>", file=output_file)
            print(
                "     <fixedheight type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(self.JJ) + "\">",
                file=output_file)
            print(bFixHeight_str_matrix, file=output_file)
            print("     </fixedheight>", file=output_file)
            print("  </buildings2D>", file=output_file)

            for b in self.s_buildingList:
                print("  <Buildinginfo>", file=output_file)
                print("    <BuildingInternalNr> " + str(b.get("BuildingInternalNr")) + " </BuildingInternalNr>",
                      file=output_file)
                print("    <BuildingName> " + b.get("BuildingName") + " </BuildingName>", file=output_file)
                print("    <BuildingWallMaterial> " + b.get("BuildingWallMaterial") + " </BuildingWallMaterial>",
                      file=output_file)
                print("    <BuildingRoofMaterial> " + b.get("BuildingRoofMaterial") + " </BuildingRoofMaterial>",
                      file=output_file)
                print("    <BuildingFacadeGreening> " + b.get("BuildingFacadeGreening") + " </BuildingFacadeGreening>",
                      file=output_file)
                print("    <BuildingRoofGreening> " + b.get("BuildingRoofGreening") + " </BuildingRoofGreening>",
                      file=output_file)
                print("    <ObserveBPS> " + b.get("BuildingBPS") + " </ObserveBPS>",
                      file=output_file)
                print("  </Buildinginfo>", file=output_file)

            print("  <simpleplants2D>", file=output_file)
            print(
                "     <ID_plants1D type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(self.JJ) + "\">",
                file=output_file)
            print(simplePlant_str_matrix, file=output_file)
            print("  </simpleplants2D>", file=output_file)

            for tree in self.s_treeList:
                print("  <3Dplants>", file=output_file)
                print("    <rootcell_i> " + str(tree.get("rootcell_i") + 1) + " </rootcell_i>",
                      file=output_file)  # the index is + 1 in envimet
                print("    <rootcell_j> " + str(tree.get("rootcell_j")) + " </rootcell_j>",
                      file=output_file)  # this index is correct in envimet
                print("    <rootcell_k> " + str(tree.get("rootcell_k")) + " </rootcell_k>", file=output_file)
                print("    <plantID> " + tree.get("plantID") + " </plantID>", file=output_file)
                print("    <name> " + tree.get("name") + " </name>", file=output_file)
                print("    <observe> " + str(tree.get("observe")) + " </observe>", file=output_file)
                print("  </3Dplants>", file=output_file)

            print("  <soils2D>", file=output_file)
            print("     <ID_soilprofile type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(self.JJ) + "\">", file=output_file)
            print(surf_str_matrix, file=output_file)
            print("     </ID_soilprofile>", file=output_file)
            print("  </soils2D>", file=output_file)

            print("  <dem>", file=output_file)
            print("     <DEMReference> " + str(self.refHeightDEM) + " </DEMReference>", file=output_file)
            print("     <terrainheight type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(
                self.JJ) + "\">", file=output_file)
            print(dem_str_matrix, file=output_file)
            print("     </terrainheight>", file=output_file)
            print("  </dem>", file=output_file)
            print("  <sources2D>", file = output_file)
            print("     <ID_sources type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(self.JJ) + "\">", file = output_file)
            print(src_str_matrix, file = output_file)
            print("     </ID_sources>", file = output_file)
            print("  </sources2D>", file = output_file)

            for rec in self.s_recList:
                print("  <Receptors>", file=output_file)
                print("    <cell_i> " + str(rec.get("cell_i") + 1) + " </cell_i>", file=output_file)  # the index is + 1 in envimet
                print("    <cell_j> " + str(rec.get("cell_j")) + " </cell_j>", file=output_file)  # this index is correct in envimet
                print("    <name> " + rec.get("name") + " </name>", file=output_file)
                print("  </Receptors>", file=output_file)

            """
            # print("  <receptors2D>", file = output_file)
            # print("     <ID_receptors type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(self.JJ) + "\">", file = output_file)
            # print(rec_str_matrix, file = output_file)
            # print("     </ID_receptors>", file = output_file)
            # print("  </receptors2D>", file = output_file)
            # print("  <additionalData>", file = output_file)
            # print("     <db_link_point type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(self.JJ) + "\">", file = output_file)
            # print(dbPoint_str_matrix.replace("1", "").replace("2", "").replace("3", "").replace("4", "").replace("5", "").replace("6", "").replace("7", "").replace("8", "").replace("9", "").replace("0","").replace(" ","").replace("[","").replace("]",""), file = output_file)
            # print("     </db_link_point>", file = output_file)
            # print("     <db_link_area type=\"matrix-data\" dataI=\"" + str(self.II) + "\" dataJ=\"" + str(self.JJ) + "\">", file = output_file)
            # print(dbArea_str_matrix.replace("1", "").replace("2", "").replace("3", "").replace("4", "").replace("5", "").replace("6", "").replace("7", "").replace("8", "").replace("9", "").replace("0","").replace(" ","").replace("[","").replace("]",""), file = output_file)
            # print("     </db_link_area>", file = output_file)
            # print("  </additionalData>", file = output_file)
            # print("  <modelGeometry3D>", file = output_file)
            # print("     <grids3D-I> " + str(self.II) + " </grids3D-I>", file = output_file)
            # print("     <grids3D-J> " + str(self.JJ) + " </grids3D-J>", file = output_file)
            # print("     <grids3D-K> " + str(self.KK3d) + " </grids3D-K>", file = output_file)
            # print("  </modelGeometry3D>", file = output_file)
            """
            print("</ENVI-MET_Datafile>", file=output_file)

        self.progress.emit(100)
        QgsMessageLog.logMessage("--- Finished Exporting INX-File ---", 'ENVI-met', level=Qgis.Info)

    def run(self):
        self.progress.emit(0)  # reset progressbar
        # print('run') # debug: we just entered the run method of Worker-Class
        #self.time = 22  # just a variable to work with
        self.total = 100  # just a variable to work with
        #self.test()
        #print("testFinished")
        self.saveINX()
        #print("bInfoFinished")
        self.finished.emit()  # report via pyqt signal that run method of Worker-Class has been finished

    def stop(self):
        self.stopworker = True

class Geo2ENVImet:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Geo2ENVImet_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Geodata to ENVI-met')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None     # this was None

        self.enviProjects = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Geo2ENVImet', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/geodata2ENVImet/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Convert geodata to ENVI-met'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Geodata to ENVI-met'),
                action)
            self.iface.removeToolBarIcon(action)

    def startWorker(self): # method to start the worker thread
        if (self.dlg.cb_subArea.currentLayer() is None):
            self.iface.messageBar().pushMessage("Error", "Please select at least a sub area layer", level=Qgis.Warning)
            return

        if (self.dlg.lineEdit.text() == ""):
            self.iface.messageBar().pushMessage("Error", "Please define an output filename", level=Qgis.Warning)
            return
        self.thread = QThread()
        self.worker = Worker()

        # here we transfer the GUI values to the worker
        # transfer building info
        if self.dlg.cb_buildingLayer.currentLayer() is None:
            self.worker.bLayer = QgsVectorLayer("Polygon", "notAvail", "memory")
        else:
            self.worker.bLayer = self.dlg.cb_buildingLayer.currentLayer()
        self.worker.bTop_UseCustom = self.dlg.chk_bTop.isChecked()
        if self.worker.bTop_UseCustom :
            self.worker.bTop = QgsField("notAvail", QVariant.Int)
            self.worker.bTop_custom = self.dlg.se_bTop.value()
        else:
            self.worker.bTop = self.dlg.cb_bTop.currentField()
            self.worker.bTop_custom = -999
        self.worker.bBot_UseCustom = self.dlg.chk_bBot.isChecked()
        if self.worker.bBot_UseCustom:
            self.worker.bBot = QgsField("notAvail", QVariant.Int)
            self.worker.bBot_custom = self.dlg.se_bBot.value()
        else:
            self.worker.bBot = self.dlg.cb_bBot.currentField()
            self.worker.bBot_custom = -999
        self.worker.bName_UseCustom = self.dlg.chk_bName.isChecked()
        if self.worker.bName_UseCustom:
            self.worker.bName = QgsField("notAvail", QVariant.String)
            self.worker.bName_custom = self.dlg.le_bName.text()
        else:
            self.worker.bName = self.dlg.cb_bName.currentField()
            self.worker.bName_custom = ""
        self.worker.bWall_UseCustom = self.dlg.chk_bWall.isChecked()
        if self.worker.bWall_UseCustom :
            self.worker.bWall = QgsField("notAvail", QVariant.String)
            self.worker.bWall_custom = self.dlg.le_bWall.text()
        else:
            self.worker.bWall = self.dlg.cb_bWall.currentField()
            self.worker.bWall_custom = "000000"
        self.worker.bRoof_UseCustom = self.dlg.chk_bRoof.isChecked()
        if self.worker.bRoof_UseCustom:
            self.worker.bRoof = QgsField("notAvail", QVariant.String)
            self.worker.bRoof_custom = self.dlg.le_bRoof.text()
        else:
            self.worker.bRoof = self.dlg.cb_bRoof.currentField()
            self.worker.bRoof_custom = "000000"
        self.worker.bGreenWall_UseCustom = self.dlg.chk_bGreenWall.isChecked()
        if self.worker.bGreenWall_UseCustom:
            self.worker.bGreenWall = QgsField("notAvail", QVariant.String)
            self.worker.bGreenWall_custom = self.dlg.le_bGreenWall.text()
        else:
            self.worker.bGreenWall = self.dlg.cb_bGreenWall.currentField()
            self.worker.bGreenWall_custom = ""
        self.worker.bGreenRoof_UseCustom = self.dlg.chk_bGreenRoof.isChecked()
        if self.worker.bGreenRoof_UseCustom:
            self.worker.bGreenRoof = QgsField("notAvail", QVariant.String)
            self.worker.bGreenRoof_custom = self.dlg.le_bGreenRoof.text()
        else:
            self.worker.bGreenRoof = self.dlg.cb_bGreenRoof.currentField()
            self.worker.bGreenRoof_custom = ""
        self.worker.bBPS_disabled = self.dlg.chk_bBPS.isChecked()
        if self.worker.bBPS_disabled:
            self.worker.bBPS = QgsField("notAvail", QVariant.String)
        else:
            self.worker.bBPS = self.dlg.cb_bBPS.currentField()

        # transfer surface info
        if self.dlg.cb_surfLayer.currentLayer() is None:
            self.worker.surfLayer = QgsVectorLayer("Polygon", "notAvail", "memory")
        else:
            self.worker.surfLayer = self.dlg.cb_surfLayer.currentLayer()
        self.worker.surfID_UseCustom = self.dlg.chk_surf.isChecked()
        if self.worker.surfID_UseCustom:
            self.worker.surfID = QgsField("notAvail", QVariant.String)
            self.worker.surfID_custom = self.dlg.le_surf.text()
        else:
            self.worker.surfID = self.dlg.cb_surfID.currentField()
            self.worker.surfID_custom = "notAvail"

        # transfer simple plant info
        if self.dlg.cb_simplePlantLayer.currentLayer() is None:
            self.worker.plant1dLayer = QgsVectorLayer("Polygon", "notAvail", "memory")
        else:
            self.worker.plant1dLayer = self.dlg.cb_simplePlantLayer.currentLayer()
        self.worker.plant1dID_UseCustom = self.dlg.chk_simplePlantID.isChecked()
        if self.worker.plant1dID_UseCustom:
            self.worker.plant1dID = QgsField("notAvail", QVariant.String)
            self.worker.plant1dID_custom = self.dlg.le_simplePlant.text()
        else:
            self.worker.plant1dID = self.dlg.cb_simplePlantID.currentField()
            self.worker.plant1dID_custom = "notAvail"

        # transfer 3d plant info
        if self.dlg.cb_plant3dLayer.currentLayer() is None:
            self.worker.plant3dLayer = QgsVectorLayer("Point", "notAvail", "memory")
        else:
            self.worker.plant3dLayer = self.dlg.cb_plant3dLayer.currentLayer()
        self.worker.plant3dID_UseCustom = self.dlg.chk_plant3d.isChecked()
        if self.worker.plant3dID_UseCustom:
            self.worker.plant3dID = QgsField("notAvail", QVariant.String)
            self.worker.plant3dID_custom = self.dlg.le_plant3d.text()
        else:
            self.worker.plant3dID = self.dlg.cb_plant3dID.currentField()
            self.worker.plant3dID_custom = "notAvail"
        self.worker.plant3dAddOut_disabled = self.dlg.chk_plant3dAddOut.isChecked()
        if self.worker.plant3dAddOut_disabled:
            self.worker.plant3dAddOut = QgsField("notAvail", QVariant.String)
        else:
            self.worker.plant3dAddOut = self.dlg.cb_plant3dAddOut.currentField()

        # transfer DEM info
        if self.dlg.cb_demLayer.currentLayer() is None:
            self.worker.dEMLayer = QgsRasterLayer("", "notAvail")
        else:
            self.worker.dEMLayer = self.dlg.cb_demLayer.currentLayer()
        if self.dlg.cb_demBand.currentBand() is None:
            self.worker.dEMBand = -1
        else:
            self.worker.dEMBand = self.dlg.cb_demBand.currentBand()

        # transfer receptor info
        if self.dlg.cb_recLayer.currentLayer() is None:
            self.worker.recLayer = QgsVectorLayer("Point", "notAvail", "memory")
        else:
            self.worker.recLayer = self.dlg.cb_recLayer.currentLayer()
        self.worker.recID_UseCustom = self.dlg.chk_recID.isChecked()
        if self.worker.recID_UseCustom:
            self.worker.recID = QgsField("notAvail", QVariant.String)
            self.worker.recID_Custom = "R"
        else:
            self.worker.recID = self.dlg.cb_recID.currentField()
            self.worker.recID_Custom = "notAvail"

        # transfer sources info Point
        if self.dlg.cb_srcPLayer.currentLayer() is None:
            self.worker.srcPLayer = QgsVectorLayer("Point", "notAvail", "memory")
        else:
            self.worker.srcPLayer = self.dlg.cb_srcPLayer.currentLayer()
        self.worker.srcPID_UseCustom = self.dlg.chk_srcPID.isChecked()
        if self.worker.srcPID_UseCustom:
            self.worker.srcPID = QgsField("notAvail", QVariant.String)
            self.worker.srcPID_custom = self.dlg.le_srcP.text()
        else:
            self.worker.srcPID = self.dlg.cb_srcPID.currentField()
            self.worker.srcPID_custom = "notAvail"

        # transfer sources info Line
        if self.dlg.cb_srcLLayer.currentLayer() is None:
            self.worker.srcLLayer = QgsVectorLayer("Line", "notAvail", "memory")
        else:
            self.worker.srcLLayer = self.dlg.cb_srcLLayer.currentLayer()
        self.worker.srcLID_UseCustom = self.dlg.chk_srcLID.isChecked()
        if self.worker.srcLID_UseCustom:
            self.worker.srcLID = QgsField("notAvail", QVariant.String)
            self.worker.srcLID_custom = self.dlg.le_srcL.text()
            #print("Custom ID set to: " + self.worker.srcLID_custom)
        else:
            self.worker.srcLID = self.dlg.cb_srcLID.currentField()
            self.worker.srcLID_custom = "notAvail"

        # transfer sources info Area
        if self.dlg.cb_srcALayer.currentLayer() is None:
            self.worker.srcALayer = QgsVectorLayer("Polygon", "notAvail", "memory")
        else:
            self.worker.srcALayer = self.dlg.cb_srcALayer.currentLayer()
        self.worker.srcAID_UseCustom = self.dlg.chk_srcAID.isChecked()
        if self.worker.srcAID_UseCustom:
            self.worker.srcAID = QgsField("notAvail", QVariant.String)
            self.worker.srcAID_custom = self.dlg.le_srcA.text()
        else:
            self.worker.srcAID = self.dlg.cb_srcAID.currentField()
            self.worker.srcAID_custom = "notAvail"

        # transfer subarea and gridding info
        if (self.dlg.cb_subArea.currentLayer() is None):
            self.iface.messageBar().pushMessage("Error","Please first select a sub area!",level=Qgis.Warning)
            return
        self.worker.subAreaLayer = self.dlg.cb_subArea.currentLayer()
        self.worker.subAreaLayer_nonRot = self.dlg.cb_subArea.currentLayer()
        self.worker.dx = self.dlg.se_dx.value()
        self.worker.dy = self.dlg.se_dy.value()
        self.worker.dz = self.dlg.se_dz.value()
        # self.worker.II and self.worker.JJ will be set by the gridding functions
        self.worker.KK = self.dlg.se_zGrids.value()
        self.worker.useSplitting = self.dlg.chk_useSplitting.isChecked()
        self.worker.useTelescoping = self.dlg.chk_useTelescoping.isChecked()
        self.worker.teleStart = self.dlg.se_teleStart.value()
        self.worker.teleStretch = self.dlg.se_teleStretch.value()

        # transfer additional options
        self.worker.defaultRoof = self.dlg.le_defRoof.text()
        self.worker.defaultWall = self.dlg.le_defWall.text()
        if self.dlg.chk_bBorders.isChecked():
            self.worker.removeBBorder = self.dlg.se_bBorders.value()
        else:
            self.worker.removeBBorder = 0
        self.worker.bLeveled = self.dlg.chk_bDEMLevel.isChecked()
        if self.dlg.chk_startSurf.isChecked():
            self.worker.startSurfID = self.dlg.le_surfStart.text()
        else:
            self.worker.startSurfID = "0100PP"
        self.worker.removeVegBuild = self.dlg.chk_bVeg.isChecked()

        # transfer filename
        self.worker.filename = self.dlg.lineEdit.text()

        # see https://realpython.com/python-pyqt-qthread/#using-qthread-to-prevent-freezing-guis
        # and https://doc.qt.io/qtforpython/PySide6/QtCore/QThread.html
        self.worker.moveToThread(self.thread) # move Worker-Class to a thread
        # Connect signals and slots:
        self.thread.started.connect(self.worker.run)
        self.worker.finished.connect(self.thread.quit)
        self.worker.finished.connect(self.worker.deleteLater)
        self.thread.finished.connect(self.thread.deleteLater)
        self.worker.progress.connect(self.reportProgress)
        self.thread.start() # finally start the thread

        ###### disable gui!
        self.dlg.bt_SaveINX.setEnabled(False)
        self.dlg.bt_SaveTo.setEnabled(False)
        self.dlg.gb_Geodata.setEnabled(False)
        self.dlg.gb_GriddingSettings.setEnabled(False)

        self.thread.finished.connect(self.updateExport) # enable the start-thread button when thread has been finished

    def killWorker(self): # method to kill/cancel the worker thread
        self.worker.stop() # call the stop method in worker class
        # print('pushed cancel') # debugging
        # see https://doc.qt.io/qtforpython/PySide6/QtCore/QThread.html
        try: # to prevent a Python error when the cancel button has been clicked but no thread is running use try/except
            if self.thread.isRunning(): # check if a thread is running
                # print('pushed cancel, thread is running, trying to cancel') # debugging
                #self.thread.requestInterruption() # not sure how to actually use it as there are no examples to find anywhere, one somehow would need to listen to isInterruptionRequested()
                self.thread.exit() # Tells the thread’s event loop to exit with a return code.
                self.thread.quit() # Tells the thread’s event loop to exit with return code 0 (success). Equivalent to calling exit (0).
                self.thread.wait() # Blocks the thread until https://doc.qt.io/qtforpython/PySide6/QtCore/QThread.html#PySide6.QtCore.PySide6.QtCore.QThread.wait
        except:
            # print('kill worker - task does no longer exist') # debugging
            pass

    def startWorkerCalcVertExt(self): # method to start the worker thread
        self.thread = QThread()
        self.worker = Worker()

        # here we transfer the GUI values to the worker
        #if (self.dlg.cb_buildingLayer.currentLayer() is None) or (self.dlg.cb_bTop.currentField() is None) or (self.dlg.cb_bTop.currentField() == "") or (self.dlg.cb_subArea.currentLayer() is None):
        if (self.dlg.cb_subArea.currentLayer() is None):
            self.iface.messageBar().pushMessage("Error", "To get the highest structures (buildings and DEM) in the sub area, please select at least a sub area layer", level=Qgis.Warning)
            return
        self.worker.subAreaLayer = self.dlg.cb_subArea.currentLayer()
        self.worker.subAreaLayer_nonRot = self.dlg.cb_subArea.currentLayer()

        if not(self.dlg.cb_buildingLayer.currentLayer() is None):
            self.worker.bLayer = self.dlg.cb_buildingLayer.currentLayer()
        if not(self.dlg.cb_bTop.currentField() is None):
            self.worker.bTop = self.dlg.cb_bTop.currentField()

        if not(self.dlg.cb_buildingLayer.currentLayer() is None):
            self.worker.bLayer = self.dlg.cb_buildingLayer.currentLayer()
        if not(self.dlg.cb_bTop.currentField() is None):
            self.worker.bTop = self.dlg.cb_bTop.currentField()

        if not(self.dlg.cb_demLayer.currentLayer() is None):
            self.worker.dEMLayer = self.dlg.cb_demLayer.currentLayer()
        if not(self.dlg.cb_demBand.currentBand() is None):
            self.worker.dEMBand = self.dlg.cb_demBand.currentBand()

        self.worker.dx = self.dlg.se_dx.value()
        self.worker.dy = self.dlg.se_dy.value()
        self.worker.dz = self.dlg.se_dz.value()

        # see https://realpython.com/python-pyqt-qthread/#using-qthread-to-prevent-freezing-guis
        # and https://doc.qt.io/qtforpython/PySide6/QtCore/QThread.html
        self.worker.moveToThread(self.thread) # move Worker-Class to a thread
        # Connect signals and slots:
        self.thread.started.connect(self.worker.calcVertExt)
        self.worker.finished.connect(self.thread.quit)
        self.worker.finished.connect(self.worker.deleteLater)
        self.thread.finished.connect(self.thread.deleteLater)
        self.thread.start() # finally start the thread
        self.dlg.cb_subArea.setEnabled(False)# disable the gui that fires these commands
        self.thread.finished.connect(self.updateCalcVertExt) # update the model dimensions when thread has been finished

    def startWorkerPreviewdxyz(self): # method to start the worker thread
        if self.dlg.cb_subArea.currentLayer() is None:
            return

        self.thread = QThread()
        self.worker = Worker()

        self.dlg.cb_subArea.setEnabled(False)# disable the gui that fires these commands
        self.dlg.se_dx.setEnabled(False)
        self.dlg.se_dy.setEnabled(False)
        self.dlg.se_dz.setEnabled(False)
        self.dlg.se_zGrids.setEnabled(False)
        self.dlg.se_teleStart.setEnabled(False)
        self.dlg.se_teleStretch.setEnabled(False)
        self.dlg.chk_useSplitting.setEnabled(False)
        self.dlg.chk_useTelescoping.setEnabled(False)

        # here we transfer the GUI values to the worker
        self.worker.subAreaLayer = self.dlg.cb_subArea.currentLayer()
        self.worker.subAreaLayer_nonRot = self.dlg.cb_subArea.currentLayer()

        self.worker.dx = self.dlg.se_dx.value()
        self.worker.dy = self.dlg.se_dy.value()
        self.worker.dz = self.dlg.se_dz.value()


        # see https://realpython.com/python-pyqt-qthread/#using-qthread-to-prevent-freezing-guis
        # and https://doc.qt.io/qtforpython/PySide6/QtCore/QThread.html
        self.worker.moveToThread(self.thread) # move Worker-Class to a thread
        # Connect signals and slots:
        self.thread.started.connect(self.worker.previewdxy)
        self.worker.finished.connect(self.thread.quit)
        self.worker.finished.connect(self.worker.deleteLater)
        self.thread.finished.connect(self.thread.deleteLater)
        self.thread.start() # finally start the thread
        self.thread.finished.connect(self.updatePreviewdxyz) # update the model dimensions when thread has been finished

    def startWorkerPreviewdz(self): # method to start the worker thread
        if self.dlg.cb_subArea.currentLayer() is None:
            return

        self.thread = QThread()
        self.worker = Worker()

        self.dlg.cb_subArea.setEnabled(False)# disable the gui that fires these commands
        self.dlg.se_dx.setEnabled(False)
        self.dlg.se_dy.setEnabled(False)
        self.dlg.se_dz.setEnabled(False)
        self.dlg.se_zGrids.setEnabled(False)
        self.dlg.se_teleStart.setEnabled(False)
        self.dlg.se_teleStretch.setEnabled(False)
        self.dlg.chk_useSplitting.setEnabled(False)
        self.dlg.chk_useTelescoping.setEnabled(False)

        # here we transfer the GUI values to the worker
        self.worker.subAreaLayer = self.dlg.cb_subArea.currentLayer()
        self.worker.subAreaLayer_nonRot = self.dlg.cb_subArea.currentLayer()

        self.worker.dx = self.dlg.se_dx.value()
        self.worker.dy = self.dlg.se_dy.value()
        self.worker.dz = self.dlg.se_dz.value()

        self.dlg.tb_zPreview.clear()
        self.worker.dz = self.dlg.se_dz.value()
        self.worker.KK = self.dlg.se_zGrids.value()
        self.worker.useSplitting = self.dlg.chk_useSplitting.isChecked()
        self.worker.useTelescoping = self.dlg.chk_useTelescoping.isChecked()
        self.worker.teleStart = self.dlg.se_teleStart.value()
        self.worker.teleStretch = self.dlg.se_teleStretch.value()


        # see https://realpython.com/python-pyqt-qthread/#using-qthread-to-prevent-freezing-guis
        # and https://doc.qt.io/qtforpython/PySide6/QtCore/QThread.html
        self.worker.moveToThread(self.thread) # move Worker-Class to a thread
        # Connect signals and slots:
        self.thread.started.connect(self.worker.previewdz)
        self.worker.finished.connect(self.thread.quit)
        self.worker.finished.connect(self.worker.deleteLater)
        self.thread.finished.connect(self.thread.deleteLater)
        self.thread.start() # finally start the thread
        self.thread.finished.connect(self.updatePreviewdz) # update the model dimensions when thread has been finished

    def reportProgress(self, n):  # method to report the progress to gui
        # print(f"Long-Running Step: {n}") # debugging purposes
        self.dlg.pb_main.setValue(n)  # set the current progress in progress bar

    def updateExport(self):
        #re-enable all gui
        self.dlg.bt_SaveINX.setEnabled(True)
        self.dlg.bt_SaveTo.setEnabled(True)
        self.dlg.gb_Geodata.setEnabled(True)
        self.dlg.gb_GriddingSettings.setEnabled(True)


        self.iface.messageBar().pushMessage("Success", "Output file written at " + self.worker.filename, level=Qgis.Success, duration=5)

    def updateCalcVertExt(self):
        self.dlg.l_highestStruct.setText("Highest Structure (DEM + Building): " + str(self.worker.maxHeightTotal) + " m (Building = " + str(self.worker.maxHeightB) + " m, DEM = " + str(self.worker.maxHeightDEM) + " m)")
        self.dlg.cb_subArea.setEnabled(True)
        self.startWorkerPreviewdxyz()

    def updatePreviewdxyz(self):
        self.dlg.l_xGrids.setText("x-Dimension: " + str(self.worker.xMeters) + " m; number of x-Grids: " + str(self.worker.II))
        self.dlg.l_yGrids.setText("y-Dimension: " + str(self.worker.yMeters) + " m; number of y-Grids: " + str(self.worker.JJ))
        self.dlg.cb_subArea.setEnabled(True)# disable the gui that fires these commands
        self.dlg.se_dx.setEnabled(True)
        self.dlg.se_dy.setEnabled(True)
        self.dlg.se_dz.setEnabled(True)
        self.dlg.se_zGrids.setEnabled(True)
        self.dlg.se_teleStart.setEnabled(True)
        self.dlg.se_teleStretch.setEnabled(True)
        self.dlg.chk_useSplitting.setEnabled(True)
        self.dlg.chk_useTelescoping.setEnabled(True)
        self.startWorkerPreviewdz()

    def updatePreviewdz(self):
        for k in range(self.worker.finalKK):
            self.worker.zLvl_center[k] = self.worker.zLvl_bot[k] + 0.5 * self.worker.dzAr[k]
            zTop = self.worker.zLvl_center[k] + 0.5 * self.worker.dzAr[k]
            self.dlg.tb_zPreview.append(str(k+1) + ": dz: " + str(round(self.worker.dzAr[k], 1)) + "m; z-Center: " + str(
                round(self.worker.zLvl_center[k], 1)) + "m; z-Top: " + str(round(zTop, 1)) + "m")

        zMax_Top = self.worker.zLvl_center[self.worker.finalKK - 1] + 0.5 * self.worker.dzAr[self.worker.finalKK - 1]
        if zMax_Top < 2500:
            self.dlg.l_zHeight.setText("Resulting model height: " + str(round(zMax_Top, 2)) + " m")
        else:
            self.dlg.l_zHeight.setText(
                "Warning: Resulting model height too high (no more than 2500 m above ground level). Current setting: " + str(
                    round(zMax_Top, 2)) + " m")

        self.dlg.cb_subArea.setEnabled(True)# disable the gui that fires these commands
        self.dlg.se_dx.setEnabled(True)
        self.dlg.se_dy.setEnabled(True)
        self.dlg.se_dz.setEnabled(True)
        self.dlg.se_zGrids.setEnabled(True)
        self.dlg.se_teleStart.setEnabled(True)
        self.dlg.se_teleStretch.setEnabled(True)
        self.dlg.chk_useSplitting.setEnabled(True)
        self.dlg.chk_useTelescoping.setEnabled(True)

    def select_output_file(self):
        filename, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select output file for ENVI-met model area", "", '*.INX')
        self.dlg.lineEdit.setText(filename)

    def select_cb_buildingClick(self):
        layerFields = self.dlg.cb_buildingLayer.currentLayer()
        self.dlg.cb_bTop.setLayer(layerFields)
        self.dlg.cb_bBot.setLayer(layerFields)
        self.dlg.cb_bGreenRoof.setLayer(layerFields)
        self.dlg.cb_bGreenWall.setLayer(layerFields)
        self.dlg.cb_bWall.setLayer(layerFields)
        self.dlg.cb_bRoof.setLayer(layerFields)
        self.dlg.cb_bName.setLayer(layerFields)
        self.dlg.cb_bBPS.setLayer(layerFields)

    def select_cb_surfClick(self):
        layerFields = self.dlg.cb_surfLayer.currentLayer()
        self.dlg.cb_surfID.setLayer(layerFields)

    def select_cb_simplePlantClick(self):
        layerFields = self.dlg.cb_simplePlantLayer.currentLayer()
        self.dlg.cb_simplePlantID.setLayer(layerFields)

    def select_cb_plant3dClick(self):
        layerFields = self.dlg.cb_plant3dLayer.currentLayer()
        self.dlg.cb_plant3dID.setLayer(layerFields)
        self.dlg.cb_plant3dAddOut.setLayer(layerFields)

    def select_cb_demClick(self):
        layerFields = self.dlg.cb_demLayer.currentLayer()
        self.dlg.cb_demBand.setLayer(layerFields)

    def select_cb_recClick(self):
        layerFields = self.dlg.cb_recLayer.currentLayer()
        self.dlg.cb_recID.setLayer(layerFields)

    def select_cb_srcPLayerClick(self):
        layerFields = self.dlg.cb_srcPLayer.currentLayer()
        self.dlg.cb_srcPID.setLayer(layerFields)

    def select_cb_srcLLayerClick(self):
        layerFields = self.dlg.cb_srcLLayer.currentLayer()
        self.dlg.cb_srcLID.setLayer(layerFields)

    def select_cb_srcALayerClick(self):
        layerFields = self.dlg.cb_srcALayer.currentLayer()
        self.dlg.cb_srcAID.setLayer(layerFields)

    def select_cb_subAreaClick(self):
        # now check if this layer only contains ONE polygon feature!!!
        tmp_subAreaLayer = self.dlg.cb_subArea.currentLayer()
        # count feats in the vector layer -> check if there is only one!
        if not(tmp_subAreaLayer is None):
            if tmp_subAreaLayer.getFeatures() is None:
                self.iface.messageBar().pushMessage("Error", "Selected sub area layer has no feature", level=Qgis.Warning)
            else:
                tmp_subAreaFeats = tmp_subAreaLayer.getFeatures()
                tmp_subAreaFeatCnt = 0
                for f in tmp_subAreaFeats:
                    tmp_subAreaFeatCnt = tmp_subAreaFeatCnt + 1
                if tmp_subAreaFeatCnt > 1:
                    self.iface.messageBar().pushMessage("Error", "More than 1 feature in sub area - please use a layer that contains only one polygon feature, this determines the bounding box of your model area", level=Qgis.Warning)
                else:
                    self.startWorkerCalcVertExt()   # now that we ensured that there is only one polygon in the layer, we can call the worder (this also calls the previewdxyz)

    def updateDB(self):
        #print("Selected items: ", self.dlg.lw_prj.selectedItems())
        self.dlg.lw_wallsRoofs.clear()
        self.dlg.lw_greenings.clear()
        self.dlg.lw_surfaces.clear()
        self.dlg.lw_simplePlants.clear()
        self.dlg.lw_3dPlants.clear()
        self.dlg.lw_sources.clear()
        for p in self.enviProjects.projects:
            #print(p.name)
            #print(self.dlg.lw_prj.selectedItems()[0].text())
            if (len(self.dlg.lw_prj.selectedItems()) > 0):
                if (self.dlg.lw_prj.selectedItems()[0].text() == p.name):
                    # load database of selected project
                    if p.useProjectDB and os.path.exists(p.projectPath + '/projectdatabase.edb'):
                        p.DB = ENVImetDB(filepath=self.enviProjects.sysDB_path, use_project_db=True, filepath_project_db=p.projectPath + '/projectdatabase.edb')
                    else:
                        p.DB = self.enviProjects.sys_db

                    # fill the other listWidgets
                    for k in p.DB.wall_dict:
                        s = p.DB.wall_dict[k]
                        self.dlg.lw_wallsRoofs.addItem(s.ID + '\t' + s.Description)

                    for k in p.DB.greening_dict:
                        s = p.DB.greening_dict[k]
                        self.dlg.lw_greenings.addItem(s.ID + '\t' + s.Description)

                    for k in p.DB.profile_dict:
                        s = p.DB.profile_dict[k]
                        self.dlg.lw_surfaces.addItem(s.ID + '\t' + s.Description)

                    for k in p.DB.plant_dict:
                        s = p.DB.plant_dict[k]
                        self.dlg.lw_simplePlants.addItem(s.ID + '\t' + s.Description)

                    for k in p.DB.plant3d_dict:
                        s = p.DB.plant3d_dict[k]
                        self.dlg.lw_3dPlants.addItem(s.ID + '\t' + s.Description)

                    """
                    for k in p.DB.profile_dict:
                        #print(p.DB.profile_dict[k])
                        s = p.DB.profile_dict[k]
                        self.dlg.lw_sources.addItem(s.ID + '\t' + s.Description)
                    """

    def startDBManager(self):
        if not self.enviProjects == None:
            #print(self.enviProjects.installPath)
            # subprocess.run([self.enviProjects.installPath + "win64/DBManager.exe", ""]) # this would halt the plugin until DBManager is closed
            filepath = self.enviProjects.installPath + "win64/DBManager.exe"
            process_id = os.spawnv(os.P_NOWAIT, filepath, ["-someFlag", "someOtherFlag"])
            #print(process_id)
        else:
            self.iface.messageBar().pushMessage("Error", "Could not find a local ENVI-met installation / workspace to load database lookup", level=Qgis.Warning)


    def loadDB(self):
        #envipath = self.dlg.le_envipath.text()
        #wrkspace = self.dlg.le_wrkspace.text()
        if self.dlg.tw_Main.currentWidget().objectName() == "tab_DB":
            self.dlg.lw_prj.clear()
            self.dlg.lw_wallsRoofs.clear()
            self.dlg.lw_greenings.clear()
            self.dlg.lw_surfaces.clear()
            self.dlg.lw_simplePlants.clear()
            self.dlg.lw_3dPlants.clear()
            self.dlg.lw_sources.clear()
            self.enviProjects = None
            self.enviProjects = EnviProjects()
            if self.enviProjects.usersettingsFound:
                for p in self.enviProjects.projects:
                    self.dlg.lw_prj.addItem(p.name)
            else:
                self.iface.messageBar().pushMessage("Error", "Could not find a local ENVI-met installation / workspace to load database lookup", level=Qgis.Warning)



    def updateChkBoxes(self):
        """
        if self.dlg.chk_bTop.isChecked():
            self.dlg.cb_bTop.setCurrentIndex(0)
        if self.dlg.chk_bBot.isChecked():
            self.dlg.cb_bBot.setCurrentIndex(0)
        if self.dlg.chk_bName.isChecked():
            self.dlg.cb_bName.setCurrentIndex(0)
        if self.dlg.chk_bWall.isChecked():
            self.dlg.cb_bWall.setCurrentIndex(0)
        if self.dlg.chk_bRoof.isChecked():
            self.dlg.cb_bRoof.setCurrentIndex(0)
        if self.dlg.chk_bGreenWall.isChecked():
            self.dlg.cb_bGreenWall.setCurrentIndex(0)
        if self.dlg.chk_bGreenRoof.isChecked():
            self.dlg.cb_bGreenRoof.setCurrentIndex(0)

        if self.dlg.chk_surf.isChecked():
            self.dlg.cb_surfID.setCurrentIndex(0)
        if self.dlg.chk_simplePlantID.isChecked():
            self.dlg.cb_simplePlantID.setCurrentIndex(0)
        if self.dlg.chk_plant3d.isChecked():
            self.dlg.cb_plant3dID.setCurrentIndex(0)
        if self.dlg.chk_recID.isChecked():
            self.dlg.cb_recID.setCurrentIndex(0)
        if self.dlg.chk_srcPID.isChecked():
            self.dlg.chk_srcPID.setCurrentIndex(0)
        if self.dlg.chk_srcLID.isChecked():
            self.dlg.cb_srcLID.setCurrentIndex(0)
        if self.dlg.chk_srcAID.isChecked():
            self.dlg.chk_srcAID.setCurrentIndex(0)
        """

        return

    def run(self):
        """Run method that performs all the real work"""
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start:
            self.first_start = True         # this was false
            self.dlg = Geo2ENVImetDialog()

            self.dlg.scrollArea.setWidget(self.dlg.scrollAreaWidgetContents)

            #self.dlg.Test_StartTest.clicked.connect(lambda: self.startWorker())  # call the startWorker method when button has been clicked
            #self.dlg.Test_Cancel.clicked.connect(lambda: self.killWorker())  # call the killWorker method when button has been clicked

            self.dlg.cb_buildingLayer.setShowCrs(True)
            self.dlg.cb_surfLayer.setShowCrs(True)
            self.dlg.cb_simplePlantLayer.setShowCrs(True)
            self.dlg.cb_plant3dLayer.setShowCrs(True)
            self.dlg.cb_subArea.setShowCrs(True)
            self.dlg.cb_demLayer.setShowCrs(True)
            self.dlg.cb_recLayer.setShowCrs(True)
            self.dlg.cb_srcPLayer.setShowCrs(True)
            self.dlg.cb_srcLLayer.setShowCrs(True)
            self.dlg.cb_srcALayer.setShowCrs(True)

            self.dlg.cb_buildingLayer.setFilters(QgsMapLayerProxyModel.PolygonLayer)
            self.dlg.cb_surfLayer.setFilters(QgsMapLayerProxyModel.PolygonLayer)
            self.dlg.cb_simplePlantLayer.setFilters(QgsMapLayerProxyModel.PolygonLayer)
            self.dlg.cb_plant3dLayer.setFilters(QgsMapLayerProxyModel.PointLayer)
            self.dlg.cb_subArea.setFilters(QgsMapLayerProxyModel.PolygonLayer)
            self.dlg.cb_demLayer.setFilters(QgsMapLayerProxyModel.RasterLayer)
            self.dlg.cb_recLayer.setFilters(QgsMapLayerProxyModel.PointLayer)
            self.dlg.cb_srcPLayer.setFilters(QgsMapLayerProxyModel.PointLayer)
            self.dlg.cb_srcLLayer.setFilters(QgsMapLayerProxyModel.LineLayer)
            self.dlg.cb_srcALayer.setFilters(QgsMapLayerProxyModel.PolygonLayer)

            self.dlg.cb_bTop.setAllowEmptyFieldName(True)
            self.dlg.cb_bBot.setAllowEmptyFieldName(True)
            self.dlg.cb_bName.setAllowEmptyFieldName(True)
            self.dlg.cb_bWall.setAllowEmptyFieldName(True)
            self.dlg.cb_bRoof.setAllowEmptyFieldName(True)
            self.dlg.cb_bGreenWall.setAllowEmptyFieldName(True)
            self.dlg.cb_bGreenRoof.setAllowEmptyFieldName(True)
            self.dlg.cb_bBPS.setAllowEmptyFieldName(True)
            self.dlg.cb_surfID.setAllowEmptyFieldName(True)
            self.dlg.cb_simplePlantID.setAllowEmptyFieldName(True)
            self.dlg.cb_plant3dID.setAllowEmptyFieldName(True)
            self.dlg.cb_plant3dAddOut.setAllowEmptyFieldName(True)
            self.dlg.cb_recID.setAllowEmptyFieldName(True)
            self.dlg.cb_srcPID.setAllowEmptyFieldName(True)
            self.dlg.cb_srcLID.setAllowEmptyFieldName(True)
            self.dlg.cb_srcAID.setAllowEmptyFieldName(True)

            self.dlg.tb_zPreview.setReadOnly(True)

            self.dlg.cb_bTop.setFilters(QgsFieldProxyModel.Int | QgsFieldProxyModel.LongLong | QgsFieldProxyModel.Numeric)
            self.dlg.cb_bBot.setFilters(QgsFieldProxyModel.Int | QgsFieldProxyModel.LongLong | QgsFieldProxyModel.Numeric)
            self.dlg.cb_bName.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_bWall.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_bRoof.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_bGreenWall.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_bGreenRoof.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_bBPS.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_surfID.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_simplePlantID.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_plant3dID.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_plant3dAddOut.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_recID.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_srcPID.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_srcLID.setFilters(QgsFieldProxyModel.String)
            self.dlg.cb_srcAID.setFilters(QgsFieldProxyModel.String)

            self.dlg.chk_bTop.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_bBot.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_bName.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_bWall.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_bRoof.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_bGreenWall.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_bGreenRoof.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_bBPS.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_surf.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_simplePlantID.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_plant3d.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_plant3dAddOut.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_recID.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_srcPID.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_srcLID.stateChanged.connect(self.updateChkBoxes)
            self.dlg.chk_srcAID.stateChanged.connect(self.updateChkBoxes)

            self.dlg.cb_buildingLayer.layerChanged.connect(self.select_cb_buildingClick)
            self.dlg.cb_surfLayer.layerChanged.connect(self.select_cb_surfClick)
            self.dlg.cb_simplePlantLayer.layerChanged.connect(self.select_cb_simplePlantClick)
            self.dlg.cb_plant3dLayer.layerChanged.connect(self.select_cb_plant3dClick)
            self.dlg.cb_demLayer.layerChanged.connect(self.select_cb_demClick)

            self.dlg.cb_recLayer.layerChanged.connect(self.select_cb_recClick)
            self.dlg.cb_srcPLayer.layerChanged.connect(self.select_cb_srcPLayerClick)
            self.dlg.cb_srcLLayer.layerChanged.connect(self.select_cb_srcLLayerClick)
            self.dlg.cb_srcALayer.layerChanged.connect(self.select_cb_srcALayerClick)

            self.dlg.cb_subArea.layerChanged.connect(self.select_cb_subAreaClick)
            self.dlg.bt_SaveTo.clicked.connect(self.select_output_file)
            self.dlg.se_dx.valueChanged.connect(self.startWorkerPreviewdxyz)
            self.dlg.se_dy.valueChanged.connect(self.startWorkerPreviewdxyz)

            self.dlg.se_dz.valueChanged.connect(self.startWorkerPreviewdz)
            self.dlg.se_zGrids.valueChanged.connect(self.startWorkerPreviewdz)
            self.dlg.se_teleStart.valueChanged.connect(self.startWorkerPreviewdz)
            self.dlg.se_teleStretch.valueChanged.connect(self.startWorkerPreviewdz)
            self.dlg.chk_useSplitting.stateChanged.connect(self.startWorkerPreviewdz)
            self.dlg.chk_useTelescoping.stateChanged.connect(self.startWorkerPreviewdz)

            self.dlg.bt_SaveINX.clicked.connect(lambda: self.startWorker())

            self.dlg.tw_Main.currentChanged.connect(self.loadDB)
            self.dlg.lw_prj.itemSelectionChanged.connect(self.updateDB)
            self.dlg.bt_updateDB.clicked.connect(self.loadDB)
            self.dlg.bt_startDBManager.clicked.connect(self.startDBManager)


        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        #print(result)

        # See if OK was pressed
        #if result:
            #self.saveINX()
            #print("OK")
            #filename = self.dlg.lineEdit.text()
            #self.iface.messageBar().pushMessage("Success", "Output file written at " + filename,level=Qgis.Success, duration=3)
