# GeoConfirmed QGIS Plugin

A QGIS plugin for importing and visualizing geolocation data from [GeoConfirmed](https://geoconfirmed.org/).

<img width="2028" height="1488" alt="image" src="https://github.com/user-attachments/assets/6c41ac0f-2f1c-4473-92a1-5c65033dddb1" />

## Features

- **Import placemarks** from GeoConfirmed conflicts (Ukraine, etc.)
- **Faction filtering** - Filter by faction (Russia, Ukraine, etc.)
- **Unit filtering** - Filter by military unit (ORBAT) with hierarchical tree view
- **Keyword search** - Boolean search with AND (`&`), OR (`|`), NOT (`!`), and grouping `()`
- **Date filtering** - Filter by date range or recent days
- **Spatial filtering** - Filter by radius, canvas extent, or polygon boundaries
- **Server-side filtering** - Fast queries with filters processed on the server
- **Auto-update** - Automatically fetch new placemarks since last import
- **GeoPackage export** - Save layers as GeoPackage files for offline use
- **Temporal support** - Enable QGIS temporal controller for time-based visualization
- **Icon styling** - Automatic categorized styling using GeoConfirmed icons or unit emblems

## Installation

### From ZIP file

1. Download the latest release ZIP
2. In QGIS: Plugins > Manage and Install Plugins > Install from ZIP
3. Select the downloaded ZIP file

### Manual installation

1. Clone or download this repository
2. Copy the `geoconfirmed_qgis` folder to your QGIS plugins directory:
   - **Windows**: `%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\`
   - **Linux**: `~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/`
   - **macOS**: `~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/`
3. Restart QGIS
4. Enable the plugin: Plugins > Manage and Install Plugins > Installed > GeoConfirmed

## Usage

1. Open the plugin from the Plugins menu or toolbar
2. Select a conflict from the dropdown
3. (Optional) Configure filters:
   - Select specific factions
   - Enter keyword search terms
   - Set date range
4. Choose output format (Memory Layer or GeoPackage)
5. Click "Fetch Data"

### Keyword Search Syntax

- Simple terms: `tank` (matches items containing "tank")
- AND: `tank & destroyed` or `tank destroyed` (implicit AND)
- OR: `tank | artillery`
- NOT: `!drone`
- Grouping: `(tank | artillery) & destroyed`
- Quoted phrases: `"air defense"`

### Auto-Update

After initial import, you can click "Update Layer" to fetch only new placemarks since your last import. This uses the `date_created` field to identify new entries.

## Data Fields

### Placemark fields:
- `id` - Unique placemark ID
- `date` - Event date (DateTime)
- `date_created` - When the placemark was added
- `name` - Placemark name
- `description` - Detailed description
- `original_source` - Source URLs (newline-separated)
- `geolocation` - Geolocation source URLs
- `faction` - Derived faction name
- `equipment_type` - Derived equipment category
- `is_destroyed` - Whether equipment was destroyed

## Requirements

- QGIS 3.28 or later
- Internet connection for fetching data

## License

This plugin is licensed under the GNU General Public License v2.0 or later (GPL-2.0+).
See the [LICENSE](LICENSE) file for details.

## Credits

- Data source: [GeoConfirmed](https://geoconfirmed.org/)
- Plugin development: Community contribution
