from qgis.core import QgsApplication
from .geocodificacion_inversa_alg import GeocodificacionProvider

class GeocodificacionPlugin:
    """Clase principal del plugin que se carga en QGIS."""
    def __init__(self, iface):
        self.provider = None

    def initGui(self):
        # Inicializa y registra el proveedor de Processing
        self.provider = GeocodificacionProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        # Limpieza al descargar el plugin
        if self.provider:
            QgsApplication.processingRegistry().removeProvider(self.provider)

def classFactory(iface):
    """Punto de entrada que QGIS usa para instanciar el plugin."""
    return GeocodificacionPlugin(iface)