# Geocod

Welcome to **Geocod**, a plugin developed for QGIS that geocodes addresses in a CSV file and generates a point vector layer.

---

## **Plugin Installation in QGIS**

After setting up the environment, follow these steps to install the plugin in QGIS:

1. Download or clone the plugin repository in a ZIP file.
2. Open QGIS.
3. Go to **Plugins > Manage and Install Plugins**.
4. Click the **Install from a ZIP file** tab.
5. Select the plugin ZIP file or the folder where the files were extracted.
6. Click **Install Plugin**.

---

With these steps completed, the plugin is ready to use!

---

## **Usage Instructions**

### **CSV File Format**

For the plugin to work correctly, the input CSV file must:

1. Use **commas** as column separators.
2. Contain an address column in the standardized format, as instructed below.

## **Address Column Format**

When running the plugin, you will be prompted to select the **address column**. This column should contain addresses formatted in the following format:

```
"Rua Saladino de Castro, 1575 - Centro, Arapoti, Paraná"
```

**Example CSV content:**

```csv
Locations, addresses, obs
Location 1, "Rua Bolívia, 151 - Vila Nova, Barbosa Ferraz, Paraná", Hospital 1
Location 2, "Rua Curitiba, 165 - Jardim América, Assis Chateaubriand, Paraná", Hospital 2
Location 3, "Avenida Thiago Peixoto, 274 - Batel, Antonina, Paraná", Hospital 3
```
---
## Credits

This plugin uses and adapts code from the [geocoder](https://github.com/DenisCarriere/geocoder) library by Denis Carriere, licensed under the MIT License.

We thank the original authors for their work and for making the code available.

## License

This plugin is licensed under the MIT License.

## Author

**Edson Tadeu da Silva Pinto**

Cartographic Engineer | Captain in the Brazilian Army

Developed within the scope of studies and applications in geotechnology.

+ ©2025 Edson Tadeu da Silva Pinto