# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Geocodificacao
                                 A QGIS plugin
 Este plugin automatiza a geocodificação de endereços dispostos em CSV e cria um shapefile deste pontos
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-11-18
        copyright            : (C) 2024 by Edson Tadeu da Silva Pinto
        email                : e.tadeu.eb@ime.eb.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Edson Tadeu da Silva Pinto'
__date__ = '2024-11-18'
__copyright__ = '(C) 2024 by Edson Tadeu da Silva Pinto'
__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .geocodificacao_provider import GeocodificacaoProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class GeocodificacaoPlugin(object):

    def __init__(self):
        self.provider = None

    def initProcessing(self):
        self.provider = GeocodificacaoProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
