# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Geocodificacao
                                 A QGIS plugin
 Este plugin automatiza a geocodificação de endereços dispostos em CSV e cria um shapefile deste pontos
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-11-18
        copyright            : (C) 2024 by Edson Tadeu da Silva Pinto
        email                : e.tadeu.eb@ime.eb.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Edson Tadeu da Silva Pinto'
__date__ = '2024-11-18'
__copyright__ = '(C) 2024 by Edson Tadeu da Silva Pinto'
__revision__ = '$Format:%H$'

import os
from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
from .geocodificacao_algorithm import GeocodificacaoAlgorithm


class GeocodificacaoProvider(QgsProcessingProvider):

    def __init__(self):
        QgsProcessingProvider.__init__(self)

    def unload(self):
        pass

    def loadAlgorithms(self):
        self.addAlgorithm(GeocodificacaoAlgorithm())

    def id(self):
        return 'Geocodificacao'

    def name(self):
        return self.tr('Geocod')

    def icon(self):
        return QIcon(os.path.join(os.path.dirname(__file__), 'icon.png'))

    def longName(self):
        return self.name()
