# -*- coding: utf-8 -*-

"""
/***************************************************************************
 geocluster
                                 A QGIS plugin
 geocluster
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-05
        copyright            : (C) 2024 by Federico Falasca
        email                : federico.falasca@graduate.univaq.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Federico Falasca'
__date__ = '2024-03-05'
__copyright__ = '(C) 2024 by Federico Falasca'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProject
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsCoordinateReferenceSystem
from qgis.core import QgsExpression
from qgis.core import QgsMessageLog
from qgis.utils import iface
import processing
import webbrowser
import os
from qgis.PyQt.QtGui import QIcon
geoclusterPath = os.path.dirname(__file__)


class OpenManualAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        project = QgsProject.instance()

    def processAlgorithm(self, parameters, context, model_feedback):
        FilePath = os.path.dirname(__file__)
        Output = 'Apri manuale'
        project = QgsProject.instance()
        webbrowser.open_new(os.path.join(FilePath, "Docs", "User's Manual.pdf"))
        return {'Output': Output}

    def name(self):
        return 'Open plugin manual'

    def displayName(self):
        return 'Open plugin manual'

    def group(self):
        return 'Help'

    def groupId(self):
        return '0help'

    def shortHelpString(self):
        return """
        Display english user manual
        """

    def createInstance(self):
        return OpenManualAlgorithm()

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(os.path.join(geoclusterPath, "icons", "manual.png"))


class GridAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('Boundary', 'Land Cover Boundary', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('UrbanAtlas', 'Land Cover Layer', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Grid_s0', 'Grid_S0', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Grid_s1', 'Grid_S1', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Grid_s2', 'Grid_S2', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Grid_s3', 'Grid_S3', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Intersection_s0', 'Intersection_S0', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Intersection_s1', 'Intersection_S1', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Intersection_s2', 'Intersection_S2', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Intersection_s3', 'Intersection_S3', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(37, model_feedback)
        results = {}
        outputs = {}

        # Buffer
        alg_params = {
            'DISSOLVE': False,
            'DISTANCE': 2000,
            'END_CAP_STYLE': 0,
            'INPUT': parameters['Boundary'],
            'JOIN_STYLE': 0,
            'MITER_LIMIT': 2,
            'OUTPUT': 'TEMPORARY_OUTPUT',
            'SEGMENTS': 5,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Create grid
        alg_params = {
            'CRS': 'ProjectCrs',
            'EXTENT': outputs['Buffer']['OUTPUT'],
            'HOVERLAY': 0,
            'HSPACING': 1074.55417,
            'TYPE': 4,
            'VOVERLAY': 0,
            'VSPACING': 1074.55417,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CreateGrid'] = processing.run('native:creategrid', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Translate_S3
        alg_params = {
            'DELTA_M': 0,
            'DELTA_X': 310.197,
            'DELTA_Y': -537.3805,
            'DELTA_Z': 0,
            'INPUT': outputs['CreateGrid']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Translate_s3'] = processing.run('native:translategeometry', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Intersection
        alg_params = {
            'INPUT': parameters['UrbanAtlas'],
            'INPUT_FIELDS': [''],
            'OVERLAY': outputs['CreateGrid']['OUTPUT'],
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersection'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Translate_S2
        alg_params = {
            'DELTA_M': 0,
            'DELTA_X': 0,
            'DELTA_Y': -537.3805,
            'DELTA_Z': 0,
            'INPUT': outputs['CreateGrid']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Translate_s2'] = processing.run('native:translategeometry', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Intersection_UA_S3
        alg_params = {
            'INPUT': parameters['UrbanAtlas'],
            'INPUT_FIELDS': [''],
            'OVERLAY': outputs['Translate_s3']['OUTPUT'],
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersection_ua_s3'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Translate_S1
        alg_params = {
            'DELTA_M': 0,
            'DELTA_X': 620.394,
            'DELTA_Y': 0,
            'DELTA_Z': 0,
            'INPUT': outputs['CreateGrid']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Translate_s1'] = processing.run('native:translategeometry', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi 0.1
        alg_params = {
            'FIELD_LENGTH': 255,
            'FIELD_NAME': 'id_txt',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\"id\"  || \'.0\'',
            'INPUT': outputs['Intersection']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi01'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Intersection_UA_S2
        alg_params = {
            'INPUT': parameters['UrbanAtlas'],
            'INPUT_FIELDS': [''],
            'OVERLAY': outputs['Translate_s2']['OUTPUT'],
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersection_ua_s2'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi 2.1
        alg_params = {
            'FIELD_LENGTH': 255,
            'FIELD_NAME': 'id_txt',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\"id\" || \'.0\'',
            'INPUT': outputs['Intersection_ua_s2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi21'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # Intersection_UA_S1
        alg_params = {
            'INPUT': parameters['UrbanAtlas'],
            'INPUT_FIELDS': [''],
            'OVERLAY': outputs['Translate_s1']['OUTPUT'],
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersection_ua_s1'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi 3.1
        alg_params = {
            'FIELD_LENGTH': 255,
            'FIELD_NAME': 'id_txt',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\"id\"  ||  \'.0\'',
            'INPUT': outputs['Intersection_ua_s3']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi31'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return {}

        # Elimina campo(i) 3.1
        alg_params = {
            'COLUMN': QgsExpression('\'fid;id;Pop2018;left;top;right;bottom;identifier;area\'').evaluate(),
            'INPUT': outputs['CalcolatoreDiCampi31']['OUTPUT'],
            'OUTPUT': parameters['Intersection_s3']
        }
        outputs['EliminaCampoi31'] = processing.run('qgis:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Intersection_s3'] = outputs['EliminaCampoi31']['OUTPUT']

        feedback.setCurrentStep(13)
        if feedback.isCanceled():
            return {}

        # Elimina campo(i) 0.1
        alg_params = {
            'COLUMN': QgsExpression('\'fid;id;Pop2018;left;top;right;bottom;identifier;area\'').evaluate(),
            'INPUT': outputs['CalcolatoreDiCampi01']['OUTPUT'],
            'OUTPUT': parameters['Intersection_s0']
        }
        outputs['EliminaCampoi01'] = processing.run('qgis:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Intersection_s0'] = outputs['EliminaCampoi01']['OUTPUT']

        feedback.setCurrentStep(14)
        if feedback.isCanceled():
            return {}

        # Dissolvi 0
        alg_params = {
            'FIELD': ['id'],
            'INPUT': outputs['Intersection']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi0'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(15)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi 1.1
        alg_params = {
            'FIELD_LENGTH': 255,
            'FIELD_NAME': 'id_txt',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\"id\" || \'.0\'',
            'INPUT': outputs['Intersection_ua_s1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi11'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(16)
        if feedback.isCanceled():
            return {}

        # Dissolvi 3
        alg_params = {
            'FIELD': ['id'],
            'INPUT': outputs['Intersection_ua_s3']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi3'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(17)
        if feedback.isCanceled():
            return {}

        # Elimina campo(i) 3
        alg_params = {
            'COLUMN': QgsExpression('\'fid;country;prod_date;perimeter;area;comment;Pop2018;left;top;right;bottom;identifier\'').evaluate(),
            'INPUT': outputs['Dissolvi3']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EliminaCampoi3'] = processing.run('qgis:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(18)
        if feedback.isCanceled():
            return {}

        # Elimina campo(i) 0
        alg_params = {
            'COLUMN': QgsExpression('\'fid;country;prod_date;perimeter;area;comment;Pop2018;left;top;right;bottom;identifier\'').evaluate(),
            'INPUT': outputs['Dissolvi0']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EliminaCampoi0'] = processing.run('qgis:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(19)
        if feedback.isCanceled():
            return {}

        # Elimina campo(i) 2.1
        alg_params = {
            'COLUMN': QgsExpression('\'fid;id;Pop2018;left;top;right;bottom;identifier;area\'').evaluate(),
            'INPUT': outputs['CalcolatoreDiCampi21']['OUTPUT'],
            'OUTPUT': parameters['Intersection_s2']
        }
        outputs['EliminaCampoi21'] = processing.run('qgis:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Intersection_s2'] = outputs['EliminaCampoi21']['OUTPUT']

        feedback.setCurrentStep(20)
        if feedback.isCanceled():
            return {}

        # Dissolvi 2
        alg_params = {
            'FIELD': ['id'],
            'INPUT': outputs['Intersection_ua_s2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi2'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(21)
        if feedback.isCanceled():
            return {}

        # Dissolvi 1
        alg_params = {
            'FIELD': ['id'],
            'INPUT': outputs['Intersection_ua_s1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi1'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(22)
        if feedback.isCanceled():
            return {}

        # Elimina campo(i) 1
        alg_params = {
            'COLUMN': QgsExpression('\'fid;country;prod_date;perimeter;area;comment;Pop2018;left;top;right;bottom;identifier\'').evaluate(),
            'INPUT': outputs['Dissolvi1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EliminaCampoi1'] = processing.run('qgis:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(23)
        if feedback.isCanceled():
            return {}

        # Elimina campo(i) 1.1
        alg_params = {
            'COLUMN': QgsExpression('\'fid;id;Pop2018;left;top;right;bottom;identifier;area\'').evaluate(),
            'INPUT': outputs['CalcolatoreDiCampi11']['OUTPUT'],
            'OUTPUT': parameters['Intersection_s1']
        }
        outputs['EliminaCampoi11'] = processing.run('qgis:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Intersection_s1'] = outputs['EliminaCampoi11']['OUTPUT']

        feedback.setCurrentStep(24)
        if feedback.isCanceled():
            return {}

        # Aggiungi campo alla tabella attributi 1.0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Area',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 1,
            'INPUT': outputs['EliminaCampoi1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AggiungiCampoAllaTabellaAttributi10'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(25)
        if feedback.isCanceled():
            return {}

        # Aggiungi campo alla tabella attributi 3.0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Area',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 1,
            'INPUT': outputs['EliminaCampoi3']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AggiungiCampoAllaTabellaAttributi30'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(26)
        if feedback.isCanceled():
            return {}

        # Elimina campo(i) 2
        alg_params = {
            'COLUMN': QgsExpression('\'fid;country;prod_date;perimeter;area;comment;Pop2018;left;top;right;bottom;identifier\'').evaluate(),
            'INPUT': outputs['Dissolvi2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EliminaCampoi2'] = processing.run('qgis:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(27)
        if feedback.isCanceled():
            return {}

        # Aggiungi campo alla tabella attributi 0.0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Area',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 1,
            'INPUT': outputs['EliminaCampoi0']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AggiungiCampoAllaTabellaAttributi00'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(28)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi 0.0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': QgsExpression('\'Area\'').evaluate(),
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': ' $area /1000000',
            'INPUT': outputs['AggiungiCampoAllaTabellaAttributi00']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi00'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(29)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi 1.0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': QgsExpression('\'Area\'').evaluate(),
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': ' $area /1000000',
            'INPUT': outputs['AggiungiCampoAllaTabellaAttributi10']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi10'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(30)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione
        alg_params = {
            'EXPRESSION': '\"Area\"  > 0.999',
            'INPUT': outputs['CalcolatoreDiCampi10']['OUTPUT'],
            'OUTPUT': parameters['Grid_s1']
        }
        outputs['EstraiTramiteEspressione'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Grid_s1'] = outputs['EstraiTramiteEspressione']['OUTPUT']

        feedback.setCurrentStep(31)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi 3.0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': QgsExpression('\'Area\'').evaluate(),
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': ' $area /1000000',
            'INPUT': outputs['AggiungiCampoAllaTabellaAttributi30']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi30'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(32)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione
        alg_params = {
            'EXPRESSION': '\"Area\"  > 0.999',
            'INPUT': outputs['CalcolatoreDiCampi30']['OUTPUT'],
            'OUTPUT': parameters['Grid_s3']
        }
        outputs['EstraiTramiteEspressione'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Grid_s3'] = outputs['EstraiTramiteEspressione']['OUTPUT']

        feedback.setCurrentStep(33)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione
        alg_params = {
            'EXPRESSION': '\"Area\"  > 0.999',
            'INPUT': outputs['CalcolatoreDiCampi00']['OUTPUT'],
            'OUTPUT': parameters['Grid_s0']
        }
        outputs['EstraiTramiteEspressione'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Grid_s0'] = outputs['EstraiTramiteEspressione']['OUTPUT']

        feedback.setCurrentStep(34)
        if feedback.isCanceled():
            return {}

        # Aggiungi campo alla tabella attributi 2.0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Area',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 1,
            'INPUT': outputs['EliminaCampoi2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AggiungiCampoAllaTabellaAttributi20'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(35)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi 2.0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': QgsExpression('\'Area\'').evaluate(),
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,
            'FORMULA': ' $area /1000000',
            'INPUT': outputs['AggiungiCampoAllaTabellaAttributi20']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi20'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(36)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione
        alg_params = {
            'EXPRESSION': '\"Area\"  > 0.999',
            'INPUT': outputs['CalcolatoreDiCampi20']['OUTPUT'],
            'OUTPUT': parameters['Grid_s2']
        }
        outputs['EstraiTramiteEspressione'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Grid_s2'] = outputs['EstraiTramiteEspressione']['OUTPUT']
        return results

    def name(self):
        return '1. Grid analysis'

    def displayName(self):
        return '1. Grid analysis'

    def group(self):
        return ''

    def groupId(self):
        return ''

    def createInstance(self):
        return GridAlgorithm()

    def shortHelpString(self):
        return """
        Grid creation, tanslation and intersection.

        INPUT

         Class layer = Layer containing the desired categories, reported into the “code” field 
         Class layer boundary = Boundary of the class layer.
         

        OUTPUT
         Grid S0 = Null Grid Shift
         Grid S1 = Horizontal Grid Shift
         Grid S2 = Vertical Grid Shift
         Grid S3 = Diagonal Grid Shift
         
         Intersection S0 = Land cover and S0 Grid Intersection
         Intersection S1 = Land cover and S1 Grid Intersection
         Intersection S2 = Land cover and S2 Grid Intersection
         Intersection S3 = Land cover and S3 Grid Intersection
         For further Information consult user's manual ("Help" voice)
        """

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(os.path.join(geoclusterPath, "icons", "1.png"))


class JoinAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('CSV', 'S0 CSV', types=[QgsProcessing.TypeVector], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('CSV (2)', 'S1 CSV', types=[QgsProcessing.TypeVector], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('CSV (2) (2)', 'S2 CSV', types=[QgsProcessing.TypeVector], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('CSV (2) (2) (2)', 'S3 CSV', types=[QgsProcessing.TypeVector], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('Dissolved', 'S0 Grid', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('S1Grid', 'S1 Grid', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('S1Grid (2)', 'S2 Grid', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('S1Grid (2) (2)', 'S3 Grid', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Joined_s0', 'Joined_S0', optional=True, type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Joined_s1', 'Joined_S1', optional=True, type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Joined_s2', 'Joined_S2', optional=True, type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Joined_s3', 'Joined_S3', optional=True, type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(8, model_feedback)
        results = {}
        outputs = {}

        # Calcolatore di campi S1
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': QgsExpression('\'id_txt\'').evaluate(),
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\"id\"  || \'.0\'',
            'INPUT': parameters['S1Grid'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampiS1'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': QgsExpression('\'id_txt\'').evaluate(),
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\"id\"  || \'.0\'',
            'INPUT': parameters['Dissolved'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampi'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Unisci attributi secondo il valore del campo
        alg_params = {
            'DISCARD_NONMATCHING': True,
            'FIELD': QgsExpression('\'id_txt\'').evaluate(),
            'FIELDS_TO_COPY': [''],
            'FIELD_2': QgsExpression('\'code\'').evaluate(),
            'INPUT': outputs['CalcolatoreDiCampi']['OUTPUT'],
            'INPUT_2': parameters['CSV'],
            'METHOD': 1,
            'PREFIX': '',
            'OUTPUT': parameters['Joined_s0']
        }
        outputs['UnisciAttributiSecondoIlValoreDelCampo'] = processing.run('native:joinattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Joined_s0'] = outputs['UnisciAttributiSecondoIlValoreDelCampo']['OUTPUT']

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi S3
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': QgsExpression('\'id_txt\'').evaluate(),
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\"id\"  || \'.0\'',
            'INPUT': parameters['S1Grid (2) (2)'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampiS3'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Unisci attributi secondo il valore del campo S3
        alg_params = {
            'DISCARD_NONMATCHING': True,
            'FIELD': QgsExpression('\'id_txt\'').evaluate(),
            'FIELDS_TO_COPY': [''],
            'FIELD_2': QgsExpression('\'code\'').evaluate(),
            'INPUT': outputs['CalcolatoreDiCampiS3']['OUTPUT'],
            'INPUT_2': parameters['CSV (2) (2) (2)'],
            'METHOD': 1,
            'PREFIX': '',
            'OUTPUT': parameters['Joined_s3']
        }
        outputs['UnisciAttributiSecondoIlValoreDelCampoS3'] = processing.run('native:joinattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Joined_s3'] = outputs['UnisciAttributiSecondoIlValoreDelCampoS3']['OUTPUT']

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Unisci attributi secondo il valore del campo
        alg_params = {
            'DISCARD_NONMATCHING': True,
            'FIELD': QgsExpression('\'id_txt\'').evaluate(),
            'FIELDS_TO_COPY': [''],
            'FIELD_2': QgsExpression('\'code\'').evaluate(),
            'INPUT': outputs['CalcolatoreDiCampiS1']['OUTPUT'],
            'INPUT_2': parameters['CSV (2)'],
            'METHOD': 1,
            'PREFIX': '',
            'OUTPUT': parameters['Joined_s1']
        }
        outputs['UnisciAttributiSecondoIlValoreDelCampo'] = processing.run('native:joinattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Joined_s1'] = outputs['UnisciAttributiSecondoIlValoreDelCampo']['OUTPUT']

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Calcolatore di campi S2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': QgsExpression('\'id_txt\'').evaluate(),
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\"id\"  || \'.0\'',
            'INPUT': parameters['S1Grid (2)'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalcolatoreDiCampiS2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Unisci attributi secondo il valore del campo S2
        alg_params = {
            'DISCARD_NONMATCHING': True,
            'FIELD': QgsExpression('\'id_txt\'').evaluate(),
            'FIELDS_TO_COPY': [''],
            'FIELD_2': QgsExpression('\'code\'').evaluate(),
            'INPUT': outputs['CalcolatoreDiCampiS2']['OUTPUT'],
            'INPUT_2': parameters['CSV (2) (2)'],
            'METHOD': 1,
            'PREFIX': '',
            'OUTPUT': parameters['Joined_s2']
        }
        outputs['UnisciAttributiSecondoIlValoreDelCampoS2'] = processing.run('native:joinattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Joined_s2'] = outputs['UnisciAttributiSecondoIlValoreDelCampoS2']['OUTPUT']
        return results

    def name(self):
        return '2. Join step'

    def displayName(self):
        return '2. Join step'

    def group(self):
        return ''

    def groupId(self):
        return ''

    def shortHelpString(self):
        return """
        Join operation between the Groupstat derived CSVs and the Grid Shifts
        For further Information consult user's manual ("Help" voice)

       INPUT

        S0 CSV = CSV resulted from the GeoDA operations, relative to the S0 Intersection
        S1 CSV = CSV resulted from the GeoDA operations, relative to the S1 Intersection
        S2 CSV = CSV resulted from the GeoDA operations, relative to the S2 Intersection
        S3 CSV = CSV resulted from the GeoDA operations, relative to the S3 Intersection

       OUTPUT

        Joined S0,S1,S2,S3 = Layers containing the joined information that will be used for the Clustering phase (GeoDa Software needed)
        """

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(os.path.join(geoclusterPath, "icons", "2.png"))

    def createInstance(self):
        return JoinAlgorithm()


class Feature_extractionAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('Joined1', 'Joined 0', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('Joined1 (2)', 'Joined 1', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('Joined1 (2) (2)', 'Joined 2', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('Joined1 (2) (2) (2)', 'Joined 3', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('UrbannourbanAreasSystem12', 'Urban/NoUrban Areas System 1/2', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('UrbannourbanAreasSystem22', 'Urban/NoUrban Areas System 2/2', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('UrbannourbanInterfaceZone', 'Urban/NoUrban Interface Zone', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(13, model_feedback)
        results = {}
        outputs = {}

        # Estrai tramite espressione_03
        alg_params = {
            'EXPRESSION': '\"kmeans\" = 1',
            'INPUT': parameters['Joined1 (2) (2) (2)'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstraiTramiteEspressione_03'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione_2
        alg_params = {
            'EXPRESSION': '\"kmeans\" = 2',
            'INPUT': parameters['Joined1 (2) (2)'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstraiTramiteEspressione_2'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione_01
        alg_params = {
            'EXPRESSION': '\"kmeans\" = 1',
            'INPUT': parameters['Joined1 (2)'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstraiTramiteEspressione_01'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione
        alg_params = {
            'EXPRESSION': '\"kmeans\" = 2',
            'INPUT': parameters['Joined1'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstraiTramiteEspressione'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione_1
        alg_params = {
            'EXPRESSION': '\"kmeans\" = 2',
            'INPUT': parameters['Joined1 (2)'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstraiTramiteEspressione_1'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione_3
        alg_params = {
            'EXPRESSION': '\"kmeans\" = 2',
            'INPUT': parameters['Joined1 (2) (2) (2)'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstraiTramiteEspressione_3'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione_00
        alg_params = {
            'EXPRESSION': '\"kmeans\" = 1',
            'INPUT': parameters['Joined1'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstraiTramiteEspressione_00'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Estrai tramite espressione_02
        alg_params = {
            'EXPRESSION': '\"kmeans\" = 1',
            'INPUT': parameters['Joined1 (2) (2)'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EstraiTramiteEspressione_02'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Fondi vettori (merge) 2/2
        alg_params = {
            'CRS': QgsCoordinateReferenceSystem('EPSG:32633'),
            'LAYERS': [outputs['EstraiTramiteEspressione_00']['OUTPUT'],outputs['EstraiTramiteEspressione_01']['OUTPUT'],outputs['EstraiTramiteEspressione_02']['OUTPUT'],outputs['EstraiTramiteEspressione_03']['OUTPUT']],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FondiVettoriMerge22'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Dissolvi 2
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['FondiVettoriMerge22']['OUTPUT'],
            'OUTPUT': parameters['UrbannourbanAreasSystem22']
        }
        outputs['Dissolvi2'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['UrbannourbanAreasSystem22'] = outputs['Dissolvi2']['OUTPUT']

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # Fondi vettori (merge) 1/2
        alg_params = {
            'CRS': QgsCoordinateReferenceSystem('EPSG:32633'),
            'LAYERS': [outputs['EstraiTramiteEspressione']['OUTPUT'],outputs['EstraiTramiteEspressione_1']['OUTPUT'],outputs['EstraiTramiteEspressione_2']['OUTPUT'],outputs['EstraiTramiteEspressione_3']['OUTPUT']],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FondiVettoriMerge12'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}

        # Dissolvi 1
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['FondiVettoriMerge12']['OUTPUT'],
            'OUTPUT': parameters['UrbannourbanAreasSystem12']
        }
        outputs['Dissolvi1'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['UrbannourbanAreasSystem12'] = outputs['Dissolvi1']['OUTPUT']

        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return {}

        # Intersezione
        alg_params = {
            'INPUT': outputs['Dissolvi1']['OUTPUT'],
            'INPUT_FIELDS': [''],
            'OVERLAY': outputs['Dissolvi2']['OUTPUT'],
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': parameters['UrbannourbanInterfaceZone']
        }
        outputs['Intersezione'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['UrbannourbanInterfaceZone'] = outputs['Intersezione']['OUTPUT']
        return results

    def name(self):
        return '3. Clusters extraction'

    def displayName(self):
        return '3. Clusters extraction'

    def group(self):
        return ''

    def groupId(self):
        return ''

    def shortHelpString(self):
        return """
        Clusters isolation and extraction

        INPUT

        Joined S0
        Joined S1
        Joined S2
        Joined S3

        OUTPUT

        Cluster group extraction 1/2 = First cluster group isolation and extraction
        Cluster group extraction 2/2 = Second cluster group isolation and extraction
        Clusters Interface Zone = Overlapping portions between the Clustering groups 1 and 2
        """

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(os.path.join(geoclusterPath, "icons", "3.png"))

    def createInstance(self):
        return Feature_extractionAlgorithm()
