#!/usr/bin/env python3
"""
Script para validar a configuração de sensores do plugin FORGEGEO
"""

import re

def validate_sensor_config():
    """Valida se os sensores estão configurados corretamente"""
    
    with open('processing_algorithm.py', 'r', encoding='utf-8') as f:
        content = f.read()
    
    # Procurar pela linha de opções
    pattern = r"options=\[(.*?)\]"
    match = re.search(pattern, content)
    
    if match:
        options_str = match.group(1)
        print("✓ Linha de opções encontrada:")
        print(f"  options=[{options_str}]")
        
        # Verificar se Sentinel-2 está presente
        if 'Sentinel-2' in options_str:
            print("\n✓ Sentinel-2 está configurado na lista de sensores!")
            
            # Contar quantos sensores estão configurados
            sensors = [s.strip().strip("'\"") for s in options_str.split(',')]
            print(f"\n✓ Total de sensores configurados: {len(sensors)}")
            for i, sensor in enumerate(sensors):
                print(f"  [{i}] {sensor}")
            
            return True
        else:
            print("\n✗ Sentinel-2 NÃO está configurado!")
            print("  Sensores encontrados:")
            sensors = [s.strip().strip("'\"") for s in options_str.split(',')]
            for i, sensor in enumerate(sensors):
                print(f"  [{i}] {sensor}")
            return False
    else:
        print("✗ Não foi possível encontrar a linha de opções!")
        return False

if __name__ == '__main__':
    print("=" * 60)
    print("Validação de Configuração de Sensores")
    print("GeoCAR Vision v1.2.0")
    print("=" * 60)
    print()
    
    result = validate_sensor_config()
    
    print()
    print("=" * 60)
    if result:
        print("Status: ✓ CONFIGURAÇÃO VÁLIDA")
    else:
        print("Status: ✗ CONFIGURAÇÃO INVÁLIDA")
    print("=" * 60)
