# Configuração de Sensores - FORGEGEO Fusionador

## Sensores Disponíveis

O plugin GeoCAR Vision suporta os seguintes sensores:

### 1. **Landsat 8** (Índice: 0)
- Bandas: B4 (Red), B5 (Near Infrared), B6 (SWIR 1), B8 (Panchromatic)
- Processamento: Pansharpening
- Resolução: 30m → 15m (com pansharpening)

### 2. **Landsat 5** (Índice: 1)
- Bandas: B3 (Red), B4 (Near Infrared), B5 (SWIR)
- Processamento: Composição simples
- Resolução: 30m

### 3. **CBERS-4A** (Índice: 2)
- Bandas: B3 (Red), B4 (Near Infrared), B5 (SWIR)
- Sequência de composição: B5-B4-B3
- Processamento: Composição simples
- Resolução: 64m

### 4. **Sentinel-2** (Índice: 3)
- Bandas: B4 (Red), B8 (Near Infrared), B11 (SWIR)
- Sequência de composição: B11-B8-B4
- Processamento: Composição simples
- Resolução: 20m (B11), 10m (B8, B4)

## Verificação da Configuração

No arquivo `processing_algorithm.py`, linha 56, a lista de sensores está configurada como:

```python
options=['Landsat 8', 'Landsat 5', 'CBERS-4A', 'Sentinel-2']
```

Isso garante que todas as 3 opções apareçam na interface de seleção de sensor.

## Como Usar

1. Abra a caixa de ferramentas de processamento do QGIS
2. Procure por "GeoCAR Vision"
3. Na seleção de "Sensor", escolha uma das 3 opções
4. Carregue as bandas correspondentes ao sensor selecionado
5. Configure o sistema de coordenadas de saída
6. Execute o processamento

## Troubleshooting

Se o Sentinel-2 ou outro sensor não aparecer na lista:

1. **Limpe o cache do QGIS**:
   - Linux: `~/.local/share/QGIS/`
   - Windows: `%APPDATA%\QGIS\`
   - macOS: `~/Library/Application Support/QGIS/`

2. **Desinstale e reinstale o plugin**

3. **Reinicie o QGIS completamente**

4. **Verifique se o arquivo `processing_algorithm.py` contém a linha**:
   ```python
   options=['Landsat 8', 'Landsat 5', 'CBERS-4A']
   ```
