"""
Provedor de processamento para algoritmos Landsat 8
Registra os algoritmos de processamento no QGIS
"""

from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
import os

from .processing_algorithm import LandsatFusionAlgorithm


class Landsat8FusionProvider(QgsProcessingProvider):
    """Provedor de processamento para algoritmos Landsat 8"""

    def loadAlgorithms(self):
        """Carrega todos os algoritmos do provedor"""
        self.addAlgorithm(LandsatFusionAlgorithm())

    def id(self):
        """Retorna o ID único do provedor"""
        return 'landsat8_fusion'

    def name(self):
        """Retorna o nome de exibição do provedor"""
        return 'FORGEGEO-Fusionador'

    def icon(self):
        """Retorna o ícone do provedor"""
        icon_path = os.path.join(
            os.path.dirname(__file__),
            'resources',
            'icon.png'
        )
        if os.path.exists(icon_path):
            return QIcon(icon_path)
        return QIcon()

    def longName(self):
        """Retorna o nome longo do provedor"""
        return 'Landsat 8 Band Fusion Processing Provider'
