"""
Landsat 8 Band Fusion Plugin
Fusiona bandas Landsat 8 (B4, B5, B6) com a banda B8 usando pansharpening
Otimizado para QGIS 3.40+
"""

from qgis.PyQt.QtWidgets import QAction, QMessageBox
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsApplication
from pathlib import Path
import os

from .processing_provider import Landsat8FusionProvider
from .dialogs.main_dialog import LandsatFusionDialog


class LandsatFusionPlugin:
    """Classe principal do plugin GeoCAR Vision"""

    def __init__(self, iface):
        """
        Inicializa o plugin
        
        Args:
            iface: Interface do QGIS
        """
        self.iface = iface
        self.provider = None
        self.dialog = None
        self.action = None

    def initGui(self):
        """Inicializa a interface gráfica do plugin"""
        # Obter o caminho do ícone
        icon_path = os.path.join(
            os.path.dirname(__file__), 
            'resources', 
            'icon.png'
        )
        
        # Criar ação do menu
        self.action = QAction(
            QIcon(icon_path) if os.path.exists(icon_path) else QIcon(),
            'GeoCAR Vision',
            self.iface.mainWindow()
        )
        self.action.triggered.connect(self.run)
        
        # Adicionar à barra de ferramentas e menu
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToRasterMenu('&GeoCAR Vision', self.action)
        
        # Registrar o provedor de processamento
        self.provider = Landsat8FusionProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        """Remove o plugin da interface do QGIS"""
        if self.action is not None:
            self.iface.removePluginRasterMenu('&GeoCAR Vision', self.action)
            self.iface.removeToolBarIcon(self.action)
        
        # Remover o provedor de processamento
        if self.provider is not None:
            QgsApplication.processingRegistry().removeProvider(self.provider)

    def run(self):
        """Executa o plugin abrindo a caixa de diálogo principal"""
        if self.dialog is None:
            self.dialog = LandsatFusionDialog(self.iface)
        
        self.dialog.show()
        self.dialog.raise_()
        self.dialog.activateWindow()
