# Relatório de Configuração - FORGEGEO Fusionador v1.1.0

## Status: ✓ CONFIGURAÇÃO VÁLIDA

Data: 22 de Janeiro de 2026

---

## 1. Sensores Configurados

A lista de sensores foi validada e contém **3 opções**:

| Índice | Sensor | Status |
|--------|--------|--------|
| 0 | Landsat 8 | ✓ Ativo |
| 1 | Landsat 5 | ✓ Ativo |
| 2 | CBERS-4A | ✓ Ativo |
| 3 | Sentinel-2 | ✓ **NOVO** |

---

## 2. Localização da Configuração

**Arquivo**: `processing_algorithm.py`  
**Linha**: 57  
**Método**: `initAlgorithm()`

```python
sensor_param = QgsProcessingParameterEnum(
    self.SENSOR_TYPE,
    'Sensor',
    options=['Landsat 8', 'Landsat 5', 'CBERS-4A', 'Sentinel-2'],  # ← Sentinel-2 adicionado aqui
    defaultValue=0,
    allowMultiple=False
)
```

---

## 3. Especificações do CBERS-4A

### Parâmetros de Entrada
- **Banda B3** (Red)
- **Banda B4** (Near Infrared)
- **Banda B5** (Short Wave Infrared)

### Sequência de Composição
- **Ordem**: B5 → B4 → B3
- **Resultado**: Composição RGB com SWIR no canal vermelho

### Processamento
- Tipo: Composição simples (sem pansharpening)
- Reprojeção: Sim (para o CRS selecionado)
- Resolução nativa: 64m

---

## 4. Especificações do Sentinel-2

### Parâmetros de Entrada
- **Banda B3** (Red)
- **Banda B4** (Near Infrared)
- **Banda B5** (Short Wave Infrared)

### Sequência de Composição
- **Ordem**: B5 → B4 → B3
- **Resultado**: Composição RGB com SWIR no canal vermelho

### Processamento
- Tipo: Composição simples (sem pansharpening)
- Reprojeção: Sim (para o CRS selecionado)
- Resolução nativa: 64m

---

## 5. Roteamento Interno

No método `processAlgorithm()`, a seleção é roteada corretamente:

```python
if sensor_type == 0:      # Landsat 8
    return self.process_landsat8(...)
elif sensor_type == 1:    # Landsat 5
    return self.process_landsat5(...)
elif sensor_type == 2:    # CBERS-4A
    return self.process_cbers4a(...)
else:                     # Sentinel-2 (sensor_type == 3)
    return self.process_sentinel2(...)
```

---

## 6. Métodos Dedicados para cada Sensor

### CBERS-4A: `process_cbers4a()`

Implementado: `process_cbers4a()`

**Etapas de processamento**:
1. Construção de raster virtual com bandas B5, B4, B3
2. Reprojeção para o CRS selecionado

**Validação**: Todas as 3 bandas são obrigatórias

---

### Sentinel-2: `process_sentinel2()`

**Etapas de processamento**:
1. Construção de raster virtual com bandas B11, B8, B4
2. Reprojeção para o CRS selecionado

**Validação**: Todas as 3 bandas são obrigatórias

---

## 7. Verificação de Compatibilidade

- ✓ QGIS 3.40+
- ✓ Python 3.7+
- ✓ GDAL/OGR com suporte a pansharpening
- ✓ Processamento do QGIS

---

## 8. Checklist de Instalação

Para garantir que o CBERS-4A apareça corretamente:

- [ ] Desinstale versões anteriores do plugin
- [ ] Limpe o cache do QGIS:
  - **Linux**: `~/.local/share/QGIS/`
  - **Windows**: `%APPDATA%\QGIS\`
  - **macOS**: `~/Library/Application Support/QGIS/`
- [ ] Reinstale o novo plugin
- [ ] Reinicie o QGIS completamente
- [ ] Abra a caixa de ferramentas de processamento
- [ ] Procure por "GeoCAR Vision"
- [ ] Verifique se a seleção de "Sensor" mostra 4 opções

---

## 9. Resultado Esperado

Ao abrir o algoritmo "GeoCAR Vision" no QGIS, você verá:

```
Sensor: [dropdown com 4 opções]
  - Landsat 8
  - Landsat 5
  - CBERS-4A
  - Sentinel-2  ← Deve aparecer aqui
```

---

## 10. Suporte Técnico

Se o CBERS-4A não aparecer:

1. Execute o script de validação:
   ```bash
   python3 validate_sensors.py
   ```

2. Verifique o arquivo `processing_algorithm.py` linha 56

3. Confirme que a linha contém:
   ```python
   options=['Landsat 8', 'Landsat 5', 'CBERS-4A', 'Sentinel-2']
   ```

4. Se necessário, edite manualmente e adicione `'CBERS-4A'` à lista

---

**Versão do Plugin**: 1.2.0  
**Data de Atualização**: 22 de Janeiro de 2026  
**Desenvolvido por**: ForgeGeo/Geoserviço
