# GeoCAR Vision

Plugin QGIS para processamento de bandas Landsat 5 e Landsat 8 com reprojeção e pansharpening.

**Desenvolvido por ForgeGeo/Geoserviço**

## Características

- **Suporte Multi-Sensor**: Processa bandas Landsat 5 e Landsat 8
- **Landsat 8**: Fusionamento de bandas B4, B5, B6 com banda pancromática B8 usando pansharpening
- **Landsat 5**: Combinação de bandas B3, B4, B5 com reprojeção
- **Seleção de Sensor**: Interface para escolher entre Landsat 5 ou Landsat 8
- **Seleção de Projeção**: Permite ao usuário selecionar o sistema de coordenadas de saída
- **Interface Gráfica**: Interface amigável para seleção de sensor, bandas e configurações
- **Processamento em Background**: Execução em thread separada para não bloquear a interface
- **Compatibilidade**: Otimizado para QGIS 3.40 e versões posteriores

## Instalação

### Método 1: Instalação Manual

1. Baixe ou clone este repositório
2. Copie a pasta `landsat8_fusion_plugin` para o diretório de plugins do QGIS:
   - **Windows**: `C:\Users\<seu_usuario>\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins\`
   - **Linux**: `~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/`
   - **macOS**: `~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/`
3. Reinicie o QGIS
4. Ative o plugin em **Plugins > Gerenciar e Instalar Plugins > Instalados**

### Método 2: Via Arquivo ZIP

1. Comprima a pasta `landsat8_fusion_plugin` em um arquivo ZIP
2. No QGIS, vá para **Plugins > Gerenciar e Instalar Plugins > Instalar do ZIP**
3. Selecione o arquivo ZIP e clique em **Instalar Plugin**

## Uso

### Interface Gráfica

1. Abra o plugin através do menu **Raster > GeoCAR Vision** ou clique no ícone ForgeGeo na barra de ferramentas
2. Selecione o sensor: **Landsat 8** ou **Landsat 5**
3. **Para Landsat 8**, selecione as bandas:
   - **Banda B4**: Banda vermelha (Red)
   - **Banda B5**: Infravermelho próximo (Near Infrared)
   - **Banda B6**: Infravermelho de onda curta 1 (Short Wave Infrared 1)
   - **Banda B8**: Banda pancromática (Panchromatic)
4. **Para Landsat 5**, selecione as bandas:
   - **Banda B3**: Banda vermelha (Red)
   - **Banda B4**: Infravermelho próximo (Near Infrared)
   - **Banda B5**: Infravermelho de onda curta (Short Wave Infrared)
5. Selecione o sistema de coordenadas de saída (padrão: EPSG:4674 - SIRGAS 2000)
6. Escolha o caminho de saída para o raster processado
7. Clique em **Processar**

### Caixa de Ferramentas de Processamento

O algoritmo também está disponível na **Caixa de Ferramentas de Processamento**:

1. Abra a **Caixa de Ferramentas de Processamento** (Ctrl+Alt+T)
2. Navegue até **Landsat Fusion > GeoCAR Vision (L5 & L8)**
3. Configure os parâmetros e execute

## Bandas Suportadas

### Landsat 8 (OLI/TIRS)

| Banda | Nome | Comprimento de Onda | Resolução Original | Resolução Final |
|-------|------|---------------------|-------------------|-----------------|
| B4 | Red | 0.64 - 0.67 μm | 30m | 15m |
| B5 | Near Infrared (NIR) | 0.85 - 0.88 μm | 30m | 15m |
| B6 | Short Wave Infrared 1 (SWIR1) | 1.57 - 1.65 μm | 30m | 15m |
| B8 | Panchromatic | 0.50 - 0.68 μm | 15m | 15m (referência) |

### Landsat 5 (TM)

| Banda | Nome | Comprimento de Onda | Resolução |
|-------|------|---------------------|-----------|
| B3 | Red | 0.63 - 0.69 μm | 30m |
| B4 | Near Infrared (NIR) | 0.76 - 0.90 μm | 30m |
| B5 | Short Wave Infrared (SWIR) | 1.55 - 1.75 μm | 30m |

## Processo de Fusionamento

### Landsat 8

O plugin executa três etapas principais:

1. **Construção de Raster Virtual**: Combina as bandas B4, B5 e B6 em um raster virtual multiespectral
2. **Pansharpening**: Aplica o algoritmo de pansharpening usando a banda B8 como referência pancromática, aumentando a resolução espacial das bandas espectrais de 30m para 15m
3. **Reprojeção**: Reprojeta o resultado para o sistema de coordenadas selecionado pelo usuário

### Landsat 5

O plugin executa duas etapas principais:

1. **Construção de Raster Virtual**: Combina as bandas B3, B4 e B5 em um raster virtual multiespectral
2. **Reprojeção**: Reprojeta o resultado para o sistema de coordenadas selecionado pelo usuário

## Requisitos

- QGIS 3.40 ou superior
- Plugin Processing (incluído por padrão no QGIS)
- GDAL (incluído por padrão no QGIS)

## Estrutura do Projeto

```
landsat8_fusion_plugin/
├── __init__.py                 # Inicializador do plugin
├── landsat8_fusion.py          # Classe principal do plugin
├── processing_algorithm.py     # Algoritmo de processamento
├── processing_provider.py      # Provedor de processamento
├── metadata.txt                # Metadados do plugin
├── README.md                   # Documentação
├── INSTALL.md                  # Guia de instalação
├── QUICKSTART.md               # Guia rápido
├── LICENSE                     # Licença MIT
├── dialogs/
│   ├── __init__.py
│   └── main_dialog.py          # Interface gráfica principal
└── resources/
    ├── __init__.py
    └── icon.png                # Logotipo ForgeGeo
```

## Desenvolvimento

### Tecnologias Utilizadas

- **Python 3**: Linguagem de programação
- **PyQt5**: Framework de interface gráfica
- **QGIS API**: API de processamento e interface do QGIS
- **GDAL**: Biblioteca de processamento geoespacial

### Contribuindo

Contribuições são bem-vindas! Por favor:

1. Faça um fork do projeto
2. Crie uma branch para sua feature (`git checkout -b feature/nova-feature`)
3. Commit suas mudanças (`git commit -am 'Adiciona nova feature'`)
4. Push para a branch (`git push origin feature/nova-feature`)
5. Abra um Pull Request

## Licença

Este plugin é distribuído sob licença MIT. Consulte o arquivo LICENSE para mais detalhes.

## Suporte

Para reportar bugs ou solicitar novas funcionalidades, por favor abra uma issue no repositório do GitHub ou entre em contato através do website ForgeGeo.

## Autor

Desenvolvido por **ForgeGeo/Geoserviço**

Website: [https://forgegeo.com](https://forgegeo.com)

## Changelog

### Versão 1.0.0
- Versão inicial
- Suporte para Landsat 5 e Landsat 8
- Fusionamento de bandas com pansharpening (Landsat 8)
- Combinação de bandas com reprojeção (Landsat 5)
- Seleção de sensor via interface
- Seleção de projeção de saída
- Interface gráfica completa
- Suporte para QGIS 3.40+
- Logotipo ForgeGeo integrado
