# Guia Rápido - GeoCAR Vision

## Instalação Rápida

1. Copie a pasta `landsat8_fusion_plugin` para o diretório de plugins do QGIS
2. Reinicie o QGIS
3. Ative o plugin em **Plugins > Gerenciar e Instalar Plugins**

## Uso Básico

### Via Interface Gráfica

1. Clique no ícone ForgeGeo ou acesse **Raster > GeoCAR Vision**
2. Selecione o sensor: **Landsat 8** ou **Landsat 5**
3. **Para Landsat 8**, selecione as bandas:
   - **B4**: Banda vermelha (Red)
   - **B5**: Infravermelho próximo (NIR)
   - **B6**: Infravermelho de onda curta (SWIR1)
   - **B8**: Banda pancromática (Pan)
4. **Para Landsat 5**, selecione as bandas:
   - **B3**: Banda vermelha (Red)
   - **B4**: Infravermelho próximo (NIR)
   - **B5**: Infravermelho de onda curta (SWIR)
5. Escolha o sistema de coordenadas de saída (padrão: EPSG:4674)
6. Selecione o local de saída
7. Clique em **Processar**

### Via Caixa de Ferramentas

1. Abra a **Caixa de Ferramentas de Processamento** (Ctrl+Alt+T)
2. Procure por "GeoCAR Vision"
3. Configure os parâmetros
4. Execute

## Resultado

**Landsat 8:**
- Resolução espacial de 15m (da banda pancromática)
- Informação espectral das bandas B4, B5 e B6
- Projeção selecionada pelo usuário

**Landsat 5:**
- Resolução espacial de 30m (original)
- Informação espectral das bandas B3, B4 e B5
- Projeção selecionada pelo usuário

## Dicas

- Use bandas da mesma cena Landsat
- Certifique-se de que as bandas têm a mesma extensão
- O processamento pode levar alguns minutos dependendo do tamanho da área
- O resultado é automaticamente adicionado ao projeto QGIS

## Sistemas de Coordenadas Comuns

- **EPSG:4674** - SIRGAS 2000 (Brasil)
- **EPSG:31982** - SIRGAS 2000 / UTM zone 22S
- **EPSG:31983** - SIRGAS 2000 / UTM zone 23S
- **EPSG:31984** - SIRGAS 2000 / UTM zone 24S
- **EPSG:4326** - WGS 84

## Solução Rápida de Problemas

| Problema | Solução |
|----------|---------|
| Plugin não aparece | Verifique se está na pasta correta e reinicie o QGIS |
| Erro ao processar | Verifique se todas as bandas são válidas |
| Resultado com qualidade ruim | Certifique-se de usar bandas da mesma cena |
| Processamento lento | Normal para áreas grandes, aguarde |

## Mais Informações

Consulte os arquivos:
- **README.md** - Documentação completa
- **INSTALL.md** - Guia detalhado de instalação
