# Guia de Instalação - GeoCAR Vision

Este guia fornece instruções detalhadas para instalar o plugin GeoCAR Vision no QGIS 3.40 ou superior.

**Desenvolvido por ForgeGeo/Geoserviço**

## Pré-requisitos

- QGIS 3.40 ou superior instalado
- Sistema operacional: Windows, Linux ou macOS

## Método 1: Instalação Manual (Recomendado)

### Passo 1: Localizar o Diretório de Plugins

Primeiro, você precisa encontrar o diretório de plugins do QGIS no seu sistema:

#### Windows
```
C:\Users\<seu_usuario>\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins\
```

#### Linux
```
~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/
```

#### macOS
```
~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/
```

**Dica**: No QGIS, você pode encontrar este diretório acessando:
- Menu **Configurações > Perfis de Usuário > Abrir Pasta do Perfil Ativo**
- Navegue até a pasta `python/plugins/`

### Passo 2: Copiar o Plugin

1. Copie toda a pasta `landsat8_fusion_plugin` para o diretório de plugins identificado no Passo 1
2. Certifique-se de que a estrutura de pastas está correta:
   ```
   plugins/
   └── landsat8_fusion_plugin/
       ├── __init__.py
       ├── landsat8_fusion.py
       ├── processing_algorithm.py
       ├── processing_provider.py
       ├── metadata.txt
       ├── README.md
       ├── dialogs/
       │   ├── __init__.py
       │   └── main_dialog.py
       └── resources/
           ├── __init__.py
           └── icon.png
   ```

### Passo 3: Ativar o Plugin no QGIS

1. Abra o QGIS (ou reinicie se já estiver aberto)
2. Vá para **Plugins > Gerenciar e Instalar Plugins**
3. Clique na aba **Instalados**
4. Procure por "GeoCAR Vision" na lista
5. Marque a caixa de seleção ao lado do plugin para ativá-lo
6. Clique em **Fechar**

### Passo 4: Verificar a Instalação

Após ativar o plugin, você deverá ver:
- Um novo ícone na barra de ferramentas do QGIS
- Uma nova entrada no menu **Raster > Landsat 8 Fusion**
- O algoritmo disponível na **Caixa de Ferramentas de Processamento** sob **Landsat 8 Fusion**

## Método 2: Instalação via ZIP

### Passo 1: Criar o Arquivo ZIP

1. Comprima a pasta `landsat8_fusion_plugin` em um arquivo ZIP
2. Certifique-se de que a estrutura dentro do ZIP está correta (a pasta raiz deve ser `landsat8_fusion_plugin`)

### Passo 2: Instalar no QGIS

1. Abra o QGIS
2. Vá para **Plugins > Gerenciar e Instalar Plugins**
3. Clique na aba **Instalar do ZIP**
4. Clique em **...** para selecionar o arquivo ZIP
5. Navegue até o arquivo ZIP criado e selecione-o
6. Clique em **Instalar Plugin**
7. Aguarde a mensagem de confirmação

### Passo 3: Ativar o Plugin

1. Após a instalação, vá para a aba **Instalados**
2. Procure por "Landsat 8 Band Fusion"
3. Marque a caixa de seleção para ativar o plugin

## Solução de Problemas

### Plugin não aparece na lista

**Problema**: O plugin GeoCAR Vision não aparece na lista de plugins instalados.

**Solução**:
1. Verifique se a pasta foi copiada para o diretório correto
2. Verifique se o arquivo `metadata.txt` existe e está correto
3. Reinicie o QGIS completamente
4. Verifique os logs do QGIS em **Configurações > Opções > Geral > Arquivos de Log**

### Erro ao ativar o plugin

**Problema**: Erro ao tentar ativar o plugin.

**Solução**:
1. Verifique se você está usando QGIS 3.40 ou superior
2. Verifique os logs de erro do QGIS
3. Certifique-se de que todos os arquivos do plugin estão presentes
4. Verifique se não há erros de sintaxe nos arquivos Python

### Plugin ativado mas não aparece na interface

**Problema**: Plugin está ativado mas o ícone/menu não aparecem.

**Solução**:
1. Reinicie o QGIS
2. Verifique se a barra de ferramentas de plugins está visível
3. Tente acessar via menu **Raster > Landsat 8 Fusion**
4. Verifique a **Caixa de Ferramentas de Processamento**

### Erro durante o processamento

**Problema**: Erro ao executar o fusionamento de bandas.

**Solução**:
1. Verifique se todas as bandas selecionadas são válidas
2. Certifique-se de que as bandas têm a mesma extensão geográfica
3. Verifique se há espaço em disco suficiente
4. Tente usar um caminho de saída mais curto (evite caracteres especiais)

## Desinstalação

Para remover o plugin:

1. No QGIS, vá para **Plugins > Gerenciar e Instalar Plugins**
2. Encontre "GeoCAR Vision" na lista
3. Clique em **Desinstalar Plugin**

Ou manualmente:

1. Feche o QGIS
2. Navegue até o diretório de plugins
3. Delete a pasta `landsat8_fusion_plugin`
4. Reinicie o QGIS

## Suporte

Para problemas ou dúvidas:
- Consulte o arquivo README.md
- Verifique os logs do QGIS
- Reporte issues no repositório do GitHub

## Verificação da Instalação

Após a instalação, você pode verificar se tudo está funcionando:

1. Abra o QGIS
2. Carregue algumas bandas Landsat 8 (B4, B5, B6, B8)
3. Abra o plugin via menu ou ícone
4. Selecione as bandas
5. Execute um teste de processamento

Se o processamento for concluído com sucesso, o plugin está instalado e funcionando corretamente!
