# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GeoCAR
                                 A QGIS plugin
 GeoCAR
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-09-30
        copyright            : (C) 2024 by Prof Cazaroli e Leandro França
        email                : contato@geoone.com.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Prof Cazaroli e Leandro França'
__date__ = '2024-09-30'
__copyright__ = '(C) 2024 by Prof Cazaroli e Leandro França'

from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
import os

from .algorithms.baixarCAR import baixarCAR
from .algorithms.preparaCAR_ZIP import preparaCAR_ZIP
from .algorithms.preparaCAR_SHP import preparaCAR_SHP
from .algorithms.preparaCAR_KML import preparaCAR_KML

class GeoCARProvider(QgsProcessingProvider):
    def __init__(self):
        QgsProcessingProvider.__init__(self)

    def unload(self):
        pass

    def loadAlgorithms(self):
        self.addAlgorithm(baixarCAR())
        self.addAlgorithm(preparaCAR_ZIP())
        self.addAlgorithm(preparaCAR_SHP())
        self.addAlgorithm(preparaCAR_KML())

    def id(self):
        return 'GeoCAR'

    def name(self):
        return self.tr('GeoCAR')

    def icon(self):
        return QIcon(os.path.dirname(__file__) + '/images/geocar.png')

    def longName(self):
        return self.name()
