# -*- coding: utf-8 -*-
"""
/***************************************************************************
 geo_webview
                                 A QGIS plugin
 Navigate QGIS map views through external permalink system
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-10-05
        copyright            : (C) 2025 by yamamoto-ryuzo
        email                : 
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

# Ensure sys.stderr is usable at import time. Some host environments set
# sys.stderr to None which causes third-party modules (e.g. numpy) to fail
# when they attempt to write diagnostic messages during import. Protect
# against that by providing a safe fallback as early as possible.
try:
    import sys, io, os
    if getattr(sys, 'stderr', None) is None:
        if getattr(sys, '__stderr__', None) is not None:
            sys.stderr = sys.__stderr__
        else:
            try:
                sys.stderr = io.TextIOWrapper(open(os.devnull, 'w', encoding='utf-8'))
            except Exception:
                try:
                    sys.stderr = io.StringIO()
                except Exception:
                    # give up silently; later imports may still fail
                    pass
except Exception:
    # Never raise from import-time guard
    pass


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """geo_webviewプラグインのファクトリー関数

    Args:
        iface: QGISのインターフェースオブジェクト (QGIS interface)

    Returns:
        GeoWebViewクラスのインスタンス
    """
    # Ensure sys.stderr is usable: some host environments (embedders
    # or GUI apps) may set sys.stderr to None which causes libraries
    # (e.g. numpy) to fail when they attempt to write error messages.
    try:
        import sys, io, os
        if getattr(sys, 'stderr', None) is None:
            if getattr(sys, '__stderr__', None) is not None:
                sys.stderr = sys.__stderr__
            else:
                # Fallback to a devnull text wrapper so write() exists.
                try:
                    sys.stderr = io.TextIOWrapper(open(os.devnull, 'w', encoding='utf-8'))
                except Exception:
                    # Last-resort: an in-memory stream
                    try:
                        sys.stderr = io.StringIO()
                    except Exception:
                        pass
    except Exception:
        # Don't let secondary errors prevent plugin loading
        pass

    from .plugin import GeoWebView
    return GeoWebView(iface)