# -*- coding: utf-8 -*-
"""
/***************************************************************************
 geo_value_functions
                                 A QGIS plugin
 Allows to apply a function to a raster or vector layer.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-09-07
        git sha              : $Format:%H$
        copyright            : (C) 2020 by LANCIS
        email                : serranoycandela@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, Qt, QVariant
from PyQt5.QtGui import QIcon, QPixmap
from PyQt5.QtWidgets import QAction, QWidget, QMessageBox, QFileDialog
from PyQt5.QtSvg import QSvgWidget
# Initialize Qt resources from file resources.py
from .resources import *
from qgis.core import QgsFieldProxyModel, QgsRasterBandStats, QgsSymbol, QgsRendererRange, QgsGraduatedSymbolRenderer, QgsClassificationCustom, QgsColorRampShader, QgsRasterShader, QgsSingleBandPseudoColorRenderer
from qgis.core import QgsSingleSymbolRenderer, QgsFillSymbol, QgsRenderContext, QgsSymbolLayer, QgsProperty, QgsVectorDataProvider, QgsField
import qgis.utils
from qgis.PyQt import QtGui
# Import the code for the DockWidget
from .geo_value_functions_dockwidget import geo_value_functionsDockWidget
import os.path
import math
import numpy

from matplotlib.backends.qt_compat import QtCore, QtWidgets
from matplotlib.backends.backend_qt5agg import FigureCanvas
from matplotlib.figure import Figure
import matplotlib
import matplotlib.pyplot as plt
from matplotlib import colors

from io import BytesIO
import processing



# matplotlib: force computer modern font set
plt.rc('mathtext', fontset='cm')




class geo_value_functions:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'geo_value_functions_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Geo value functions')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'geo_value_functions')
        self.toolbar.setObjectName(u'geo_value_functions')

        #print "** INITIALIZING geo_value_functions"

        self.pluginIsActive = False
        self.dockwidget = None


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('geo_value_functions', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/geo_value_functions/img/logistic.png'
        self.add_action(
            icon_path,
            text=self.tr(u''),
            callback=self.run,
            parent=self.iface.mainWindow())






    #--------------------------------------------------------------------------
    def normalize_max_min(self, y, maxy, miny):
        return (y - miny)/(maxy - miny)

    def denormalize_max_min(self, y, maxy, miny):
        return (y * (maxy - miny)) + miny

    def normalize01(self, y):
        maxy = max(y)
        miny = min(y)
        y_prima = [self.normalize_max_min(t, maxy, miny) for t in y]
        return y_prima

    def normalize100(self, x, xmax, xmin):
        return (100.0 * ( x - xmin )/( xmax - xmin ) )




    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING geo_value_functions"

        # disconnects
        #self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)
        self.dockwidget = None
        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD geo_value_functions"

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Geo value functions'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #-------------------------------------------------------funciones -----------------------------------------
    def logistic(self, x, inverse=False):
        #\frac{1}{1+e^{-k\cdot  \left(\frac{100\cdot \left(x-xmin\right)}{xmax-xmin}-\frac{100\cdot \left(center-xmin\right)}{xmax-xmin}\right)}}
        if not inverse:
            return 1 / (1.0 + math.exp(-self.p1 * (   (100 * ( x - self.minx )/( self.maxx - self.minx ) )  - ( 100 * ( self.p2 - self.minx )/( self.maxx - self.minx ) ) )) )
        else:
            j = (self.p1*100.0)/(self.maxx - self.minx)
            return [self.p2 + (math.log((1.0/x)-1.0)/(0.0 - j))]

    def logistica_invertida(self, x, inverse=False):
        #1-\frac{1}{1+e^{-k\cdot  \left(\frac{100\cdot \left(x-xmin\right)}{xmax-xmin}-\frac{100\cdot \left(center-xmin\right)}{xmax-xmin}\right)}}
        if not inverse:
            return 1.0 - self.logistic(x)
        else:
            j = (self.p1*100.0)/(self.maxx - self.minx)
            return [self.p2 + (math.log((1.0/(1.0-x))-1.0)/(0.0 - j))]


    def campana(self, x, inverse=False):
        if not inverse:
            return math.exp(0.0 - ((( self.normalize100(x, self.maxx, self.minx) - self.normalize100(self.p2, self.maxx, self.minx)) / (  self.p1  ) )**2))
        else:
            j = (100.0/(self.p1*(self.maxx - self.minx)))**2
            raiz = math.sqrt(math.log(x)/(0.0-j))
            x1 = self.p2 - raiz
            x2 = self.p2 + raiz
            cuts = []
            if x1 > self.minx and x1 < self.maxx:
                cuts.append(x1)
            if x2 > self.minx and x2 < self.maxx:
                cuts.append(x2)

            return cuts



    def campana_invertida(self, x, inverse=False):
        if not inverse:
            return 1.0 - self.campana(x)
        else:
            j = (100.0/(self.p1*(self.maxx - self.minx)))**2
            raiz = math.sqrt(math.log(1.0-x)/(0.0-j))
            x1 = self.p2 - raiz
            x2 = self.p2 + raiz
            cuts = []
            if x1 > self.minx and x1 < self.maxx:
                cuts.append(x1)
            if x2 > self.minx and x2 < self.maxx:
                cuts.append(x2)

            return cuts

    def bojorquezSerrano(self, fp, categories=5, maximum=1.0, minimum=0.0):
        the_sum = 0
        for i in range(categories):
            the_sum += ((fp) ** i)

        bit = (maximum - minimum) / the_sum
        cuts = []
        cuts.append(minimum)
        for i in range(categories):
            prev = cuts[i]
            cut = prev + fp ** i * bit
            cuts.append(cut)

        return cuts


    def concava_decreciente(self, x, inverse=False):
        if not inverse:
            return  ( math.exp(self.p1 * (100.0 -  self.normalize100(x, self.maxx, self.minx) ) ) - 1.0 )  / ( math.exp(self.p1 * 100) - 1.0)
        else:
            j = self.p1*100.0
            return [self.minx + ((1.0 - (math.log((x * (math.exp(j)-1.0)) + 1.0)/j))*(self.maxx - self.minx))]


    def concava_creciente(self, x, inverse=False):
        if not inverse:
    #\frac{e^{\left( \gamma \cdot \frac{100\cdot \left(x-xmin\right)}{xmax-xmin}\right )}-1}{e^{ \left (\gamma\cdot100  \right )}-1}
            return ((math.exp(self.p1 * self.normalize100(x, self.maxx, self.minx) ) ) - 1) / ( math.exp(self.p1 * 100) -1 )
        else:
            j = self.p1*100.0
            return [self.minx + (((math.log((x * (math.exp(j)-1.0)) + 1.0)/j))*(self.maxx - self.minx))]

    def convexa_decreciente(self, x, inverse=False):
        if not inverse:
    #1-\frac{e^{\left( \gamma \cdot \frac{100\cdot \left(x-xmin\right)}{xmax-xmin}\right )}-1}{e^{ \left (\gamma\cdot100  \right )}-1}
            return 1.0 - self.concava_creciente (x)
        else:
            j = self.p1*100.0
            return [self.minx + (((math.log(((1.0 - x) * (math.exp(j)-1.0)) + 1.0)/j))*(self.maxx - self.minx))]

    def convexa_creciente(self, x, inverse=False):
        if not inverse:
    #1-\frac{e^{\left(\gamma \cdot \left(100-\frac{100\cdot \left(x-xmin\right)}{xmax-xmin}\right)\right)}-1}{e^{\left(\gamma\cdot100 \right)}-1}
            return 1.0 - self.concava_decreciente (x)
        else:
            j = self.p1*100.0
            return [self.minx + ((1.0 - (math.log(((1.0 - x) * (math.exp(j)-1.0)) + 1.0)/j))*(self.maxx - self.minx))]

    def wf(self, t, fp, min_v, max_v):
        x_cuts = self.bojorquezSerrano(fp, minimum=min_v, maximum=max_v)
        if t < x_cuts[1]:
            return 0.2
        elif t >= x_cuts[1] and t < x_cuts[2]:
            return 0.4
        elif t >= x_cuts[2] and t < x_cuts[3]:
            return 0.6
        elif t >= x_cuts[3] and t < x_cuts[4]:
            return 0.8
        elif t >= x_cuts[4]:
            return 1.0


    def wf2(self, t, fp, min_v, max_v):
        x_cuts = self.bojorquezSerrano(fp, minimum=min_v, maximum=max_v)
        y_cuts = self.bojorquezSerrano(fp, minimum=0, maximum=1)
        if t < x_cuts[1]:
            return y_cuts[1]
        elif t >= x_cuts[1] and t < x_cuts[2]:
            return y_cuts[2]
        elif t >= x_cuts[2] and t < x_cuts[3]:
            return y_cuts[3]
        elif t >= x_cuts[3] and t < x_cuts[4]:
            return y_cuts[4]
        elif t >= x_cuts[4]:
            return 1.0


    def lineal_creciente(self, x, inverse=False):
        if not inverse:
            return (self.p1 * x) + self.p2
        else:
            return [(x - self.p2) / self.p1]


    def lineal_decreciente(self, x, inverse=False):
        if not inverse:
            return (self.p1 * x) + self.p2
        else:
            return [(x - self.p2) / self.p1]


    def normalize_max_min(self, y, maxy, miny):
        return (y - miny)/(maxy - miny)

    def raster_min_max(self):
        '''
        Esta funcion regresa los valores maximos y minimos de una capa raster

        :param path_raster: ruta de la capa raster
        :type path_raster: str
        '''

        extent = self.layer.extent()
        provider = self.layer.dataProvider()
        stats = provider.bandStatistics(1,
                                        QgsRasterBandStats.All,
                                        extent,
                                        0)

        v_min = stats.minimumValue
        v_max = stats.maximumValue
        return v_min, v_max

    def todos_grises(self):
        self.dockwidget.lineal_creciente.setStyleSheet("background-color : lightgray;")
        self.dockwidget.logistica.setStyleSheet("background-color : lightgray;")
        self.dockwidget.convexa_creciente.setStyleSheet("background-color : lightgray;")
        self.dockwidget.concava_creciente.setStyleSheet("background-color : lightgray;")

        self.dockwidget.lineal_decreciente.setStyleSheet("background-color : lightgray;")
        self.dockwidget.logistica_invertida.setStyleSheet("background-color : lightgray;")
        self.dockwidget.convexa_decreciente.setStyleSheet("background-color : lightgray;")
        self.dockwidget.concava_decreciente.setStyleSheet("background-color : lightgray;")

        self.dockwidget.campana.setStyleSheet("background-color : lightgray;")
        self.dockwidget.campana_invertida.setStyleSheet("background-color : lightgray;")

    def select_graph(self):

        self.todos_grises()
        try:
            self.minx = float(self.dockwidget.minx.text())
            self.maxx = float(self.dockwidget.maxx.text())

            sender = self.dockwidget.sender()
            self.selected_function_str = sender.objectName()
            sender.setStyleSheet("background-color : black;")
            self.apply_function_first_time()
            #self.logistic_plot()
        except:
            QMessageBox.information(self.dockwidget, "Information select grph", "Error, no field selected" )

    def handleReturnPressed1(self):
        self.dockwidget.slider1.setValue(round(float(self.dockwidget.p1.text())*2.0))
        self.apply_function()

    def handleReturnPressed2(self):
        self.dockwidget.slider2.setValue(round( 1000.0*((float(self.dockwidget.p2.text()) - self.minx)/(self.maxx - self.minx))))
        self.apply_function()

    def handleSlider1Released(self):
        self.p1dragging = False
        self.dockwidget.p1.setText(self.formatNumber1(self.dockwidget.sender().value()/2.0))
        self.apply_function()

    def handleSlider2Released(self):
        self.p2dragging = False
        self.dockwidget.p2.setText(self.formatNumber2(self.minx+((self.maxx - self.minx)*(self.dockwidget.sender().value()/1000.0))))
        self.apply_function()

    def handleSlider1ValueChange(self):
        self.dockwidget.p1.setText(self.formatNumber1(self.dockwidget.sender().value()/2.0))
        #if not self.p1dragging:
        self.apply_function()

    def handleSlider2ValueChange(self):
        self.dockwidget.p2.setText(self.formatNumber2(self.minx+((self.maxx - self.minx)*(self.dockwidget.sender().value()/1000.0))))
        #if not self.p2dragging:
        self.apply_function()

    def formatNumber1(self, num):
        num = round(num,1)
        if num % 1 == 0:
            return str(int(num))
        else:
            return str(num)

    def formatNumber2(self, num):

        logmax = math.log10(self.maxx)
        n = 1
        if logmax > 2.0:
            n = 0
        elif logmax <= 0:
            n = round(0.0 - (logmax - 2.0))
        num = round(num,n)
        if num % 1 == 0:
            return str(int(num))
        else:
            return str(num)

    def formatNumber(self, j):
        print(str(j))
        if abs(j) < 0.00001:
            return "0"
        elif j < 0:
            return str(j)
        else:
            logj = math.log10(j)
            n = 2
            if logj > 2.0:
                n = 0
            elif logj < 0:
                n = round(0.0 - (logj - 3.0))
            j = round(j,n)
            if j % 1 == 0:
                return str(int(j))
            else:
                return str(j)

    def tex2svg(self, formula, fontsize=25, dpi=300):
        """Render TeX formula to SVG.
        Args:
            formula (str): TeX formula.
            fontsize (int, optional): Font size.
            dpi (int, optional): DPI.
        Returns:
            str: SVG render.
        """

        fig = plt.figure(figsize=(6, 1.4))
        fig.text(10, 10, r'${}$'.format(formula), fontsize=fontsize)

        output = BytesIO()
        fig.savefig(output, dpi=dpi, transparent=True, format='svg',
                    bbox_inches='tight', pad_inches=0.3)
        plt.close(fig)

        output.seek(0)
        return output.read()

    def get_GDAL_formula(self):
        if self.selected_function_str == "logistica":
            j = (self.p1*100.0)/(self.maxx - self.minx)
            j_str = str(j)
            resta_str = str(self.maxy - self.miny)
            formula = '(((1)/(1+exp((0.0 -'+j_str+') * (A -'+self.dockwidget.p2.text()+')))) - '+str(self.miny)+')/('+resta_str+')'
            formula = formula.replace("--","+")

        if self.selected_function_str == "convexa_creciente":
            j = self.p1*100.0
            j_str = str(j)
            resta_str = str(self.maxx - self.minx)
            denominador = str(math.exp(j) - 1.0)
            # formula =  r'1-\frac{e^{\left('+j_str+r' \cdot \left(1-\frac{\left(x-'+self.formatNumber(self.minx)+r'\right)}{'+self.formatNumber(self.maxx - self.minx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'
            formula = '1.0 - ((exp('+j_str+' * (1.0 - ((A-'+str(self.minx)+')/('+resta_str+'))) ) - 1.0)/('+denominador+'))'
            formula = formula.replace("--","+")
        if self.selected_function_str == "concava_creciente":
            j = self.p1*100.0
            j_str = str(j)
            resta_str = str(self.maxx - self.minx)
            denominador = str(math.exp(j) - 1.0)
            formula = '(exp('+j_str+' * (((A-'+str(self.minx)+')/('+resta_str+'))) ) - 1.0)/('+denominador+')'
            formula = formula.replace("--","+")

        if self.selected_function_str == "logistica_invertida":
            j = (self.p1*100.0)/(self.maxx - self.minx)
            j_str = str(j)
            resta_str = str(self.maxy - self.miny)
            formula = '((1.0 - ((1.0)/(1.0 + exp((0.0 -'+j_str+') * (A -'+self.dockwidget.p2.text()+'))))) - '+str(self.miny)+')/('+resta_str+')'
            formula = formula.replace("--","+")

        if self.selected_function_str == "convexa_decreciente":
            j = self.p1*100.0
            j_str = str(j)
            resta_str = str(self.maxx - self.minx)
            denominador = str(math.exp(j) - 1.0)
            formula = '1.0 - ((exp('+j_str+' * (((A-'+str(self.minx)+')/('+resta_str+'))) ) - 1.0)/('+denominador+'))'
            formula = formula.replace("--","+")

        if self.selected_function_str == "concava_decreciente":
            j = self.p1*100.0
            j_str = str(j)
            resta_str = str(self.maxx - self.minx)
            denominador = str(math.exp(j) - 1.0)
            formula = '(exp('+j_str+' * (1.0 - ((A-'+str(self.minx)+')/('+resta_str+'))) ) - 1.0)/('+denominador+')'
            formula = formula.replace("--","+")

        if self.selected_function_str == "campana":
            j = (100.0/(self.p1*(self.maxx - self.minx)))**2
            j_str = str(j)
            resta_str = str(self.maxy - self.miny)
            formula = '((exp((0.0-'+j_str+')*power(A-'+str(self.p2)+',2)))-'+str(self.miny)+')/'+resta_str
            formula = formula.replace("--","+")

        if self.selected_function_str == "campana_invertida":
            j = (100.0/(self.p1*(self.maxx - self.minx)))**2
            j_str = str(j)
            resta_str = str(self.maxy - self.miny)
            formula = '(1.0-(exp((0.0-'+j_str+')*power(A-'+str(self.p2)+',2))))/'+resta_str
            formula = formula.replace("--","+")

        if self.selected_function_str == "lineal_creciente":
            formula = '('+str(self.p1)+'*A)+'+str(self.p2)
            formula = formula.replace("+-","-")
        if self.selected_function_str == "lineal_decreciente":
            formula = '('+str(self.p1)+'*A)+'+str(self.p2)
            formula = formula.replace("+-","-")


        return formula


    def getFormula(self):
        if self.selected_function_str == "logistica":
            j = (self.p1*100.0)/(self.maxx - self.minx)
            j_str = self.formatNumber(j)
            f_base = r'\frac{1}{1+e^{-'+j_str+r'\cdot  \left(x-'+self.dockwidget.p2.text()+r'\right)}}'
            if abs((self.maxy - self.miny) - 1.0) > 0.00001 and abs(self.miny) > 0.00001:
                formula =  r'\frac{\left('+f_base+r'\right)-'+self.formatNumber(self.miny)+r'}{'+self.formatNumber(self.maxy - self.miny)+r'}'
            elif abs((self.maxy - self.miny) - 1.0) > 0.00001 and abs(self.miny) < 0.00001:
                a = 1.0/(self.maxy - self.miny)
                formula = r'\frac{'+self.formatNumber(a)+r'}{1+e^{-'+j_str+r'\cdot  \left(x-'+self.dockwidget.p2.text()+r'\right)}}'
                #formula =  r'\frac{\left('+f_base+r'\right)}{'+str(round(self.maxy - self.miny,3))+r'}'
            elif abs((self.maxy - self.miny) - 1.0) < 0.00001 and abs(self.miny) < 0.00001:
                formula = f_base
            elif abs((self.maxy - self.miny) - 1.0) < 0.00001 and abs(self.miny) > 0.00001:
                formula =  r'\left('+f_base+r'\right)-'+self.formatNumber(self.miny)
            formula = formula.replace("--","+")

        if self.selected_function_str == "convexa_creciente":
            j = self.p1*100.0
            j_str = self.formatNumber(j)
            if self.minx == 0:
                formula =  r'1-\frac{e^{\left('+j_str+r' \cdot \left(1-\frac{x}{'+self.formatNumber(self.maxx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'
            elif self.minx > 0:
                formula =  r'1-\frac{e^{\left('+j_str+r' \cdot \left(1-\frac{\left(x-'+self.formatNumber(self.minx)+r'\right)}{'+self.formatNumber(self.maxx - self.minx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'
            else:
                formula =  r'1-\frac{e^{\left('+j_str+r' \cdot \left(1-\frac{\left(x+'+self.formatNumber(abs(self.minx))+r'\right)}{'+self.formatNumber(self.maxx - self.minx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'


        if self.selected_function_str == "concava_creciente":
            j = self.p1*100.0
            j_str = self.formatNumber(j)
            if self.minx == 0:
                formula =  r'\frac{e^{\left('+j_str+r' \cdot \left(\frac{x}{'+self.formatNumber(self.maxx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'
            elif self.minx > 0:
                formula =  r'\frac{e^{\left('+j_str+r' \cdot \left(\frac{\left(x-'+self.formatNumber(self.minx)+r'\right)}{'+self.formatNumber(self.maxx - self.minx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'
            else:
                formula =  r'\frac{e^{\left('+j_str+r' \cdot \left(\frac{\left(x+'+self.formatNumber(abs(self.minx))+r'\right)}{'+self.formatNumber(self.maxx - self.minx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'


        if self.selected_function_str == "logistica_invertida":
            j = (self.p1*100.0)/(self.maxx - self.minx)
            j_str = self.formatNumber(j)
            f_base = r'1-\frac{1}{1+e^{-'+j_str+r'\cdot  \left(x-'+self.dockwidget.p2.text()+r'\right)}}'
            if abs((self.maxy - self.miny) - 1.0) > 0.00001 and abs(self.miny) > 0.00001:
                formula =  r'\frac{\left('+f_base+r'\right)-'+self.formatNumber(self.miny)+r'}{'+self.formatNumber(self.maxy - self.miny)+r'}'
            elif abs((self.maxy - self.miny) - 1.0) > 0.00001 and abs(self.miny) < 0.00001:
                formula =  r'\frac{\left('+f_base+r'\right)}{'+self.formatNumber(self.maxy - self.miny)+r'}'
            elif abs((self.maxy - self.miny) - 1.0) < 0.00001 and abs(self.miny) < 0.00001:
                formula = f_base
            elif abs((self.maxy - self.miny) - 1.0) < 0.00001 and abs(self.miny) > 0.00001:
                formula =  r'\left('+f_base+r'\right)-'+self.formatNumber(self.miny)
            formula = formula.replace("--","+")

        if self.selected_function_str == "convexa_decreciente":
            j = self.p1*100.0
            j_str = self.formatNumber(j)
            if self.minx == 0:
                formula =  r'1-\frac{e^{\left('+j_str+r' \cdot \left(\frac{x}{'+self.formatNumber(self.maxx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'
            elif self.minx > 0:
                formula =  r'1-\frac{e^{\left('+j_str+r' \cdot \left(\frac{\left(x-'+self.formatNumber(self.minx)+r'\right)}{'+self.formatNumber(self.maxx - self.minx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'
            else:
                formula =  r'1-\frac{e^{\left('+j_str+r' \cdot \left(\frac{\left(x+'+self.formatNumber(abs(self.minx))+r'\right)}{'+self.formatNumber(self.maxx - self.minx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'

        if self.selected_function_str == "concava_decreciente":
            j = self.p1*100.0
            j_str = self.formatNumber(j)
            if self.minx == 0:
                formula =  r'\frac{e^{\left('+j_str+r' \cdot \left(1-\frac{x}{'+self.formatNumber(self.maxx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'
            elif self.minx > 0:
                formula =  r'\frac{e^{\left('+j_str+r' \cdot \left(1-\frac{\left(x-'+self.formatNumber(self.minx)+r'\right)}{'+self.formatNumber(self.maxx - self.minx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'
            else:
                formula =  r'\frac{e^{\left('+j_str+r' \cdot \left(1-\frac{\left(x+'+self.formatNumber(abs(self.minx))+r'\right)}{'+self.formatNumber(self.maxx - self.minx)+r'}\right)\right)}-1}{e^{\left('+j_str+r'\right)}-1}'


        if self.selected_function_str == "campana":
            j = (100.0/(self.p1*(self.maxx - self.minx)))**2
            j_str = self.formatNumber(j)
            if self.p2 == 0:
                f_base = r'e^{-'+j_str+r'x^{2}}'
            elif self.p2 > 0:
                f_base = r'e^{-'+j_str+r'\left(x-'+self.formatNumber(self.p2)+r'\right)^{2}}'
            else:
                f_base = r'e^{-'+j_str+r'\left(x+'+self.formatNumber(abs(self.p2))+r'\right)^{2}}'
            if abs((self.maxy - self.miny) - 1.0) > 0.00001 and abs(self.miny) > 0.00001:
                formula =  r'\frac{\left('+f_base+r'\right)-'+self.formatNumber(self.miny)+r'}{'+self.formatNumber(self.maxy - self.miny)+r'}'
            elif abs((self.maxy - self.miny) - 1.0) > 0.00001 and abs(self.miny) < 0.00001:
                formula =  r'\frac{\left('+f_base+r'\right)}{'+self.formatNumber(self.maxy - self.miny)+r'}'
            elif abs((self.maxy - self.miny) - 1.0) < 0.00001 and abs(self.miny) < 0.00001:
                formula = f_base
            elif abs((self.maxy - self.miny) - 1.0) < 0.00001 and abs(self.miny) > 0.00001:
                formula =  r'\left('+f_base+r'\right)-'+self.formatNumber(self.miny)
            #return math.exp(0.0 - ((( self.normalize100(x, self.maxx, self.minx) - self.normalize100(self.p2, self.maxx, self.minx)) / (  self.p1  ) )**2))
        if self.selected_function_str == "campana_invertida":
            j = (100.0/(self.p1*(self.maxx - self.minx)))**2
            j_str = self.formatNumber(j)
            f_base = r'1-e^{-'+j_str+r'\left(x-'+self.formatNumber(self.p2)+r'\right)^{2}}'
            if abs((self.maxy - self.miny) - 1.0) > 0.00001 and abs(self.miny) > 0.00001:
                formula =  r'\frac{\left('+f_base+r'\right)-'+self.formatNumber(self.miny)+r'}{'+self.formatNumber(self.maxy - self.miny)+r'}'
            elif abs((self.maxy - self.miny) - 1.0) > 0.00001 and abs(self.miny) < 0.00001:
                formula =  r'\frac{\left('+f_base+r'\right)}{'+self.formatNumber(self.maxy - self.miny)+r'}'
            elif abs((self.maxy - self.miny) - 1.0) < 0.00001 and abs(self.miny) < 0.00001:
                formula = f_base
            elif abs((self.maxy - self.miny) - 1.0) < 0.00001 and abs(self.miny) > 0.00001:
                formula =  r'\left('+f_base+r'\right)-'+self.formatNumber(self.miny)

        if self.selected_function_str == "lineal_creciente":
            if self.p2 > 0:
                formula = 'y = '+self.formatNumber(self.p1)+'x + '+self.formatNumber(self.p2)
            if self.p2 == 0:
                formula = 'y = '+self.formatNumber(self.p1)+'x'
            if self.p2 < 0:
                formula = 'y = '+self.formatNumber(self.p1)+'x - '+self.formatNumber(abs(self.p2))
        if self.selected_function_str == "lineal_decreciente":

            if self.p2 > 0:
                formula = 'y = -'+self.formatNumber(abs(self.p1))+'x + '+self.formatNumber(self.p2)
            if self.p2 == 0:
                formula = 'y = -'+self.formatNumber(abs(self.p1))+'x'
            if self.p2 < 0:
                formula = 'y = -'+self.formatNumber(abs(self.p1))+'x - '+self.formatNumber(abs(self.p2))
        return formula

    def apply_function_first_time(self):
        print(self.selected_function_str, self.dockwidget.minx.text(),self.dockwidget.maxx.text())


        self.center = self.minx + ((self.maxx - self.minx)/2.0)
        self.p1_name = "m"
        self.p2_name = "b"
        base_path = os.path.join(self.layer_dir,self.dockwidget.prefix.text()+self.layer_name.split(".")[0])


        if self.isVector(self.layer):
            self.dockwidget.saveResult.setText("Result Field")
            self.layer_path = os.path.join(self.layer_dir,self.layer_name.split("|")[0])
            field = str(self.dockwidget.mFieldComboBox.currentField())
            self.tex_path = os.path.join(self.layer_dir,self.dockwidget.prefix.text()+field+"_"+self.layer_name.split(".")[0]+".tex")
            self.json_path = os.path.join(self.layer_dir,self.dockwidget.prefix.text()+field+"_"+self.layer_name.split(".")[0]+".json")
        else:
            self.dockwidget.saveResult.setText("Result Layer")
            self.layer_path = base_path + ".tif"
            self.tex_path = base_path + ".tex"
            self.json_path = base_path + ".json"
        #self.dockwidget.latex_path.setText("..."+self.tex_path[-40:])
        self.dockwidget.layer_path.setText("..."+self.layer_path[-40:])
        #self.dockwidget.json_path.setText("..."+self.json_path[-40:])
        #self.dockwidget.latex_path.setToolTip(self.tex_path)
        self.dockwidget.layer_path.setToolTip(self.layer_path)
        #self.dockwidget.json_path.setToolTip(self.json_path)
        if self.selected_function_str == "logistica":
            self.p1_name = "Saturation"
            self.p2_name = "Center"
            self.dockwidget.p1.setText("2")
            self.dockwidget.p2.setText(self.formatNumber2(self.center))
            self.selected_function = self.logistic
            self.dockwidget.slider1.setMaximum(40)
            self.dockwidget.slider1.setMinimum(0)
            self.dockwidget.slider2.setMaximum(1000)
            self.dockwidget.slider2.setMinimum(0)
            self.dockwidget.slider1.setValue(4)
            self.dockwidget.slider2.setValue(500)
            self.dockwidget.p1_frame.show()
            self.dockwidget.p2_frame.show()
        if self.selected_function_str == "convexa_creciente":
            self.p1_name = "Saturation"
            self.p2_name = ""
            self.dockwidget.p1.setText("5")
            self.selected_function = self.convexa_creciente
            self.dockwidget.slider1.setMaximum(40)
            self.dockwidget.slider1.setMinimum(0)
            self.dockwidget.slider1.setValue(10)
            self.dockwidget.p1_frame.show()
            self.dockwidget.p2_frame.hide()
        if self.selected_function_str == "concava_creciente":
            self.p1_name = "Saturation"
            self.p2_name = ""
            self.dockwidget.p1.setText("5")
            self.selected_function = self.concava_creciente
            self.dockwidget.slider1.setMaximum(40)
            self.dockwidget.slider1.setMinimum(0)
            self.dockwidget.slider1.setValue(10)
            self.dockwidget.p1_frame.show()
            self.dockwidget.p2_frame.hide()
        if self.selected_function_str == "logistica_invertida":
            self.p1_name = "Saturation"
            self.p2_name = "Center"
            self.dockwidget.p1.setText("2")
            self.dockwidget.p2.setText(self.formatNumber2(self.center))
            self.selected_function = self.logistica_invertida
            self.dockwidget.slider1.setMaximum(40)
            self.dockwidget.slider1.setMinimum(0)
            self.dockwidget.slider2.setMaximum(1000)
            self.dockwidget.slider2.setMinimum(0)
            self.dockwidget.slider1.setValue(4)
            self.dockwidget.slider2.setValue(500)
            self.dockwidget.p1_frame.show()
            self.dockwidget.p2_frame.show()
        if self.selected_function_str == "convexa_decreciente":
            self.p1_name = "Saturation"
            self.p2_name = ""
            self.dockwidget.p1.setText("5")
            self.selected_function = self.convexa_decreciente
            self.dockwidget.slider1.setMaximum(40)
            self.dockwidget.slider1.setMinimum(0)
            self.dockwidget.slider1.setValue(10)
            self.dockwidget.p1_frame.show()
            self.dockwidget.p2_frame.hide()
        if self.selected_function_str == "concava_decreciente":
            self.p1_name = "Saturation"
            self.p2_name = ""
            self.dockwidget.p1.setText("5")
            self.selected_function = self.concava_decreciente
            self.dockwidget.slider1.setMaximum(40)
            self.dockwidget.slider1.setMinimum(0)
            self.dockwidget.slider1.setValue(10)
            self.dockwidget.p1_frame.show()
            self.dockwidget.p2_frame.hide()
        if self.selected_function_str == "campana":
            self.p1_name = "Amplitude"
            self.p2_name = "Center"
            self.dockwidget.p1.setText("2")
            self.dockwidget.p2.setText(self.formatNumber2(self.center))
            self.selected_function = self.campana
            self.dockwidget.slider1.setMaximum(40)
            self.dockwidget.slider1.setMinimum(1)
            self.dockwidget.slider2.setMaximum(1000)
            self.dockwidget.slider2.setMinimum(0)
            self.dockwidget.slider1.setValue(4)
            self.dockwidget.slider2.setValue(500)
            self.dockwidget.p1_frame.show()
            self.dockwidget.p2_frame.show()
        if self.selected_function_str == "campana_invertida":
            self.p1_name = "Amplitude"
            self.p2_name = "Center"
            self.dockwidget.p1.setText("2")
            self.dockwidget.p2.setText(self.formatNumber2(self.center))
            self.selected_function = self.campana_invertida
            self.dockwidget.slider1.setMaximum(40)
            self.dockwidget.slider1.setMinimum(1)
            self.dockwidget.slider2.setMaximum(1000)
            self.dockwidget.slider2.setMinimum(0)
            self.dockwidget.slider1.setValue(4)
            self.dockwidget.slider2.setValue(500)
            self.dockwidget.p1_frame.show()
            self.dockwidget.p2_frame.show()
        if self.selected_function_str == "lineal_creciente":
            self.p1_name = "m"
            self.p2_name = "b"
            self.selected_function = self.lineal_creciente
            self.dockwidget.p1_frame.hide()
            self.dockwidget.p2_frame.hide()
        if self.selected_function_str == "lineal_decreciente":
            self.p1_name = "m"
            self.p2_name = "b"
            self.selected_function = self.lineal_decreciente
            self.dockwidget.p1_frame.hide()
            self.dockwidget.p2_frame.hide()

        self.dockwidget.tabWidget.setCurrentWidget(self.dockwidget.tabWidget.findChild(QWidget, "tab_2"))
        # self.p1 = float(self.dockwidget.p1.text())
        # self.p2 = float(self.dockwidget.p2.text())
        self.dockwidget.label1.setText(self.p1_name)
        self.dockwidget.label2.setText(self.p2_name)
        self.apply_function()


    def apply_function(self):



        if self.selected_function_str == "logistica":
            self.p1 = 0.01 + (float(self.dockwidget.p1.text()) * (0.5 - 0.01) / 20.0 )
            self.p2 = float(self.dockwidget.p2.text())
        if self.selected_function_str == "convexa_creciente":
            self.p1 = 0.0005 + (pow(float(self.dockwidget.p1.text())/20.0,2) * (0.3 - 0.0005))
        if self.selected_function_str == "concava_creciente":
            self.p1 = 0.0005 + (pow(float(self.dockwidget.p1.text())/20.0,2) * (0.3 - 0.0005))
        if self.selected_function_str == "logistica_invertida":
            self.p1 = 0.01 + (float(self.dockwidget.p1.text()) * (0.5 - 0.01) / 20.0 )
            self.p2 = float(self.dockwidget.p2.text())
        if self.selected_function_str == "convexa_decreciente":
            self.p1 = 0.0005 + (pow(float(self.dockwidget.p1.text())/20.0,2) * (0.3 - 0.0005))
        if self.selected_function_str == "concava_decreciente":
            self.p1 = 0.0005 + (pow(float(self.dockwidget.p1.text())/20.0,2) * (0.3 - 0.0005))
        if self.selected_function_str == "campana":
            self.p1 = 0 + (float(self.dockwidget.p1.text()) * (100 - 5) / 19.0 )
            self.p2 = float(self.dockwidget.p2.text())
        if self.selected_function_str == "campana_invertida":
            self.p1 = 0 + (float(self.dockwidget.p1.text()) * (100 - 5) / 19.0 )
            self.p2 = float(self.dockwidget.p2.text())
        if self.selected_function_str == "lineal_creciente":
            self.p1 = (1.0)/(self.maxx - self.minx)
            self.p2 = 0.0 - (self.p1 * self.minx)
        if self.selected_function_str == "lineal_decreciente":
            self.p1 = 0.0 - ((1.0)/(self.maxx - self.minx))
            self.p2 = 1.0 - (self.p1 * self.minx)




        # value = float(request.args.get('value', -1))
        # value_index = int(99 * ((value - min_v)/(max_v - min_v)))

        x = numpy.linspace(self.minx, self.maxx, 1000)  # 100 linearly spaced numbers
        yraw = [self.selected_function(t) for t in x]
        self.maxy = max(yraw)
        self.miny = min(yraw)
        y = [self.normalize_max_min(t, self.maxy, self.miny) for t in yraw]

        fig = Figure(figsize=(7, 7))
        grid = plt.GridSpec(10, 1, hspace=0)

        #grid.tight_layout(fig, rect=[0.5, 0.5, 1, 1], h_pad=0.9)
        ax = fig.add_subplot(grid[0:7, 0])
        ax.margins(x=0, y=0.01)
        markers_on = []
        # if value > -1:
        #     markers_on.append(value_index)

        ax.plot(x, y, '-bD', markevery=markers_on, linewidth=2)

        #var paleta = ['rgba(74,190,181,0.8)', 'rgba(24,138,156,0.8)', 'rgba(0,69,132,0.8)', 'rgba(0,30,123,0.8)', 'rgba(16,0,90,0.8)'];
        ax = fig.add_subplot(grid[9:, 0])
        #cmap = colors.LinearSegmentedColormap.from_list("", ["#4ABEB5","#10005A"], N=n)

        cuts = []

        primerpunto = 1.0/self.n

        ys = numpy.linspace(primerpunto, 1.0-primerpunto, self.n - 1)

        for this_y in ys:
            cuts += self.selected_function(self.denormalize_max_min(this_y, self.maxy, self.miny), inverse=True)

        cuts.sort()
        cuts1 = cuts.copy()
        cuts2 = cuts.copy()
        cuts1.insert(0,self.minx)
        cuts2.append(self.maxx)
        myRangeList = []
        myOpacity = 1
        contador = 0
        if self.isVector(self.layer):
            for tuple in zip(cuts1,cuts2):
                contador += 1
                myMin = tuple[0]
                myMax = tuple[1]
                myLabel = myLabel = str(myMin) + " - " + str(myMax)
                insideInterval = myMin + ((myMax - myMin)/2.0)
                colorIndex = self.normalize_max_min(self.selected_function(insideInterval), self.maxy, self.miny)
                rgba = [int(round(255*v, 0)) for v in self.cmap(colorIndex)]

                myColour = QtGui.QColor.fromRgb(rgba[0],rgba[1],rgba[2],rgba[3])
                mySymbol1 = QgsSymbol.defaultSymbol(self.layer.geometryType())
                mySymbol1.setColor(myColour)
                mySymbol1.setOpacity(myOpacity)
                myRange1 = QgsRendererRange(myMin, myMax, mySymbol1, myLabel)
                myRangeList.append(myRange1)


            myRenderer = QgsGraduatedSymbolRenderer('', myRangeList)
            myRenderer.setClassAttribute(self.field)

            self.layer.setRenderer(myRenderer)
            self.layer.triggerRepaint()
        else:

            fcn = QgsColorRampShader()

            fcn.setColorRampType(QgsColorRampShader.Discrete)
            #fcn.setColorRampType(QgsColorRampShader.Interpolated)
            lst = []

            for tuple in zip(cuts1,cuts2):
                contador += 1
                myMin = tuple[0]
                myMax = tuple[1]
                myLabel = str(myMin) + " - " + str(myMax)
                insideInterval = myMin + ((myMax - myMin)/2.0)

                colorIndex = self.normalize_max_min(self.selected_function(insideInterval), self.maxy, self.miny)
                rgba = [int(round(255*v, 0)) for v in self.cmap(colorIndex)]

                myColour = QtGui.QColor.fromRgb(rgba[0],rgba[1],rgba[2],rgba[3])
                lst.append(QgsColorRampShader.ColorRampItem(myMax, myColour,myLabel))
                #lst.append(QgsColorRampShader.ColorRampItem(insideInterval, myColour,myLabel))

            fcn.setColorRampItemList(lst)
            shader = QgsRasterShader()
            shader.setRasterShaderFunction(fcn)
            renderer = QgsSingleBandPseudoColorRenderer(self.layer.dataProvider(), 1, shader)
            self.layer.setRenderer(renderer)
            self.layer.triggerRepaint()
        #QgsApplication.classificationMethodRegistry().methodNames()
        #myRenderer.setClassificationMethod(QgsApplication.classificationMethodRegistry().method("Custom"))


        ax.imshow([y, y], cmap=self.cmap, extent=[0, 100, 0, 8])
        ax.get_xaxis().set_visible(False)
        ax.get_yaxis().set_visible(False)
        plt.tight_layout()
        self.canvas = FigureCanvas(fig)
        if self.dockwidget.verticalLayout_2.count()>0:

            layout_item = self.dockwidget.verticalLayout_2.itemAt(0)

            self.dockwidget.verticalLayout_2.removeItem(layout_item)

        self.dockwidget.verticalLayout_2.addWidget(self.canvas)


        # FORMULA = r'\int_{-\infty}^\infty e^{-x^2}\,dx = \sqrt{\pi}'
        #
        # FORMULA = r'1-\frac{e^{\left(\gamma \cdot \left(100-\frac{100\cdot \left(x-xmin\right)}{xmax-xmin}\right)\right)}-1}{e^{\left(\gamma\cdot100 \right)}-1}'
        # FORMULA = r'\frac{1}{1+e^{-k\cdot  \left(\frac{100\cdot \left(x-xmin\right)}{xmax-xmin}-\frac{100\cdot \left(center-xmin\right)}{xmax-xmin}\right)}}'
        # #0.02418032786885245901639344262295
        # FORMULA = r'\frac{1}{1+e^{-0.024\cdot  \left(x-123\right)}}'
        self.latexFormula = self.getFormula()
        self.dockwidget.svg.load(self.tex2svg(self.latexFormula))
        self.dockwidget.svg.show()

        # miny, maxy = getmaxminy()
        # for each feature or pixel:
        #     function(feature or pixel,p1,p2,)
        #     normalize(miny, maxy)


    def isVector(self, layer):
      if layer.type() != layer.VectorLayer:
        return False
      if layer.providerType() != 'ogr':
        return False
      return True

    def clearRange(self):
        self.dockwidget.minx.setText("")
        self.dockwidget.maxx.setText("")

    def getLayerRange(self):
        self.layer = self.dockwidget.mMapLayerComboBox.currentLayer()
        if self.isVector(self.layer):
            self.field = self.dockwidget.mFieldComboBox.currentField()
            idx = self.layer.fields().indexFromName(self.field)
            self.minx = self.layer.minimumValue(idx)
            self.maxx = self.layer.maximumValue(idx)
        else:
            # stats = self.layer.dataProvider().bandStatistics(1, QgsRasterBandStats.All)
            # self.minx = stats.minimumValue
            # self.maxx = stats.maximumValue
            self.minx, self.maxx = self.raster_min_max()

        self.dockwidget.maxx.setText(str(self.maxx))
        self.dockwidget.minx.setText(str(self.minx))
        self.dockwidget.lineal_creciente.click()
        self.dockwidget.tabWidget.setCurrentWidget(self.dockwidget.tabWidget.findChild(QWidget, "tab"))



    def handleLayerChanged(self):
        self.layer = self.dockwidget.mMapLayerComboBox.currentLayer()
        l_path = self.layer.dataProvider().dataSourceUri()
        (self.layer_dir,self.layer_name) = os.path.split(l_path)
        self.dockwidget.mFieldComboBox.setLayer(self.layer)
        self.clearRange()
        qgis.utils.iface.setActiveLayer(self.layer)
        qgis.utils.iface.zoomToActiveLayer()
        if not self.isVector(self.dockwidget.mMapLayerComboBox.currentLayer()):
            self.getLayerRange()
            self.dockwidget.mFieldComboBox.setEnabled(False)
        else:
            self.dockwidget.mFieldComboBox.setEnabled(True)

            sym1 = QgsFillSymbol.createSimple({'color': '#33bdad', 'outline_color': 'black'})

            renderer = QgsSingleSymbolRenderer(sym1)
            #renderer.symbols(QgsRenderContext())[0].symbolLayers()[0].setDataDefinedProperty(QgsSymbolLayer.PropertyFillColor, QgsProperty.fromExpression('color_rgb( (@geometry_part_count - 1) * 200, 0, 0 )'))
            self.layer.setRenderer(renderer)

            # more efficient than refreshing the whole canvas, which requires a redraw of ALL layers
            self.layer.triggerRepaint()


    def handleSlider1press(self):
        self.p1dragging = True

    def handleSlider2press(self):
        self.p2dragging = True

    def handleCustomPrefixToggle(self):
        if self.dockwidget.prefixRadio.isChecked() == True:
            self.dockwidget.prefix.setEnabled(True)
        else:
            self.dockwidget.prefix.setEnabled(False)
            self.dockwidget.prefix.setText("f_")

    def handleDiscreteToggle(self):
        if self.dockwidget.discRadio.isChecked() == True:
            self.n = 5
        else:
            self.n = 100

        self.setRamp()
        self.apply_function()

    def setRamp(self):
        rampa = self.dockwidget.colorRampChooser.currentText()
        print(rampa)
        if rampa == "rdylgr":
            self.cmap = colors.LinearSegmentedColormap.from_list("", ["#730000","#ff5500","#ffff00","#4ce600","#267300"], N=self.n)
        if rampa == "brylgr":
            self.cmap = colors.LinearSegmentedColormap.from_list("", ["#6b491f","#e8d548","#84b53a"], N=self.n)
        if rampa == "ylrd":
            self.cmap = colors.LinearSegmentedColormap.from_list("", ["#fcf30a","#fbb43b","#f07424","#dc1400","#820f34"], N=self.n)
        if rampa == "ylorpr":
            self.cmap = colors.LinearSegmentedColormap.from_list("", ["#ffee7e","#faaf3c","#f35864","#c9008c","#691e91"], N=self.n)
        if self.dockwidget.invertBox.isChecked() == True:
            self.cmap = self.reverse_colourmap(self.cmap)

    def handleRampChanged(self):
        self.setRamp()
        self.dockwidget.invertBox.setChecked(False)
        self.apply_function()

    def reverse_colourmap(self, cmap, name = 'my_cmap_r'):
        """
        In:
        cmap, name
        Out:
        my_cmap_r

        Explanation:
        t[0] goes from 0 to 1
        row i:   x  y0  y1 -> t[0] t[1] t[2]
                       /
                      /
        row i+1: x  y0  y1 -> t[n] t[1] t[2]

        so the inverse should do the same:
        row i+1: x  y1  y0 -> 1-t[0] t[2] t[1]
                       /
                      /
        row i:   x  y1  y0 -> 1-t[n] t[2] t[1]
        """
        reverse = []
        k = []

        for key in cmap._segmentdata:
            k.append(key)
            channel = cmap._segmentdata[key]
            data = []

            for t in channel:
                data.append((1-t[0],t[2],t[1]))
            reverse.append(sorted(data))

        LinearL = dict(zip(k,reverse))
        my_cmap_r = colors.LinearSegmentedColormap(name, LinearL, N=self.n)
        return my_cmap_r

    def handleInvertRamp(self):
        #if self.dockwidget.invertBox.isChecked() == True:
        self.setRamp()
        self.apply_function()

    def handleSaveResultHere(self):
        if self.isVector(self.layer):
            print("path")
        else:
            self.layer_path, _ = QFileDialog.getSaveFileName(self.dockwidget, "Save to file", self.layer_path, filter='Tiff (*.tif)')

            if self.layer_path != '':
                #print(self.layer_path)
                self.dockwidget.layer_path.setText("..."+self.layer_path[-40:])
                self.dockwidget.layer_path.setToolTip(self.layer_path)
                self.handleSaveResult()

    def handleSaveResult(self):
        if self.isVector(self.layer):
            #guardar en el field
            f_field = self.dockwidget.prefix.text() + self.field
            print("guardaria el campo ", f_field)


            field_index = self.layer.fields().indexFromName(f_field)

            if field_index == -1:
                caps = self.layer.dataProvider().capabilities()
                if caps & QgsVectorDataProvider.AddAttributes:
                            res = self.layer.dataProvider().addAttributes(
                                [QgsField(f_field, QVariant.Double)])
                self.layer.updateFields()
            else:
                print("The field exists")


            self.layer.startEditing()
            for feature in self.layer.getFeatures():
                yraw = self.selected_function(feature[self.field])
                feature[f_field] = self.normalize_max_min(yraw, self.maxy, self.miny)
                self.layer.updateFeature(feature)
            self.layer.commitChanges()
        else:
            print("guardaria el raster ", self.layer_path)
            formula = self.get_GDAL_formula()
            print("formula: ",formula)

            #input_raster = QgsRasterLayer(self.layer, 'raster')
            output_raster = self.layer_path

            #I find it nice to create parameters as a dictionary
            parameters = {'INPUT_A' : self.layer,
                    'BAND_A' : 1,
                    'FORMULA' : formula,   #your expression here. Mine finds all cells with value > 100. Experiment in the GUI if needed. You can copy and paste exactly the same expression to into your code here
                    'OUTPUT' : output_raster}

            processing.runAndLoadResults('gdal:rastercalculator', parameters)  #feed in the parameters dictionary cleanly as one argument. You can also write the parameters here as individual arguments if you want.

        self.saveJson()



    def saveJson(self):
        print("salvaria el json",self.json_path)
        with open(self.json_path, "w") as f:
            f.write("{\n")
            f.write('"layer": "'+self.layer_path+'",\n')
            if self.isVector(self.layer):
                f.write('"field": "'+self.field+'",\n')
            f.write('"xmin": '+str(self.minx)+",\n")
            f.write('"xmax": '+str(self.maxx)+",\n")
            f.write('"p1": '+str(self.p1)+",\n")
            if len(self.p2_name) > 0:
                f.write('"p2": '+str(self.p2)+",\n")
            f.write('"'+self.p1_name+'": '+self.dockwidget.p1.text()+",\n")
            if len(self.p2_name) > 0:
                f.write('"'+self.p2_name+'": '+self.dockwidget.p2.text()+",\n")
            f.write('"function_name": "'+self.selected_function_str+'",\n')
            f.write('"gdal_raster_calculator": "'+self.get_GDAL_formula()+'",\n')
            f.write('"latex": "'+self.getFormula()+'",\n')
            python_formula = self.get_GDAL_formula().replace(",2)",")**2").replace("exp", "math.exp").replace("power","").replace("A","x")
            f.write('"python_code": "'+python_formula+'"\n')
            f.write("}")
            f.close()

    def tabChanged(self):
        """
        Handles the current tab being changed
        """
        print(self.dockwidget.tabWidget.currentWidget().objectName())
        if self.dockwidget.tabWidget.currentWidget().objectName() == "tab_2":
            if self.isVector(self.layer):
                self.dockwidget.saveResult.setText("Result Field")
                self.layer_path = os.path.join(self.layer_dir,self.layer_name.split("|")[0])
                field = str(self.dockwidget.mFieldComboBox.currentField())
                self.tex_path = os.path.join(self.layer_dir,self.dockwidget.prefix.text()+field+"_"+self.layer_name.split(".")[0]+".tex")
                self.json_path = os.path.join(self.layer_dir,self.dockwidget.prefix.text()+field+"_"+self.layer_name.split(".")[0]+".json")
                self.dockwidget.pushButton_4.setEnabled(False)
            else:
                self.dockwidget.saveResult.setText("Result Layer")
                base_path = os.path.join(self.layer_dir,self.dockwidget.prefix.text()+self.layer_name.split(".")[0])
                self.layer_path = base_path + ".tif"
                self.tex_path = base_path + ".tex"
                self.json_path = base_path + ".json"
                self.dockwidget.layer_path.setText("..."+self.layer_path[-40:])
                self.dockwidget.layer_path.setToolTip(self.layer_path)
                self.dockwidget.pushButton_4.setEnabled(True)



    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True
            self.p1dragging = False
            self.p2dragging = False
            #print "** STARTING geo_value_functions"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = geo_value_functionsDockWidget()

            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)
            self.dockwidget.lineal_creciente.setIcon(QIcon(QPixmap(":/plugins/geo_value_functions/img/a1.PNG")))
            self.dockwidget.logistica.setIcon(QIcon(QPixmap(":/plugins/geo_value_functions/img/a2.PNG")))
            self.dockwidget.convexa_creciente.setIcon(QIcon(QPixmap(":/plugins/geo_value_functions/img/a3.PNG")))
            self.dockwidget.concava_creciente.setIcon(QIcon(QPixmap(":/plugins/geo_value_functions/img/a4.PNG")))

            self.dockwidget.lineal_decreciente.setIcon(QIcon(QPixmap(":/plugins/geo_value_functions/img/d1.PNG")))
            self.dockwidget.logistica_invertida.setIcon(QIcon(QPixmap(":/plugins/geo_value_functions/img/d2.PNG")))
            self.dockwidget.convexa_decreciente.setIcon(QIcon(QPixmap(":/plugins/geo_value_functions/img/d3.PNG")))
            self.dockwidget.concava_decreciente.setIcon(QIcon(QPixmap(":/plugins/geo_value_functions/img/d4.PNG")))

            self.dockwidget.campana.setIcon(QIcon(QPixmap(":/plugins/geo_value_functions/img/n1.PNG")))
            self.dockwidget.campana_invertida.setIcon(QIcon(QPixmap(":/plugins/geo_value_functions/img/n2.PNG")))
            self.dockwidget.lineal_creciente.clicked.connect(self.select_graph)
            self.dockwidget.logistica.clicked.connect(self.select_graph)
            self.dockwidget.convexa_creciente.clicked.connect(self.select_graph)
            self.dockwidget.concava_creciente.clicked.connect(self.select_graph)

            self.dockwidget.lineal_decreciente.clicked.connect(self.select_graph)
            self.dockwidget.logistica_invertida.clicked.connect(self.select_graph)
            self.dockwidget.convexa_decreciente.clicked.connect(self.select_graph)
            self.dockwidget.concava_decreciente.clicked.connect(self.select_graph)

            self.dockwidget.campana.clicked.connect(self.select_graph)
            self.dockwidget.campana_invertida.clicked.connect(self.select_graph)
            self.dockwidget.mFieldComboBox.setFilters(QgsFieldProxyModel.Numeric)
            #self.dockwidget.mMapLayerComboBox.layerChanged.connect(lambda: self.dockwidget.mFieldComboBox.setLayer(self.dockwidget.mMapLayerComboBox.currentLayer()))
            self.dockwidget.mMapLayerComboBox.layerChanged.connect(self.handleLayerChanged)
            self.dockwidget.mFieldComboBox.fieldChanged.connect(self.getLayerRange)

            self.selected_function_str = ""


            self.dockwidget.p1.returnPressed.connect(self.handleReturnPressed1)
            self.dockwidget.p2.returnPressed.connect(self.handleReturnPressed2)
            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dockwidget)
            self.dockwidget.slider1.valueChanged.connect(self.handleSlider1ValueChange)
            self.dockwidget.slider2.valueChanged.connect(self.handleSlider2ValueChange)
            self.dockwidget.slider1.sliderReleased.connect(self.handleSlider1Released)
            self.dockwidget.slider2.sliderReleased.connect(self.handleSlider2Released)
            self.dockwidget.slider1.sliderPressed.connect(self.handleSlider1press)
            self.dockwidget.slider2.sliderPressed.connect(self.handleSlider2press)


            self.dockwidget.svg = QSvgWidget(self.dockwidget.frame)
            self.dockwidget.svg.setGeometry(0,0,376,165)
            self.dockwidget.prefix.setText("f_")
            self.dockwidget.prefixRadio.toggled.connect(self.handleCustomPrefixToggle)
            self.dockwidget.contRadio.toggled.connect(self.handleDiscreteToggle)
            self.dockwidget.discRadio.toggled.connect(self.handleDiscreteToggle)
            self.n = 5
            self.cmap = colors.LinearSegmentedColormap.from_list("", ["#6b491f","#e8d548","#84b53a"], N=self.n)
            self.dockwidget.colorRampChooser.addItem(QIcon(QPixmap(":/plugins/geo_value_functions/img/ylorpr.PNG")),"ylorpr")
            self.dockwidget.colorRampChooser.addItem(QIcon(QPixmap(":/plugins/geo_value_functions/img/brylgr.PNG")),"brylgr")
            self.dockwidget.colorRampChooser.addItem(QIcon(QPixmap(":/plugins/geo_value_functions/img/rdylgr.PNG")),"rdylgr")
            self.dockwidget.colorRampChooser.addItem(QIcon(QPixmap(":/plugins/geo_value_functions/img/ylrd.PNG")),"ylrd")
            self.dockwidget.colorRampChooser.setCurrentText("brylgr")
            self.dockwidget.colorRampChooser.currentTextChanged.connect(self.handleRampChanged)
            self.dockwidget.invertBox.stateChanged.connect(self.handleInvertRamp)
            self.dockwidget.saveResult.clicked.connect(self.handleSaveResult)
            self.dockwidget.pushButton_4.clicked.connect(self.handleSaveResultHere)
            self.dockwidget.tabWidget.currentChanged.connect(self.tabChanged)
            self.dockwidget.show()
            #self.getLayerRange()
