# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoMaringa
                                 A QGIS plugin
 Teste para obtenção dos dados do portal Geomaringá
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-08-26
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Andre Zanco
        email                : andrezanco88@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Geo_Maringa_dialog import GeoMaringaDialog
import os.path

from .utils.data import read_json

from qgis.core import QgsVectorLayer
from qgis.core import QgsProject
from qgis.core import Qgis
from qgis.utils import iface

class GeoMaringa:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        self.dlg = GeoMaringaDialog()
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'GeoMaringa_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&GeoMaringa')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        #reading the json conting the data and adding to ComboBox
        self.app_data_dir = os.path.join(self.plugin_dir, "app_data")
        self.json_path = os.path.join(self.app_data_dir, "metadata.json")
        self.data = read_json(self.json_path)

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('GeoMaringa', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Geo_Maringa/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'GeoMaringa'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

        self.dlg.LayerSelector.addItems([layer['NAME'] for layer in self.data])
        self.dlg.LayerSelector.activated.connect(self.__add_subLayer)
        self.dlg.LayerSelector.currentIndexChanged.connect(self.__add_subLayer)

        #adding a function to download button
        self.dlg.SubmitButton.clicked.connect(self.__submit_content)

        self.__add_subLayer()

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&GeoMaringa'),
                action)
            self.iface.removeToolBarIcon(action)

    def __add_subLayer(self):
        self.dlg.SubLayerSelector.clear()
        self.dlg.SubLayerSelector.addItems([sublayer['NAME'] for sublayer in self.data[self.dlg.LayerSelector.currentIndex()]['Childrens']])

    def __submit_content(self):
        if self.dlg.LayerSelector.currentIndex() != -1:
            dir = self.data[self.dlg.LayerSelector.currentIndex()]['Childrens'][self.dlg.SubLayerSelector.currentIndex()]['dir']
            name = self.data[self.dlg.LayerSelector.currentIndex()]['Childrens'][self.dlg.SubLayerSelector.currentIndex()]['NAME']
            select_layer = QgsVectorLayer(f"url={dir}", name, "arcgisfeatureserver")
            # Verificar se a camada foi carregada com sucesso
            if select_layer.isValid():
                # Adicionar ao projeto
                QgsProject.instance().addMapLayer(select_layer)
                iface.messageBar().pushMessage('DEU BOM', f'camada {name} adicionada com sucesso', level = Qgis.Success)
                
            else:
                error_msg = select_layer.error().message() if select_layer.error() else "Erro desconhecido"
                iface.messageBar().pushMessage('DEU RUIM', f'ocorreu algum erro ao adicionar a camada {name}: {error_msg}', level = Qgis.Critical)
               


            


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
