# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoAgentDialog
                                 A QGIS plugin
 Plugin for geospatial workflow
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-12-15
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Tek Kshetri
        email                : iamtekson@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import QSize

from ..logger.logger import UILogHandler
from ..config.settings import SHOW_DEBUG_LOGS, MAX_LOG_LINES

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "geo_agent_dialog_base.ui")
)


class GeoAgentDialog(QtWidgets.QDockWidget, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(GeoAgentDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # Initialize UI Log Handler
        self._setup_logging()

        # Set default values for UI controls
        self._set_defaults()

        # Apply standard info icons to helper buttons
        self._apply_info_icons()

        # Set initial tooltips that depend on provider selection
        self._update_model_name_tooltip()

        # Setup connections for mode switching
        self.setup_connections()

    def _setup_logging(self):
        """Initialize the UI log handler for the logs tab."""
        try:
            # Get the text browser widget from the logs tab
            if hasattr(self, "geoagent_logs"):
                # Create and configure the UI log handler
                ui_log_handler = UILogHandler(
                    text_browser=self.geoagent_logs,
                    max_lines=MAX_LOG_LINES,
                    show_debug=SHOW_DEBUG_LOGS,
                )

                # Store the handler as an attribute for later access
                self.ui_log_handler = ui_log_handler
        except Exception as e:
            print(f"Failed to initialize UI logging: {e}")

    def _set_defaults(self):
        """Set default values for dialog controls."""
        try:
            # Set temperature to 0.8
            if hasattr(self, "temperature"):
                self.temperature.setValue(0.8)
        except Exception:
            pass

    def _apply_info_icons(self):
        """apply native information icons to tooltip buttons."""
        try:
            info_icon = self.style().standardIcon(QtWidgets.QStyle.SP_MessageBoxInformation)
            for btn_name in (
                "info_provider",
                "info_temperature",
                "info_maximum_token",
                "info_model_name",
                "info_api_key",
                "info_ollama_base_url",
                "info_ollama_model_name",
            ):
                btn = getattr(self, btn_name, None)
                if btn:
                    btn.setIcon(info_icon)
                    btn.setIconSize(QSize(14, 14))
                    btn.setText("")
                    btn.setAutoRaise(True)
        except Exception:
            pass

        try:
            # Set max tokens to 5000
            if hasattr(self, "max_tokens"):
                self.max_tokens.setValue(5000)
        except Exception:
            pass

        try:
            # Set Ollama model name to llama3.2:3b
            if hasattr(self, "ollama_model_name"):
                self.ollama_model_name.setText("llama3.2:3b")
        except Exception:
            pass

        try:
            # Set Ollama base URL
            if hasattr(self, "ollama_base_url"):
                self.ollama_base_url.setText("http://localhost:11434")
        except Exception:
            pass

        try:
            # set llm_response text for getting started info
            if hasattr(self, "llm_response"):
                self.llm_response.setPlainText(
                    "Welcome to GeoAgent!\n\n"
                    "Select your LLM provider and configure settings on the left.\n"
                    "If your provider is Ollama, ensure your Ollama server is running.\n\n"
                    "   - Download Ollama: [https://ollama.com/download](https://ollama.com/download)\n"
                    "   - Make sure Ollama is running by executing `ollama serve` in your terminal.\n\n"
                    "Then choose a mode (default: General):\n"
                    "   - Choose 'General' mode for conversational GIS assistance.\n"
                    "   - Choose 'Processing' mode to execute geoprocessing tasks.\n\n"
                    "Type your message above and click 'Send' to get started."
                )
        except Exception:
            pass

    def get_current_mode(self) -> str:
        """Get the currently selected mode (general or processing)."""
        try:
            if hasattr(self, "processing_mode") and self.processing_mode.isChecked():
                return "processing"
        except Exception:
            pass
        return "general"

    def get_ui_log_handler(self):
        """
        Get the UI log handler for this dialog.

        This method allows other parts of the plugin to access the log handler
        so they can add it to their loggers.

        Returns:
            UILogHandler instance or None if not initialized
        """
        return getattr(self, "ui_log_handler", None)

    def setup_connections(self):
        # Connect the combo box change signal to our switching function and tooltip updates
        self.model.currentIndexChanged.connect(self.update_ui_visibility)
        self.model.currentTextChanged.connect(lambda _: self._update_model_name_tooltip())

        # Show info dialog for model name when requested
        if hasattr(self, "info_model_name"):
            self.info_model_name.clicked.connect(self._on_model_name_info_clicked)

        # Set the initial state
        self.update_ui_visibility()

    def update_ui_visibility(self):
        selection = self.model.currentText()

        if selection == "Ollama":
            self.stackedWidget.setCurrentIndex(1)
        else:
            self.stackedWidget.setCurrentIndex(0)

        # refresh tooltips that depend on provider selection
        self._update_model_name_tooltip()

    def _update_model_name_tooltip(self):
        """Set model-name tooltip based on current provider selection."""
        try:
            btn = getattr(self, "info_model_name", None)
            if not btn:
                return
            # click on the info button shows detailed info
            btn.setToolTip("Click for more information.")
        except Exception:
            pass

    def _get_model_name_help_text(self) -> str:
        """Return the model-name help text based on current provider selection."""
        selection = self.model.currentText() if hasattr(self, "model") else ""
        if selection == "ChatGPT":
            return (
                "Select one of the model names from https://platform.openai.com/docs/models\n"
                "\n"
                "Examples: gpt-5.2-2025-12-11, gpt-5-mini-2025-08-07, gpt-4.1-2025-04-14, etc.\n"
            )

        if selection == "Gemini":
            return (
                "Select one of the model codes from https://ai.google.dev/gemini-api/docs\n"
                "\n"
                "Examples: gemini-3-pro-preview, gemini-2.5-pro, gemini-2.5-flash-preview-09-2025, etc.\n"
            )
    
        return ""

    def _on_model_name_info_clicked(self):
        """show a message box with more information."""
        try:
            message = self._get_model_name_help_text()
            if message:
                QtWidgets.QMessageBox.information(self, "Information", message)
        except Exception:
            pass
