# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoZoneCheckGermany
                                 A QGIS plugin
 UAS flight restriction checker for Germany
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-12-15
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Jannis Midasch
        email                : jannis.midasch@midasch-geovis.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from os import system
from time import time, localtime, strftime 
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QMessageBox
from qgis.core import *
import processing
from osgeo import gdal, ogr, osr
from osgeo import gdal_array
from osgeo.gdalconst import *
from shutil import rmtree   
from shapely.geometry import shape        
import numpy as np
from PIL import Image  
import tempfile                
import xml.etree.cElementTree as ET                            
gdal.UseExceptions()
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .geo_zone_check_germany_dialog import GeoZoneCheckGermanyDialog
import os.path


class GeoZoneCheckGermany:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'GeoZoneCheckGermany_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Geo-Zone Check Germany')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('GeoZoneCheckGermany', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/geo_zone_check_germany/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Check flightpath for geo-zones'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Geo-Zone Check Germany'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = GeoZoneCheckGermanyDialog()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            print ()
            print ('-------------------------------')
            print ('New run')
            tstart = time()
            tb=0
            print("Starting time: ", strftime("%H:%M:%S", localtime()))
            outputpath=tempfile.mkdtemp(prefix="qgisflightplanner_")
            print(outputpath)
            #get flightpath and extent, transform extent to utm if needed
            flightpath = self.dlg.mMapLayerComboBox.currentLayer()
            print ("Flightpath layer: ",flightpath.name())
            epsg = 25832
            destCrs = QgsCoordinateReferenceSystem(epsg)
            flightpathCrs = QgsCoordinateReferenceSystem(flightpath.crs())
            ext = flightpath.extent()
            if destCrs != flightpathCrs:
                tform = QgsCoordinateTransform(flightpathCrs, destCrs, QgsProject.instance())
                ext = tform.transform(ext)
            #vlayers for results
            conflicts=QgsVectorLayer('Polygon','Intersecting Geo-Zones','memory')
            conflictsprov=conflicts.dataProvider()
            conflictsprov.addAttributes([
                QgsField("type", QVariant.String),
                QgsField("legalinfo", QVariant.String)
            ])
            conflicts.setCrs(destCrs)
            conflicts.updateFields()
            conflictlist=[]
            closeby=QgsVectorLayer('Polygon','Closeby Geo-Zones','memory') 
            closebyprov=closeby.dataProvider()
            closebyprov.addAttributes([
                QgsField("type", QVariant.String),
                QgsField("legalinfo", QVariant.String),
                QgsField("distance", QVariant.Double)
            ])   
            closeby.setCrs(destCrs)
            closeby.updateFields() 
            closebylist=[]
            #create 1km buffer
            xMin = int(ext.xMinimum())-1000
            yMin = int(ext.yMinimum())-1000
            xMax = int(ext.xMaximum())+1000
            yMax = int(ext.yMaximum())+1000
            #calculate raster size for 1m/px with max 2500x2500px overall
            height = yMax-yMin
            if height > 2500:
                height = 2500
            width = xMax-xMin
            if width > 2500:
                width = 2500
            #get layers for wms
            layerlist=['flugplaetze','flughaefen','kontrollzonen','flugbeschraenkungsgebiete','bundesautobahnen','bundesstrassen','bahnanlagen','binnenwasserstrassen','seewasserstrassen','schifffahrtsanlagen','wohngrundstuecke','freibaeder','industrieanlagen','kraftwerke','umspannwerke','stromleitungen','windkraftanlagen','justizvollzugsanstalten','militaerische_anlagen','labore','verfassungsorgane','oberste_behoerden','diplomatische_vertretungen','internationale_organisationen','polizei','sicherheitsbehoerden','krankenhaeuser','nationalparks','naturschutzgebiete','ffh-gebiete','vogelschutzgebiete']
            layerlisteng=['aerodromes','airports','control_zones','flight_restrictions','federal_highways','federal_roads','railroad_facilities','inland_waterways','sea_waterways','shipping_facilities','residential_properties','outdoor_swimming_pools_and_beaches','industrial_plants','power_plants','transformer_stations','powerlines','wind_turbines','prisons_and_facilities_for_the_treatment_of_psychiatric_disorders','military_installations_and_organisations','facilities_BSL_4','federal_or_state_constitutional_bodies','supreme_federal_and_state_authorities','diplomatic_and_consular_missions','international_organizations_within_the_meaning_of_international_law','police_properties','other_safety_authorities','hospitals','national_parks','nature_reserves','FFH_areas','bird_sanctuaries']
            layerlistlegal=['https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-0','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-1','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-8','https://www.dipul.de/homepage/en/information/geographical-zones/entry-restricted-areas-ed-r/','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-4','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-4','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-4','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-4','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-4','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-4','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-6','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-7','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-2','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-2','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-2','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-2','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-2','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-2','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-2','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-2','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-3','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-3','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-3','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-3','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-3','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-3','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-9','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-5','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-5','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-5','https://www.dipul.de/homepage/en/information/geographical-zones/legal-basis/#accordion-1-5']
            for i in range(len(layerlist)):
                #get strings
                ilyr=layerlist[i]
                ieng=layerlisteng[i]
                ilb=layerlistlegal[i]
                #generate URIs
                wms_url = 'https://uas-betrieb.de/geoservices/dipul/wms?service=WMS&version=1.3.0&request=GetMap&layers='+ilyr+'&styles&bbox='+str(xMin)+','+str(yMin)+','+str(xMax)+','+str(yMax)+'&width='+str(width)+'&height='+str(height)+'&crs=EPSG:'+str(epsg)+'&transparent=TRUE&format=image/png&'
                rpath2 = r"{}".format(outputpath+'/'+ieng+'.png')
                rpath = r"{}".format(outputpath+'/'+ieng+'.tif')
                rbwpath = r"{}".format(outputpath+'/'+ieng+'bw.tif')
                vpath= r"{}".format(outputpath+'/'+ieng+'.shp')
                #save the wms image to tiff
                tb=tb-time()
                ds=gdal.Translate(rpath,"WMS:"+wms_url,height=height,width=width, projWin=[xMin,yMax,xMax,yMin])
                ds=None
                tb=tb+time()            
                #binarize the image via numpy array                
                im = np.array(Image.open(rpath).convert('L'))
                im_bin = (im < 250) * 255
                Image.fromarray(np.uint8(im_bin)).save(rbwpath)
                del im, im_bin
                #re-georeference the image
                src_ds = gdal.Open(rbwpath)
                src_ds.SetGeoTransform(gdal.Open(rpath).GetGeoTransform())
                srs = osr.SpatialReference()
                srs.ImportFromEPSG(epsg)
                dest_wkt = srs.ExportToWkt()
                src_ds.SetProjection(dest_wkt)
                #polygonize the image
                band = src_ds.GetRasterBand(1)
                drv = ogr.GetDriverByName("ESRI Shapefile")
                outfile = drv.CreateDataSource(r"{}".format(vpath)) 
                outlayer = outfile.CreateLayer("polygonized raster", srs )
                newField = ogr.FieldDefn("DN", ogr.OFTReal)
                outlayer.CreateField(newField)
                gdal.Polygonize(band, None, outlayer, 0, [])
                #get rid of no longer needed stuff
                del src_ds, outfile, outlayer
                #Create vector layer and delete background
                vgeozones = QgsVectorLayer(vpath, 'vgeozones')
                vgeozones.setSubsetString("DN != 0")
                #only process shapefiles with contents
                if vgeozones.featureCount()!=0:
                #calculate distance/intersections
                    for fp in flightpath.getFeatures():
                        fp=fp.geometry()
                        if destCrs != flightpathCrs:
                            fp.transform(tform)
                        for fz in vgeozones.getFeatures():
                            feat=QgsFeature()
                            feat.setGeometry(fz.geometry())
                            if fp.intersects(fz.geometry()):
                                if ieng not in conflictlist:
                                    conflictlist.append(ieng)
                                feat.setAttributes([ieng, ilb])
                                conflictsprov.addFeatures([feat])
                                conflicts.updateExtents()                                
                            else:
                                dist=round(QgsGeometry.distance(fp, fz.geometry()),2)
                                if 0<dist:
                                    if ieng not in closebylist:
                                        closebylist.append(ieng)                                
                                    feat.setAttributes([ieng, ilb, dist])
                                    closebyprov.addFeatures([feat])
                                    closeby.updateExtents()                                
                del vgeozones
            #style the layers
            symb={'aerodromes':('#DF7979','Aerodromes'),'airports':('#DF7979','Airports'),'control_zones':('#DF7979', 'Control zones'),'flight_restrictions':('#DF7979', 'Flight restrictions'),'federal_highways':('#C6CBCF','Federal highways'),'federal_roads':('#C6CBCF','Federal roads'),'railroad_facilities':('#8F9193','Railroad facilities'),'inland_waterways':('#9BC8ED','Inland waterways'),'sea_waterways':('#9BC8ED','Sea waterways'),'shipping_facilities':('#9BC8ED','Shipping facilities'),'residential_properties':('#F3DC90','Residential properties'),'outdoor_swimming_pools_and_beaches':('#F3DC90','Outdoor swimming pools and beaches'),'industrial_plants':('#78779F','Industrial plants'),'power_plants':('#78779F','Power plants'),'transformer_stations':('#78779F','Transformer stations'),'powerlines':('#78779F','Powerlines'),'wind_turbines':('#78779F','Wind turbines'),'prisons_and_facilities_for_the_treatment_of_psychiatric_disorders':('#EDA362','Prisons and facilities for the treatment of psychiatric disorders'),'military_installations_and_organisations':('#EDA362','Military installations and organisations'),'facilities_BSL_4':('#EDA362','Facilities BSL-4'),'federal_or_state_constitutional_bodies':('#EDA362','Federal or state constitutional bodies'),'supreme_federal_and_state_authorities':('#EDA362','Supreme federal and state authorities'),'diplomatic_and_consular_missions':('#EDA362','Diplomatic and consular missions'),'international_organizations_within_the_meaning_of_international_law':('#EDA362','International organizations within the meaning of international law'),'police_properties':('#EDA362','Police properties'),'other_safety_authorities':('#EDA362','Other safety authorities'),'hospitals':('#EDA362','Hospitals'),'national_parks':('#9EC28A','National parks'),'nature_reserves':('#9EC28A','Nature reserves'),'FFH_areas':('#9EC28A','FFH areas'),'bird_sanctuaries':('#9EC28A','Bird sanctuaries')}
            conflictcategories = []
            closebycategories = []
            for symb_name, (color, label) in symb.items():
                if symb_name in closebylist:
                    symbol = QgsSymbol.defaultSymbol(closeby.geometryType())
                    symbol.setColor(QColor(color))
                    symbol.setOpacity(0.4)           
                    closebycategories.append(QgsRendererCategory(symb_name, symbol, label))
                if symb_name in conflictlist:
                    symbolconf=QgsSymbol.defaultSymbol(conflicts.geometryType())
                    symbolconf.setColor(QColor(color))
                    symbolconf.setOpacity(0.75)
                    symbolconf.symbolLayer(0).setStrokeColor(QColor(255, 0, 0))                
                    conflictcategories.append(QgsRendererCategory(symb_name, symbolconf, label))
            closeby.setRenderer(QgsCategorizedSymbolRenderer('Type', closebycategories))
            QgsProject.instance().addMapLayer(closeby)
            conflicts.setRenderer(QgsCategorizedSymbolRenderer('Type', conflictcategories))
            QgsProject.instance().addMapLayer(conflicts)  
            #Delete files produced in previous run 
            for root, dirs, files in os.walk(tempfile.gettempdir()):
                for dir in dirs:
                    if "qgisflightplanner" in dir:
                        try:
                            rmtree(tempfile.gettempdir()+"/"+dir)
                        except:
                            if dir in outputpath:
                                continue
                            else:
                                print("Directory could not be removed:", dir)
            print('Finished after:', round(time()-tstart, 4), "sec.")
            print('Total time to save tiffs from wms:', tb)
            #print("Files created in temporary directory at: "+outputpath)
            print('-------------------------------')
