![](./views/Contour.jpg)
<img src="https://img.shields.io/badge/-Python-ffdc00.svg?logo=python&style=flat-square"><img src="https://img.shields.io/badge/-QGIS-cee4ae.svg?logo=qgis&style=flat-square">

# **Overview**
この QGIS プラグインは DTM（DEM）から微地形図の RGB 画像を作成する為のプラグインです。

<br>


# **Install**
QGISのプラグインとして公開しているので、プラグイン管理画面で 「Topo Maps」 と検索すれば表示されます。
![](./views/Install.jpg)

<br>


# **Layers**
以下の順番で上から重ねたものを使用しています。
 - 傾斜図（Slope）
 - 地形位置指数（TPI: Topographic Position Index）
 - 地形凹凸指数（TRI: Terrain Ruggedness Index）
 - 陰影起伏図（Hillshade）

<br>


# **Styles**
![](./views/Styles.jpg)
このプラグインでは様々な色の微地形図を生成する事が出来ます。3種類のスタイルとは他に、ユーザーが自分自身でスタイルを作成する事も可能です。

### Original-Map Style

![](./views/ORIGINAL-Map__Img.jpg)

### Vintage-Map Style
![](./views/Vintage-Map__Img.jpg)

### RGB-Map Style
![](./views/RGB-Map__Img.jpg)

> 😁 **Note:** この微地形図は分解能 50cmの DTMを使用して作成されています。

<br>

# **Resampling**
このプラグインでは微地形図を計算する前に、DTMのリサンプリングを行う事ができます。1m 程度の分解能の DTM であれば綺麗な微地形図が作成できますが、5m や 10m の DTM を使用するとあまり綺麗な微地形図が作成できません。その為、分解能が低い DTM の場合は最初に分解能を 1m 程度にリサンプリングするのがおススメです。

>🧐 **Note:**
> このプラグインでは投影座標系のDTMを使用する事を前提としています。地理座標系のデータでも動作しますが、綺麗な微地形図が作成されない場合があります。地理座標系のデータを使用する場合も各パラメーターはメートル単位で指定する事が出来ます。

<br>

# **Options**
基本的には初期設定のまま使用できますが、分解能に合わせて各計算の詳細を変更する事ができます。

## **Slope Options**
傾斜は `gdal.DEMProcessing` で計算しています。
#### *傾斜計算の距離（距離を指定）*
メートル単位で指定した距離離れた場所との傾斜を計算します。

#### *傾斜計算の距離（セル数で指定）*
セル単位で指定した距離離れた場所との傾斜を計算します。隣接セルとの傾斜を計算する場合はこちらを使用して下さい。

#### *ガウシアンフィルター*
傾斜計算した後にガウシアンフィルターを使用してぼかしを入れる事が出来ます。`Sigma`パラメーターを大きくする程にカーネルサイズが大きくなり、ぼかしが強くなります。

#### *相対的な透過率の変更*
データによっては色が必要以上に濃く出てしまうので、このスライダーで相対的な透過率を調整して下さい。


## **TPI Options**
TPI ではオリジナルの DTM と畳み込み後の DTM の差分を計算します。正の値を取る場合は該当セルが付近より高い位置にある事を示し、負の値を取る場合は付近よりも低い位置にある事を示します。
#### *カーネルサイズ*
カーネルサイズは「距離」と「セル数」で指定できます。

#### *カーネルタイプ*
カーネルタイプは「ドーナツ」「平均」「隣接セルを使用」「ガウシアン」「逆ガウシアン」の5種類あるので、好みのカーネルを選択して下さい。

#### *外れ値処理*
TPIの計算では、一部に極端な値が現れる場合があります。そのまま描画してしまうと、その外れ値に引っ張られて綺麗に可視化されません。外れ値を丸めてから描画した方が良いでしょう。

#### *相対的な透過率の変更*
データによっては色が必要以上に濃く出てしまうので、このスライダーで相対的な透過率を調整して下さい。

#### *Multiple TPI*
TPIの画像を2枚重ねる事が出来ます。これは1枚目のTPIで設定した距離の乗数を設定し、1枚目を10m、2枚目は50mなどに設定する事で小さい地形の変化と大きな地形の変化を同じ微地形図で表現する為に追加します。

> 🧐 **Note:** TPIは周囲の高さと比べたターゲットの位置を計算する指標です。`平均`や`ガウシアン`を選択するよりも`ドーナツ`や`逆ガウシアン`のカーネルを使用する事で、周囲の情報の重みを重くして指標を計算する事が出来ます。
![](./views/ShowKernel.png)

> 🧐 **Note:** カーネルサイズを小さくすれば、より詳細な特徴（例えば小さな凹凸）が表現されますが、大きな特徴（例えば尾根や沢）が分かりづらくなります。微地形図は森林を対象とする事が多いと思われますので、大体 10～20m 程度で設定するのがおススメです。
![](./views/ChangeKernelSize.png)

<br>


## TRI Options
TRIは`gdal.DEMProcessing`を使用して計算されます。デフォルトでは使用しない設定になっていますが、チェックボックスをONにすれば陰影起伏図の上に重ねる事が出来ます。

<br>


## Hillshade Options
Hillshadeは`gdal.DEMProcessing`を使用して計算されます。このプラグインで作成される微地形図のベースには陰影起伏図を使用しています。

#### *光源タイプ*
「Single」は一方向から光を当てた陰影起伏図を作成し、「Multiple」は 225°, 270°, 315°, 360°の方向から光を当てた陰影起伏図を作成します。

#### *方位*
光源タイプで "Single" を選択した場合はこの方向から光を当てます。

#### *高度*
高度は光源の傾斜角です。0°が水平を表し、90°は真上を表します。90°以外を選択すると、影のある斜面とない斜面が表現されてしまうので、90°で設定するのがおススメです。

#### *強調係数*
標高を事前に乗算するために使用される係数。

#### *ガウシアンフィルターを適用する*
高分解能の DTM を使用する場合はフィルターを通して少し変化を抑えた方が見やすい場合があります。必要に応じて使用して下さい。

#### *外れ値処理*
陰影起伏図を作成後に外れ値を処理する事で、輪郭がハッキリした陰影起伏図を作成する事が出来ます。


## Others Options
#### *アンシャープマスク*
UnsharpMaskで画像をシャープにします。詳しくは Wikipedia を参照してください。

[Wikipedia: UnsharpMask](https://en.wikipedia.org/wiki/Unsharp_masking#Digital_unsharp_masking)

#### *コントラスト調整*
コントラストを調整します。


<br>

# **Preview composited image**
このプラグインで高分解能の DTM から微地形図を作成する場合は時間が掛かります。サイズが大きな DTM の場合は`サンプルの確認`にチェックを入れて実行する事で、全体ではなく一部の範囲で計算・確認を行う事ができます。



## **Styled images by resolution**

> Resolution = 0.5m
![](./views/Sample__CS-Map__R0_5.jpg)

> Resolution = 5.0m (resampled = 1.0m)
![](./views/Sample__CS-Map__R5.jpg)



## **UI Image**
![](./views/UI.png)