# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GenerateSwmmInp
                                 A QGIS plugin
 This plugin generates SWMM Input files
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-07-09
        copyright            : (C) 2023 by Jannik Schilling
        email                : jannik.schilling@posteo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Jannik Schilling'
__date__ = '2023-05-09'
__copyright__ = '(C) 2023 by Jannik Schilling'


# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from .generate_swmm_inp_file import GenerateSwmmInpFile
from .generate_default_data import GenerateDefaultFolder
from .generate_swmm_import_inp_file import ImportInpFile
from .create_submodel import CreateSubModel
from qgis.PyQt.QtGui import QIcon
import os
pluginPath = os.path.dirname(__file__)


class GenerateSwmmProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(GenerateSwmmInpFile())
        self.addAlgorithm(GenerateDefaultFolder())
        self.addAlgorithm(ImportInpFile())
        self.addAlgorithm(CreateSubModel())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'GenSwmmInp'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Generate Swmm Inp')

    def icon(self):
        return QIcon(os.path.join(pluginPath, "icons", "icon.svg"))

    def svgIconPath(self):
        return os.path.join(pluginPath, "icons", "icon.svg")

    def longName(self):
        return self.name()
