# -*- coding: utf-8 -*-
"""QGIS QgsPalLabeling examples

.. note:: This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
"""
__author__ = 'Larry Shaffer'
__date__ = '10/14/2013'
__copyright__ = 'Copyright 2013, The QGIS Project'

from qgis.core import (
    QgsApplication,
    QgsPalLabeling,
    QgsPalLayerSettings,
    QgsVectorLayer
)
from qgis.utils import iface

from PyQt4.Qt import *

mc = iface.mapCanvas()
mr = mc.mapRenderer()  # note this is deprecated

pal = QgsPalLabeling()
mr.setLabelingEngine(pal)
mrpal = mr.labelingEngine()

mrpal.setShowingCandidates(True)
mrpal.saveEngineSettings()

layer = iface.activeLayer()
palyr = QgsPalLayerSettings()
palyr.readFromLayer(layer)

palyr.enabled = True
# 'text' is default field in labeling test data sources
palyr.fieldName = 'text'
palyr.fontSizeInMapUnits = True
palyr.textColor = Qt.blue

font = QgsApplication.font()
# note: this size will be set, but overridden by data definition below
font.setPointSizeF(200)
palyr.textFont = font

palyr.writeToLayer(layer)
mc.refresh()

# get currently set data definitions as dict of
#   {QgsPalLayerSettings.DataDefinedProperties: QgsDataDefined}
#   e.g. {18: <qgis.core.QgsDataDefined object at 0x1237daa70>, 10: ...}
ddp = palyr.dataDefinedProperties

# get a data definition from those currently set
ddft = None
if QgsPalLayerSettings.FontTransp in ddp:
    ddft = ddp[QgsPalLayerSettings.FontTransp]

# or try to get a data definition directly (returns None if not found)
ddfc = palyr.dataDefinedProperty(QgsPalLayerSettings.FontCase)
ddfc_field = ''
if ddfc is not None:
    ddfc_field = ddfc.field()


# you can update the data definition as well
ddfc = palyr.dataDefinedProperty(QgsPalLayerSettings.FontCase)
if ddfc:
    ddfc.setField('myfield')  # which would need to be a valid field

# you can also add a new data definition
if not QgsPalLayerSettings.Size in ddp:
    # add an active definition that defines to use an expression of 36
    # (i.e. no attribute field is mapped)
    palyr.setDataDefinedProperty(QgsPalLayerSettings.Size, True, True, '460', '')

# whenever you update/add/remove a data definition,
# from your QgsPalLayerSettings object, if you want to
# save it to the project instance and see results on canvas
palyr.writeToLayer(layer)
mc.refresh()
