# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GaliciaSustentable
                                 A QGIS plugin
 GaliciaSustentable processing provider
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-04-14
        copyright            : (C) 2020 by Luigi Pirelli / GaliciaSustentable
        email                : luipir AT gmail DOT com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Luigi Pirelli / GaliciaSustentable'
__date__ = '2020-04-14'
__copyright__ = '(C) 2020 by Luigi Pirelli / GaliciaSustentable'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsProcessingAlgorithm, QgsApplication
import processing
from .galiciasustentable_provider import GaliciaSustentableProvider
from . import galiciasustentable_constants

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)

# eventually
libs = os.path.abspath(os.path.dirname(__file__) + '/libs')
if os.path.exists(libs) and libs not in sys.path:
    sys.path.insert(0, libs)


class GaliciaSustentablePlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = GaliciaSustentableProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

        # add actions to start processing GUI directly from main interface
        # self.actionSeverityMapAndPerimeter = QAction('Calc severity map and perimeter', self.iface.mainWindow())
        # self.actionSeverityMapAndPerimeter.triggered.connect(self.startSeverityMapAndPerimeter)
        # self.iface.addPluginToMenu(galiciasustentable_constants.PLUGIN_DOMAIN, self.actionSeverityMapAndPerimeter)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        # self.iface.removePluginMenu(galiciasustentable_constants.PLUGIN_DOMAIN, self.actionSeverityMapAndPerimeter)
    
    # def startSeverityMapAndPerimeter(self):
    #     initial_params={}
    #     results = processing.execAlgorithmDialog('model:Severity map and perimeter generation', initial_params)
