# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FuzzyJoinDialog
                                 A QGIS plugin
 Join tables using min Damerau-Levenshtein distance
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-04-09
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Zoltán Siki
        email                : siki1958@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets, QtCore

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'fuzzy_join_dialog_base.ui'))


class FuzzyJoinDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(FuzzyJoinDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.baseCombo.currentIndexChanged.connect(self.fillBaseColumn)
        self.joinedCombo.currentIndexChanged.connect(self.fillJoinColumn)

    def showEvent(self, event):
        """ initialize widgets """
        self.baseCombo.view().setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAsNeeded)
        self.joinedCombo.view().setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAsNeeded)
        self.matchSpin.setValue(85)
        self.baseCombo.setCurrentIndex(-1)
        self.joinedCombo.setCurrentIndex(-1)

    def fillBaseColumn(self):
        """ update column list """
        self.baseFieldCombo.setLayer(self.baseCombo.currentLayer())

    def fillJoinColumn(self):
        """ update column list """
        self.joinedFieldCombo.setLayer(self.joinedCombo.currentLayer())
