# Fun Reprojector

2024-03-19 by Junta Taguasari

## Functionality

Same as the native QGIS reprojection tool, `native:reprojector`.

## How to use

Install as the QGIS plugin.
Only the items registered in `crs` directory are used.

## Contribution

Any contribution is welcome. Especially, providing the avatar images and information for the CRS is appreciated.
The information for the CRS is stored in the following structure:

```
- directory (EPSG code)
  - avatar.png
  - info.json
```

See `crs/4326` for the example.

Here is the sample of the prompt to generate the information using AIs:
```
You are a top-notch geospatial data scientist and storyteller. For the benefit of those new to geospatial data and as a break from the daily grind, we have decided to anthropomorphize the coordinate system used in the analysis. Please anthropomorphize the coordinate system EPSG:4326 and summarize the information in the following json format:
{
 "code": EPSG code, formatted as EPSG:{code}
 "avatar_description": description of the avatar, approx 100 words
 "crs_title": name of the crs
 "crs_description": description of the crs, approx 100 words
}
```


## 日本語解説

QGISの標準リプロジェクトツール`native:reprojector`と同様の機能を持つプラグインで，座標系の擬人化を中心とした（？）プラグインです。
プラグインの`crs`フォルダに登録されたCRSのみが利用可能です。

参考→<https://qiita.com/jtagusari/items/3d8dbf3382ceff87609e>

画像や擬人化の設定情報の提供をお待ちしております。
`crs/4326`フォルダと同様に，`avatar.jpg`と`info.json`があれば，プラグインに追加されます。

AIに食わせるサンプルは以下
```
あなたは一流の地理空間データサイエンティストでありストーリーテラーです。地理空間データの初学者のために，また日々の業務の息抜きのために，解析に使われる座標系を擬人化することにしました。座標系EPSG:4326を擬人化して以下のjson形式で情報をまとめてください。
{
 "code": EPSG code, formatted as EPSG:{code}
 "avatar_description": description of the avatar, approx 100 words
 "crs_title": name of the crs
 "crs_description": description of the crs, approx 100 words
 "avatar_description_ja": アバターの説明
 "crs_description_ja": 座標系の説明
}
```