BEGIN TRANSACTION;

INSERT INTO `ReferenceSystems` VALUES (1,'Alicante',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `ReferenceSystems` VALUES (2,'ETRS_1989_UTM_Zone_31N',NULL,NULL,NULL,NULL,NULL);

INSERT INTO `HydrogeologicalUnits` VALUES (9,'upperAquiferTest','acuifero superior del Delta del Llobregat','upper aquifer of the Llobregat Delta',NULL,NULL,1,NULL,NULL,NULL);
INSERT INTO `HydrogeologicalUnits` VALUES (10,'lowerAquiferTest',NULL,'lower aquifer of the Llobregat Delta',NULL,NULL,1,NULL,NULL,NULL);
INSERT INTO `HydrogeologicalUnits` VALUES (11,'aquicludeTest',NULL,'test aquiclude',NULL,NULL,3,NULL,NULL,NULL);

INSERT INTO 'Points' VALUES (1,'P1','Dinonino River','DANONINO',NULL,NULL,431168020081,45846213501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e61000003018951400511a41d40968562b7d51413018951400511a41d40968562b7d51417c010000003018951400511a41d40968562b7d5141fe');
INSERT INTO 'Points' VALUES (2,'P10','Santiago Spring','SANTILLANA','S3',NULL,432525544922,458997641248,2529,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e61000000044fa2d36661a416666661a668251410044fa2d36661a416666661a668251417c010000000044fa2d36661a416666661a66825141fe');
INSERT INTO 'Points' VALUES (3,'P11','School Well','SCUOLA','S4',NULL,433660000122,458903999707,17086,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL, X'0001e6100000e0361a00f0771a41847cd0ff7b815141e0361a00f0771a41847cd0ff7b8151417c01000000e0361a00f0771a41847cd0ff7b815141fe');
INSERT INTO 'Points' VALUES (4,'P12','Txalete Well','TXALET','S5',NULL,43085872113,458277701611,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e6100000d00968e22a4c1a414cc807415e7b5141d00968e22a4c1a414cc807415e7b51417c01000000d00968e22a4c1a414cc807415e7b5141fe');
INSERT INTO 'Points' VALUES (5,'P2','Expositions Company Well','EXPOSICION',NULL,NULL,428407248718,458149089709,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e61000008036abfedc251a411e166ab91c7a51418036abfedc251a411e166ab91c7a51417c010000008036abfedc251a411e166ab91c7a5141fe');
INSERT INTO 'Points' VALUES (6,'P3','Rio Helado','FRIGOPIE',NULL,NULL,432962066284,458464189209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e6100000b025e443086d1a419a2a1879307d5141b025e443086d1a419a2a1879307d51417c01000000b025e443086d1a419a2a1879307d5141fe');
INSERT INTO 'Points' VALUES (7,'P4','Hocoriscausa Well','HOCORIS',NULL,NULL,431194576721,458140225909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e6100000e0718a4e6a511a412a189590067a5141e0718a4e6a511a412a189590067a51417c01000000e0718a4e6a511a412a189590067a5141fe');
INSERT INTO 'Points' VALUES (8,'P5','Barna Sea','MANSO',NULL,NULL,429844961121,458108880908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e610000030992ad8533c1a415e4bc833b879514130992ad8533c1a415e4bc833b87951417c0100000030992ad8533c1a415e4bc833b8795141fe');
INSERT INTO 'Points' VALUES (9,'P6','Maqui Well','MAQUIAVELO',NULL,NULL,433176188904,458820067712,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e610000070006fc160701a413e9b552baa80514170006fc160701a413e9b552baa8051417c0100000070006fc160701a413e9b552baa805141fe');
INSERT INTO 'Points' VALUES (10,'P7','Buscaawally Well','MONTEPERDIDO',NULL,NULL,433630001099,458727000012,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e6100000c05b200178771a416ea30180c17f5141c05b200178771a416ea30180c17f51417c01000000c05b200178771a416ea30180c17f5141fe');
INSERT INTO 'Points' VALUES (11,'P8','Pepepig Well','PUGCERDI','S1',NULL,433624078308,458849928412,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e610000010e02d5060771a41c4b12ed2f480514110e02d5060771a41c4b12ed2f48051417c0100000010e02d5060771a41c4b12ed2f4805141fe');
INSERT INTO 'Points' VALUES (12,'P9','Magdalena Spring','REGADIO','S2',NULL,432849999695,45900000011,20,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e6100000505bb1ff476b1a41bc0512006c825141505bb1ff476b1a41bc0512006c8251417c01000000505bb1ff476b1a41bc0512006c825141fe');

INSERT INTO `HydrogeologicalUnitsApparence` VALUES (1,NULL,9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,X'0001e610000030a91390f6051a41fccbeedd1b7a514140e8d9ec6a841a41164850f8978251417c03000000010000000500000070ce88920b261a41fccbeedd1b7a514130a91390f6051a41a4923af9dd7b5141e0f97eea55641a41164850f89782514140e8d9ec6a841a41708104ddd580514170ce88920b261a41fccbeedd1b7a5141fe');

INSERT INTO `ResponsibleParties` VALUES (1,'EU',NULL,'Union Europea',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL);
INSERT INTO `ResponsibleParties` VALUES (2,'EXLAB3',NULL,'Exemple entitat 3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `ResponsibleParties` VALUES (3,'EXOWNER1',NULL,'Exemple entitat 1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `ResponsibleParties` VALUES (4,'EXOWNER2',NULL,'Exemple entitat 2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `ResponsibleParties` VALUES (5,'EXPER5',NULL,'Example person name 5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `ResponsibleParties` VALUES (6,'WNA4',NULL,'Water National Agency exemple 4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `Citations` VALUES (8,'DTMEXEMPLE2',NULL,NULL,NULL,'MDT desarrollado por Instituto geografia (2013) ejemplo',1,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Citations` VALUES (9,'ESCECYT',NULL,NULL,NULL,'Spanish European Project ejemplo',1,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Citations` VALUES (10,'EU-9985569-02',NULL,NULL,NULL,'Erupean Project of water research ejemplo',1,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Citations` VALUES (11,'EXAMPLE1',NULL,NULL,NULL,'Report of Hydrogeochemistry provided by CHEM S.A ejemplo',2,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Citations` VALUES (12,'Example2 et al., 2014',NULL,NULL,NULL,'Example2.1.QUIMET. C&G.Vol1(3), 114-116 (2014)',14,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Citations` VALUES (13,'EXDMA',NULL,NULL,NULL,'Ejemplo de una directiva marco del agua local',1,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Citations` VALUES (14,'EXEWFD',NULL,NULL,NULL,'European Water Frame Directive',1,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Citations` VALUES (15,NULL,NULL,NULL,NULL,'viol',NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `Wells` VALUES (1,NULL,2,NULL,NULL,30.0,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,1,NULL,NULL);
INSERT INTO `Wells` VALUES (2,NULL,3,NULL,NULL,40.0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `WellsHydrogeologicalUnit` VALUES (1,0.0,20.0,9,NULL,NULL);
INSERT INTO `WellsHydrogeologicalUnit` VALUES (1,20.0,25.0,11,NULL,NULL);
INSERT INTO `WellsHydrogeologicalUnit` VALUES (1,25.0,30.0,10,NULL,NULL);
INSERT INTO `WellsHydrogeologicalUnit` VALUES (2,0.0,20.0,9,NULL,NULL);
INSERT INTO `WellsHydrogeologicalUnit` VALUES (2,20.0,34.0,11,NULL,NULL);
INSERT INTO `WellsHydrogeologicalUnit` VALUES (2,34.0,40.0,10,NULL,NULL);

INSERT INTO `Screens` VALUES (1,'screen1',2,1,NULL,NULL,NULL,NULL);

INSERT INTO `WellScreens` VALUES (1,1,0.0,20.0,3,NULL,9,NULL,NULL);

INSERT INTO `Springs` VALUES (1,NULL,6,2,1,NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `Projects` VALUES (1,'Pr1','ProjectEU',NULL,NULL,10,1,NULL,NULL,NULL);
INSERT INTO `Projects` VALUES (2,'Pr2','ProjectES',NULL,NULL,9,5,NULL,NULL,NULL);
INSERT INTO `Projects` VALUES (3,'Pr3','ProjectBCN',NULL,NULL,12,NULL,NULL,NULL,NULL);

INSERT INTO `HydrogeologicalPointsObservations` VALUES (1,'headObservation_P11',3,14,NULL,NULL,NULL,NULL,'2005-08-01 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrogeologicalPointsObservations` VALUES (2,'headObservation_P10',2,14,NULL,NULL,NULL,NULL,'2003-08-01 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `HydrogeologicalPointsMeasurements` VALUES (1, 1,'2005-08-01 00:00:00.000',23.0,NULL,NULL,NULL);
INSERT INTO `HydrogeologicalPointsMeasurements` VALUES (2, 1,'2005-08-02 00:00:00.000',20.0,NULL,NULL,NULL);
INSERT INTO `HydrogeologicalPointsMeasurements` VALUES (3, 2,'2003-08-03 00:00:00.000',19.5,NULL,NULL,NULL);
INSERT INTO `HydrogeologicalPointsMeasurements` VALUES (4, 2,'2003-08-04 00:00:00.000',18.0,NULL,NULL,NULL);
INSERT INTO `HydrogeologicalPointsMeasurements` VALUES (5, 1,'2004-08-05 00:00:00.000',10.0,NULL,NULL,NULL);

INSERT INTO `Campaigns` VALUES (12,'Campaign1',2,1,'1973-09-01 00:00:00.000','1973-09-02 00:00:00.000',2,2,3,5,NULL,NULL);
INSERT INTO `Campaigns` VALUES (13,'Campaign10',2,3,'2010-05-30 00:00:00.000','2010-11-24 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Campaigns` VALUES (14,'Campaign11',2,3,'2013-11-26 00:00:00.000','2014-02-20 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Campaigns` VALUES (15,'Campaign2',2,1,'1996-12-17 00:00:00.000','1996-12-19 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Campaigns` VALUES (16,'Campaign3',2,1,'1997-04-30 00:00:00.000','1997-11-20 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Campaigns` VALUES (17,'Campaign4',2,1,'1998-01-29 00:00:00.000','1998-01-30 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Campaigns` VALUES (18,'Campaign5',2,2,'1998-10-15 00:00:00.000','1998-10-16 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Campaigns` VALUES (19,'Campaign6',2,1,'1999-01-27 00:00:00.000','1999-01-28 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Campaigns` VALUES (20,'Campaign7',2,1,'2001-10-24 00:00:00.000','2001-10-24 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Campaigns` VALUES (21,'Campaign8',2,3,'2003-01-28 00:00:00.000','2003-01-29 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `Campaigns` VALUES (22,'Campaign9',2,3,'2006-09-24 00:00:00.000','2006-12-13 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `AquiferSystems` VALUES (1,'Llobregat',NULL,NULL,1,NULL,NULL);

INSERT INTO `Aquitards` VALUES (1,11,NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `Aquifers` VALUES (1,9,3,2,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `HydrochemicalSamples` VALUES (85,'P12-2014',4,'2014-02-20 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (86,'P11-2014',3,'2014-02-20 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (87,'P1-2014',1,'2014-02-12 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (88,'P10-2014',2,'2014-02-04 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (89,'P7-2014',10,'2014-01-19 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (90,'P6-2014',9,'2014-01-15 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (91,'P5-2014',8,'2014-01-11 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (92,'P9-2014',12,'2014-01-07 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (93,'P8-2014',11,'2014-01-03 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (94,'P7-2013',10,'2013-12-22 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (95,'P6-2013',9,'2013-12-16 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (96,'P5-2013',8,'2013-12-08 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (97,'P4-2013',7,'2013-12-04 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (98,'P3-2013',6,'2013-12-03 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (99,'P2-2013',5,'2013-12-02 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (100,'P12-2013',4,'2013-11-29 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (101,'P11-2013',3,'2013-11-28 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (102,'P10-2013',2,'2013-11-27 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (103,'P1-2013',1,'2013-11-26 00:00:00.000',14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (104,'P12_CUP0612',4,'2006-12-13 00:00:00.000',22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (105,'P11_CAG0110-005',3,'2001-10-24 00:00:00.000',20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (106,'P10_CUP9711-004',2,'1997-11-20 00:00:00.000',16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (107,'P10_CUP0610',2,'2006-10-25 00:00:00.000',22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (108,'P9_CAG0110-004',12,'2001-10-24 00:00:00.000',20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (109,'P8_CUP9612-015',11,'1996-12-19 00:00:00.000',15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (110,'P8_CUP0610',11,'2006-10-24 00:00:00.000',22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (111,'P7_CUP0609',10,'2006-09-24 00:00:00.000',22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (112,'P6_CUP_7309',9,'1973-09-01 00:00:00.000',12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (113,'P5_CPR1011',8,'2010-05-30 00:00:00.000',13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (114,'P5_CCL0301',8,'2003-01-28 00:00:00.000',21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (115,'P4_CUP9612-002',7,'1996-12-17 00:00:00.000',15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (116,'P4_CPR1011',7,'2010-05-30 00:00:00.000',13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (117,'P3_CUP0610',6,'2006-10-24 00:00:00.000',22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (118,'P3_CCL0301',6,'2003-01-29 00:00:00.000',21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (119,'P2_CUP9901-012',5,'1999-01-27 00:00:00.000',19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (120,'P2_CUP9810-026',5,'1998-10-15 00:00:00.000',18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (121,'P2_CUP9801-007',5,'1998-01-29 00:00:00.000',17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (122,'P2_CUP9704-017',5,'1997-04-30 00:00:00.000',16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (123,'P2_CPR1011',5,'2010-11-24 00:00:00.000',13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (124,'P1_CUP9710-010',1,'1997-10-29 00:00:00.000',16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (125,'P1_CUP9612-012',1,'1996-12-19 00:00:00.000',15,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalSamples` VALUES (126,'P1_CUP0611',1,'2006-11-08 00:00:00.000',22,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `HydrochemicalMeasurements` VALUES (1,106,1,'1997-11-20 00:00:00.000',NULL,'<0.20',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (2,106,1064,'1997-11-20 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (3,106,19,'1997-11-20 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (4,106,104,'1997-11-20 00:00:00.000',NULL,'<0.15',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (5,106,753,'1997-11-20 00:00:00.000',NULL,'<0.10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (6,106,605,'1997-11-20 00:00:00.000',NULL,'<0.10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (7,106,11,'1997-11-20 00:00:00.000',NULL,'<0.10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (8,106,40,'1997-11-20 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (9,106,556,'1997-11-20 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (10,106,381,'1997-11-20 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (11,106,38,'1997-11-20 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (12,106,979,'1997-11-20 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (13,106,470,'1997-11-20 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (14,121,1054,'1998-01-29 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (15,119,1054,'1999-01-27 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (16,119,257,'1999-01-27 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (17,106,939,'1997-11-20 00:00:00.000',NULL,'<0.08',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (18,106,852,'1997-11-20 00:00:00.000',NULL,'<0.06',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (19,106,784,'1997-11-20 00:00:00.000',NULL,'<0.06',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (20,106,33,'1997-11-20 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (21,106,52,'1997-11-20 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (22,106,353,'1997-11-20 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (23,106,1143,'1997-11-20 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (24,106,5,'1997-11-20 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (25,106,28,'1997-11-20 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (26,121,703,'1998-01-29 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (27,106,112,'1997-11-20 00:00:00.000',NULL,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (28,106,831,'1997-11-20 00:00:00.000',NULL,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (29,106,161,'1997-11-20 00:00:00.000',NULL,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (30,106,306,'1997-11-20 00:00:00.000',NULL,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (31,106,667,'1997-11-20 00:00:00.000',NULL,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (32,106,119,'1997-11-20 00:00:00.000',NULL,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (33,106,420,'1997-11-20 00:00:00.000',NULL,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (34,125,703,'1996-12-19 00:00:00.000',NULL,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (35,106,75,'1997-11-20 00:00:00.000',NULL,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (36,106,670,'1997-11-20 00:00:00.000',NULL,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (37,106,905,'1997-11-20 00:00:00.000',NULL,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (38,106,798,'1997-11-20 00:00:00.000',NULL,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (39,106,128,'1997-11-20 00:00:00.000',NULL,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (40,115,703,'1996-12-17 00:00:00.000',NULL,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (41,109,703,'1996-12-19 00:00:00.000',NULL,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (42,106,722,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (43,106,864,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (44,106,303,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (45,106,764,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (46,106,720,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (47,106,137,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (48,106,776,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (49,106,164,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (50,106,716,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (51,106,66,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (52,106,187,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (53,106,417,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (54,106,795,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (55,106,640,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (56,106,356,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (57,106,69,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (58,106,1102,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (59,106,561,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (60,106,1098,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (61,106,749,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (62,106,870,'1997-11-20 00:00:00.000',NULL,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (63,126,788,'2006-11-08 00:00:00.000',0.636,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (64,126,645,'2006-11-08 00:00:00.000',901.84,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (65,126,414,'2006-11-08 00:00:00.000',97.93,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (66,126,292,'2006-11-08 00:00:00.000',22.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (67,126,514,'2006-11-08 00:00:00.000',39.38,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (68,126,638,'2006-11-08 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (69,126,636,'2006-11-08 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (70,126,283,'2006-11-08 00:00:00.000',0.41,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (71,126,876,'2006-11-08 00:00:00.000',0.67,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (72,126,896,'2006-11-08 00:00:00.000',0.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (73,126,813,'2006-11-08 00:00:00.000',58.92,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (74,93,894,'2014-01-03 00:00:00.000',6.011,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (75,93,410,'2014-01-03 00:00:00.000',2.389,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (76,93,1003,'2014-01-03 00:00:00.000',3.548,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (77,93,321,'2014-01-03 00:00:00.000',0.231,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (78,93,904,'2014-01-03 00:00:00.000',0.335,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (79,93,1031,'2014-01-03 00:00:00.000',3.129,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (80,93,505,'2014-01-03 00:00:00.000',0.755,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (81,92,47,'2014-01-07 00:00:00.000',0.526,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (82,92,321,'2014-01-07 00:00:00.000',0.001,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (83,92,347,'2014-01-07 00:00:00.000',0.175,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (84,92,505,'2014-01-07 00:00:00.000',0.35,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (85,92,904,'2014-01-07 00:00:00.000',0.087,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (86,92,1209,'2014-01-07 00:00:00.000',1.754,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (87,92,442,'2014-01-07 00:00:00.000',8.771,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (88,92,899,'2014-01-07 00:00:00.000',8.771,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (89,92,1003,'2014-01-07 00:00:00.000',1.754,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (90,92,270,'2014-01-07 00:00:00.000',0.877,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (91,92,894,'2014-01-07 00:00:00.000',3.508,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (92,92,836,'2014-01-07 00:00:00.000',0.175,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (93,92,514,'2014-01-07 00:00:00.000',8.771,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (94,92,314,'2014-01-07 00:00:00.000',0.175,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (95,92,410,'2014-01-07 00:00:00.000',0.877,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (96,92,283,'2014-01-07 00:00:00.000',1.754,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (97,92,1031,'2014-01-07 00:00:00.000',1.754,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (98,105,700,'2001-10-24 00:00:00.000',25.0,'<50',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (99,107,638,'2006-10-25 00:00:00.000',3.0,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (100,107,514,'2006-10-25 00:00:00.000',3.0,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (101,107,1003,'2006-10-25 00:00:00.000',3.0,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (102,107,894,'2006-10-25 00:00:00.000',3.0,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (103,107,345,'2006-10-25 00:00:00.000',3.0,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (104,105,638,'2001-10-24 00:00:00.000',2.5,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (105,105,1159,'2001-10-24 00:00:00.000',2.5,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (106,105,1075,'2001-10-24 00:00:00.000',2.5,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (107,105,710,'2001-10-24 00:00:00.000',2.5,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (108,105,1003,'2001-10-24 00:00:00.000',2.5,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (109,105,345,'2001-10-24 00:00:00.000',2.5,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (110,105,954,'2001-10-24 00:00:00.000',2.5,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (111,105,786,'2001-10-24 00:00:00.000',2.5,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (112,105,769,'2001-10-24 00:00:00.000',2.5,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (113,114,1058,'2003-01-28 00:00:00.000',2.0,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (114,111,514,'2006-09-24 00:00:00.000',3.0,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (115,111,638,'2006-09-24 00:00:00.000',3.0,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (116,111,1003,'2006-09-24 00:00:00.000',3.0,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (117,124,245,'1997-10-29 00:00:00.000',NULL,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (118,124,1153,'1997-10-29 00:00:00.000',NULL,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (119,124,441,'1997-10-29 00:00:00.000',NULL,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (120,124,282,'1997-10-29 00:00:00.000',NULL,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (121,122,1153,'1997-04-30 00:00:00.000',NULL,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (122,122,441,'1997-04-30 00:00:00.000',NULL,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (123,119,1153,'1999-01-27 00:00:00.000',NULL,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (124,119,441,'1999-01-27 00:00:00.000',NULL,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (125,119,282,'1999-01-27 00:00:00.000',NULL,'<5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (126,118,269,'2003-01-29 00:00:00.000',NULL,'<4',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (127,114,269,'2003-01-28 00:00:00.000',NULL,'<4',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (128,125,820,'1996-12-19 00:00:00.000',NULL,'<30',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (129,124,820,'1997-10-29 00:00:00.000',NULL,'<30',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (130,122,820,'1997-04-30 00:00:00.000',NULL,'<30',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (131,119,820,'1999-01-27 00:00:00.000',NULL,'<30',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (132,115,820,'1996-12-17 00:00:00.000',NULL,'<30',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (133,109,820,'1996-12-19 00:00:00.000',NULL,'<30',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (134,106,933,'1997-11-20 00:00:00.000',1.5,'<3',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (135,107,1024,'2006-10-25 00:00:00.000',13.0,'<25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (136,105,1024,'2001-10-24 00:00:00.000',12.5,'<25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (137,105,246,'2001-10-24 00:00:00.000',12.5,'<25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (138,111,1024,'2006-09-24 00:00:00.000',13.0,'<25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (139,114,1153,'2003-01-28 00:00:00.000',NULL,'<25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (140,111,704,'2006-09-24 00:00:00.000',10.0,'<20',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (141,107,493,'2006-10-25 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (142,107,1154,'2006-10-25 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (143,107,876,'2006-10-25 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (144,107,279,'2006-10-25 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (145,107,1110,'2006-10-25 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (146,107,283,'2006-10-25 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (147,107,500,'2006-10-25 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (148,107,1031,'2006-10-25 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (149,107,333,'2006-10-25 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (150,107,270,'2006-10-25 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (151,106,441,'1997-11-20 00:00:00.000',1.9,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (152,105,270,'2001-10-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (153,105,279,'2001-10-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (154,105,1154,'2001-10-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (155,105,876,'2001-10-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (156,105,333,'2001-10-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (157,105,283,'2001-10-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (158,105,1110,'2001-10-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (159,114,278,'2003-01-28 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (160,111,500,'2006-09-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (161,111,283,'2006-09-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (162,111,1154,'2006-09-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (163,111,270,'2006-09-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (164,111,1110,'2006-09-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (165,111,279,'2006-09-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (166,111,876,'2006-09-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (167,111,333,'2006-09-24 00:00:00.000',1.0,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (168,124,269,'1997-10-29 00:00:00.000',NULL,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (169,124,1030,'1997-10-29 00:00:00.000',NULL,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (170,122,1030,'1997-04-30 00:00:00.000',NULL,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (171,119,269,'1999-01-27 00:00:00.000',NULL,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (172,119,1030,'1999-01-27 00:00:00.000',NULL,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (173,118,278,'2003-01-29 00:00:00.000',NULL,'<2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (174,107,1165,'2006-10-25 00:00:00.000',50.0,'<100',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (175,105,1165,'2001-10-24 00:00:00.000',50.0,'<100',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (176,111,1165,'2006-09-24 00:00:00.000',50.0,'<100',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (177,106,523,'1997-11-20 00:00:00.000',5.0,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (178,105,442,'2001-10-24 00:00:00.000',5.0,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (179,105,524,'2001-10-24 00:00:00.000',5.0,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (180,124,893,'1997-10-29 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (181,124,683,'1997-10-29 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (182,124,523,'1997-10-29 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (183,124,1002,'1997-10-29 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (184,124,506,'1997-10-29 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (185,122,245,'1997-04-30 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (186,122,506,'1997-04-30 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (187,122,1002,'1997-04-30 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (188,122,893,'1997-04-30 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (189,122,683,'1997-04-30 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (190,122,523,'1997-04-30 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (191,119,1002,'1999-01-27 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (192,119,893,'1999-01-27 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (193,119,523,'1999-01-27 00:00:00.000',NULL,'<10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (194,107,410,'2006-10-25 00:00:00.000',0.5,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (195,105,410,'2001-10-24 00:00:00.000',0.5,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (196,111,410,'2006-09-24 00:00:00.000',0.5,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (197,124,278,'1997-10-29 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (198,124,492,'1997-10-29 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (199,106,49,'1997-11-20 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (200,106,46,'1997-11-20 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (201,106,269,'1997-11-20 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (202,106,1030,'1997-11-20 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (203,106,409,'1997-11-20 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (204,106,278,'1997-11-20 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (205,122,492,'1997-04-30 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (206,119,492,'1999-01-27 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (207,119,278,'1999-01-27 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (208,118,492,'2003-01-29 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (209,114,492,'2003-01-28 00:00:00.000',NULL,'<1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (210,125,348,'1996-12-19 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (211,124,835,'1997-10-29 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (212,124,409,'1997-10-29 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (213,124,348,'1997-10-29 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (214,122,835,'1997-04-30 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (215,122,348,'1997-04-30 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (216,122,409,'1997-04-30 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (217,115,348,'1996-12-17 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (218,109,348,'1996-12-19 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (219,105,382,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (220,105,9,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (221,105,47,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (222,105,12,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (223,105,26,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (224,105,1062,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (225,105,50,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (226,105,1065,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (227,105,23,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (228,105,15,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (229,105,41,'2001-10-24 00:00:00.000',0.125,'<0.25',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (230,105,229,'2001-10-24 00:00:00.000',0.1,'<0.20',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (231,105,1083,'2001-10-24 00:00:00.000',0.1,'<0.20',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (232,105,1071,'2001-10-24 00:00:00.000',0.1,'<0.20',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (233,105,232,'2001-10-24 00:00:00.000',0.1,'<0.20',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (234,107,1115,'2006-10-25 00:00:00.000',0.1,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (235,111,1115,'2006-09-24 00:00:00.000',0.1,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (236,107,809,'2006-10-25 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (237,107,314,'2006-10-25 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (238,107,950,'2006-10-25 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (239,107,657,'2006-10-25 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (240,107,952,'2006-10-25 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (241,111,314,'2006-09-24 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (242,111,657,'2006-09-24 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (243,111,809,'2006-09-24 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (244,111,950,'2006-09-24 00:00:00.000',NULL,'<0.2',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (245,105,105,'2001-10-24 00:00:00.000',0.075,'<0.15',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (246,105,860,'2001-10-24 00:00:00.000',0.05,'<0.100',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (247,105,159,'2001-10-24 00:00:00.000',0.05,'<0.10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (248,105,759,'2001-10-24 00:00:00.000',0.05,'<0.10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (249,105,73,'2001-10-24 00:00:00.000',0.05,'<0.10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (250,105,394,'2001-10-24 00:00:00.000',0.05,'<0.10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (251,105,606,'2001-10-24 00:00:00.000',0.05,'<0.10',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (252,105,1099,'2001-10-24 00:00:00.000',0.05,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (253,118,1163,'2003-01-29 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (254,114,347,'2003-01-28 00:00:00.000',NULL,'<0.1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (255,105,87,'2001-10-24 00:00:00.000',0.04,'<0.08',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (256,105,601,'2001-10-24 00:00:00.000',0.04,'<0.08',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (257,105,940,'2001-10-24 00:00:00.000',0.04,'<0.08',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (258,105,714,'2001-10-24 00:00:00.000',0.03,'<0.06',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (259,105,853,'2001-10-24 00:00:00.000',0.03,'<0.06',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (260,105,1108,'2001-10-24 00:00:00.000',0.025,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (261,105,1144,'2001-10-24 00:00:00.000',0.025,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (262,105,1139,'2001-10-24 00:00:00.000',0.025,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (263,105,1041,'2001-10-24 00:00:00.000',0.025,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (264,105,836,'2001-10-24 00:00:00.000',0.025,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (265,105,354,'2001-10-24 00:00:00.000',0.025,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (266,107,836,'2006-10-25 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (267,118,702,'2003-01-29 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (268,114,702,'2003-01-28 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (269,111,836,'2006-09-24 00:00:00.000',NULL,'<0.05',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (270,105,476,'2001-10-24 00:00:00.000',0.0225,'<0.045',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (271,107,476,'2006-10-25 00:00:00.000',NULL,'<0.045',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (272,111,476,'2006-09-24 00:00:00.000',NULL,'<0.045',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (273,105,1085,'2001-10-24 00:00:00.000',0.02,'<0.040',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (274,105,647,'2001-10-24 00:00:00.000',0.02,'<0.040',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (275,105,526,'2001-10-24 00:00:00.000',0.02,'<0.040',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (276,105,600,'2001-10-24 00:00:00.000',0.02,'<0.040',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (277,105,219,'2001-10-24 00:00:00.000',0.02,'<0.040',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (278,105,841,'2001-10-24 00:00:00.000',0.02,'<0.040',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (279,105,904,'2001-10-24 00:00:00.000',0.02,'<0.04',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (280,111,904,'2006-09-24 00:00:00.000',NULL,'<0.04',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (281,105,1135,'2001-10-24 00:00:00.000',0.0175,'<0.035',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (282,105,858,'2001-10-24 00:00:00.000',0.0175,'<0.035',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (283,105,622,'2001-10-24 00:00:00.000',0.0175,'<0.035',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (284,107,1135,'2006-10-25 00:00:00.000',NULL,'<0.035',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (285,111,1135,'2006-09-24 00:00:00.000',NULL,'<0.035',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (286,105,619,'2001-10-24 00:00:00.000',0.015,'<0.030',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (287,105,712,'2001-10-24 00:00:00.000',0.015,'<0.030',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (288,105,120,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (289,105,162,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (290,105,311,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (291,105,239,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (292,105,664,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (293,105,668,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (294,105,435,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (295,105,596,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (296,105,113,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (297,105,873,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (298,105,201,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (299,105,832,'2001-10-24 00:00:00.000',0.015,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (300,118,819,'2003-01-29 00:00:00.000',NULL,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (301,114,819,'2003-01-28 00:00:00.000',NULL,'<0.03',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (302,105,538,'2001-10-24 00:00:00.000',0.0125,'<0.025',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (303,105,472,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (304,105,1141,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (305,105,314,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (306,105,1068,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (307,105,76,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (308,105,772,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (309,105,266,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (310,105,884,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (311,105,177,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (312,105,113,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (313,105,129,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (314,105,168,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (315,105,171,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (316,105,174,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (317,105,421,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (318,105,242,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (319,105,743,'2001-10-24 00:00:00.000',0.01,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (320,118,522,'2003-01-29 00:00:00.000',NULL,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (321,114,522,'2003-01-28 00:00:00.000',NULL,'<0.02',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (322,107,733,'2006-10-25 00:00:00.000',0.008,'<0.015',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (323,107,587,'2006-10-25 00:00:00.000',0.008,'<0.015',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (324,107,736,'2006-10-25 00:00:00.000',0.008,'<0.015',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (325,105,1018,'2001-10-24 00:00:00.000',0.0075,'<0.015',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (326,111,587,'2006-09-24 00:00:00.000',0.008,'<0.015',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (327,111,733,'2006-09-24 00:00:00.000',0.008,'<0.015',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (328,111,736,'2006-09-24 00:00:00.000',0.008,'<0.015',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (329,111,236,'2006-09-24 00:00:00.000',0.008,'<0.015',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (330,105,992,'2001-10-24 00:00:00.000',0.005,'<0.010',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (331,105,212,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (332,105,165,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (333,105,777,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (334,105,138,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (335,105,1133,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (336,105,452,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (337,105,125,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (338,105,376,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (339,105,110,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (340,105,360,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (341,105,131,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (342,105,404,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (343,105,399,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (344,105,357,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (345,105,1103,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (346,105,188,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (347,105,871,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (348,105,868,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (349,105,562,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (350,105,418,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (351,105,914,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (352,105,723,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (353,105,725,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (354,105,796,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (355,105,70,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (356,105,67,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (357,105,95,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (358,105,81,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (359,105,304,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (360,105,888,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (361,105,91,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (362,105,343,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (363,105,307,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (364,105,641,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (365,105,765,'2001-10-24 00:00:00.000',0.005,'<0.01',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (366,118,1029,'2003-01-29 00:00:00.000',NULL,'<0.009',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (367,114,1029,'2003-01-28 00:00:00.000',NULL,'<0.009',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (368,105,717,'2001-10-24 00:00:00.000',0.0025,'<0.005',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (369,118,1001,'2003-01-29 00:00:00.000',NULL,'<0.005',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (370,118,444,'2003-01-29 00:00:00.000',NULL,'<0.005',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (371,118,892,'2003-01-29 00:00:00.000',NULL,'<0.005',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (372,114,1001,'2003-01-28 00:00:00.000',NULL,'<0.005',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (373,114,444,'2003-01-28 00:00:00.000',NULL,'<0.005',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (374,114,892,'2003-01-28 00:00:00.000',NULL,'<0.005',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (375,118,281,'2003-01-29 00:00:00.000',NULL,'<0.004',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (376,114,281,'2003-01-28 00:00:00.000',NULL,'<0.004',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (377,118,408,'2003-01-29 00:00:00.000',NULL,'<0.001',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (378,114,408,'2003-01-28 00:00:00.000',NULL,'<0.001',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (379,114,834,'2003-01-28 00:00:00.000',NULL,'<0.001',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (380,106,60,'1997-11-20 00:00:00.000',0.3,'<0.6',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (381,106,22,'1997-11-20 00:00:00.000',0.3,'<0.6',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (382,106,1061,'1997-11-20 00:00:00.000',0.3,'<0.6',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (383,122,703,'1997-04-30 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (384,119,835,'1999-01-27 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (385,119,348,'1999-01-27 00:00:00.000',NULL,'<0.5',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (386,106,43,'1997-11-20 00:00:00.000',NULL,'<0.3',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (387,106,57,'1997-11-20 00:00:00.000',NULL,'<0.3',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (388,126,805,'2006-11-08 00:00:00.000',16.87,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (389,126,886,'2006-11-08 00:00:00.000',22.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (390,126,899,'2006-11-08 00:00:00.000',86.61,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (391,126,630,'2006-11-08 00:00:00.000',6.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (392,126,433,'2006-11-08 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (393,126,479,'2006-11-08 00:00:00.000',94.17,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (394,126,455,'2006-11-08 00:00:00.000',31.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (395,126,1046,'2006-11-08 00:00:00.000',64.74,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (396,126,1117,'2006-11-08 00:00:00.000',30.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (397,126,700,'2006-11-08 00:00:00.000',27.09,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (398,126,1127,'2006-11-08 00:00:00.000',18.35,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (399,126,704,'2006-11-08 00:00:00.000',15.33,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (400,126,822,'2006-11-08 00:00:00.000',0.97,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (401,126,1050,'2006-11-08 00:00:00.000',181.43,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (402,126,438,'2006-11-08 00:00:00.000',0.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (403,126,179,'2006-11-08 00:00:00.000',1.35,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (404,126,437,'2006-11-08 00:00:00.000',0.14,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (405,126,1112,'2006-11-08 00:00:00.000',0.77,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (406,126,1150,'2006-11-08 00:00:00.000',4.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (407,126,372,'2006-11-08 00:00:00.000',0.14,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (408,126,1154,'2006-11-08 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (409,126,349,'2006-11-08 00:00:00.000',127.45,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (410,126,1165,'2006-11-08 00:00:00.000',7.88,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (411,126,345,'2006-11-08 00:00:00.000',0.38,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (412,126,339,'2006-11-08 00:00:00.000',304.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (413,126,333,'2006-11-08 00:00:00.000',0.34,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (414,126,299,'2006-11-08 00:00:00.000',26.75,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (415,126,295,'2006-11-08 00:00:00.000',125.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (416,126,1129,'2006-11-08 00:00:00.000',314.73,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (417,126,685,'2006-11-08 00:00:00.000',0.52,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (418,126,904,'2006-11-08 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (419,126,1073,'2006-11-08 00:00:00.000',249.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (420,126,919,'2006-11-08 00:00:00.000',0.08,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (421,126,500,'2006-11-08 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (422,126,693,'2006-11-08 00:00:00.000',320.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (423,126,493,'2006-11-08 00:00:00.000',0.27,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (424,126,948,'2006-11-08 00:00:00.000',6.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (425,126,270,'2006-11-08 00:00:00.000',4.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (426,126,270,'2006-11-08 00:00:00.000',0.13,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (427,126,983,'2006-11-08 00:00:00.000',7.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (428,126,254,'2006-11-08 00:00:00.000',0.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (429,126,507,'2006-11-08 00:00:00.000',0.16,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (430,126,1003,'2006-11-08 00:00:00.000',0.14,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (431,126,1094,'2006-11-08 00:00:00.000',296.38,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (432,126,1007,'2006-11-08 00:00:00.000',1.57,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (433,126,763,'2006-11-08 00:00:00.000',0.15,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (434,126,246,'2006-11-08 00:00:00.000',2.35,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (435,126,431,'2006-11-08 00:00:00.000',1090.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (436,126,1110,'2006-11-08 00:00:00.000',2.22,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (437,126,1024,'2006-11-08 00:00:00.000',1.23,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (438,126,468,'2006-11-08 00:00:00.000',30.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (439,126,1035,'2006-11-08 00:00:00.000',10.43,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (440,126,1083,'2006-11-08 00:00:00.000',0.39,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (441,125,415,'1996-12-19 00:00:00.000',531.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (442,125,828,'1996-12-19 00:00:00.000',7.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (443,125,683,'1996-12-19 00:00:00.000',85.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (444,125,431,'1996-12-19 00:00:00.000',781.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (445,125,482,'1996-12-19 00:00:00.000',400.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (446,125,294,'1996-12-19 00:00:00.000',5200.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (447,125,1049,'1996-12-19 00:00:00.000',0.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (448,125,1047,'1996-12-19 00:00:00.000',653.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (449,125,225,'1996-12-19 00:00:00.000',584.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (450,125,480,'1996-12-19 00:00:00.000',112.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (451,125,643,'1996-12-19 00:00:00.000',200.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (452,125,497,'1996-12-19 00:00:00.000',2900.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (453,125,499,'1996-12-19 00:00:00.000',3500.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (454,125,905,'1996-12-19 00:00:00.000',5.33,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (455,125,814,'1996-12-19 00:00:00.000',230.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (456,125,1051,'1996-12-19 00:00:00.000',100.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (457,125,292,'1996-12-19 00:00:00.000',3600.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (458,125,613,'1996-12-19 00:00:00.000',2273.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (459,125,900,'1996-12-19 00:00:00.000',89.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (460,124,1022,'1997-10-29 00:00:00.000',1717.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (461,124,703,'1997-10-29 00:00:00.000',2.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (462,124,294,'1997-10-29 00:00:00.000',9600.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (463,124,1164,'1997-10-29 00:00:00.000',85.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (464,124,1049,'1997-10-29 00:00:00.000',5.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (465,124,613,'1997-10-29 00:00:00.000',301.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (466,124,1047,'1997-10-29 00:00:00.000',95.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (467,124,431,'1997-10-29 00:00:00.000',1005.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (468,124,415,'1997-10-29 00:00:00.000',84.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (469,124,828,'1997-10-29 00:00:00.000',6.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (470,124,480,'1997-10-29 00:00:00.000',153.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (471,124,225,'1997-10-29 00:00:00.000',166.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (472,124,292,'1997-10-29 00:00:00.000',6400.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (473,124,1051,'1997-10-29 00:00:00.000',101.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (474,124,985,'1997-10-29 00:00:00.000',7.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (475,124,814,'1997-10-29 00:00:00.000',21.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (476,124,900,'1997-10-29 00:00:00.000',45.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (477,124,905,'1997-10-29 00:00:00.000',0.69,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (478,124,692,'1997-10-29 00:00:00.000',0.18,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (479,107,414,'2006-10-25 00:00:00.000',134.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (480,107,813,'2006-10-25 00:00:00.000',28.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (481,107,288,'2006-10-25 00:00:00.000',0.06,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (482,107,1050,'2006-10-25 00:00:00.000',165.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (483,107,904,'2006-10-25 00:00:00.000',0.07,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (484,107,704,'2006-10-25 00:00:00.000',67.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (485,107,1044,'2006-10-25 00:00:00.000',0.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (486,107,254,'2006-10-25 00:00:00.000',2.27,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (487,107,431,'2006-10-25 00:00:00.000',1388.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (488,107,983,'2006-10-25 00:00:00.000',7.21,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (489,107,292,'2006-10-25 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (490,107,270,'2006-10-25 00:00:00.000',6.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (491,107,805,'2006-10-25 00:00:00.000',17.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (492,107,1007,'2006-10-25 00:00:00.000',12.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (493,107,248,'2006-10-25 00:00:00.000',41.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (494,107,1046,'2006-10-25 00:00:00.000',143.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (495,107,507,'2006-10-25 00:00:00.000',12.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (496,107,1094,'2006-10-25 00:00:00.000',9.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (497,107,1073,'2006-10-25 00:00:00.000',329.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (498,107,899,'2006-10-25 00:00:00.000',16.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (499,107,339,'2006-10-25 00:00:00.000',401.38,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (500,107,1085,'2006-10-25 00:00:00.000',0.05,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (501,107,468,'2006-10-25 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (502,107,1035,'2006-10-25 00:00:00.000',9.28,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (503,107,693,'2006-10-25 00:00:00.000',0.39,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (504,107,1129,'2006-10-25 00:00:00.000',10.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (505,107,479,'2006-10-25 00:00:00.000',193.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (506,107,1088,'2006-10-25 00:00:00.000',0.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (507,107,685,'2006-10-25 00:00:00.000',6.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (508,107,349,'2006-10-25 00:00:00.000',226.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (509,107,433,'2006-10-25 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (510,107,299,'2006-10-25 00:00:00.000',68.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (511,107,645,'2006-10-25 00:00:00.000',640.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (512,107,822,'2006-10-25 00:00:00.000',11.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (513,107,1127,'2006-10-25 00:00:00.000',1.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (514,107,372,'2006-10-25 00:00:00.000',0.52,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (515,107,1112,'2006-10-25 00:00:00.000',2.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (516,106,90,'1997-11-20 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (517,106,820,'1997-11-20 00:00:00.000',206.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (518,106,1077,'1997-11-20 00:00:00.000',17.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (519,106,945,'1997-11-20 00:00:00.000',1.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (520,106,980,'1997-11-20 00:00:00.000',3.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (521,106,925,'1997-11-20 00:00:00.000',0.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (522,106,1073,'1997-11-20 00:00:00.000',394.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (523,106,912,'1997-11-20 00:00:00.000',0.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (524,106,274,'1997-11-20 00:00:00.000',0.44,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (525,106,1164,'1997-11-20 00:00:00.000',34.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (526,106,814,'1997-11-20 00:00:00.000',41.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (527,106,80,'1997-11-20 00:00:00.000',0.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (528,106,348,'1997-11-20 00:00:00.000',470.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (529,106,342,'1997-11-20 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (530,106,282,'1997-11-20 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (531,106,1051,'1997-11-20 00:00:00.000',193.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (532,106,810,'1997-11-20 00:00:00.000',0.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (533,106,340,'1997-11-20 00:00:00.000',480.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (534,106,1070,'1997-11-20 00:00:00.000',0.06,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (535,106,123,'1997-11-20 00:00:00.000',0.05,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (536,106,173,'1997-11-20 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (537,106,1047,'1997-11-20 00:00:00.000',175.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (538,106,1126,'1997-11-20 00:00:00.000',3.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (539,106,1123,'1997-11-20 00:00:00.000',0.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (540,106,200,'1997-11-20 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (541,106,158,'1997-11-20 00:00:00.000',0.05,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (542,106,1040,'1997-11-20 00:00:00.000',0.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (543,106,1114,'1997-11-20 00:00:00.000',0.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (544,106,387,'1997-11-20 00:00:00.000',0.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (545,106,459,'1997-11-20 00:00:00.000',0.05,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (546,106,228,'1997-11-20 00:00:00.000',0.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (547,106,109,'1997-11-20 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (548,106,124,'1997-11-20 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (549,106,1083,'1997-11-20 00:00:00.000',0.19,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (550,106,384,'1997-11-20 00:00:00.000',0.07,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (551,106,245,'1997-11-20 00:00:00.000',0.08,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (552,106,8,'1997-11-20 00:00:00.000',1.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (553,106,373,'1997-11-20 00:00:00.000',0.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (554,106,1002,'1997-11-20 00:00:00.000',2.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (555,106,506,'1997-11-20 00:00:00.000',9.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (556,106,480,'1997-11-20 00:00:00.000',252.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (557,106,519,'1997-11-20 00:00:00.000',5.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (558,106,985,'1997-11-20 00:00:00.000',7.17,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (559,106,14,'1997-11-20 00:00:00.000',1.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (560,106,257,'1997-11-20 00:00:00.000',2.09,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (561,106,231,'1997-11-20 00:00:00.000',0.06,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (562,106,415,'1997-11-20 00:00:00.000',175.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (563,106,403,'1997-11-20 00:00:00.000',0.05,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (564,106,613,'1997-11-20 00:00:00.000',609.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (565,106,893,'1997-11-20 00:00:00.000',9.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (566,106,887,'1997-11-20 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (567,106,566,'1997-11-20 00:00:00.000',0.18,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (568,106,758,'1997-11-20 00:00:00.000',0.25,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (569,106,398,'1997-11-20 00:00:00.000',0.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (570,106,63,'1997-11-20 00:00:00.000',32.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (571,106,883,'1997-11-20 00:00:00.000',0.27,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (572,106,656,'1997-11-20 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (573,106,835,'1997-11-20 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (574,106,683,'1997-11-20 00:00:00.000',15.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (575,106,313,'1997-11-20 00:00:00.000',0.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (576,106,431,'1997-11-20 00:00:00.000',1610.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (577,106,707,'1997-11-20 00:00:00.000',0.43,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (578,106,501,'1997-11-20 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (579,106,390,'1997-11-20 00:00:00.000',0.13,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (580,106,393,'1997-11-20 00:00:00.000',0.07,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (581,106,900,'1997-11-20 00:00:00.000',16.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (582,106,581,'1997-11-20 00:00:00.000',0.17,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (583,88,1003,'2014-02-04 00:00:00.000',2.941,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (584,88,314,'2014-02-04 00:00:00.000',0.294,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (585,88,283,'2014-02-04 00:00:00.000',2.941,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (586,88,894,'2014-02-04 00:00:00.000',5.882,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (587,88,321,'2014-02-04 00:00:00.000',0.002,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (588,88,347,'2014-02-04 00:00:00.000',0.294,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (589,88,270,'2014-02-04 00:00:00.000',1.47,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (590,88,514,'2014-02-04 00:00:00.000',14.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (591,88,1209,'2014-02-04 00:00:00.000',2.941,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (592,88,442,'2014-02-04 00:00:00.000',14.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (593,88,505,'2014-02-04 00:00:00.000',0.588,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (594,88,899,'2014-02-04 00:00:00.000',14.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (595,88,47,'2014-02-04 00:00:00.000',0.882,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (596,88,836,'2014-02-04 00:00:00.000',0.294,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (597,88,410,'2014-02-04 00:00:00.000',1.47,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (598,88,1031,'2014-02-04 00:00:00.000',2.941,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (599,88,904,'2014-02-04 00:00:00.000',0.147,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (600,105,671,'2001-10-24 00:00:00.000',0.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (601,105,468,'2001-10-24 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (602,105,536,'2001-10-24 00:00:00.000',0.21,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (603,105,385,'2001-10-24 00:00:00.000',0.05,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (604,105,1021,'2001-10-24 00:00:00.000',1300.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (605,105,685,'2001-10-24 00:00:00.000',9.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (606,105,288,'2001-10-24 00:00:00.000',0.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (607,105,1007,'2001-10-24 00:00:00.000',29.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (608,105,708,'2001-10-24 00:00:00.000',0.72,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (609,105,1127,'2001-10-24 00:00:00.000',4.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (610,105,294,'2001-10-24 00:00:00.000',23.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (611,105,822,'2001-10-24 00:00:00.000',5.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (612,105,1050,'2001-10-24 00:00:00.000',239.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (613,105,1046,'2001-10-24 00:00:00.000',226.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (614,105,1124,'2001-10-24 00:00:00.000',0.06,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (615,105,704,'2001-10-24 00:00:00.000',46.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (616,105,431,'2001-10-24 00:00:00.000',1890.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (617,105,156,'2001-10-24 00:00:00.000',0.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (618,105,460,'2001-10-24 00:00:00.000',0.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (619,105,1044,'2001-10-24 00:00:00.000',0.141,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (620,105,1115,'2001-10-24 00:00:00.000',0.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (621,105,388,'2001-10-24 00:00:00.000',0.09,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (622,105,1037,'2001-10-24 00:00:00.000',5.78,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (623,105,299,'2001-10-24 00:00:00.000',75.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (624,105,541,'2001-10-24 00:00:00.000',0.026,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (625,105,1031,'2001-10-24 00:00:00.000',4.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (626,105,559,'2001-10-24 00:00:00.000',0.026,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (627,105,339,'2001-10-24 00:00:00.000',439.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (628,105,270,'2001-10-24 00:00:00.000',1.41,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (629,105,372,'2001-10-24 00:00:00.000',0.55,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (630,105,493,'2001-10-24 00:00:00.000',6.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (631,105,933,'2001-10-24 00:00:00.000',2.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (632,105,926,'2001-10-24 00:00:00.000',0.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (633,105,894,'2001-10-24 00:00:00.000',11.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (634,105,83,'2001-10-24 00:00:00.000',6.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (635,105,657,'2001-10-24 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (636,105,913,'2001-10-24 00:00:00.000',3.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (637,105,774,'2001-10-24 00:00:00.000',0.07,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (638,105,275,'2001-10-24 00:00:00.000',0.25,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (639,105,391,'2001-10-24 00:00:00.000',0.05,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (640,105,500,'2001-10-24 00:00:00.000',3.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (641,105,899,'2001-10-24 00:00:00.000',14.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (642,105,507,'2001-10-24 00:00:00.000',15.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (643,105,612,'2001-10-24 00:00:00.000',581.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (644,105,813,'2001-10-24 00:00:00.000',33.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (645,105,582,'2001-10-24 00:00:00.000',0.06,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (646,105,1073,'2001-10-24 00:00:00.000',359.83,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (647,105,644,'2001-10-24 00:00:00.000',0.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (648,105,479,'2001-10-24 00:00:00.000',352.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (649,105,256,'2001-10-24 00:00:00.000',1.41,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (650,105,1088,'2001-10-24 00:00:00.000',0.073,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (651,105,805,'2001-10-24 00:00:00.000',10.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (652,105,567,'2001-10-24 00:00:00.000',0.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (653,105,944,'2001-10-24 00:00:00.000',1.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (654,105,985,'2001-10-24 00:00:00.000',7.51,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (655,105,514,'2001-10-24 00:00:00.000',8.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (656,105,799,'2001-10-24 00:00:00.000',6.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (657,105,811,'2001-10-24 00:00:00.000',0.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (658,105,643,'2001-10-24 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (659,105,1080,'2001-10-24 00:00:00.000',53.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (660,105,1078,'2001-10-24 00:00:00.000',18.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (661,105,981,'2001-10-24 00:00:00.000',3.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (662,105,414,'2001-10-24 00:00:00.000',156.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (663,105,693,'2001-10-24 00:00:00.000',229.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (664,105,349,'2001-10-24 00:00:00.000',649.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (665,105,292,'2001-10-24 00:00:00.000',41.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (666,86,1031,'2014-02-20 00:00:00.000',3.125,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (667,86,505,'2014-02-20 00:00:00.000',0.625,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (668,86,1003,'2014-02-20 00:00:00.000',3.125,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (669,86,899,'2014-02-20 00:00:00.000',15.62,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (670,86,270,'2014-02-20 00:00:00.000',1.562,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (671,86,904,'2014-02-20 00:00:00.000',0.156,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (672,86,47,'2014-02-20 00:00:00.000',0.937,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (673,86,347,'2014-02-20 00:00:00.000',0.312,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (674,86,1209,'2014-02-20 00:00:00.000',3.125,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (675,86,442,'2014-02-20 00:00:00.000',15.62,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (676,86,321,'2014-02-20 00:00:00.000',0.003,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (677,86,314,'2014-02-20 00:00:00.000',0.312,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (678,86,894,'2014-02-20 00:00:00.000',6.25,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (679,86,836,'2014-02-20 00:00:00.000',0.312,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (680,86,410,'2014-02-20 00:00:00.000',1.562,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (681,86,514,'2014-02-20 00:00:00.000',15.62,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (682,86,283,'2014-02-20 00:00:00.000',3.125,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (683,104,788,'2006-12-13 00:00:00.000',1.23,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (684,104,700,'2006-12-13 00:00:00.000',6.69,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (685,104,507,'2006-12-13 00:00:00.000',8.57,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (686,104,345,'2006-12-13 00:00:00.000',0.57,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (687,104,514,'2006-12-13 00:00:00.000',13.44,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (688,104,704,'2006-12-13 00:00:00.000',11.33,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (689,104,645,'2006-12-13 00:00:00.000',945.69,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (690,104,339,'2006-12-13 00:00:00.000',377.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (691,104,763,'2006-12-13 00:00:00.000',0.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (692,104,813,'2006-12-13 00:00:00.000',49.72,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (693,104,693,'2006-12-13 00:00:00.000',360.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (694,104,333,'2006-12-13 00:00:00.000',0.07,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (695,104,685,'2006-12-13 00:00:00.000',4.96,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (696,104,299,'2006-12-13 00:00:00.000',53.79,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (697,104,805,'2006-12-13 00:00:00.000',19.98,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (698,104,1003,'2006-12-13 00:00:00.000',0.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (699,104,437,'2006-12-13 00:00:00.000',0.19,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (700,104,1046,'2006-12-13 00:00:00.000',82.96,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (701,104,433,'2006-12-13 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (702,104,1050,'2006-12-13 00:00:00.000',158.22,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (703,104,1035,'2006-12-13 00:00:00.000',8.96,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (704,104,1024,'2006-12-13 00:00:00.000',0.92,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (705,104,349,'2006-12-13 00:00:00.000',134.83,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (706,104,1007,'2006-12-13 00:00:00.000',1.85,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (707,104,500,'2006-12-13 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (708,104,372,'2006-12-13 00:00:00.000',0.19,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (709,104,479,'2006-12-13 00:00:00.000',139.89,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (710,104,438,'2006-12-13 00:00:00.000',0.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (711,104,983,'2006-12-13 00:00:00.000',7.49,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (712,104,948,'2006-12-13 00:00:00.000',4.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (713,104,919,'2006-12-13 00:00:00.000',0.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (714,104,468,'2006-12-13 00:00:00.000',5.75,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (715,104,1150,'2006-12-13 00:00:00.000',3.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (716,104,1154,'2006-12-13 00:00:00.000',3.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (717,104,246,'2006-12-13 00:00:00.000',5.69,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (718,104,1165,'2006-12-13 00:00:00.000',5.14,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (719,104,896,'2006-12-13 00:00:00.000',0.32,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (720,104,822,'2006-12-13 00:00:00.000',0.89,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (721,104,886,'2006-12-13 00:00:00.000',29.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (722,104,414,'2006-12-13 00:00:00.000',129.85,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (723,104,899,'2006-12-13 00:00:00.000',95.08,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (724,104,179,'2006-12-13 00:00:00.000',1.39,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (725,104,1112,'2006-12-13 00:00:00.000',0.67,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (726,104,270,'2006-12-13 00:00:00.000',0.22,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (727,104,254,'2006-12-13 00:00:00.000',0.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (728,104,876,'2006-12-13 00:00:00.000',1.49,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (729,104,431,'2006-12-13 00:00:00.000',1293.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (730,104,1073,'2006-12-13 00:00:00.000',309.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (731,104,1083,'2006-12-13 00:00:00.000',0.24,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (732,104,1129,'2006-12-13 00:00:00.000',119.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (733,104,838,'2006-12-13 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (734,104,1094,'2006-12-13 00:00:00.000',115.83,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (735,104,1127,'2006-12-13 00:00:00.000',3.77,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (736,104,1110,'2006-12-13 00:00:00.000',2.52,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (737,104,1117,'2006-12-13 00:00:00.000',5.75,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (738,104,270,'2006-12-13 00:00:00.000',3.79,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (739,87,321,'2014-02-12 00:00:00.000',0.003,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (740,87,47,'2014-02-12 00:00:00.000',0.909,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (741,87,505,'2014-02-12 00:00:00.000',0.606,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (742,87,283,'2014-02-12 00:00:00.000',3.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (743,87,904,'2014-02-12 00:00:00.000',0.151,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (744,87,270,'2014-02-12 00:00:00.000',1.515,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (745,87,1209,'2014-02-12 00:00:00.000',3.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (746,87,1031,'2014-02-12 00:00:00.000',3.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (747,87,1003,'2014-02-12 00:00:00.000',3.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (748,87,442,'2014-02-12 00:00:00.000',15.15,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (749,87,894,'2014-02-12 00:00:00.000',6.06,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (750,87,836,'2014-02-12 00:00:00.000',0.303,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (751,87,514,'2014-02-12 00:00:00.000',15.15,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (752,87,314,'2014-02-12 00:00:00.000',0.303,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (753,87,347,'2014-02-12 00:00:00.000',0.303,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (754,87,410,'2014-02-12 00:00:00.000',1.515,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (755,87,899,'2014-02-12 00:00:00.000',15.15,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (756,85,1209,'2014-02-20 00:00:00.000',3.225,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (757,85,314,'2014-02-20 00:00:00.000',0.322,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (758,85,899,'2014-02-20 00:00:00.000',16.12,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (759,85,270,'2014-02-20 00:00:00.000',1.612,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (760,85,283,'2014-02-20 00:00:00.000',3.225,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (761,85,347,'2014-02-20 00:00:00.000',0.322,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (762,85,321,'2014-02-20 00:00:00.000',0.003,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (763,85,47,'2014-02-20 00:00:00.000',0.967,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (764,85,505,'2014-02-20 00:00:00.000',0.645,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (765,85,904,'2014-02-20 00:00:00.000',0.161,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (766,85,442,'2014-02-20 00:00:00.000',16.12,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (767,85,514,'2014-02-20 00:00:00.000',16.12,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (768,85,836,'2014-02-20 00:00:00.000',0.322,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (769,85,894,'2014-02-20 00:00:00.000',6.451,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (770,85,1003,'2014-02-20 00:00:00.000',3.225,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (771,85,410,'2014-02-20 00:00:00.000',1.612,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (772,85,1031,'2014-02-20 00:00:00.000',3.225,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (773,123,1007,'2010-11-24 00:00:00.000',21.31,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (774,123,899,'2010-11-24 00:00:00.000',0.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (775,123,1073,'2010-11-24 00:00:00.000',356.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (776,123,985,'2010-11-24 00:00:00.000',7.59,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (777,123,479,'2010-11-24 00:00:00.000',206.41,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (778,123,813,'2010-11-24 00:00:00.000',28.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (779,123,270,'2010-11-24 00:00:00.000',0.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (780,123,1046,'2010-11-24 00:00:00.000',146.33,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (781,123,339,'2010-11-24 00:00:00.000',433.93,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (782,123,414,'2010-11-24 00:00:00.000',130.68,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (783,123,431,'2010-11-24 00:00:00.000',1413.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (784,123,1050,'2010-11-24 00:00:00.000',142.45,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (785,122,985,'1997-04-30 00:00:00.000',6.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (786,122,1164,'1997-04-30 00:00:00.000',31.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (787,122,1022,'1997-04-30 00:00:00.000',1250.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (788,122,613,'1997-04-30 00:00:00.000',829.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (789,122,814,'1997-04-30 00:00:00.000',90.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (790,122,1049,'1997-04-30 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (791,122,1051,'1997-04-30 00:00:00.000',226.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (792,122,294,'1997-04-30 00:00:00.000',50.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (793,122,480,'1997-04-30 00:00:00.000',303.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (794,122,225,'1997-04-30 00:00:00.000',379.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (795,122,828,'1997-04-30 00:00:00.000',0.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (796,122,415,'1997-04-30 00:00:00.000',182.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (797,122,1047,'1997-04-30 00:00:00.000',135.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (798,122,431,'1997-04-30 00:00:00.000',1812.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (799,122,269,'1997-04-30 00:00:00.000',2.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (800,122,905,'1997-04-30 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (801,122,292,'1997-04-30 00:00:00.000',130.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (802,122,278,'1997-04-30 00:00:00.000',1.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (803,122,692,'1997-04-30 00:00:00.000',0.37,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (804,122,900,'1997-04-30 00:00:00.000',104.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (805,121,985,'1998-01-29 00:00:00.000',6.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (806,121,480,'1998-01-29 00:00:00.000',304.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (807,121,431,'1998-01-29 00:00:00.000',1920.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (808,121,905,'1998-01-29 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (809,121,294,'1998-01-29 00:00:00.000',16000.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (810,121,828,'1998-01-29 00:00:00.000',0.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (811,121,1051,'1998-01-29 00:00:00.000',250.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (812,121,683,'1998-01-29 00:00:00.000',1350.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (813,121,820,'1998-01-29 00:00:00.000',60.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (814,121,814,'1998-01-29 00:00:00.000',89.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (815,121,348,'1998-01-29 00:00:00.000',0.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (816,121,225,'1998-01-29 00:00:00.000',266.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (817,121,292,'1998-01-29 00:00:00.000',26000.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (818,121,1049,'1998-01-29 00:00:00.000',1.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (819,121,613,'1998-01-29 00:00:00.000',727.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (820,121,415,'1998-01-29 00:00:00.000',142.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (821,121,900,'1998-01-29 00:00:00.000',107.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (822,121,1047,'1998-01-29 00:00:00.000',147.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (823,120,294,'1998-10-15 00:00:00.000',6000.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (824,119,415,'1999-01-27 00:00:00.000',162.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (825,119,1047,'1999-01-27 00:00:00.000',179.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (826,119,900,'1999-01-27 00:00:00.000',101.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (827,119,814,'1999-01-27 00:00:00.000',86.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (828,119,225,'1999-01-27 00:00:00.000',310.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (829,119,480,'1999-01-27 00:00:00.000',310.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (830,119,828,'1999-01-27 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (831,119,431,'1999-01-27 00:00:00.000',1843.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (832,119,683,'1999-01-27 00:00:00.000',320.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (833,119,905,'1999-01-27 00:00:00.000',0.18,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (834,119,1049,'1999-01-27 00:00:00.000',1.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (835,119,1164,'1999-01-27 00:00:00.000',443.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (836,119,1022,'1999-01-27 00:00:00.000',1390.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (837,119,294,'1999-01-27 00:00:00.000',10.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (838,119,613,'1999-01-27 00:00:00.000',762.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (839,119,506,'1999-01-27 00:00:00.000',33.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (840,119,1051,'1999-01-27 00:00:00.000',287.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (841,119,692,'1999-01-27 00:00:00.000',0.42,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (842,119,409,'1999-01-27 00:00:00.000',1.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (843,119,245,'1999-01-27 00:00:00.000',116.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (844,119,985,'1999-01-27 00:00:00.000',7.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (845,119,703,'1999-01-27 00:00:00.000',0.38,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (846,119,292,'1999-01-27 00:00:00.000',20.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (847,118,834,'2003-01-29 00:00:00.000',0.002,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (848,118,270,'2003-01-29 00:00:00.000',6.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (849,118,415,'2003-01-29 00:00:00.000',146.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (850,118,691,'2003-01-29 00:00:00.000',0.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (851,118,479,'2003-01-29 00:00:00.000',164.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (852,118,643,'2003-01-29 00:00:00.000',3.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (853,118,905,'2003-01-29 00:00:00.000',0.08,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (854,118,1050,'2003-01-29 00:00:00.000',236.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (855,118,499,'2003-01-29 00:00:00.000',72.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (856,118,899,'2003-01-29 00:00:00.000',57.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (857,118,483,'2003-01-29 00:00:00.000',7.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (858,118,497,'2003-01-29 00:00:00.000',54.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (859,118,613,'2003-01-29 00:00:00.000',586.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (860,118,814,'2003-01-29 00:00:00.000',53.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (861,118,826,'2003-01-29 00:00:00.000',1.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (862,118,297,'2003-01-29 00:00:00.000',18.0142,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (863,118,1047,'2003-01-29 00:00:00.000',142.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (864,118,225,'2003-01-29 00:00:00.000',383.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (865,118,347,'2003-01-29 00:00:00.000',0.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (866,118,945,'2003-01-29 00:00:00.000',0.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (867,118,1153,'2003-01-29 00:00:00.000',35.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (868,118,1022,'2003-01-29 00:00:00.000',1157.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (869,118,296,'2003-01-29 00:00:00.000',18.1322,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (870,118,254,'2003-01-29 00:00:00.000',0.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (871,118,985,'2003-01-29 00:00:00.000',7.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (872,118,431,'2003-01-29 00:00:00.000',1516.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (873,118,293,'2003-01-29 00:00:00.000',230.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (874,118,292,'2003-01-29 00:00:00.000',210.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (875,118,682,'2003-01-29 00:00:00.000',0.028,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (876,117,246,'2006-10-24 00:00:00.000',86.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (877,117,894,'2006-10-24 00:00:00.000',1.91,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (878,117,700,'2006-10-24 00:00:00.000',41.84,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (879,117,349,'2006-10-24 00:00:00.000',252.08,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (880,117,1154,'2006-10-24 00:00:00.000',5.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (881,117,788,'2006-10-24 00:00:00.000',5.064,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (882,117,805,'2006-10-24 00:00:00.000',38.35,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (883,117,372,'2006-10-24 00:00:00.000',0.51,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (884,117,437,'2006-10-24 00:00:00.000',0.21,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (885,117,514,'2006-10-24 00:00:00.000',68.19,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (886,117,822,'2006-10-24 00:00:00.000',10.59,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (887,117,1117,'2006-10-24 00:00:00.000',10.45,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (888,117,948,'2006-10-24 00:00:00.000',4.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (889,117,693,'2006-10-24 00:00:00.000',250.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (890,117,507,'2006-10-24 00:00:00.000',8.67,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (891,117,1007,'2006-10-24 00:00:00.000',3.72,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (892,117,339,'2006-10-24 00:00:00.000',405.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (893,117,299,'2006-10-24 00:00:00.000',43.81,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (894,117,704,'2006-10-24 00:00:00.000',21.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (895,117,455,'2006-10-24 00:00:00.000',38.55,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (896,117,1046,'2006-10-24 00:00:00.000',147.81,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (897,117,179,'2006-10-24 00:00:00.000',1.88,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (898,117,899,'2006-10-24 00:00:00.000',84.22,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (899,117,1112,'2006-10-24 00:00:00.000',0.64,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (900,117,1177,'2006-10-24 00:00:00.000',0.178,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (901,117,1050,'2006-10-24 00:00:00.000',244.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (902,117,1110,'2006-10-24 00:00:00.000',3.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (903,117,345,'2006-10-24 00:00:00.000',0.57,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (904,117,414,'2006-10-24 00:00:00.000',142.59,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (905,117,763,'2006-10-24 00:00:00.000',0.05,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (906,117,935,'2006-10-24 00:00:00.000',0.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (907,117,1024,'2006-10-24 00:00:00.000',6.72,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (908,117,886,'2006-10-24 00:00:00.000',30.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (909,117,214,'2006-10-24 00:00:00.000',0.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (910,117,813,'2006-10-24 00:00:00.000',47.39,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (911,117,983,'2006-10-24 00:00:00.000',7.47,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (912,117,1035,'2006-10-24 00:00:00.000',8.69,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (913,117,1094,'2006-10-24 00:00:00.000',54.31,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (914,117,433,'2006-10-24 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (915,117,1150,'2006-10-24 00:00:00.000',6.81,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (916,117,438,'2006-10-24 00:00:00.000',0.16,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (917,117,1129,'2006-10-24 00:00:00.000',103.48,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (918,117,431,'2006-10-24 00:00:00.000',1556.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (919,117,1083,'2006-10-24 00:00:00.000',0.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (920,117,919,'2006-10-24 00:00:00.000',0.007,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (921,117,1127,'2006-10-24 00:00:00.000',49.17,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (922,117,645,'2006-10-24 00:00:00.000',893.35,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (923,117,279,'2006-10-24 00:00:00.000',0.35,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (924,117,254,'2006-10-24 00:00:00.000',0.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (925,117,500,'2006-10-24 00:00:00.000',1.47,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (926,117,292,'2006-10-24 00:00:00.000',53.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (927,117,468,'2006-10-24 00:00:00.000',10.45,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (928,117,479,'2006-10-24 00:00:00.000',182.58,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (929,117,1073,'2006-10-24 00:00:00.000',332.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (930,98,1031,'2013-12-03 00:00:00.000',8.366,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (931,98,904,'2013-12-03 00:00:00.000',1.115,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (932,98,442,'2013-12-03 00:00:00.000',42.48,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (933,98,270,'2013-12-03 00:00:00.000',4.54,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (934,98,283,'2013-12-03 00:00:00.000',9.232,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (935,98,314,'2013-12-03 00:00:00.000',1.477,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (936,98,1003,'2013-12-03 00:00:00.000',9.299,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (937,98,505,'2013-12-03 00:00:00.000',2.49,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (938,98,899,'2013-12-03 00:00:00.000',42.18,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (939,98,894,'2013-12-03 00:00:00.000',17.47,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (940,98,47,'2013-12-03 00:00:00.000',2.774,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (941,98,836,'2013-12-03 00:00:00.000',0.853,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (942,98,514,'2013-12-03 00:00:00.000',42.31,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (943,98,410,'2013-12-03 00:00:00.000',4.525,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (944,98,321,'2013-12-03 00:00:00.000',0.831,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (945,98,347,'2013-12-03 00:00:00.000',1.663,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (946,98,1209,'2013-12-03 00:00:00.000',8.547,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (947,116,479,'2010-05-30 00:00:00.000',201.22,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (948,116,899,'2010-05-30 00:00:00.000',0.36,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (949,116,1046,'2010-05-30 00:00:00.000',165.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (950,116,1073,'2010-05-30 00:00:00.000',342.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (951,116,813,'2010-05-30 00:00:00.000',28.48,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (952,116,985,'2010-05-30 00:00:00.000',7.69,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (953,116,431,'2010-05-30 00:00:00.000',1383.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (954,116,1007,'2010-05-30 00:00:00.000',16.15,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (955,116,1050,'2010-05-30 00:00:00.000',145.55,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (956,116,339,'2010-05-30 00:00:00.000',416.87,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (957,116,414,'2010-05-30 00:00:00.000',122.16,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (958,115,683,'1996-12-17 00:00:00.000',89.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (959,115,270,'1996-12-17 00:00:00.000',9.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (960,115,1051,'1996-12-17 00:00:00.000',202.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (961,115,1049,'1996-12-17 00:00:00.000',0.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (962,115,431,'1996-12-17 00:00:00.000',1449.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (963,115,1047,'1996-12-17 00:00:00.000',189.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (964,115,900,'1996-12-17 00:00:00.000',15.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (965,115,828,'1996-12-17 00:00:00.000',1.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (966,115,225,'1996-12-17 00:00:00.000',299.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (967,115,415,'1996-12-17 00:00:00.000',138.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (968,115,613,'1996-12-17 00:00:00.000',541.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (969,115,480,'1996-12-17 00:00:00.000',278.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (970,115,905,'1996-12-17 00:00:00.000',0.07,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (971,115,814,'1996-12-17 00:00:00.000',47.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (972,97,283,'2013-12-04 00:00:00.000',2.864,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (973,97,1031,'2013-12-04 00:00:00.000',2.982,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (974,97,1003,'2013-12-04 00:00:00.000',3.329,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (975,97,894,'2013-12-04 00:00:00.000',5.192,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (976,97,836,'2013-12-04 00:00:00.000',0.715,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (977,97,514,'2013-12-04 00:00:00.000',12.25,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (978,97,410,'2013-12-04 00:00:00.000',1.319,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (979,97,314,'2013-12-04 00:00:00.000',0.714,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (980,97,899,'2013-12-04 00:00:00.000',12.86,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (981,97,505,'2013-12-04 00:00:00.000',1.355,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (982,97,1209,'2013-12-04 00:00:00.000',2.758,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (983,97,347,'2013-12-04 00:00:00.000',0.579,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (984,97,270,'2013-12-04 00:00:00.000',1.685,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (985,97,321,'2013-12-04 00:00:00.000',0.833,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (986,97,47,'2013-12-04 00:00:00.000',1.136,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (987,97,442,'2013-12-04 00:00:00.000',12.84,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (988,97,904,'2013-12-04 00:00:00.000',0.384,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (989,114,479,'2003-01-28 00:00:00.000',305.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (990,114,613,'2003-01-28 00:00:00.000',800.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (991,114,431,'2003-01-28 00:00:00.000',2006.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (992,114,292,'2003-01-28 00:00:00.000',510.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (993,114,483,'2003-01-28 00:00:00.000',15.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (994,114,682,'2003-01-28 00:00:00.000',0.109,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (995,114,296,'2003-01-28 00:00:00.000',24.9908,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (996,114,497,'2003-01-28 00:00:00.000',17.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (997,114,499,'2003-01-28 00:00:00.000',35.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (998,114,1050,'2003-01-28 00:00:00.000',438.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (999,114,899,'2003-01-28 00:00:00.000',70.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1000,114,643,'2003-01-28 00:00:00.000',21.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1001,114,297,'2003-01-28 00:00:00.000',22.6603,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1002,114,293,'2003-01-28 00:00:00.000',400.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1003,114,270,'2003-01-28 00:00:00.000',3.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1004,114,985,'2003-01-28 00:00:00.000',7.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1005,114,254,'2003-01-28 00:00:00.000',0.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1006,114,1022,'2003-01-28 00:00:00.000',1606.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1007,114,945,'2003-01-28 00:00:00.000',0.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1008,114,415,'2003-01-28 00:00:00.000',207.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1009,114,814,'2003-01-28 00:00:00.000',68.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1010,114,1047,'2003-01-28 00:00:00.000',152.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1011,114,225,'2003-01-28 00:00:00.000',306.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1012,114,826,'2003-01-28 00:00:00.000',3.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1013,114,905,'2003-01-28 00:00:00.000',0.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1014,114,691,'2003-01-28 00:00:00.000',0.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1015,113,339,'2010-05-30 00:00:00.000',402.24,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1016,113,985,'2010-05-30 00:00:00.000',7.42,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1017,113,1073,'2010-05-30 00:00:00.000',330.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1018,113,479,'2010-05-30 00:00:00.000',183.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1019,113,899,'2010-05-30 00:00:00.000',0.0001,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1020,113,813,'2010-05-30 00:00:00.000',26.18,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1021,113,414,'2010-05-30 00:00:00.000',117.28,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1022,113,1050,'2010-05-30 00:00:00.000',139.14,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1023,113,1007,'2010-05-30 00:00:00.000',18.07,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1024,113,431,'2010-05-30 00:00:00.000',1277.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1025,113,1046,'2010-05-30 00:00:00.000',156.07,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1026,96,904,'2013-12-08 00:00:00.000',0.288,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1027,96,314,'2013-12-08 00:00:00.000',0.928,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1028,96,1209,'2013-12-08 00:00:00.000',3.241,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1029,96,47,'2013-12-08 00:00:00.000',1.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1030,96,321,'2013-12-08 00:00:00.000',0.473,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1031,96,505,'2013-12-08 00:00:00.000',0.77,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1032,96,442,'2013-12-08 00:00:00.000',13.19,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1033,96,899,'2013-12-08 00:00:00.000',14.15,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1034,96,270,'2013-12-08 00:00:00.000',1.605,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1035,96,283,'2013-12-08 00:00:00.000',3.487,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1036,96,410,'2013-12-08 00:00:00.000',1.648,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1037,96,514,'2013-12-08 00:00:00.000',13.72,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1038,96,836,'2013-12-08 00:00:00.000',0.27,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1039,96,894,'2013-12-08 00:00:00.000',5.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1040,96,347,'2013-12-08 00:00:00.000',0.49,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1041,96,1003,'2013-12-08 00:00:00.000',3.053,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1042,96,1031,'2013-12-08 00:00:00.000',3.028,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1043,91,1031,'2014-01-11 00:00:00.000',5.555,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1044,91,836,'2014-01-11 00:00:00.000',0.555,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1045,91,314,'2014-01-11 00:00:00.000',0.555,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1046,91,899,'2014-01-11 00:00:00.000',27.77,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1047,91,894,'2014-01-11 00:00:00.000',11.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1048,91,1003,'2014-01-11 00:00:00.000',5.555,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1049,91,442,'2014-01-11 00:00:00.000',27.77,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1050,91,410,'2014-01-11 00:00:00.000',2.777,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1051,91,1209,'2014-01-11 00:00:00.000',5.555,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1052,91,47,'2014-01-11 00:00:00.000',1.666,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1053,91,347,'2014-01-11 00:00:00.000',0.555,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1054,91,514,'2014-01-11 00:00:00.000',27.77,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1055,91,283,'2014-01-11 00:00:00.000',5.555,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1056,91,270,'2014-01-11 00:00:00.000',2.777,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1057,91,505,'2014-01-11 00:00:00.000',1.111,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1058,91,904,'2014-01-11 00:00:00.000',0.277,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1059,91,321,'2014-01-11 00:00:00.000',0.005,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1060,112,431,'1973-09-01 00:00:00.000',1649.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1061,112,1008,'1973-09-01 00:00:00.000',6.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1062,112,1023,'1973-09-01 00:00:00.000',1320.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1063,112,1038,'1973-09-01 00:00:00.000',20.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1064,112,613,'1973-09-01 00:00:00.000',626.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1065,112,270,'1973-09-01 00:00:00.000',2.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1066,112,480,'1973-09-01 00:00:00.000',166.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1067,112,814,'1973-09-01 00:00:00.000',43.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1068,112,340,'1973-09-01 00:00:00.000',438.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1069,112,1073,'1973-09-01 00:00:00.000',359.01,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1070,112,1051,'1973-09-01 00:00:00.000',187.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1071,112,415,'1973-09-01 00:00:00.000',178.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1072,112,1047,'1973-09-01 00:00:00.000',109.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1073,112,985,'1973-09-01 00:00:00.000',7.28,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1074,112,900,'1973-09-01 00:00:00.000',62.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1075,95,314,'2013-12-16 00:00:00.000',1.099,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1076,95,1031,'2013-12-16 00:00:00.000',10.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1077,95,899,'2013-12-16 00:00:00.000',2.185,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1078,95,442,'2013-12-16 00:00:00.000',18.98,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1079,95,1209,'2013-12-16 00:00:00.000',5.965,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1080,95,347,'2013-12-16 00:00:00.000',1.893,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1081,95,410,'2013-12-16 00:00:00.000',5.53,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1082,95,321,'2013-12-16 00:00:00.000',0.363,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1083,95,1003,'2013-12-16 00:00:00.000',9.186,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1084,95,505,'2013-12-16 00:00:00.000',1.476,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1085,95,47,'2013-12-16 00:00:00.000',3.199,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1086,95,514,'2013-12-16 00:00:00.000',43.81,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1087,95,904,'2013-12-16 00:00:00.000',0.725,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1088,95,270,'2013-12-16 00:00:00.000',4.265,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1089,95,283,'2013-12-16 00:00:00.000',9.256,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1090,95,836,'2013-12-16 00:00:00.000',1.69,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1091,95,894,'2013-12-16 00:00:00.000',20.61,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1092,90,1209,'2014-01-15 00:00:00.000',7.142,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1093,90,270,'2014-01-15 00:00:00.000',3.571,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1094,90,904,'2014-01-15 00:00:00.000',0.357,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1095,90,505,'2014-01-15 00:00:00.000',1.428,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1096,90,47,'2014-01-15 00:00:00.000',2.142,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1097,90,321,'2014-01-15 00:00:00.000',0.007,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1098,90,442,'2014-01-15 00:00:00.000',35.71,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1099,90,347,'2014-01-15 00:00:00.000',0.714,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1100,90,1031,'2014-01-15 00:00:00.000',7.142,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1101,90,899,'2014-01-15 00:00:00.000',35.71,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1102,90,314,'2014-01-15 00:00:00.000',0.714,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1103,90,283,'2014-01-15 00:00:00.000',7.142,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1104,90,514,'2014-01-15 00:00:00.000',35.71,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1105,90,894,'2014-01-15 00:00:00.000',14.28,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1106,90,836,'2014-01-15 00:00:00.000',0.714,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1107,90,1003,'2014-01-15 00:00:00.000',7.142,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1108,90,410,'2014-01-15 00:00:00.000',3.571,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1109,111,270,'2006-09-24 00:00:00.000',5.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1110,111,295,'2006-09-24 00:00:00.000',11.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1111,111,248,'2006-09-24 00:00:00.000',166.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1112,111,292,'2006-09-24 00:00:00.000',8.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1113,111,479,'2006-09-24 00:00:00.000',207.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1114,111,1044,'2006-09-24 00:00:00.000',0.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1115,111,299,'2006-09-24 00:00:00.000',35.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1116,111,1085,'2006-09-24 00:00:00.000',0.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1117,111,1088,'2006-09-24 00:00:00.000',0.06,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1118,111,1094,'2006-09-24 00:00:00.000',24.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1119,111,1046,'2006-09-24 00:00:00.000',168.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1120,111,468,'2006-09-24 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1121,111,372,'2006-09-24 00:00:00.000',0.54,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1122,111,1112,'2006-09-24 00:00:00.000',1.6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1123,111,1031,'2006-09-24 00:00:00.000',5.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1124,111,1007,'2006-09-24 00:00:00.000',8.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1125,111,339,'2006-09-24 00:00:00.000',434.32,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1126,111,254,'2006-09-24 00:00:00.000',1.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1127,111,983,'2006-09-24 00:00:00.000',7.34,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1128,111,345,'2006-09-24 00:00:00.000',8.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1129,111,431,'2006-09-24 00:00:00.000',1459.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1130,111,1127,'2006-09-24 00:00:00.000',5.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1131,111,952,'2006-09-24 00:00:00.000',0.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1132,111,1129,'2006-09-24 00:00:00.000',29.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1133,111,349,'2006-09-24 00:00:00.000',301.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1134,111,433,'2006-09-24 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1135,111,1035,'2006-09-24 00:00:00.000',9.27,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1136,111,493,'2006-09-24 00:00:00.000',2.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1137,111,507,'2006-09-24 00:00:00.000',11.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1138,111,813,'2006-09-24 00:00:00.000',32.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1139,111,414,'2006-09-24 00:00:00.000',147.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1140,111,894,'2006-09-24 00:00:00.000',5.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1141,111,1073,'2006-09-24 00:00:00.000',356.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1142,111,805,'2006-09-24 00:00:00.000',19.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1143,111,693,'2006-09-24 00:00:00.000',0.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1144,111,645,'2006-09-24 00:00:00.000',570.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1145,111,288,'2006-09-24 00:00:00.000',0.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1146,111,899,'2006-09-24 00:00:00.000',9.46,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1147,111,1050,'2006-09-24 00:00:00.000',175.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1148,111,685,'2006-09-24 00:00:00.000',35.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1149,111,822,'2006-09-24 00:00:00.000',5.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1150,94,505,'2013-12-22 00:00:00.000',0.478,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1151,94,47,'2013-12-22 00:00:00.000',0.821,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1152,94,321,'2013-12-22 00:00:00.000',0.371,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1153,94,283,'2013-12-22 00:00:00.000',2.417,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1154,94,314,'2013-12-22 00:00:00.000',0.875,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1155,94,1209,'2013-12-22 00:00:00.000',2.278,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1156,94,442,'2013-12-22 00:00:00.000',8.747,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1157,94,347,'2013-12-22 00:00:00.000',1.096,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1158,94,899,'2013-12-22 00:00:00.000',8.782,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1159,94,904,'2013-12-22 00:00:00.000',0.143,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1160,94,514,'2013-12-22 00:00:00.000',8.201,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1161,94,270,'2013-12-22 00:00:00.000',0.983,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1162,94,836,'2013-12-22 00:00:00.000',0.447,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1163,94,894,'2013-12-22 00:00:00.000',3.295,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1164,94,1031,'2013-12-22 00:00:00.000',1.74,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1165,94,1003,'2013-12-22 00:00:00.000',2.486,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1166,94,410,'2013-12-22 00:00:00.000',1.175,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1167,89,270,'2014-01-19 00:00:00.000',4.166,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1168,89,1003,'2014-01-19 00:00:00.000',8.333,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1169,89,894,'2014-01-19 00:00:00.000',16.66,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1170,89,836,'2014-01-19 00:00:00.000',0.833,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1171,89,514,'2014-01-19 00:00:00.000',41.66,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1172,89,410,'2014-01-19 00:00:00.000',4.166,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1173,89,314,'2014-01-19 00:00:00.000',0.833,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1174,89,505,'2014-01-19 00:00:00.000',1.666,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1175,89,283,'2014-01-19 00:00:00.000',8.333,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1176,89,899,'2014-01-19 00:00:00.000',41.66,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1177,89,1209,'2014-01-19 00:00:00.000',8.333,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1178,89,904,'2014-01-19 00:00:00.000',0.416,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1179,89,1031,'2014-01-19 00:00:00.000',8.333,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1180,89,47,'2014-01-19 00:00:00.000',2.5,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1181,89,442,'2014-01-19 00:00:00.000',41.66,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1182,89,321,'2014-01-19 00:00:00.000',0.008,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1183,89,347,'2014-01-19 00:00:00.000',0.833,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1184,110,1024,'2006-10-24 00:00:00.000',1.42,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1185,110,894,'2006-10-24 00:00:00.000',8.66,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1186,110,295,'2006-10-24 00:00:00.000',9.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1187,110,638,'2006-10-24 00:00:00.000',0.28,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1188,110,886,'2006-10-24 00:00:00.000',84.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1189,110,693,'2006-10-24 00:00:00.000',400.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1190,110,876,'2006-10-24 00:00:00.000',1.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1191,110,822,'2006-10-24 00:00:00.000',39.12,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1192,110,1154,'2006-10-24 00:00:00.000',2.63,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1193,110,1007,'2006-10-24 00:00:00.000',12.59,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1194,110,292,'2006-10-24 00:00:00.000',35.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1195,110,645,'2006-10-24 00:00:00.000',541.7,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1196,110,685,'2006-10-24 00:00:00.000',3814.62,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1197,110,922,'2006-10-24 00:00:00.000',8.574,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1198,110,788,'2006-10-24 00:00:00.000',1.875,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1199,110,1165,'2006-10-24 00:00:00.000',6.82,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1200,110,349,'2006-10-24 00:00:00.000',382.96,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1201,110,514,'2006-10-24 00:00:00.000',59.33,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1202,110,333,'2006-10-24 00:00:00.000',0.15,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1203,110,1176,'2006-10-24 00:00:00.000',3.426,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1204,110,1175,'2006-10-24 00:00:00.000',7.007,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1205,110,1035,'2006-10-24 00:00:00.000',6.06,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1206,110,215,'2006-10-24 00:00:00.000',0.02,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1207,110,345,'2006-10-24 00:00:00.000',0.56,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1208,110,339,'2006-10-24 00:00:00.000',437.98,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1209,110,1177,'2006-10-24 00:00:00.000',12.79,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1210,110,899,'2006-10-24 00:00:00.000',2.82,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1211,110,414,'2006-10-24 00:00:00.000',126.07,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1212,110,704,'2006-10-24 00:00:00.000',33.14,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1213,110,179,'2006-10-24 00:00:00.000',5.28,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1214,110,896,'2006-10-24 00:00:00.000',1.04,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1215,110,1046,'2006-10-24 00:00:00.000',144.53,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1216,110,299,'2006-10-24 00:00:00.000',28.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1217,110,214,'2006-10-24 00:00:00.000',1.13,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1218,110,493,'2006-10-24 00:00:00.000',0.94,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1219,110,279,'2006-10-24 00:00:00.000',0.35,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1220,110,431,'2006-10-24 00:00:00.000',1476.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1221,110,1129,'2006-10-24 00:00:00.000',3.21,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1222,110,433,'2006-10-24 00:00:00.000',1.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1223,110,437,'2006-10-24 00:00:00.000',0.21,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1224,110,1127,'2006-10-24 00:00:00.000',1.96,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1225,110,1083,'2006-10-24 00:00:00.000',53.3,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1226,110,438,'2006-10-24 00:00:00.000',0.11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1227,110,500,'2006-10-24 00:00:00.000',3.51,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1228,110,1112,'2006-10-24 00:00:00.000',2.06,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1229,110,813,'2006-10-24 00:00:00.000',24.99,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1230,110,936,'2006-10-24 00:00:00.000',0.429,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1231,110,1110,'2006-10-24 00:00:00.000',5.05,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1232,110,935,'2006-10-24 00:00:00.000',0.094,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1233,110,1073,'2006-10-24 00:00:00.000',359.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1234,110,1094,'2006-10-24 00:00:00.000',1.25,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1235,110,921,'2006-10-24 00:00:00.000',1.769,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1236,110,919,'2006-10-24 00:00:00.000',0.044,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1237,110,1088,'2006-10-24 00:00:00.000',0.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1238,110,479,'2006-10-24 00:00:00.000',214.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1239,110,1050,'2006-10-24 00:00:00.000',178.86,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1240,110,507,'2006-10-24 00:00:00.000',5.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1241,110,1003,'2006-10-24 00:00:00.000',0.61,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1242,110,283,'2006-10-24 00:00:00.000',0.76,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1243,110,246,'2006-10-24 00:00:00.000',10.85,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1244,110,948,'2006-10-24 00:00:00.000',1.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1245,110,372,'2006-10-24 00:00:00.000',0.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1246,110,1150,'2006-10-24 00:00:00.000',4.47,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1247,110,998,'2006-10-24 00:00:00.000',0.03,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1248,110,805,'2006-10-24 00:00:00.000',34.24,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1249,110,983,'2006-10-24 00:00:00.000',7.64,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1250,110,254,'2006-10-24 00:00:00.000',3.8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1251,109,225,'1996-12-19 00:00:00.000',117.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1252,109,1047,'1996-12-19 00:00:00.000',199.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1253,109,1049,'1996-12-19 00:00:00.000',0.2,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1254,109,480,'1996-12-19 00:00:00.000',215.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1255,109,814,'1996-12-19 00:00:00.000',33.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1256,109,482,'1996-12-19 00:00:00.000',4.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1257,109,613,'1996-12-19 00:00:00.000',409.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1258,109,900,'1996-12-19 00:00:00.000',17.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1259,109,292,'1996-12-19 00:00:00.000',980.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1260,109,905,'1996-12-19 00:00:00.000',0.07,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1261,109,270,'1996-12-19 00:00:00.000',7.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1262,109,828,'1996-12-19 00:00:00.000',3.1,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1263,109,431,'1996-12-19 00:00:00.000',1434.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1264,109,499,'1996-12-19 00:00:00.000',93.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1265,109,1051,'1996-12-19 00:00:00.000',187.9,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1266,109,683,'1996-12-19 00:00:00.000',20.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1267,109,294,'1996-12-19 00:00:00.000',660.0,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1268,109,415,'1996-12-19 00:00:00.000',109.4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1269,93,899,'2014-01-03 00:00:00.000',15.24,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1270,93,314,'2014-01-03 00:00:00.000',0.745,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1271,93,514,'2014-01-03 00:00:00.000',15.17,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1272,93,283,'2014-01-03 00:00:00.000',3.824,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1273,93,270,'2014-01-03 00:00:00.000',1.907,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1274,93,836,'2014-01-03 00:00:00.000',0.957,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1275,93,47,'2014-01-03 00:00:00.000',1.385,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1276,93,442,'2014-01-03 00:00:00.000',14.82,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1277,93,1209,'2014-01-03 00:00:00.000',3.553,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalMeasurements` VALUES (1278,93,347,'2014-01-03 00:00:00.000',0.339,NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `Normatives` VALUES (1,'EXDMA',NULL,'normativa de calidad de aguas local ejemplo','normativa de calidad de aguas local ejemplo','2003-2-21',NULL,NULL,'Examples data!Any similarities to a real data are pure, unintentional coincidence');
INSERT INTO `Normatives` VALUES (2,'EXEWFD',1,'European Water Frame Directive example','European Water Frame Directive example','2013-5-21',NULL,NULL,NULL);

INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,270,NULL,NULL,1,5,10,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,1003,NULL,NULL,1,25,50,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,894,NULL,NULL,1,20,50,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,836,NULL,NULL,0.01,1,10,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,514,NULL,NULL,1,50,100,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,505,NULL,NULL,0.5,2,10,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,410,NULL,NULL,1,5,10,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,283,NULL,NULL,5,10,50,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,1031,NULL,NULL,1,10,15,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,314,NULL,NULL,1,10,15,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,47,NULL,NULL,1,3,5,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,1209,NULL,NULL,3,10,25,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,904,NULL,NULL,0.01,0.1,0.5,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,899,NULL,NULL,5,25,50,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,442,NULL,NULL,1,50,100,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,347,NULL,NULL,0.01,1,5,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (1,321,NULL,NULL,0.0001,0.001,0.003,NULL,NULL,NULL,NULL);
INSERT INTO `HydrochemicalNormativeParameters` VALUES (2,899,NULL,NULL,1,50,100,NULL,NULL,NULL,NULL);

INSERT INTO 'AK_SavedQueries' (id,queryName,startDate,endDate) VALUES (1,'only2Points','1900-01-27 00:00:00.000','2014-01-27 00:00:00.000');
INSERT INTO 'AK_SavedQueries' (id,queryName,startDate,endDate) VALUES (2,'AllPoints','2000-01-27 00:00:00.000','2014-01-27 00:00:00.000');
INSERT INTO 'AK_SavedQueries' (id,queryName,startDate,endDate) VALUES (3,'NorthernPoints','1990-01-27 00:00:00.000','2012-01-27 00:00:00.000');

INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (61,1,6);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (62,1,1);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (63,2,10);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (64,2,9);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (65,2,8);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (66,2,12);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (67,2,11);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (68,2,7);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (69,2,6);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (70,2,5);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (71,2,4);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (72,2,3);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (73,2,2);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (74,2,1);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (75,3,3);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (76,3,2);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (77,3,12);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (78,3,11);
INSERT INTO `AK_SavedQueryPoints` (id,savedQueryId,pointId) VALUES (79,3,10);

INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (43,61,'98',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (44,61,'117',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (45,61,'118',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (46,62,'103',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (47,62,'124',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (48,62,'125',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (49,62,'126',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (50,63,'89',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (51,63,'94',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (52,63,'111',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (53,64,'90',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (54,64,'95',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (55,65,'91',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (56,65,'96',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (57,65,'113',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (58,65,'114',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (59,66,'92',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (60,66,'108',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (61,67,'93',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (62,67,'110',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (63,68,'97',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (64,68,'116',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (65,69,'98',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (66,69,'117',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (67,69,'118',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (68,70,'99',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (69,70,'123',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (70,71,'100',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (71,71,'104',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (72,72,'101',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (73,72,'105',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (74,73,'102',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (75,73,'107',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (76,74,'103',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (77,74,'126',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (78,75,'105',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (79,76,'106',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (80,76,'107',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (81,77,'108',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (82,78,'109',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (83,78,'110',1);
INSERT INTO `AK_SavedQuerySamples` (id,savedQueryPointId,sampleID,Active) VALUES (84,79,'111',1);


INSERT INTO 'AK_SavedQueriesHydro' (id,queryName,startDate,endDate) VALUES (1,'only2Points','1900-01-27 00:00:00.000','2014-01-27 00:00:00.000');
INSERT INTO 'AK_SavedQueriesHydro' (id,queryName,startDate,endDate) VALUES (2,'AllPoints','2000-01-27 00:00:00.000','2014-01-27 00:00:00.000');
INSERT INTO 'AK_SavedQueriesHydro' (id,queryName,startDate,endDate) VALUES (3,'NorthernPoints','1990-01-27 00:00:00.000','2012-01-27 00:00:00.000');

INSERT INTO `AK_SavedQueryPointsHydro` VALUES (80,1,6);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (81,1,1);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (82,2,10);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (83,2,9);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (84,2,8);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (85,2,12);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (86,2,11);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (87,2,7);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (88,2,6);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (89,2,5);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (90,2,4);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (91,2,3);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (92,2,2);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (93,2,1);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (94,3,3);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (95,3,2);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (96,3,12);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (97,3,11);
INSERT INTO `AK_SavedQueryPointsHydro` VALUES (98,3,10);

INSERT INTO `AK_SavedQuerySamplesHydro` VALUES (1,91,1,1);
INSERT INTO `AK_SavedQuerySamplesHydro` VALUES (2,92,2,1);
INSERT INTO `AK_SavedQuerySamplesHydro` VALUES (3,94,1,1);
INSERT INTO `AK_SavedQuerySamplesHydro` VALUES (4,95,2,1);

COMMIT;
