# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from ui_freeframe import Ui_FreeFrame
import os, sys
import utils

class FreeFrameGui(QDialog, Ui_FreeFrame):
  
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        
        self.okButton = self.buttonBox.button(QDialogButtonBox.Ok)
        self.connect(self.okButton, SIGNAL("accepted()"), self.accept)

        ## Get the params from last session.
        self.settings = QSettings("CatAIS","freeframe")
        self.dirpath = self.settings.value("gui/dirpath")

    def initGui(self):
        ## Get all layers in the map canvas.
        layers = utils.getLayerNames( "all",  "wms" )
        self.inLayer.addItems(sorted(layers))
        
        self.dirpath =  self.settings.value("gui/dirpath").toString()     
        self.outDir.insert(self.dirpath)
        
    def accept(self):
        if(self.outDir.text() == ""):
            QMessageBox.information(None, 'Information', str("Please specify a output directory."))   
        else:
            self.emit( SIGNAL("okClicked()") ) 

        
    @pyqtSignature("on_btnBrowse_clicked()")    
    def on_btnBrowse_clicked(self):
        self.dir= QFileDialog.getExistingDirectory(self, "Daten einlesen", str(self.dirpath))
        self.dirInfo = QFileInfo(self.dir)
        self.outDir.setText(QString(self.dirInfo.absoluteFilePath()))
        
        ## save the path again in the settings    
        self.settings.setValue("gui/dirpath", QVariant(self.dirInfo.absoluteFilePath()))


    @pyqtSignature("on_inLayer_currentIndexChanged(int)")    
    def on_inLayer_currentIndexChanged(self, idx):
        layerType = utils.getLayerTypeByName(self.inLayer.currentText())
        
        if layerType == 1:
            self.useSelected.setEnabled(False)
        else:
            self.useSelected.setEnabled(True)
