# =====================================================================================
# Developed by: C.Langen.R.M.M.M.Mushi
# e-mail: info@jbidhaa.co.tz
# =====================================================================================
import os, sys, subprocess, csv, datetime, piexif, importlib
from datetime import datetime
from decimal import Decimal
from PIL import Image
# =====================================================================================
from qgis.PyQt.QtCore import Qt, QDir, QSettings, QVariant, QUrl, QDateTime
from qgis.PyQt.QtGui import (QIcon, QStandardItemModel, QStandardItem, QPixmap,
                             QImage, QPalette, QColor)
from qgis.PyQt.QtWidgets import (QWidget, QDockWidget, QFileSystemModel,QTreeView,
                                 QVBoxLayout, QComboBox, QPushButton, QHBoxLayout,
                                 QTextEdit, QPlainTextEdit, QCheckBox, QTextBrowser,
                                 QTabWidget, QLabel, QGroupBox, QFormLayout, QLineEdit,
                                 QFileDialog, QHeaderView, QScrollArea, QDateTimeEdit)
from qgis._core import (QgsPointXY, QgsVectorLayer, QgsField, QgsFeature, QgsGeometry,
                        QgsProject, QgsCoordinateReferenceSystem, QgsCoordinateTransform)
from qgis._gui import QgsVertexMarker
from qgis.utils import iface

from PyQt5.QtWidgets import QMessageBox
# =====================================================================================
# =====================================================================================
class pichadoku(QDockWidget):
    def __init__(self, parent=None):
        super().__init__("FooPicha", parent)
        self.setObjectName("FooPicha")

        # Main widget
        self.main_widget = QWidget()
        self.layout = QVBoxLayout(self.main_widget)

        # Setup UI
        self.setup_ui()

        self.setWidget(self.main_widget)

        # Load last used directory
        settings = QSettings()
        last_dir = settings.value("picture_browser/last_dir", QDir.homePath())
        self.set_directory(last_dir)
        self.check_packages()

        self.canvas = iface.mapCanvas()
        self.marker = None

    # =====================================================================================
    # =====================================================================================
    def setup_ui(self):
        # Create a tab widget
        self.tab_widget = QTabWidget()
        self.layout.addWidget(self.tab_widget)

        # Tab 1 - File Browser (existing code)
        self.setup_file_browser_tab()

        # Tab 2 - Image Viewer with GPS info
        self.setup_image_viewer_tab()

        # Tab 3 - Data list ready for displayI
        self.setup_list_viewer_tab()

        # Tab 5 - Kuhusu
        self.setup_kuhusu_tab()
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    #  Tabs
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    # TAB 1
    def setup_file_browser_tab(self):
        """Setup the first tab with file browser (your existing UI)"""
        self.tab1 = QWidget()
        self.tab_widget.addTab(self.tab1, "Image List")

        # Create layout for the first tab
        tab1_layout = QVBoxLayout(self.tab1)
        # -----------------------------------------------------------------------------------
        # Directory selection
        self.dir_combo = QComboBox()
        self.dir_combo.setEditable(True)
        self.dir_combo.setInsertPolicy(QComboBox.InsertAtTop)

        # Add common directories
        self.dir_combo.addItem(QIcon.fromTheme("user-home"), "Home", QDir.homePath())
        self.dir_combo.addItem(QIcon.fromTheme("folder-pictures"), "Pictures",
                               os.path.join(QDir.homePath(), "Pictures"))

        browse_button = QPushButton("...")
        browse_button.setMaximumWidth(30)
        browse_button.clicked.connect(self.browse_directory)

        dir_layout = QHBoxLayout()
        dir_layout.addWidget(self.dir_combo)
        dir_layout.addWidget(browse_button)

        tab1_layout.addLayout(dir_layout)
        # -----------------------------------------------------------------------------------
        # File system model and view
        self.model = QFileSystemModel()
        self.model.setNameFilters(["*.jpg", "*.jpeg", "*.png"])
        self.model.setNameFilterDisables(False)
        self.model.setReadOnly(True)  # This disables all editing in the model

        self.tree_view = QTreeView()
        self.tree_view.setModel(self.model)
        # Configure view behavior
        self.tree_view.setRootIsDecorated(True)
        self.tree_view.setSortingEnabled(True)
        self.tree_view.setAlternatingRowColors(True)  # Zebra stripes
        self.tree_view.setEditTriggers(QTreeView.NoEditTriggers)  # No editing
        self.tree_view.setSelectionMode(QTreeView.SingleSelection)  # Single selection
        self.tree_view.setSelectionBehavior(QTreeView.SelectRows)  # Full row selection

        # Customize selection colors
        palette = self.tree_view.palette()
        palette.setColor(QPalette.Highlight, QColor(100, 150, 200))
        palette.setColor(QPalette.HighlightedText, Qt.white)
        self.tree_view.setPalette(palette)

        tab1_layout.addWidget(self.tree_view)
        # -----------------------------------------------------------------------------------
        # Connect signals
        self.dir_combo.currentTextChanged.connect(self.dir_combo_changed)
        self.dir_combo.currentIndexChanged.connect(self.dir_combo_index_changed)
        # -----------------------------------------------------------------------------------
        # Create two buttons to add below the tree view
        self.angaliaJira = QPushButton("List for Plotting")
        # Add the button layout to the tab layout
        tab1_layout.addWidget(self.angaliaJira)

        #Jumbe
        self.tab1_jumbe = QLineEdit()
        self.tab1_jumbe.setReadOnly(True)
        tab1_layout.addWidget(self.tab1_jumbe)

        # Click withi Treeview
        self.tree_view.clicked.connect(self.onClicked_OnaJira)
        self.tree_view.doubleClicked.connect(self.onDClicked_OnaJira)
        # Click on Button
        self.angaliaJira.clicked.connect(self.onClicked_OnaOrodhaJira)
    # =====================================================================================
    # TAB 2
    def setup_image_viewer_tab(self):
        """Setup the second tab with image viewer and GPS info"""
        self.tab2 = QWidget()
        self.tab_widget.addTab(self.tab2, "Image Viewer")
        tab2_layout = QVBoxLayout(self.tab2)

        # Image display area
        self.image_label = QLabel()
        self.image_label.setAlignment(Qt.AlignCenter)
        #self.image_label.setStyleSheet("background-color: black;")
        tab2_layout.addWidget(self.image_label, stretch=1)

        # GPS information group box
        gps_group = QGroupBox("Image Coordinates")
        gps_layout = QFormLayout()

        # path
        self.view_path = QLineEdit()
        self.view_path.setReadOnly(True)
        # Coordinate fields
        self.latitude_edit = QLineEdit()
        self.longitude_edit = QLineEdit()
        self.altitude_edit = QLineEdit()
        self.datetime_edit = QDateTimeEdit()
        self.decription_edit = QLineEdit()

        # Set placeholders
        self.latitude_edit.setPlaceholderText("e.g., 37.7749")
        self.longitude_edit.setPlaceholderText("e.g., -122.4194")
        self.altitude_edit.setPlaceholderText("e.g., 10.5")
        self.datetime_edit.setDisplayFormat("yyyy:MM:dd HH:mm:ss")
        self.datetime_edit.setCalendarPopup(True)  # Enable calendar dropdown
        self.datetime_edit.setDateTime(QDateTime.currentDateTime())  # Set current datetime
        self.decription_edit.setPlaceholderText("e.g., Image detials")

        # Add fields to form
        gps_layout.addRow("Path:", self.view_path)
        gps_layout.addRow("Latitude:", self.latitude_edit)
        gps_layout.addRow("Longitude:", self.longitude_edit)
        gps_layout.addRow("Altitude (m):", self.altitude_edit)
        gps_layout.addRow("Date-Time:", self.datetime_edit)
        gps_layout.addRow("Description:", self.decription_edit)

        gps_group.setLayout(gps_layout)
        tab2_layout.addWidget(gps_group)

        # Save button
        self.save_button = QPushButton("Save Coordinates")
        tab2_layout.addWidget(self.save_button)
        self.save_button.clicked.connect(self.save_img_jira)

        # Jumbe
        self.tab2_jumbe = QLineEdit()
        self.tab2_jumbe.setReadOnly(True)
        tab2_layout.addWidget(self.tab2_jumbe)

        # Connect tree view selection to update image view
        #self.tree_view.selectionModel().selectionChanged.connect(self.display_selected_image)

    # =====================================================================================
    # TAB 3
    def setup_list_viewer_tab(self):
        """Setup the second tab with image viewer and GPS info"""
        self.tab3 = QWidget()
        self.tab_widget.addTab(self.tab3, "Point List")
        tab3_layout = QVBoxLayout(self.tab3)

        self.tree_view_jira = QTreeView()
        self.tree_view_jira.setModel(self.model)
        # Configure view behavior
        self.tree_view_jira.setRootIsDecorated(True)
        self.tree_view_jira.setSortingEnabled(True)
        self.tree_view_jira.setAlternatingRowColors(True)  # Zebra stripes
        self.tree_view_jira.setEditTriggers(QTreeView.NoEditTriggers)  # No editing
        self.tree_view_jira.setSelectionMode(QTreeView.SingleSelection)  # Single selection
        self.tree_view_jira.setSelectionBehavior(QTreeView.SelectRows)  # Full row selection

        # Customize selection colors
        palette = self.tree_view.palette()
        palette.setColor(QPalette.Highlight, QColor(100, 150, 200))
        palette.setColor(QPalette.HighlightedText, Qt.white)
        self.tree_view.setPalette(palette)

        tab3_layout.addWidget(self.tree_view_jira)

        # Save button
        self.plot_button = QPushButton("Plot")
        self.csv_button = QPushButton("Export CSV")

        jira_layout = QHBoxLayout()
        jira_layout.addWidget(self.plot_button)
        jira_layout.addWidget(self.csv_button)
        # Add some spacing between buttons
        jira_layout.setSpacing(10)  # 10 pixels between buttons
        jira_layout.setContentsMargins(0, 5, 0, 0)  # Small top

        # Add the button layout to the tab layout
        tab3_layout.addLayout(jira_layout)

        # Jumbe
        self.tab3_jumbe = QLineEdit()
        self.tab3_jumbe.setReadOnly(True)
        tab3_layout.addWidget(self.tab3_jumbe)

        self.plot_button.clicked.connect(self.chora_jira)
        self.csv_button.clicked.connect(self.csv_jira)

    # =====================================================================================
    # TAB 4
    def setup_kuhusu_tab(self):
        """Setup the second tab with image viewer and GPS info"""
        self.tab4 = QWidget()
        self.tab_widget.addTab(self.tab4, "More")
        tab4_layout = QVBoxLayout(self.tab4)
        # --------------------------------------------------------------------------
        maktaba_group = QGroupBox("Libraries")
        maktaba_layout = QFormLayout()
        self.bt_pillow = QPushButton("Install")
        self.bt_pillow.setEnabled(False)
        self.bt_piexif = QPushButton("Install")
        self.bt_piexif.setEnabled(False)
        maktaba_layout.addRow("Pillow ==> ", self.bt_pillow)
        maktaba_layout.addRow("Exif ==> ", self.bt_piexif)
        self.bt_piexif.clicked.connect(self.weka_pe)
        self.bt_pillow.clicked.connect(self.weka_pi)
        maktaba_group.setLayout(maktaba_layout)
        tab4_layout.addWidget(maktaba_group)
        # --------------------------------------------------------------------------
        # Main tab widget for statistics
        self.tab_kuhusu = QTabWidget()
        # --------------------------------------------------------------------------
        # Tab 1: Maktaba
        self.kuhusu_tab1 = QWidget()
        kuhusu_tab1_layout = QVBoxLayout(self.kuhusu_tab1)
        self.bt_pillow = QPushButton("Install PILLOW")
        self.bt_piexif = QPushButton("Install PIEXIF")
        kuhusu_tab1_layout.addWidget(self.bt_pillow)
        kuhusu_tab1_layout.addWidget(self.bt_piexif)

        # --------------------------------------------------------------------------
        # Tab 2: Msaada
        self.kuhusu_tab2 = QWidget()
        kuhusu_tab2_layout = QVBoxLayout(self.kuhusu_tab2)
        self.help_browser = QTextBrowser()
        self.help_browser.setOpenExternalLinks(True)
        kuhusu_tab2_layout.addWidget(self.help_browser)
        self.load_help_page()
        # --------------------------------------------------------------------------
        # Tab 3: Kuhusu
        self.kuhusu_tab3 = QWidget()
        kuhusu_tab3_layout = QVBoxLayout(self.kuhusu_tab3)
        self.about_browser = QTextBrowser()
        self.about_browser.setOpenExternalLinks(True)
        kuhusu_tab3_layout.addWidget(self.about_browser)
        self.load_about_page()
        # --------------------------------------------------------------------------
        # Add all tabs to the main tab widget
        #self.tab_kuhusu.addTab(self.kuhusu_tab1, "Libraries")
        self.tab_kuhusu.addTab(self.kuhusu_tab2, "Help")
        self.tab_kuhusu.addTab(self.kuhusu_tab3, "About")

        # Add main tab widget to the tab layout
        tab4_layout.addWidget(self.tab_kuhusu)

    # =====================================================================================
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # Mafaili
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    def add_img_treeview(self, file_path):
        dir_path = os.path.normpath(file_path)
        if not os.path.isdir(dir_path):
            return

        i = 1
        # Set up model with GPS columns
        self.tree_model = QStandardItemModel()
        self.tree_model.setHorizontalHeaderLabels(
            ["Na", "File Name", "Latitude", "Longitude", "Altitude", "Date Taken", "Description"])
        self.tree_view.setModel(self.tree_model)
        self.tree_view.header().setSectionResizeMode(QHeaderView.ResizeToContents)

        for file_name in os.listdir(dir_path):
            file_path = os.path.join(dir_path, file_name)
            if not file_name.lower().endswith(('.jpg', '.jpeg', '.dng')):
                continue

            Na = QStandardItem(f"{i}")
            file_item = QStandardItem(file_name)
            # Usage
            g_color = QColor("#00ff00")  # Green
            r_color = QColor("#ff0000")  # Red
            metadata = self.get_metadata(file_path)
            latitude = metadata.get("latitude")
            if float(latitude) != -9999:
                ilat = QStandardItem(f"{latitude:.6f}")
                ilat.setBackground(g_color)
            else:
                ilat = QStandardItem("N/A")
                ilat.setBackground(r_color)

            longitude = metadata.get("longitude")
            if float(longitude) != -9999:
                ilon = QStandardItem(f"{longitude:.6f}")
                ilon.setBackground(g_color)
            else:
                ilon = QStandardItem("N/A")
                ilon.setBackground(r_color)

            altitude = metadata.get("altitude")
            if float(altitude) != -9999:
                ialt = QStandardItem(f"{altitude:.6f}")
                ialt.setBackground(g_color)
            else:
                ialt = QStandardItem("N/A")
                ialt.setBackground(r_color)

            date_taken = metadata.get("date_taken")
            if date_taken:
                idate = QStandardItem(date_taken)
                ialt.setBackground(g_color)
            else:
                idate = QStandardItem("N/A")
                ialt.setBackground(r_color)

            description = metadata.get("description")
            if description:
                idescription = QStandardItem(description)
                idescription.setBackground(g_color)
            else:
                idescription = QStandardItem("N/A")
                idescription.setBackground(r_color)

            # Add row to model
            row_items = [Na, file_item, ilat, ilon, ialt, idate, idescription]
            self.tree_model.appendRow(row_items)
            i = i + 1
    # =====================================================================================
    # Listview for plotting/CSV
    def add_img_treeview_jira(self, file_path):
        dir_path = os.path.normpath(file_path)
        if not os.path.isdir(dir_path):
            return

        # Set up model with GPS columns
        self.tree_model_jira = QStandardItemModel()
        self.tree_model_jira.setHorizontalHeaderLabels(
            ["Na", "File Name", "Latitude", "Longitude", "Altitude", "Date Taken", "Description"])
        self.tree_view_jira.setModel(self.tree_model_jira)
        self.tree_view_jira.header().setSectionResizeMode(QHeaderView.ResizeToContents)

        r_color = QColor("#ff0000")  # Red

        i = 1
        for file_name in os.listdir(dir_path):
            file_path = os.path.join(dir_path, file_name)
            if not file_name.lower().endswith(('.jpg', '.jpeg', '.dng')):
                continue
            Na = QStandardItem(f"{i}")
            file_item = QStandardItem(file_name)
            metadata = self.get_metadata(file_path)
            latitude = metadata.get("latitude")
            longitude = metadata.get("longitude")
            if latitude != "-9999" or  longitude != "-9999":
                ilat = QStandardItem(f"{latitude:.6f}")
                ilon = QStandardItem(f"{longitude:.6f}")

                altitude = metadata.get("altitude")
                if altitude:
                    ialt = QStandardItem(f"{altitude:.6f}")
                else:
                    ialt = QStandardItem("N/A")
                    ialt.setBackground(r_color)

                date_taken = metadata.get("date_taken")
                if date_taken:
                    idate = QStandardItem(date_taken)
                else:
                    idate = QStandardItem("N/A")
                    idate.setBackground(r_color)

                description = metadata.get("description")
                if description:
                    idescription = QStandardItem(description)
                else:
                    idescription = QStandardItem("N/A")
                    idescription.setBackground(r_color)

                # Add row to model
                row_items = [Na, file_item, ilat, ilon, ialt, idate, idescription]
                self.tree_model_jira.appendRow(row_items)
                i = i + 1

    # =====================================================================================
    def browse_directory(self):
        dir_path = QFileDialog.getExistingDirectory(
            self,
            "Select Picture Directory",
            self.dir_combo.currentText() or QDir.homePath()
        )
        if dir_path:
            dir_path = os.path.normpath(dir_path)  # Normalize for cross-platform
            self.set_directory(dir_path)

    def set_directory(self, dir_path):
        dir_path = os.path.normpath(dir_path)
        if os.path.isdir(dir_path):
            self.add_img_treeview(dir_path)
            self.dir_combo.setCurrentText(dir_path)
            QSettings().setValue("picture_browser/last_dir", dir_path)

    def dir_combo_changed(self, text):
        text = os.path.normpath(text)
        if os.path.isdir(text):
            self.set_directory(text)

    def dir_combo_index_changed(self, index):
        if index >= 0:
            dir_path = self.dir_combo.itemData(index)
            if dir_path:
                dir_path = os.path.normpath(str(dir_path))
                if os.path.isdir(dir_path):
                    self.set_directory(dir_path)

    # =====================================================================================
    def onClicked_OnaJira(self):
        model = self.tree_view.model()
        selection_model = self.tree_view.selectionModel()
        selected_indexes = selection_model.selectedRows()
        nukta_data = []
        for index in selected_indexes:
            row_data = {}
            # Get data from all columns in this row
            for col in range(model.columnCount()):
                cell_index = model.index(index.row(), col, index.parent())
                header = model.headerData(col, Qt.Horizontal)  # Column header
                value = cell_index.data()  # Cell value
                row_data[header] = value
            nukta_data.append(row_data)
        self.add_jira(nukta_data[0])
    # =====================================================================================
    def onDClicked_OnaJira(self):
        # Show Tab 2
        self.tab_widget.setCurrentIndex(1)
        self.check_packages()
        model = self.tree_view.model()
        selection_model = self.tree_view.selectionModel()
        selected_indexes = selection_model.selectedRows()
        nukta_data = []
        for index in selected_indexes:
            row_data = {}
            # Get data from all columns in this row
            for col in range(model.columnCount()):
                cell_index = model.index(index.row(), col, index.parent())
                header = model.headerData(col, Qt.Horizontal)  # Column header
                value = cell_index.data()  # Cell value
                row_data[header] = value
            nukta_data.append(row_data)

        self.add_jira(nukta_data[0])
        self.get_foopichaimg(nukta_data[0])

    # =====================================================================================
    def onClicked_OnaOrodhaJira(self):
        dir_path = self.dir_combo.currentText()
        if os.path.isdir(dir_path):
            self.add_img_treeview_jira(dir_path)
            # Show Tab 3
            self.tab_widget.setCurrentIndex(2)
            self.tab2_jumbe.setText('Picture and attributes')
            self.tab2_jumbe.setStyleSheet("background: green")
        else:
            self.tab2_jumbe.setText('Error retrieving image')
            self.tab2_jumbe.setStyleSheet("background: red")
    # =====================================================================================
    # Plot all jira
    def chora_jira(self):
        model = self.tree_view.model()
        data_list = []

        # Get column headers
        headers = [model.headerData(col, Qt.Horizontal) for col in range(model.columnCount())]

        for row in range(model.rowCount()):
            row_data = {}
            for col in range(model.columnCount()):
                item = model.item(row, col)
                if item:
                    key = headers[col] if headers[col] else f"column_{col}"
                    row_data[key] = item.text()
            data_list.append(row_data)

        self.choraJiraNukta(data_list)

    # =====================================================================================
    # Plot all jira
    def csv_jira(self):
        model = self.tree_view.model()
        data_list = []

        # Get column headers
        headers = [model.headerData(col, Qt.Horizontal) for col in range(model.columnCount())]

        for row in range(model.rowCount()):
            row_data = {}
            for col in range(model.columnCount()):
                item = model.item(row, col)
                if item:
                    key = headers[col] if headers[col] else f"column_{col}"
                    row_data[key] = item.text()
            data_list.append(row_data)

        self.csvJiraNukta(data_list)

    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # Jira
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    def convert_to_degrees(self, value):
        """Convert GPS coordinates stored in EXIF to degrees in float format"""
        d = Decimal(value[0][0]) / Decimal(value[0][1])
        m = Decimal(value[1][0]) / Decimal(value[1][1])
        s = Decimal(value[2][0]) / Decimal(value[2][1])
        return float(d + (m / 60) + (s / 3600))
    # =====================================================================================
    def get_metadata(self, img_path):
        try:
            metadata = {}
            exif_dict = piexif.load(img_path)
            gps_ifd = exif_dict.get("GPS", {})

            # --- GPS Coordinates ---
            if 'GPS' in exif_dict:
                # GPSLatitude (2) and GPSLatitudeRef (1) must be present
                if 2 in gps_ifd and 1 in gps_ifd:
                    gps_info = exif_dict['GPS']
                    # Latitude
                    lat = self.convert_to_degrees(gps_info[2])
                    if gps_info[1] == b'S':
                        lat = -lat

                    # Longitude
                    lon = self.convert_to_degrees(gps_info[4])
                    if gps_info[3] == b'W':
                        lon = -lon

                    metadata['latitude'] = lat
                    metadata['longitude'] = lon

                    # Altitude
                    if 6 in gps_info:  # GPSAltitude tag
                        alt_value = gps_info[6]
                        altitude = float(alt_value[0]) / float(alt_value[1])
                        if 5 in gps_info and gps_info[5] == 1:  # GPSAltitudeRef == 1 means below sea level
                            altitude = -altitude
                        metadata['altitude'] = altitude
                    else:
                        metadata['altitude'] = "-9999"
                else:
                    metadata['latitude'] = "-9999"
                    metadata['longitude'] = "-9999"
                    metadata['altitude'] = "-9999"

            else:
                metadata['latitude'] = "-9999"
                metadata['longitude'] = "-9999"
                metadata['altitude'] = "-9999"

            # --- Date Taken ---
            # Stored in 'Exif' section under tag 36867 = DateTimeOriginal
            if 'Exif' in exif_dict:
                exif_info = exif_dict['Exif']
                datetime_tag = 36867  # DateTimeOriginal
                if datetime_tag in exif_info:
                    metadata['date_taken'] = exif_info[datetime_tag].decode('utf-8')
                else:
                    metadata['date_taken'] = "N/A"
            else:
                metadata['date_taken'] = "N/A"

            description = None
            # Check IFD0 (Image) tags for ImageDescription
            if "0th" in exif_dict and piexif.ImageIFD.ImageDescription in exif_dict["0th"]:
                description = exif_dict["0th"][piexif.ImageIFD.ImageDescription]
                if isinstance(description, bytes):
                    metadata['description'] = description.decode('utf-8', errors='ignore')
                else:
                    metadata['description'] = "N/A"
            else:
                metadata['description'] = "N/A"

            # print(f"Coordinates: {metadata.get('latitude')}, {metadata.get('longitude')}")
            # print(f"Other: {metadata.get('altitude')}, {metadata.get('date_taken')}")
            return metadata

        except Exception as e:
            print(f"Error reading metadata: {e}")
            return None
    # =====================================================================================


    # =====================================================================================
    def set_metadata(self,image_path, parameta):
        print("OK")
    # =====================================================================================
    def save_img_jira(self):
        wekaFil = self.view_path.text() # file pth
        wekaLat = self.latitude_edit.text().strip()  # Remove whitespace
        wekaLon = self.longitude_edit.text().strip()
        wekaAlt = self.altitude_edit.text().strip()
        wekaDat = self.datetime_edit.text().strip()
        wekaDes = self.decription_edit.text().strip()

        def is_number(s):
            # Check if string is a valid number (int or float, positive or negative)
            try:
                float(s)  # Try converting to float
                return True
            except ValueError:
                return False

        if not is_number(wekaLat):
            self.tab2_jumbe.setText("Latitude must be a number!")
            self.tab2_jumbe.setStyleSheet("background: red")
        elif not is_number(wekaLon):
            self.tab2_jumbe.setText("Longitude must be a number!")
            self.tab2_jumbe.setStyleSheet("background: red")
        elif not is_number(wekaAlt):
            self.tab2_jumbe.setText("Altitude must be a number!")
            self.tab2_jumbe.setStyleSheet("background: red")
        else:
            # All inputs are valid numbers
            lat = float(wekaLat)
            lon = float(wekaLon)
            alt = float(wekaAlt)

            self.tab2_jumbe.setText(f"Valid coordinates")
            self.tab2_jumbe.setStyleSheet("background: green")
            self.set_exif_data(wekaFil, lat, lon, alt, wekaDat, wekaDes, None)
    # =====================================================================================
    def add_jira(self, jira):
        # Define your location (longitude, latitude)
        jina = jira['File Name']
        if jira['Longitude'] != "N/A" and jira['Latitude'] != "N/A":
            jiraLon = float(jira['Longitude'])
            jiraLat = float(jira['Latitude'])

            # Create point in WGS 84
            wgs84 = QgsCoordinateReferenceSystem("EPSG:4326")
            map_crs = iface.mapCanvas().mapSettings().destinationCrs()
            transform = QgsCoordinateTransform(wgs84, map_crs, QgsProject.instance())
            projected_point = transform.transform(QgsPointXY(jiraLon, jiraLat))

            # Clear previous marker if any
            canvas = iface.mapCanvas()
            if hasattr(self, 'marker') and self.marker:
                canvas.scene().removeItem(self.marker)

            # Create a new marker
            self.marker = QgsVertexMarker(self.canvas)
            self.marker.setCenter(projected_point)
            self.marker.setColor(Qt.red)
            self.marker.setIconSize(20)
            self.marker.setIconType(QgsVertexMarker.ICON_CROSS)  # or ICON_BOX, ICON_CIRCLE

            # Zoom to the location
            self.canvas.setCenter(projected_point)
            self.canvas.zoomScale(5000)  # Adjust zoom level (smaller number = more zoomed in)
            self.canvas.refresh()
        else:
            self.tab1_jumbe.setText("No coordinates")
            self.tab1_jumbe.setStyleSheet("background: red")

    # =====================================================================================
    # Chora Nukta
    def choraJiraNukta(self, Nukta):
        print(Nukta)
        iGeoP = QgsVectorLayer("Point?crs=epsg:4326", "Jira-Nukta", "memory")
        jGeoP = iGeoP.dataProvider()
        jGeoP.addAttributes([QgsField('__id', QVariant.String)])
        jGeoP.addAttributes([QgsField('name', QVariant.String)])
        jGeoP.addAttributes([QgsField('longitude', QVariant.String)])
        jGeoP.addAttributes([QgsField('latitude', QVariant.String)])
        jGeoP.addAttributes([QgsField('altitude', QVariant.String)])
        jGeoP.addAttributes([QgsField('date', QVariant.String)])
        jGeoP.addAttributes([QgsField('description', QVariant.String)])
        iGeoP.updateFields()

        # --------------------------------------------------------
        # Convert and add features
        features = []
        for row in Nukta:
            try:
                lon = float(row["Longitude"])
                lat = float(row["Latitude"])
                point = QgsGeometry.fromWkt(f"POINT({lon} {lat})")

                feat = QgsFeature()
                feat.setGeometry(point)
                feat.setAttributes([
                    row.get("Na", ""),
                    row.get("File Name", ""),
                    row.get("Longitude", ""),
                    row.get("Latitude", ""),
                    row.get("Altitude", ""),
                    row.get("Date Taken", ""),
                    row.get("Description", "")
                ])
                features.append(feat)
            except Exception as e:
                #print(f"Skipping row due to error: {e}")
                self.tab3_jumbe.setText(f"Skipping feature due to error: {e}")
                self.tab3_jumbe.setStyleSheet("background: red")

        # Add features
        jGeoP.addFeatures(features)
        iGeoP.updateFields()
        iGeoP.updateExtents()

        # Add layer to project
        QgsProject.instance().addMapLayer(iGeoP)

        # --------------------------------------------------------
        self.tab3_jumbe.setText('Point Layer Added)')
        self.tab3_jumbe.setStyleSheet("background: green")
        return None
    # =====================================================================================
    # Export to CSV
    def csvJiraNukta(self, Nukta, parent: QWidget = None):
    #def save_dict_to_csv(data: list[dict], parent: QWidget = None):
        if not Nukta:
            self.tab3_jumbe.setText('No data to save')
            self.tab3_jumbe.setStyleSheet("background: red")
            return

        # Open save file dialog
        options = QFileDialog.Options()
        file_path, _ = QFileDialog.getSaveFileName(
            parent,"Save CSV File", "",
            "CSV Files (*.csv);;All Files (*)", options=options)

        if not file_path:
            self.tab3_jumbe.setText('Save cancelled')
            self.tab3_jumbe.setStyleSheet("background: red")
            return

        try:
            # Get field names from first dict
            fieldnames = Nukta[0].keys()
            with open(file_path, "w", newline="", encoding="utf-8") as csvfile:
                writer = csv.DictWriter(csvfile, fieldnames=fieldnames)
                writer.writeheader()
                writer.writerows(Nukta)

            self.tab3_jumbe.setText(f"CSV saved to: {file_path}")
            self.tab3_jumbe.setStyleSheet("background: green")

        except Exception as e:
            self.tab3_jumbe.setText(f"Error saving CSV: {e}")
            self.tab3_jumbe.setStyleSheet("background: red")

    # =====================================================================================
    def has_latitude(image_path):
        try:
            exif_dict = piexif.load(image_path)

            gps_ifd = exif_dict.get("GPS", {})

            # GPSLatitude (2) and GPSLatitudeRef (1) must be present
            if 2 in gps_ifd and 1 in gps_ifd:
                return True
            else:
                return False

        except Exception as e:
            print(f"Error reading EXIF from {image_path}: {e}")
            return False
    # =====================================================================================
    # ====================================================================================
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # Picha
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    def get_foopichaimg(self, jira):
        qkalag = QColor("#00ff00")  # Green
        qkalar = QColor("#ff0000")  # Red
        path = self.dir_combo.currentText()
        jiraJina = jira['File Name']
        if jira['Longitude'] != "N/A" or jira['Latitude'] != "N/A":
            jiraLon = float(jira['Longitude'])
            jiraLat = float(jira['Latitude'])
            jiraAlt = float(jira['Altitude'])
            self.latitude_edit.setText(str(jiraLat))
            self.longitude_edit.setText(str(jiraLon))
            self.altitude_edit.setText(str(jiraAlt))
        else:
            self.latitude_edit.setText("")
            self.longitude_edit.setText("")
            self.altitude_edit.setText("")
            self.latitude_edit.setPlaceholderText("Please enter latitude")
            self.longitude_edit.setPlaceholderText("Please enter longitude")
            self.altitude_edit.setPlaceholderText("Please enter altitude")

        if jira['Date Taken'] != "N/A":
            jiraDes = jira['Date Taken']
            idt = QDateTime.fromString(jiraDes, "yyyy:MM:dd HH:mm:ss")
            self.datetime_edit.setDateTime(idt)
        else:
            self.datetime_edit.setDateTime(QDateTime.currentDateTime())  # Set current datetime

        if jira['Description'] != "N/A":
            jiraDes = jira['Description']
            self.decription_edit.setText(str(jiraDes))
        else:
            self.decription_edit.setText("N/A")

        dir_path = os.path.normpath(path)
        if not os.path.isdir(dir_path):
            return

        file_path = os.path.join(dir_path, jiraJina)
        if not file_path.lower().endswith(('.jpg', '.jpeg', '.dgn')):
            return

        #file_path = "/Users/cuthbertmushi/Downloads/cku/DJI_0640.jpg"
        self.view_path.setText(file_path)
        # Load with PIL
        try:
            pil_image = Image.open(file_path)
            pil_image = pil_image.convert("RGBA")
            data = pil_image.tobytes("raw", "RGBA")
            qimage = QImage(data, pil_image.width, pil_image.height, QImage.Format_RGBA8888)
            pixmap = QPixmap.fromImage(qimage)

            if pixmap.isNull():
                self.tab2_jumbe.setText("PIL Error")
                self.tab2_jumbe.setStyleSheet("background-color: #ff0000;")
            else:
                # ✅ Scale the pixmap to fit the QLabel while maintaining aspect ratio
                scaled_pixmap = pixmap.scaled(
                    self.image_label.width(),
                    self.image_label.height(),
                    Qt.AspectRatioMode.KeepAspectRatio,
                    Qt.TransformationMode.SmoothTransformation
                )

                self.image_label.setPixmap(scaled_pixmap)
                #self.image_label.setPixmap(pixmap)
                self.tab2_jumbe.setText("Image Loaded")
                self.tab2_jumbe.setStyleSheet("background-color: #00ff00;")
        except Exception as e:
            self.tab2_jumbe.setText(f"Error loading image via PIL: {e}")
            self.tab2_jumbe.setStyleSheet("background-color: #8B0000;")

        # Show Tab 2
        self.tab_widget.setCurrentIndex(1)

    # =====================================================================================
    # Degreea => Decimal to DDMMSS
    def deg_to_dms_rational(self, deg):
        """Convert decimal degrees to degrees, minutes, seconds tuple for EXIF."""
        d = int(deg)
        md = abs(deg - d) * 60
        m = int(md)
        sd = (md - m) * 60
        return ((abs(d), 1), (m, 1), (int(sd * 100), 100))
    # =====================================================================================
    # Update location
    def set_gps_location(self, exif_dict, lat, lng, alt):
        # Latitude
        lat_ref = 'N' if lat >= 0 else 'S'
        exif_dict['GPS'][piexif.GPSIFD.GPSLatitudeRef] = lat_ref.encode()
        exif_dict['GPS'][piexif.GPSIFD.GPSLatitude] = self.deg_to_dms_rational(lat)

        # Longitude
        lng_ref = 'E' if lng >= 0 else 'W'
        exif_dict['GPS'][piexif.GPSIFD.GPSLongitudeRef] = lng_ref.encode()
        exif_dict['GPS'][piexif.GPSIFD.GPSLongitude] = self.deg_to_dms_rational(lng)

        # Altitude
        exif_dict['GPS'][piexif.GPSIFD.GPSAltitudeRef] = 0  # 0 = above sea level
        exif_dict['GPS'][piexif.GPSIFD.GPSAltitude] = (int(alt * 100), 100)  # meters

    def is_object(self, param):
        return not isinstance(param, (int, float, str, bool, list, tuple, dict, set, type(None)))

    def update_datetime(self, exif_dict, tarehe):
        print(tarehe)
        exif_dict['Exif'][piexif.ExifIFD.DateTimeOriginal] = tarehe

    def update_description(self, exif_dict, description):
        user_comment = description.encode('utf-8')
        exif_dict['0th'][piexif.ImageIFD.ImageDescription] = user_comment

    # =====================================================================================
    def set_exif_data(self, img_path, lat, lng, alt, idatetime, description, output_path=None):
        # Load image and EXIF data
        img = Image.open(img_path)

        # ✅ Safe loading of EXIF data
        # exif_dict = piexif.load(img.info.get("exif", b""))
        try:
            exif_dict = piexif.load(img.info["exif"])
        except (KeyError, piexif.InvalidImageDataError):
            exif_dict = {"0th": {}, "Exif": {}, "GPS": {}, "1st": {}, "thumbnail": None}

        # Make sure GPS and 0th keys exist
        if 'GPS' not in exif_dict:
            exif_dict['GPS'] = {}
        if '0th' not in exif_dict:
            exif_dict['0th'] = {}

        # Set GPS and description
        self.set_gps_location(exif_dict, lat, lng, alt)
        self.update_datetime(exif_dict, idatetime)
        self.update_description(exif_dict, description)

        # Save EXIF back to image
        exif_bytes = piexif.dump(exif_dict)
        if not output_path:
            output_path = img_path  # Overwrite original

        img.save(output_path, exif=exif_bytes)
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # About & Help
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    def load_help_page(self):
        icon_path = os.path.join(os.path.dirname(__file__), "help.html")
        self.help_browser.setSource(QUrl.fromLocalFile(icon_path))

    def load_about_page(self):
        icon_path = os.path.join(os.path.dirname(__file__), "about.html")
        self.about_browser.setSource(QUrl.fromLocalFile(icon_path))
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # Dependencies
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    def check_packages(self):
        try:
            import PIL
            self.bt_pillow.setEnabled(False)
        except ImportError:
            self.bt_pillow.setEnabled(True)
            self.tab_widget.setCurrentIndex(3)
            QMessageBox.warning(self, "Missing", "Pillow")

        try:
            import piexif
            self.bt_piexif.setEnabled(False)
        except ImportError:
            self.bt_piexif.setEnabled(True)
            self.tab_widget.setCurrentIndex(3)
            QMessageBox.warning(self, "Missing", "PiExif")
    # =====================================================================================
    def weka_package(self, jina):
        qgis_python = os.path.join(os.path.dirname(sys.executable), "python3")
        try:
            subprocess.check_call([qgis_python, "-m", "pip", "install", jina])
            QMessageBox.warning(self, "Success", f"{jina} installed successfully")
        except subprocess.CalledProcessError as e:
            QMessageBox.warning(self, "Success", f"Error installing {jina}: {e}")

    def weka_pe(self):
        self.weka_package("piexif")

    def weka_pi(self):
        self.weka_package("pillow")
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # ???
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
