import os.path
import pyplugin_installer
import sys
from qgis.PyQt.QtCore import Qt, QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from .foopichadoku import pichadoku

class foopicha:
    def __init__(self, iface):
        self.iface = iface
        self.canvas = iface.mapCanvas()
        self.marker = None

        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir, 'i18n', 'FooPicha{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Initialize plugin components
        self.actions = []  # This is the critical line that was missing
        self.menu = self.tr(u'&FooPicha')
        #self.toolbar = None
        #self.dock = None

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    #==================================================================================================================
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('foopicha', message)

    # ==================================================================================================================

    def add_action(self, icon_path, text, callback, enabled_flag=True, add_to_menu=True, add_to_toolbar=True,
                   status_tip=None, whats_this=None, parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    # ==================================================================================================================
    def initGui(self):
        """Create the menu entries and toolbar icons"""
        # Create action(s)
        icon_path = os.path.join(self.plugin_dir, 'icon.png')
        #icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        self.action = QAction(QIcon(icon_path), "FooPicha",  self.iface.mainWindow())
        self.action.triggered.connect(self.run)

        # Initialize actions list
        self.add_action(icon_path,text=self.tr(u'FooPicha'), callback=self.run, parent=self.iface.mainWindow())

        # Create dock widget (but don't show it yet)
        self.dock = pichadoku()
        self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dock)

        # will be set False in run()
        self.first_start = True

    # ==================================================================================================================
    def _cleanup(self):
        if hasattr(self, 'iface'):
            # Remove all menu items
            for action in getattr(self, 'actions', []):
                try:
                    self.iface.removePluginMenu("&FooPicha", action)
                    self.iface.removeToolBarIcon(action)
                except:
                    pass
            
            # Remove dock widget
            if hasattr(self, 'dock'):
                try:
                    self.iface.removeDockWidget(self.dock)
                    #self.iface.removeDockWidget(self.dock)
                    self.dock = None
                except:
                    pass

    # ==================================================================================================================
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&FooPicha'), action)
            self.iface.removeToolBarIcon(action)
    # ==================================================================================================================
    def run(self):
        if self.dock:
            self.dock.show()
    # ==================================================================================================================