# -*- coding: utf-8 -*-
"""
/***************************************************************************
                                     FooODK
                                 A QGIS plugin
Pulls data from ODK Central to QGIS, using ODK Central API(based on OData).
                              -------------------
        begin                : 2022-05-10
        git sha              : $Format:%H$
        copyright            : (C) 2022 by CutLan
        email                : cutlan@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
from qgis.PyQt.QtCore import Qt, QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from .fooodkdoku import odkdoku

class fooodk:
    """QGIS Plugin Implementation."""
    
    def __init__(self, iface):
        self.iface = iface
        self.canvas = iface.mapCanvas()
        self.marker = None
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir,'i18n', 'fooodk_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&FooODK')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
    # ====================================================================================
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('fooodk', message)
    # ====================================================================================
    def add_action(self, icon_path, text, callback, enabled_flag=True, add_to_menu=True, add_to_web=True,
                   add_to_toolbar=True, status_tip=None,  whats_this=None, parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        if add_to_web:
            self.iface.addPluginToWebMenu(self.menu, action)

        self.actions.append(action)

        return action

    # ====================================================================================
    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon_path = os.path.join(self.plugin_dir, 'icon.png')
        self.action = QAction(QIcon(icon_path), "FooODK", self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        # Initialize actions list
        #self.add_action(icon_path, text=self.tr(u'FooPicha'), callback=self.run, parent=self.iface.mainWindow())
        self.add_action(icon_path, text=self.tr(u'FooODK'), callback=self.run, parent=self.iface.mainWindow())
        # Create dock widget (but don't show it yet)
        self.dock = odkdoku()
        self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dock)
        # will be set False in run()
        self.first_start = True
    # ====================================================================================
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&FooODK'), action)
            self.iface.removeToolBarIcon(action)
            
    # ====================================================================================================
    # ====================================================================================================

    # ====================================================================================================
    # ====================================================================================================
    def run(self):
        """Run method that performs all the real work"""
        if self.dock:
            self.dock.show()