# -*- coding: utf-8 -*-
"""
/***************************************************************************
                                     FooODK
                                 A QGIS plugin
Pulls data from ODK Central to QGIS, using ODK Central API(based on OData).
                              -------------------
        begin                : 2022-05-10
        git sha              : $Format:%H$
        copyright            : (C) 2025 by CutLan
        email                : cutlan@gmail.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import ast, math, re
import sys, os, os.path, requests, json, subprocess, csv, json
from decimal import Decimal
from io import StringIO
from io import BytesIO
from urllib.parse import quote

from PIL import Image
from datetime import datetime
import pandas as pd
from matplotlib import pyplot as plt
from matplotlib.figure import Figure
from matplotlib.backends.backend_qt5agg import FigureCanvasQTAgg as FigureCanvas
# =====================================================================================
from qgis.PyQt.QtCore import Qt, QDir, QSettings, QVariant, QUrl, QDateTime
from qgis.PyQt.QtGui import (QIcon, QStandardItemModel, QStandardItem, QPixmap,
                             QImage, QPalette, QColor)
from qgis.PyQt.QtWidgets import (QWidget, QDockWidget, QFileSystemModel,QTreeView,
                                 QVBoxLayout, QComboBox, QPushButton, QHBoxLayout,
                                 QTextEdit, QPlainTextEdit, QCheckBox, QTextBrowser,
                                 QTabWidget, QLabel, QGroupBox, QFormLayout, QLineEdit,
                                 QFileDialog, QHeaderView, QScrollArea, QDateTimeEdit)
from qgis._core import (QgsPointXY, QgsVectorLayer, QgsField, QgsFeature, QgsGeometry,
                        QgsProject, QgsCoordinateReferenceSystem, QgsCoordinateTransform,
                        QgsSettings, QgsMarkerSymbol, QgsFields, QgsMessageLog, Qgis)
from qgis._gui import QgsVertexMarker
from qgis.utils import iface, available_plugins, pluginMetadata

from PyQt5.QtCore import QDate, QModelIndex, QMetaType
from PyQt5.QtGui import QTextOption, QFont
from PyQt5.QtWidgets import QRadioButton, QDateEdit, QListWidget, QTreeWidgetItem, QTableView, QTableWidget, \
    QMessageBox, QSpacerItem, QSizePolicy
# =====================================================================================
# =====================================================================================
class odkdoku(QDockWidget):
    def __init__(self, parent=None):
        super().__init__("FooODK", parent)
        self.setObjectName("FooODK")

        # Main widget
        self.main_widget = QWidget()
        self.layout = QVBoxLayout(self.main_widget)

        # Setup UI
        self.setup_ui()

        self.setWidget(self.main_widget)

        # Load last used directory
        settings = QSettings()
        #last_dir = settings.value("picture_browser/last_dir", QDir.homePath())
        #self.set_directory(last_dir)
        #self.check_packages()
        self.get_logins_baruapepe()
        self.check_packages()
        self.load_list_modules()

        self.canvas = iface.mapCanvas()
        self.marker = None

    # =====================================================================================
    # =====================================================================================
    def setup_ui(self):
        # Create a tab widget
        self.tab_widget = QTabWidget()
        self.layout.addWidget(self.tab_widget)

        # Tab 1 - ODK Central Login
        self.odk_tab()

        # Tab 2 - Main Table View
        self.meza_tab()

        # Tab 3 - Sub Table View
        self.takwimu_tab()

        # Tab 4 - Chakata
        self.msaada_tab()

        # Tab 5 - Kuhusu
        self.kuhusu_tab()

    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # Tabs
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    # TAB 1
    def odk_tab(self):
        self.tab1 = QWidget()
        self.tab_widget.addTab(self.tab1, "Projects")
        tab1_layout = QVBoxLayout(self.tab1)
        # ---------------------------------------------------------------------------------
        # Group Login
        self.login_group = QGroupBox("Login Info")
        login_layout = QFormLayout()

        # Domain/URL section
        self.label_msimbo = QLabel("URL(Link)")
        self.msimbo = QLineEdit("")
        self.msimbo.setToolTip("ODK Central Domain (htps://xxxx.domain.xxx)")
        url_layout = QHBoxLayout()
        url_layout.addWidget(self.label_msimbo, 1)  # 25%
        url_layout.addWidget(self.msimbo, 3)  # 75%
        login_layout.addRow(url_layout)

        # Credentials section e-mail
        self.label_jina = QLabel("E-mail")
        self.label_jina.setToolTip("e-mail")
        self.jina = QComboBox()
        self.jina.setEditable(True)
        self.jina.setToolTip("e-mail (xxxxxx@domain.xxx)")
        email_layout = QHBoxLayout()
        email_layout.addWidget(self.label_jina, 1)
        email_layout.addWidget(self.jina,3)
        login_layout.addRow(email_layout)

        # Credentials section password
        self.label_nywila = QLabel("Password")
        self.nywila = QLineEdit()
        self.nywila.setToolTip("Password")
        self.nywila.setEchoMode(QLineEdit.Password)
        password_layout = QHBoxLayout()
        password_layout.addWidget(self.label_nywila,1)
        password_layout.addWidget(self.nywila, 3)
        login_layout.addRow(password_layout)

        # Credentials section save
        self.label_tunza_credential = QLabel("Credentials")
        self.tunza_credential = QCheckBox()
        self.tunza_credential.setText("Store")
        self.ondoa_credential = QCheckBox()
        self.ondoa_credential.setText("Remove")
        safisha_layout = QHBoxLayout()
        safisha_layout.addWidget(self.label_tunza_credential, 1)
        safisha_layout.addWidget(self.tunza_credential, 2)
        safisha_layout.addWidget(self.ondoa_credential,2)
        login_layout.addRow(safisha_layout)
        # Credentials section button login
        self.ingia = QPushButton()
        self.ingia.setText("Login")
        login_layout.addRow(self.ingia)
        self.tunza_credential.stateChanged.connect(self.on_checkbox_state_changed_tunza)
        self.ondoa_credential.stateChanged.connect(self.on_checkbox_state_changed_ondoa)
        self.jina.currentIndexChanged.connect(self.jina_badilika)
        self.ingia.clicked.connect(self.ingiaODK)

        self.login_group.setLayout(login_layout)
        tab1_layout.addWidget(self.login_group)
        # ---------------------------------------------------------------------------------
        # Group Miradi
        self.miradi_group = QGroupBox("Projects Info")
        miradi_layout = QFormLayout()
        # Listi ya Miradi
        self.label_miradi = QLabel("Projects")
        self.miradi_listi = QComboBox()
        miradi_info = QHBoxLayout()
        miradi_info.addWidget(self.label_miradi, 1)
        miradi_info.addWidget(self.miradi_listi, 3)
        miradi_layout.addRow(miradi_info)
        self.miradi_listi.currentTextChanged.connect(self.onselect_mradi)

        self.mradi_json_view = QPlainTextEdit()
        self.mradi_json_view.setReadOnly(True)
        self.mradi_json_view.setWordWrapMode(QTextOption.NoWrap)  # Disable word wrap for JSON
        self.mradi_json_view.setFont(QFont("Courier New", 10))  # Monospace font for JSON
        miradi_layout.addRow(self.mradi_json_view)

        self.miradi_group.setLayout(miradi_layout)
        tab1_layout.addWidget(self.miradi_group)

        # Pakia fomu
        self.ona_fomu = QPushButton()
        self.ona_fomu.setText("Load Forms")
        tab1_layout.addWidget(self.ona_fomu)
        self.ona_fomu.clicked.connect(self.list_forms)

        # --------------------------------------------------------------------------
        # --------------------------------------------------------------------------

    # =====================================================================================
    # =====================================================================================
     # TAB 2
    def meza_tab(self):
        self.tab2 = QWidget()
        self.tab_widget.addTab(self.tab2, "Form")
        tab2_layout = QVBoxLayout(self.tab2)

        # Group Mradi
        self.mradi_group = QGroupBox("Selection")
        mradi_layout = QFormLayout()
        # Listi ya Miradi
        self.label_fomu = QLabel("Form")
        self.fomu_listi = QComboBox()
        fomu_info = QHBoxLayout()
        fomu_info.addWidget(self.label_fomu, 1)
        fomu_info.addWidget(self.fomu_listi, 3)
        mradi_layout.addRow(fomu_info)

        self.mradi_group.setLayout(mradi_layout)
        tab2_layout.addWidget(self.mradi_group)
        # ---------------------------------------------------------------------------------
        # Group Fomu
        self.fomu_group = QGroupBox("Metadata")
        fomu_layout = QFormLayout()
        # Fomu Taarifa
        self.tab_fomu = QTabWidget()
        # Tab 1: Listbox
        self.fomu_tab1 = QWidget()
        fomu_tab1_layout = QVBoxLayout()
        self.fomu_json_view = QPlainTextEdit()
        self.fomu_json_view.setReadOnly(True)
        self.fomu_json_view.setWordWrapMode(QTextOption.NoWrap)  # Disable word wrap for JSON
        self.fomu_json_view.setFont(QFont("Courier New", 10))  # Monospace font for JSON
        fomu_tab1_layout.addWidget(self.fomu_json_view)
        self.fomu_tab1.setLayout(fomu_tab1_layout)

        # Tab 2: Fields
        self.fomu_tab2 = QWidget()
        fomu_tab2_layout = QVBoxLayout()
        self.fomu_tab2_treeview = QTreeView()
        self.fomu_model = QStandardItemModel()
        self.fomu_tab2_treeview.setModel(self.fomu_model)
        self.fomu_model.setHorizontalHeaderLabels(["Name", "Type", "Path", "Properties"])
        fomu_tab2_layout.addWidget(self.fomu_tab2_treeview)
        self.fomu_tab2.setLayout(fomu_tab2_layout)

        # Tab 3: Entities
        self.fomu_tab3 = QWidget()
        fomu_tab3_layout = QVBoxLayout()
        self.fomu_tab3_treeview = QTreeView()
        self.entity_model = QStandardItemModel()
        self.fomu_tab3_treeview.setModel(self.entity_model)
        self.entity_model.setHorizontalHeaderLabels(["Name", "Type"])
        fomu_tab3_layout.addWidget(self.fomu_tab3_treeview)
        self.fomu_tab3.setLayout(fomu_tab3_layout)

        # Tab 4: Users
        self.fomu_tab4 = QWidget()
        fomu_tab4_layout = QVBoxLayout()
        self.fomu_tab4_treeview = QTreeView()
        self.user_model = QStandardItemModel()
        self.fomu_tab4_treeview.setModel(self.user_model)
        self.user_model.setHorizontalHeaderLabels(["Name", "Type"])
        fomu_tab4_layout.addWidget(self.fomu_tab4_treeview)
        self.fomu_tab4.setLayout(fomu_tab4_layout)

        # --------------------------------------------------------------------------
        # Add tabs to tab widget
        self.tab_fomu.addTab(self.fomu_tab1, "Details")
        self.tab_fomu.addTab(self.fomu_tab2, "Fields")
        self.tab_fomu.addTab(self.fomu_tab3, "Entities")
        self.tab_fomu.addTab(self.fomu_tab4, "Users")
        #self.tab_fomu.addTab(self.fomu_tab5, "Downloads")

        # Add tab widget to the main layout
        fomu_layout.addRow(self.tab_fomu)
        self.fomu_group.setLayout(fomu_layout)
        tab2_layout.addWidget(self.fomu_group)
        # --------------------------------------------------------------------------
        # Group Parameta
        self.data_group = QGroupBox("Filters")
        data_layout = QFormLayout()

        # Chagua tarehe
        self.label_tarehe = QLabel("By")
        self.takwimu_kwa = QComboBox()
        self.idadi_listi = QComboBox()

        tarehe_info = QHBoxLayout()
        tarehe_info.addWidget(self.label_tarehe, 1)
        tarehe_info.addWidget(self.takwimu_kwa, 2)
        tarehe_info.addWidget(self.idadi_listi, 3)
        data_layout.addRow(tarehe_info)

        # Tarehe
        self.tarehe_listi = QComboBox()
        self.tarehemwanzo = QDateEdit(QDate.currentDate())
        self.tarehemwanzo.setDisplayFormat("dd-MM-yyyy")
        self.tarehemwanzo.setToolTip("Start Date")
        self.tarehemwanzo.setCalendarPopup(True)
        self.label_9 = QLabel(" < ")
        self.tarehemwisho = QDateEdit(QDate.currentDate())
        self.tarehemwisho.setDisplayFormat("dd-MM-yyyy")
        self.tarehemwisho.setToolTip("End Date")
        self.tarehemwisho.setCalendarPopup(True)

        date_layout = QHBoxLayout()
        date_layout.addWidget(self.tarehe_listi, 3)
        date_layout.addWidget(self.tarehemwanzo, 2)
        date_layout.addWidget(self.label_9, 1)
        date_layout.addWidget(self.tarehemwisho, 2)
        data_layout.addRow(date_layout)
        self.tarehe_listi.setEnabled(False)
        self.tarehemwanzo.setEnabled(False)
        self.label_9.setEnabled(False)
        self.tarehemwisho.setEnabled(False)

        lodi_layout = QHBoxLayout()
        #self.kurasa = QComboBox()
        self.pakia_takwimu = QPushButton()
        self.pakia_takwimu.setText("Load Data")
        #lodi_layout.addWidget(self.kurasa, 1)
        lodi_layout.addWidget(self.pakia_takwimu, 1)
        data_layout.addRow(lodi_layout)

        self.data_group.setLayout(data_layout)
        tab2_layout.addWidget(self.data_group)
        # --------------------------------------------------------------------------
        self.fomu_listi.currentTextChanged.connect(self.list_iterms)
        # connect signal to change visibility
        self.takwimu_kwa.currentIndexChanged.connect(self.on_takwimu_changed)
        self.idadi_listi.currentIndexChanged.connect(self.idadi_listi_changed)
        self.pakia_takwimu.clicked.connect(self.pakia_takwimu_kliki)
    # =====================================================================================
    # =====================================================================================
    # TAB 3
    def takwimu_tab(self):
        """Create the statistics tab with multiple sub-tabs for data visualization"""
        self.tab3 = QWidget()
        self.tab_widget.addTab(self.tab3, "Data")
        tab3_layout = QVBoxLayout(self.tab3)

        # Main tab widget for statistics
        self.tab_takwimu = QTabWidget()

        # --------------------------------------------------------------------------
        # Tab 1: Data Table (Meza)
        self.takwimu_tab1 = QWidget()
        takwimu_tab1_layout = QVBoxLayout(self.takwimu_tab1)

        # Kurasa
        kurasa_container = QWidget()
        kurasa_info = QHBoxLayout(kurasa_container)
        self.kurasa = QComboBox()
        self.kurasar = QPushButton("Repeats")
        self.kurasar.setEnabled(False)
        self.flati = QCheckBox("Group")
        self.flati.setChecked(False)  # Check the checkbox
        #kurasa_info.addWidget(self.mfomu,2)
        kurasa_info.addWidget(self.kurasa, 3)
        kurasa_info.addWidget(self.kurasar, 1)
        takwimu_tab1_layout.addWidget(kurasa_container)

        # Table view for data display
        self.takwimu_meza = QTableView()
        self.takwimu_meza.setSelectionBehavior(QTableView.SelectRows)
        self.takwimu_meza.horizontalHeader().setStretchLastSection(True)
        takwimu_tab1_layout.addWidget(self.takwimu_meza)

        # Field selection for plotting
        chora_container = QWidget()
        jira_info = QHBoxLayout(chora_container)
        self.jira_listi = QComboBox()
        self.jira_chora = QPushButton("Plot")
        jira_info.addWidget(self.jira_listi, 3)
        jira_info.addWidget(self.jira_chora, 1)
        takwimu_tab1_layout.addWidget(chora_container)

        # Plot/Export buttons
        ambata_container = QWidget()
        ambata_info = QHBoxLayout(ambata_container)
        self.pakia_vyote = QPushButton("Attachments")
        self.pakia_chakata = QPushButton("Analysis")
        ambata_info.addWidget(self.pakia_vyote)
        ambata_info.addWidget(self.pakia_chakata)
        takwimu_tab1_layout.addWidget(ambata_container)


        # Matukio
        self.kurasar.clicked.connect(self.sabufomu_ona)
        self.kurasa.currentTextChanged.connect(self.kurasa_listi_changed)
        self.takwimu_meza.clicked.connect(self.onClicked_OnaJira)
        self.jira_listi.currentTextChanged.connect(self.data_ploti_e)
        self.jira_chora.clicked.connect(self.data_ploti_a)
        self.pakia_chakata.clicked.connect(self.takwimu_chakata_a)
        self.takwimu_meza.doubleClicked.connect(self.zoomDkliki)
        self.pakia_vyote.clicked.connect(self.pakia_viambata_vyote)
        # --------------------------------------------------------------------------
        # Tab 1: Data Table (Meza Ndogo)
        self.takwimu_tab5 = QWidget()
        takwimu_tab5_layout = QVBoxLayout(self.takwimu_tab5)
        # Kurasa
        kurasa_rcontainer = QWidget()
        kurasa_rinfo = QHBoxLayout(kurasa_rcontainer)
        self.rudia = QComboBox()
        self.rudia.setDisabled(True)
        kurasa_rinfo.addWidget(self.rudia)
        takwimu_tab5_layout.addWidget(kurasa_rcontainer)

        # Table view for data display
        self.takwimu_rmeza = QTableView()
        self.takwimu_rmeza.setSelectionBehavior(QTableView.SelectRows)
        self.takwimu_rmeza.horizontalHeader().setStretchLastSection(True)
        takwimu_tab5_layout.addWidget(self.takwimu_rmeza)

        # Field selection for plotting
        chora_rcontainer = QWidget()
        jira_rinfo = QHBoxLayout(chora_rcontainer)
        self.jira_rlisti = QComboBox()
        self.jira_rchora = QPushButton("Plot")
        jira_rinfo.addWidget(self.jira_rlisti, 3)
        jira_rinfo.addWidget(self.jira_rchora, 1)
        takwimu_tab5_layout.addWidget(chora_rcontainer)

        # Plot/Export buttons
        chakata_rcontainer = QWidget()
        chakata_rinfo = QHBoxLayout(chakata_rcontainer)
        self.pakia_rchakata = QPushButton("Analysis")
        chakata_rinfo.addWidget(self.pakia_rchakata)
        takwimu_tab5_layout.addWidget(chakata_rcontainer)

        # Matukio
        self.rudia.currentTextChanged.connect(self.sabufomu_changed)
        self.takwimu_rmeza.clicked.connect(self.onClicked_OnaJirar)
        self.jira_rlisti.currentTextChanged.connect(self.data_ploti_er)
        self.jira_rchora.clicked.connect(self.data_ploti_ar)
        self.pakia_rchakata.clicked.connect(self.takwimu_chakata_a)
        # --------------------------------------------------------------------------
        # Tab 2: Attachments (Viambata)
        self.takwimu_tab2 = QWidget()
        takwimu_tab2_layout = QVBoxLayout(self.takwimu_tab2)

        # Viambata
        self.takwimu_tab2_meza = QTreeView()
        self.takwimu_tab2_model = QStandardItemModel()
        self.takwimu_tab2_meza.setModel(self.takwimu_tab2_model)
        self.takwimu_tab2_model.setHorizontalHeaderLabels(["__id", "Name", "Size", "Date", "Location", "URL"])
        self.takwimu_tab2_meza.setEditTriggers(QTreeView.NoEditTriggers)
        self.takwimu_tab2_meza.setSelectionBehavior(QTreeView.SelectRows)
        self.takwimu_tab2_meza.setSelectionMode(QTreeView.SingleSelection)
        self.pakia_oditi_zote = QPushButton("Load All Audits")

        self.takwimu_tab2_meza.doubleClicked.connect(self.pakia_1c_kiambata)
        self.pakia_oditi_zote.clicked.connect(self.pakia_1d_viambata)
        takwimu_tab2_layout.addWidget(self.takwimu_tab2_meza)
        takwimu_tab2_layout.addWidget(self.pakia_oditi_zote)

        # --------------------------------------------------------------------------
        # Tab 3: Image Viewer (Ona Picha)
        self.takwimu_tab3 = QWidget()
        takwimu_tab3_layout = QVBoxLayout(self.takwimu_tab3)

        # Kombo
        kombo_pakia = QWidget()
        kombo_info = QHBoxLayout(kombo_pakia)
        self.pakia_mael_img = QComboBox()
        self.pakia_jira_img = QComboBox()
        self.load_batani = QPushButton("Load")
        kombo_info.addWidget(self.pakia_mael_img)
        kombo_info.addWidget(self.pakia_jira_img)
        kombo_info.addWidget(self.load_batani)
        self.load_batani.clicked.connect(self.pakia_img_meta)

        # Image display area
        self.image_label = QLabel()
        self.image_label.setScaledContents(True)

        # GPS information group box
        gps_group = QGroupBox("Metadata")
        gps_layout = QFormLayout()

        # path
        self.view_path = QLineEdit()
        self.view_path.setReadOnly(True)
        self.view_uuid = QLineEdit()
        self.view_uuid.setReadOnly(True)
        # Coordinate fields
        self.latitude_edit = QLineEdit()
        self.longitude_edit = QLineEdit()
        self.altitude_edit = QLineEdit()
        self.datetime_edit = QDateTimeEdit()
        self.decription_edit = QLineEdit()

        # Set placeholders
        self.latitude_edit.setPlaceholderText("e.g., 37.7749")
        self.longitude_edit.setPlaceholderText("e.g., -122.4194")
        self.altitude_edit.setPlaceholderText("e.g., 10.5")
        self.datetime_edit.setDisplayFormat("yyyy:MM:dd HH:mm:ss")
        self.datetime_edit.setCalendarPopup(True)  # Enable calendar dropdown
        self.datetime_edit.setDateTime(QDateTime.currentDateTime())  # Set current datetime
        self.decription_edit.setPlaceholderText("e.g., Image detials")

        # Add fields to form
        gps_layout.addRow("Path:", self.view_path)
        gps_layout.addRow("UUID:", self.view_uuid)
        gps_layout.addRow("Latitude:", self.latitude_edit)
        gps_layout.addRow("Longitude:", self.longitude_edit)
        gps_layout.addRow("Altitude (m):", self.altitude_edit)
        gps_layout.addRow("Date-Time:", self.datetime_edit)
        gps_layout.addRow("Description:", self.decription_edit)
        gps_group.setLayout(gps_layout)

        # Save button
        batani_picha = QWidget()
        batani_picha_info = QHBoxLayout(batani_picha)
        self.save_batani = QPushButton("Save an image")
        self.save_batanj = QPushButton("Save all Images")
        batani_picha_info.addWidget(self.save_batani)
        batani_picha_info.addWidget(self.save_batanj)
        self.save_batani.clicked.connect(self.save_img_jira_one)
        self.save_batanj.clicked.connect(self.save_img_jira_all)


        takwimu_tab3_layout.addWidget(kombo_pakia)
        takwimu_tab3_layout.addWidget(self.image_label, stretch=1)
        takwimu_tab3_layout.addWidget(gps_group)
        takwimu_tab3_layout.addWidget(batani_picha)

        # --------------------------------------------------------------------------
        # Tab 4: Audits (Ufwatiliaji)
        self.takwimu_tab4 = QWidget()
        takwimu_tab4_layout = QVBoxLayout(self.takwimu_tab4)
        self.takwimu_tab4_meza = QTableView()
        self.takwimu_tab4_meza.setSelectionBehavior(QTableView.SelectRows)
        self.audit_model = QStandardItemModel()
        headers = ['Event', 'Node', 'Start', 'End', 'Latitude', 'Longitude', 'Accuracy',
                   'Old Value', 'New Value','Time(Minutes)']
        self.audit_model.setHorizontalHeaderLabels(headers)
        self.takwimu_tab4_meza.setModel(self.audit_model)

        # Audit buttons
        audit_button_container = QWidget()
        audit_button_layout = QHBoxLayout(audit_button_container)
        self.oditi_chora = QPushButton("Plot")
        self.oditi_chakata = QPushButton("Analysis")
        audit_button_layout.addWidget(self.oditi_chora)
        audit_button_layout.addWidget(self.oditi_chakata)

        takwimu_tab4_layout.addWidget(self.takwimu_tab4_meza)
        takwimu_tab4_layout.addWidget(audit_button_container)

        # Matukio
        self.takwimu_tab4_meza.clicked.connect(self.onClicked_OnaJiraAudit)
        self.oditi_chora.clicked.connect(self.oditi_ploti_a)
        self.oditi_chakata.clicked.connect(self.oditi_chakata_a)

        # --------------------------------------------------------------------------
        # Add all tabs to the main tab widget
        self.tab_takwimu.addTab(self.takwimu_tab1, "Data")
        self.tab_takwimu.addTab(self.takwimu_tab5, "Repeat")
        self.tab_takwimu.addTab(self.takwimu_tab2, "Attachments")
        self.tab_takwimu.addTab(self.takwimu_tab3, "Image Viewer")
        self.tab_takwimu.addTab(self.takwimu_tab4, "Audit Logs")

        # Add main tab widget to the tab layout
        tab3_layout.addWidget(self.tab_takwimu)

        # Connect form selection change
        #self.fomu_listi.currentTextChanged.connect(self.load_form_data)

    # =====================================================================================
    # =====================================================================================
    # TAB 4 - Chakata
    def msaada_tab(self):
        self.tab4 = QWidget()
        self.tab_widget.addTab(self.tab4, "Analysis")
        tab4_layout = QVBoxLayout(self.tab4)

        # Main tab widget for statistics
        self.tab_akaunti = QTabWidget()
        # --------------------------------------------------------------------------
        # Tab 1: Chakata
        self.akaunti_tab1 = QWidget()
        akaunti_tab1_layout = QVBoxLayout(self.akaunti_tab1)

        # Group
        self.chakata_group = QGroupBox("Parameters")
        chakata_layout = QFormLayout()
        # Listi roo
        self.label_a = QLabel("Rows")
        self.chakatai = QComboBox()
        chakatai_info = QHBoxLayout()
        chakatai_info.addWidget(self.label_a, 1)
        chakatai_info.addWidget(self.chakatai, 3)
        chakata_layout.addRow(chakatai_info)

        self.label_e = QLabel("Column")
        self.chakatei = QComboBox()
        chakatei_info = QHBoxLayout()
        chakatei_info.addWidget(self.label_e, 1)
        chakatei_info.addWidget(self.chakatei, 3)
        chakata_layout.addRow(chakatei_info)

        self.label_o = QLabel("Values")
        self.chakatoi = QComboBox()
        chakatoi_info = QHBoxLayout()
        chakatoi_info.addWidget(self.label_o, 1)
        chakatoi_info.addWidget(self.chakatoi, 3)
        chakata_layout.addRow(chakatoi_info)

        self.label_oj = QLabel("Math")
        self.chakatoj = QComboBox()
        chakatoj_info = QHBoxLayout()
        chakatoj_info.addWidget(self.label_oj, 1)
        chakatoj_info.addWidget(self.chakatoj, 3)
        chakata_layout.addRow(chakatoj_info)

        self.chakata_group.setLayout(chakata_layout)
        akaunti_tab1_layout.addWidget(self.chakata_group)

        self.akaunti_tab1_tv = QTreeView()
        self.akaunti_tab1_model = QStandardItemModel()
        self.akaunti_tab1_tv.setModel(self.akaunti_tab1_model)
        self.akaunti_tab1_model.setHorizontalHeaderLabels(["__id", "Name"])
        akaunti_tab1_layout.addWidget(self.akaunti_tab1_tv)

        # Save button
        self.batani_grafu = QPushButton("Graph")
        self.batani_wordcount = QPushButton("Word Count")
        batani_chakata_info = QHBoxLayout()
        batani_chakata_info.addWidget(self.batani_grafu)
        #batani_chakata_info.addWidget(self.batani_wordcount)
        akaunti_tab1_layout.addLayout(batani_chakata_info)

        self.chakatai.currentTextChanged.connect(lambda _: self.takwimu_chakata_b())
        self.chakatei.currentTextChanged.connect(lambda _: self.takwimu_chakata_b())
        self.chakatoi.currentTextChanged.connect(lambda _: self.takwimu_chakata_b())
        self.chakatoj.currentTextChanged.connect(lambda _: self.takwimu_chakata_b())
        self.batani_grafu.clicked.connect(self.takwimu_chakata_c)
        self.batani_wordcount.clicked.connect(self.takwimu_chakata_d)
        # --------------------------------------------------------------------------
        # Tab 2: Chakata Oditi
        self.audit_tab2 = QWidget()
        audit_tab2_layout = QVBoxLayout(self.audit_tab2)

        # Group
        self.audit_group = QGroupBox("Parameters")
        audit_layout = QFormLayout()
        # Listi roo
        self.label_au = QLabel("Index(Rows)")
        self.auditi = QComboBox()
        audit_info = QHBoxLayout()
        audit_info.addWidget(self.label_au, 1)
        audit_info.addWidget(self.auditi, 3)
        audit_layout.addRow(audit_info)

        self.label_eu = QLabel("Values")
        self.auditk = QComboBox()
        audjt_info = QHBoxLayout()
        audjt_info.addWidget(self.label_eu, 1)
        audjt_info.addWidget(self.auditk, 3)
        audit_layout.addRow(audjt_info)

        self.label_io = QLabel("Maths")
        self.auditn = QComboBox()
        auditm_info = QHBoxLayout()
        auditm_info.addWidget(self.label_io, 1)
        auditm_info.addWidget(self.auditn, 3)
        audit_layout.addRow(auditm_info)

        self.audit_group.setLayout(audit_layout)
        audit_tab2_layout.addWidget(self.audit_group)

        self.audit_tab1_tv = QTreeView()
        self.audit_tab1_model = QStandardItemModel()
        self.audit_tab1_tv.setModel(self.audit_tab1_model)
        self.audit_tab1_model.setHorizontalHeaderLabels(["__id", "Name"])
        audit_tab2_layout.addWidget(self.audit_tab1_tv)

        self.auditi.currentTextChanged.connect(lambda _: self.oditi_chakata_b())
        self.auditk.currentTextChanged.connect(lambda _: self.oditi_chakata_b())
        self.auditn.currentTextChanged.connect(lambda _: self.oditi_chakata_b())
        # --------------------------------------------------------------------------
        # Tab 3: Kuona grafu
        self.grafu_tab3 = QWidget()
        grafu_tab3_layout = QVBoxLayout(self.grafu_tab3)
        # Group
        self.grafu_group = QGroupBox("Visualization")
        self.grafu_layout = QFormLayout(self.grafu_group)
        self.grafu_group.setLayout(self.grafu_layout)
        grafu_tab3_layout.addWidget(self.grafu_group)
        # --------------------------------------------------------------------------
        # Tab 4: Maneno
        self.word_tab4 = QWidget()
        wc_tab4_layout = QVBoxLayout(self.word_tab4)
        # Kolamu
        self.wc_label = QLabel("Column")
        self.wc_cb = QComboBox()
        wc_info = QHBoxLayout()
        wc_info.addWidget(self.wc_label, 1)
        wc_info.addWidget(self.wc_cb, 3)
        wc_tab4_layout.addLayout(wc_info)
        # Group
        self.word_group = QGroupBox("Visualization")
        self.word_layout = QFormLayout(self.word_group)
        self.word_group.setLayout(self.word_layout)
        wc_tab4_layout.addWidget(self.word_group)

        self.wc_cb.currentTextChanged.connect(lambda _: self.takwimu_chakata_d())

    # --------------------------------------------------------------------------
        # Add all tabs to the main tab widget
        self.tab_akaunti.addTab(self.akaunti_tab1, "Data")
        self.tab_akaunti.addTab(self.audit_tab2, "Audit")
        self.tab_akaunti.addTab(self.grafu_tab3, "Chart")
        self.tab_akaunti.addTab(self.word_tab4, "Words")

        # Add main tab widget to the tab layout
        tab4_layout.addWidget(self.tab_akaunti)
    # =====================================================================================
    # =====================================================================================
    # TAB 5
    def kuhusu_tab(self):
        self.tab5 = QWidget()
        self.tab_widget.addTab(self.tab5, "Help")
        tab5_layout = QVBoxLayout(self.tab5)

        # Main tab widget for statistics
        self.tab_kuhusu = QTabWidget()
        # --------------------------------------------------------------------------
        # Tab 1: Msaada
        self.kuhusu_tab1 = QWidget()
        kuhusu_tab1_layout = QVBoxLayout(self.kuhusu_tab1)
        self.help_browser = QTextBrowser()
        self.help_browser.setOpenExternalLinks(True)
        kuhusu_tab1_layout.addWidget(self.help_browser)
        self.load_help_page()
        # --------------------------------------------------------------------------
        # Tab 2: Maktaba
        self.kuhusu_tab2 = QWidget()
        kuhusu_tab2_layout = QVBoxLayout(self.kuhusu_tab2)

        # Set padding (left, top, right, bottom)
        kuhusu_tab2_layout.setContentsMargins(5, 5, 5, 5)
        kuhusu_tab2_layout.setSpacing(5)  # spacing between widgets

        self.bt_chatu = QPushButton("Python Version")
        self.bt_pillow = QPushButton("Install PILLOW")
        self.bt_piexif = QPushButton("Install PIEXIF")
        self.bt_wordcount = QPushButton("Install WordCount")
        self.bt_pandas = QPushButton("Install Pandas")
        self.bt_matplotlib = QPushButton("Install Matplotlib")
        # kuhusu_tab2_layout.addWidget(self.bt_chatu)
        kuhusu_tab2_layout.addWidget(self.bt_pillow)
        kuhusu_tab2_layout.addWidget(self.bt_piexif)
        kuhusu_tab2_layout.addWidget(self.bt_wordcount)
        kuhusu_tab2_layout.addWidget(self.bt_pandas)
        kuhusu_tab2_layout.addWidget(self.bt_matplotlib)

        # Modules, Libraries & Plugins
        self.modulu_treeview = QTreeView()
        self.modulu_model = QStandardItemModel()
        self.modulu_treeview.setModel(self.modulu_model)
        self.modulu_model.setHorizontalHeaderLabels(["Key Name", "Na", "Name", "Internal",  "Version"])
        self.modulu_treeview.setSortingEnabled(True)
        kuhusu_tab2_layout.addWidget(self.modulu_treeview)
        # Add stretch/spacer at bottom to push buttons up
        #kuhusu_tab2_layout.addSpacerItem(QSpacerItem(20, 40, QSizePolicy.Minimum, QSizePolicy.Expanding))

        self.bt_chatu.clicked.connect(self.chatu_toleo)
        self.bt_pillow.clicked.connect(self.weka_plagini_a)
        self.bt_piexif.clicked.connect(self.weka_plagini_b)
        self.bt_wordcount.clicked.connect(self.weka_plagini_c)
        self.bt_pandas.clicked.connect(self.weka_plagini_d)
        self.bt_matplotlib.clicked.connect(self.weka_plagini_e)
        # --------------------------------------------------------------------------
        # Tab 3: Kuhusu
        self.kuhusu_tab3 = QWidget()
        kuhusu_tab3_layout = QVBoxLayout(self.kuhusu_tab3)
        self.about_browser = QTextBrowser()
        self.about_browser.setOpenExternalLinks(True)
        kuhusu_tab3_layout.addWidget(self.about_browser)
        self.load_about_page()
        # --------------------------------------------------------------------------
        # Add all tabs to the main tab widget
        self.tab_kuhusu.addTab(self.kuhusu_tab1, "Contents")
        self.tab_kuhusu.addTab(self.kuhusu_tab2, "Libraries")
        self.tab_kuhusu.addTab(self.kuhusu_tab3, "About")

        # Add main tab widget to the tab layout
        tab5_layout.addWidget(self.tab_kuhusu)
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # Logins
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    session_token = ''
    namba_ya_mradi = ''
    # =====================================================================================
    # checkboc
    def on_checkbox_state_changed_tunza(self, state):
        if state == Qt.Checked:
            self.ondoa_credential.setChecked(False)

    def on_checkbox_state_changed_ondoa(self, state):
        if state == Qt.Checked:
            self.tunza_credential.setChecked(False)

    # =====================================================================================
    # Get ODK Central Connection - self.dlg.DistancelineEdit.text()
    def ingiaODK(self):
            self.miradi_listi.clear()
            self.fomu_listi.clear()

            # Ingia na Orodhesha miradi
            tokeni = self.get_session_token()
            if tokeni:
                global session_token
                session_token = tokeni
                self.miradi_listi.addItem('---Chagua Mradi---')
                self.list_projects()
    # =====================================================================================
    # Soma
    def get_logins_baruapepe(self):
        self.jina.addItem("-- Select Saved Users --")
        settings = QSettings()
        all_keys = settings.allKeys()
        key_prefix = "fooodk/baruapepe-"
        for key in all_keys:
            if key.startswith(key_prefix):
                self.jina.addItem(settings.value(key))

    # -----------------------------------------------------------------------------------------------
    # Tunza
    def save_setting(self, key, value):
        try:
            settings = QgsSettings()
            settings.setValue(f"fooodk/{key}", value)
            return True
        except Exception as e:
            QMessageBox.warning(self, "FooODK-Warning", f"Error saving setting: {e}")
            return False
    # -----------------------------------------------------------------------------------------------
    # Pata
    def get_setting(self, key, default=None):
        try:
            settings = QgsSettings()
            return settings.value(f"fooodk/{key}", default)
        except Exception as e:
            QMessageBox.warning(self, "FooODK-Warning", f"{e}")
            return default
    # -----------------------------------------------------------------------------------------------
    def jina_badilika(self, index):
        odk_jina = self.jina.currentText()
        odk_url = self.get_setting(f"msimbo-{odk_jina}")
        self.msimbo.setText(odk_url)
        odk_nywila = self.get_setting(f"nywila-{odk_jina}")
        self.nywila.setText(odk_nywila)
    # ====================================================================================================
    # ODK Central Session
    def get_session_token(self):
        msimbo = self.msimbo.text()
        jina = self.jina.currentText()
        nywila = self.nywila.text()
        uMsimbo = (str(msimbo), "/v1/sessions")
        email_token_response = requests.post("".join(uMsimbo), data=json.dumps({"email": jina, "password": nywila}),
                                             headers={"Content-Type": "application/json"}, )
        if email_token_response.status_code == 200:
            if self.tunza_credential.isChecked():
                self.save_setting(f"msimbo-{jina}", msimbo)
                self.save_setting(f"baruapepe-{jina}", jina)
                self.save_setting(f"nywila-{jina}", nywila)

                global BASE_URL
                BASE_URL = f"{msimbo}/v1/"
            return email_token_response.json()["token"]
        else:
            QMessageBox.warning(self, "FooODK-Warning", f"Failed to fetch form: {email_token_response.status_code}")
            return None

    # ====================================================================================================
    # List all Project
    def list_projects(self):
        iMsimbo = self.msimbo.text()
        jMsimbo = (str(iMsimbo), "/v1/projects/")
        kMsimbo = "".join(jMsimbo)
        projects_response = requests.get(kMsimbo, headers={"Authorization": "Bearer " + session_token}, )
        projects = {}

        if projects_response.status_code == 200:
            for project in projects_response.json():
                self.miradi_listi.addItem(str(project["id"]) + '|' + project["name"])
        else:
            QMessageBox.warning(self, "FooODK-Warning", f"Failed to fetch form: {projects_response.status_code}")
        return None
    # ====================================================================================================
    # Project Metadata
    def onselect_mradi(self):
        selected_items = self.miradi_listi.currentText()
        if selected_items:
            namba_ya_mradi = selected_items.split("|")[0]
            iMsimbo = self.msimbo.text()
            jMsimbo = (str(iMsimbo), f"/v1/projects/{namba_ya_mradi}")
            kMsimbo = "".join(jMsimbo)
            kichwa = {"Authorization": f"Bearer {session_token}", "Accept": "application/json",
                      "X-Extended-Metadata": "true" }
            projects_response_a = requests.get(kMsimbo, headers=kichwa)
            if projects_response_a.status_code == 200:
                global msimbo_wa_mradi
                msimbo_wa_mradi = kMsimbo
                json_text = json.dumps(projects_response_a.json(), indent=4)
                self.mradi_json_view.setPlainText(json_text)

            lMsimbo = f"{kMsimbo}/assignments"
            projects_response_b = requests.get(lMsimbo, headers={"Authorization": "Bearer " + session_token,
                                                                 "Accept": "application/json"})
            if projects_response_b.status_code == 200:
                json_text_b = json.dumps(projects_response_b.json(), indent=4)
                self.mradi_json_view.appendPlainText(json_text_b)

    # ====================================================================================================
    # List all Forms
    def list_forms(self):
        self.fomu_listi.blockSignals(True)
        self.fomu_listi.clear()
        self.fomu_listi.addItem("--Select Form--")

        fMsimbo = (msimbo_wa_mradi, "/forms/")
        kichwa = { "Authorization": f"Bearer {session_token}"}
        form_response = requests.get("".join(fMsimbo), headers=kichwa )
        if form_response.status_code == 200:
            for fomu in form_response.json():
                self.fomu_listi.addItem(str(fomu["xmlFormId"]))

            # Show Tab 2
            self.tab_widget.setCurrentIndex(1)
        self.fomu_listi.blockSignals(False)
        return None
    # ====================================================================================================
    # ====================================================================================================
    # Clean
    def safisha_a(self):
        self.fomu_json_view.clear()
        self.fomu_model.clear()
        self.idadi_listi.clear()
        self.tarehe_listi.clear()
        self.jira_listi.clear()
        self.jira_rlisti.clear()
        self.pakia_mael_img.clear()
        self.pakia_jira_img.clear()
        self.takwimu_kwa.clear()
        self.kurasa.clear()
        self.rudia.clear()

        self.chakatai.clear()
        self.chakatei.clear()
        self.chakatoi.clear()
        self.chakatoj.clear()
        self.auditi.clear()
        self.auditk.clear()
        self.auditn.clear()
    # ====================================================================================================
    def safisha_b(self):
        self.tarehe_listi.clear()
        self.jira_listi.clear()
        self.pakia_mael_img.clear()
        self.pakia_jira_img.clear()
        self.takwimu_kwa.clear()
        self.kurasa.clear()
        self.rudia.clear()

        self.chakatai.clear()
        self.chakatei.clear()
        self.chakatoi.clear()
        self.chakatoj.clear()
        self.auditi.clear()
        self.auditk.clear()
        self.auditn.clear()

    # ====================================================================================================
    def safisha_c(self):
        self.chakatai.clear()
        self.chakatei.clear()
        self.chakatoi.clear()
        self.chakatoj.clear()
        self.auditi.clear()
        self.auditk.clear()
        self.auditn.clear()

    # ====================================================================================================
    # ====================================================================================================
    # https://towardsdatascience.com/how-do-i-extract-nested-data-in-python-4e7bed37566a
    # List all Forms Iterms
    def list_iterms(self):
        self.safisha_a()

        ifomu = self.fomu_listi.currentText()
        # Fomu metadata
        jfomu = (msimbo_wa_mradi, f"/forms/{ifomu}")
        kfomu = "".join(jfomu)

        kichwa = {"Authorization": f"Bearer {session_token}", "X-Extended-Metadata": "true",
                  "Accept": "application/json"}
        fomu_response = requests.get("".join(kfomu), headers=kichwa)
        if fomu_response.status_code == 200:
            data_json = fomu_response.json()
            json_text = json.dumps(data_json, indent=4)
            self.fomu_json_view.setPlainText(json_text)
            self.tab_widget.setCurrentIndex(1)

            global submissions_count
            submissions_count = data_json["submissions"]

        # Muundo wa fomu (Fields)
        lfomu = (msimbo_wa_mradi, f"/forms/{ifomu}/fields")
        mfomu = "".join(lfomu)
        kichwa = {"Authorization": f"Bearer {session_token}", "Accept": "application/json"}
        field_response = requests.get("".join(mfomu), headers=kichwa)
        if field_response.status_code == 200:
            self.load_json_data(field_response.text)
        else:
            QMessageBox.warning(self, "FooODK-Warning", f"Failed to fetch form: {field_response.status_code}")

        # List subforms (repeat groups)
        self.rudia.clear()
        self.rudia.addItem("--Select Repeat (Sub-form)--")
        self.rudia.setDisabled(True)

        nFomu = (msimbo_wa_mradi, f"/forms/{ifomu}.svc")
        oFomu = "".join(nFomu)
        sub_response = requests.get("".join(oFomu), headers=kichwa)
        if sub_response.status_code == 200:
            iFomuSub = sub_response.json()['value']
            self.rudia.blockSignals(True)
            for sf in iFomuSub:
                meza_zote = sf["url"]
                if meza_zote != "Submissions":
                    mezan = meza_zote.split(".")[-1]
                    self.rudia.addItem(mezan)
            self.rudia.setDisabled(False)
            self.rudia.blockSignals(False)
        else:
            QMessageBox.warning(self, "FooODK-Warning", f"Failed to fetch form: {sub_response.status_code}")

    # ====================================================================================================
    # Pakia majira
    def load_json_jira(self, json_jira, jira_aina, jira_pathi):
        if jira_aina == "Point":
            self.pakia_jira_img.addItem(f'{json_jira} (Point)')
            if jira_pathi == "kubwa":
                self.jira_listi.addItem(f'{json_jira} (Point)')
            if jira_pathi == "ndogo":
                self.jira_rlisti.addItem(f'{json_jira} (Point)')
        elif jira_aina == "Line":
            if jira_pathi == "kubwa":
                self.jira_listi.addItem(f'{json_jira} (Line)')
            if jira_pathi == "ndogo":
                self.jira_rlisti.addItem(f'{json_jira} (Line)')
        elif jira_aina == "Polygon":
            if jira_pathi == "kubwa":
                self.jira_listi.addItem(f'{json_jira} (Polygon)')
            if jira_pathi == "ndogo":
                self.jira_rlisti.addItem(f'{json_jira} (Polygon)')
    # ====================================================================================================
    # Pakia parameta za takwimu
    def load_json_data(self, json_data):
        try:
            global grupu_vichwa
            grupu_vichwa = []
            self.safisha_b()

            self.tarehe_listi.addItem("__system/submissionDate")
            self.jira_listi.addItem("--Select Location--")
            self.jira_rlisti.addItem("--Select Location--")
            self.pakia_mael_img.addItem("--Select Description--")
            self.pakia_jira_img.addItem("--Select Location--")
            self.takwimu_kwa.blockSignals(True)
            self.takwimu_kwa.addItems(["Please Select...", "By Date", "By Rows"])
            self.takwimu_kwa.blockSignals(False)

            self.jira_chora.setText("Table")
            self.jira_rchora.setText("Table")

            """Alternative version without root item"""
            self.fomu_model.setHorizontalHeaderLabels(["Name", "Type", "Path", "Properties"])

            if isinstance(json_data, str):
                data = json.loads(json_data)
            else:
                data = json_data
            global takwimu_vichwa
            takwimu_vichwa = data
            repeat_jina = [item["name"] for item in data if item.get("type") == "repeat"]

            path_dict = {}
            for item in data:
                is_in_jina = any(name in item["path"] for name in repeat_jina)
                # Weka tarehe
                if item["type"] == "date" or item["type"] == "dateTime":
                    self.tarehe_listi.addItem(item["name"])
                elif item["type"] == "geopoint":
                    if is_in_jina:
                        self.load_json_jira(item["name"], "Point", "ndogo")
                    else:
                        self.load_json_jira(item["name"], "Point", "kubwa")
                elif item["type"] == "geotrace":
                    if is_in_jina:
                        self.load_json_jira(item["name"], "Line", "ndogo")
                    else:
                        self.load_json_jira(item["name"], "Line", "kubwa")
                elif item["type"] == "geoshape":
                    if is_in_jina:
                        self.load_json_jira(item["name"], "Polygon", "ndogo")
                    else:
                        self.load_json_jira(item["name"], "Polygon", "kubwa")
                elif item["type"] == "string":
                    self.pakia_mael_img.addItem(item["name"])
                elif item["type"] == "int" or item["type"] == "decimal":
                    self.pakia_mael_img.addItem(item["name"])
                elif item["type"] == "structure":
                    new_item = item["name"].strip().replace("-", "_").lower()
                    if new_item not in grupu_vichwa:
                        grupu_vichwa.append(new_item)

                path = item["path"]
                parts = [p for p in path.split('/') if p]  # Split path, remove empty strings

                # Determine parent path
                parent_path = '/' + '/'.join(parts[:-1]) if len(parts) > 1 else "/"

                # Create QStandardItems and enable checkboxes
                def create_item(text):
                    item = QStandardItem(text)
                    item.setEditable(False)
                    item.setCheckable(True)
                    item.setCheckState(Qt.Unchecked)
                    return item

                # Create items for each column
                name_item = create_item(item["name"])
                # name_item = QStandardItem(item["name"])
                type_item = QStandardItem(item["type"])
                path_item = QStandardItem(path)

                # Handle properties
                properties = []
                if item.get("binary", False):
                    properties.append("binary")
                props_item = QStandardItem(", ".join(properties))

                # Get or create parent item
                if parent_path == "/":
                    parent_item = self.fomu_model.invisibleRootItem()
                else:
                    parent_item = path_dict.get(parent_path)
                    if not parent_item:
                        continue  # Skip if parent doesn't exist

                # Make other columns non-editable
                for col_item in [type_item, path_item, props_item]:
                    col_item.setEditable(False)

                # Create a new row with all columns
                row_items = [name_item, type_item, path_item, props_item]

                # Add to parent (THIS is where data gets added to the model)
                parent_item.appendRow(row_items)

                # Store in path dictionary for future reference
                path_dict[path] = name_item

            self.fomu_tab2_treeview.expandAll()
            self.fomu_tab2_treeview.header().setSectionResizeMode(QHeaderView.ResizeToContents)

        except json.JSONDecodeError as e:
            QgsMessageLog.logMessage(f"Invalid JSON: {str(e)}", "FooODK", Qgis.Info)
        except KeyError as e:
            QgsMessageLog.logMessage(f"Invalid JSON: {str(e)}", "FooODK", Qgis.Info)
        except Exception as e:
            QgsMessageLog.logMessage(f"Invalid JSON: {str(e)}", "FooODK", Qgis.Info)

    # ====================================================================================================
    # Jinsi ya Kupata Data za Kweri
    def on_takwimu_changed(self, index):

        choice = self.takwimu_kwa.currentText()
        jumla = submissions_count
        if choice == "By Date":
            self.tarehe_listi.setEnabled(True)
            self.tarehemwanzo.setEnabled(True)
            self.label_9.setEnabled(True)
            self.tarehemwisho.setEnabled(True)
            self.idadi_kurasa(jumla)
        elif choice == "By Rows":
            self.tarehe_listi.setEnabled(False)
            self.tarehemwanzo.setEnabled(False)
            self.label_9.setEnabled(False)
            self.tarehemwisho.setEnabled(False)
            self.idadi_kurasa(jumla)
        else:
            # default: hide all
            self.tarehe_listi.setEnabled(False)
            self.tarehemwanzo.setEnabled(False)
            self.label_9.setEnabled(False)
            self.tarehemwisho.setEnabled(False)
    # ====================================================================================================
    # Pakia za kurasa
    def idadi_kurasa(self,jumla):
        self.idadi_listi.blockSignals(True)
        self.idadi_listi.clear()
        if jumla > 1000:
            self.idadi_listi.addItem("Select Records per Page", 0)
            self.idadi_listi.addItem("10 Records per Page", 10)
            self.idadi_listi.addItem("20 Records per Page", 20)
            self.idadi_listi.addItem("50 Records per Page", 50)
            self.idadi_listi.addItem("100 Records per Page", 100)
            self.idadi_listi.addItem("200 Records per Page", 200)
            self.idadi_listi.addItem("500 Records per Page", 500)
            self.idadi_listi.addItem("1000 Records per Page", 1000)

        elif jumla <= 1000 and jumla > 500:
            self.idadi_listi.addItem("Select Records per Page", 0)
            self.idadi_listi.addItem("10 Records per Page", 10)
            self.idadi_listi.addItem("20 Records per Page", 20)
            self.idadi_listi.addItem("50 Records per Page", 50)
            self.idadi_listi.addItem("100 Records per Page", 100)
            self.idadi_listi.addItem("200 Records per Page", 200)
            self.idadi_listi.addItem("500 Records per Page", 500)

        elif jumla <= 500 and jumla > 200:
            self.idadi_listi.addItem("Select Records per Page", 0)
            self.idadi_listi.addItem("10 Records per Page", 10)
            self.idadi_listi.addItem("20 Records per Page", 20)
            self.idadi_listi.addItem("50 Records per Page", 50)
            self.idadi_listi.addItem("100 Records per Page", 100)
            self.idadi_listi.addItem("200 Records per Page", 200)

        elif jumla <= 200 and jumla > 100:
            self.idadi_listi.addItem("Select Records per Page", 0)
            self.idadi_listi.addItem("10 Records per Page", 10)
            self.idadi_listi.addItem("20 Records per Page", 20)
            self.idadi_listi.addItem("50 Records per Page", 50)
            self.idadi_listi.addItem("100 Records per Page", 100)

        elif jumla <= 100 and jumla > 50:
            self.idadi_listi.addItem("Select Records per Page", 0)
            self.idadi_listi.addItem("10 Records per Page", 10)
            self.idadi_listi.addItem("20 Records per Page", 20)
            self.idadi_listi.addItem("50 Records per Page", 50)

        elif jumla <= 50 and jumla > 20:
            self.idadi_listi.addItem("Select Records per Page", 0)
            self.idadi_listi.addItem("10 Records per Page", 10)
            self.idadi_listi.addItem("20 Records per Page", 20)
        elif jumla <= 20:
            self.idadi_listi.addItem("Select Records per Page", 0)
            self.idadi_listi.addItem("10 Records per Page", 10)
        self.idadi_listi.blockSignals(False)
    # ====================================================================================================
    # Pakia Kurasa
    def idadi_listi_changed(self, index):
        self.kurasa.blockSignals(True)
        jkurasa = self.kurasa.clear()
        jumla = submissions_count
        if index > 0:
            rows_per_page = self.idadi_listi.itemData(index)  # get key (10,20,50,100)
            total_pages = math.ceil(jumla / rows_per_page)
            for page in range(total_pages):
                start = page * rows_per_page + 1
                end = min((page + 1) * rows_per_page, jumla)
                self.kurasa.addItem(f"Records {start} -> {end} (Page {page+1})", (page+1, start, end))  # store page index as data
        self.kurasa.blockSignals(False)
    # ====================================================================================================
    # Fomu Kuu na Ndogo
    def sabufomu_changed(self, fndogo):
        fomu = self.fomu_listi.currentText()
        if fndogo != "--Select Repeat (Sub-form)--":
            self.pakia_takwimu_meza_ndogo(fomu, fndogo)
        else:
            modelir = self.takwimu_rmeza.model()
            if modelir:  # make sure a model is set
                modelir.removeRows(0, model.rowCount())
    # ====================================================================================================
    # Pakia Kurasa
    def kurasa_listi_changed(self, teksiti):
        fndogo = self.rudia.currentText()
        fomu = self.fomu_listi.currentText()
        self.pakia_takwimu_meza("Submissions")
        if fndogo != "--Select Repeat (Sub-form)--":
            self.pakia_takwimu_meza_ndogo(fomu, fndogo)
    # ====================================================================================================
    # Fomu Kuu na Ndogo
    def sabufomu_ona(self):
        self.tab_takwimu.setCurrentIndex(1)
    # ====================================================================================================
    # Pakia Takwimu
    def pakia_takwimu_kliki(self):
        self.tab_widget.setCurrentIndex(2)
        self.pakia_takwimu_meza("Submissions")
        self.kurasar.setEnabled(True)
    # ====================================================================================================
    # Download XML
    def shusha_xml(self):
        # Muundo wa fomu xml
        iFomu = self.fomu_listi.currentText()
        jFomu = (msimbo_wa_mradi, f"/forms/{iFomu}.xml")
        kFomu = "".join(jFomu)

        kichwa = {"Authorization": f"Bearer {session_token}",
                  "Accept": "application/xml"}
        xml_response = requests.get("".join(kFomu), headers=kichwa)

        if xml_response.status_code == 200:
            self.load_xml_to_treeview(xml_response.text)
            xml_text = self.xml_to_json_structure(xml_response.text)
            self.fomu_xml_view.setPlainText(xml_text)

            # Open Save As dialog
            filename, _ = QFileDialog.getSaveFileName(
                self,
                "Save XML File",
                f"{iFomu}.xml",  # Default filename
                "XML Files (*.xml);;All Files (*)"
            )

            if filename:  # If user didn't cancel the dialog
                try:
                    with open(filename, 'w', encoding='utf-8') as f:
                        f.write(xml_response.text)
                    QMessageBox.information(self, "Success", "XML file saved successfully!")
                except Exception as e:
                    QMessageBox.warning(self, "Error", f"Failed to save file: {str(e)}")
        else:
            QMessageBox.warning(self, "API Error", f"Failed to fetch form: {xml_response.status_code}=>Chech Your Level of Access")

    # ====================================================================================================
    # Download XLSX
    def shusha_xlsx(self):
        iFomu = self.fomu_listi.currentText()
        jFomu = (msimbo_wa_mradi, f"/forms/{iFomu}.xlsx")
        kFomu = "".join(jFomu)
        kichwa = { "Authorization": f"Bearer {session_token}",
                   "Accept": "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" }
        try:
            response = requests.get(kFomu, headers=kichwa)
            response.raise_for_status()  # Raise an error for bad status codes

            # Open "Save As" dialog
            file_path, _ = QFileDialog.getSaveFileName(
                self,
                "Save ODK Form as XLSX",
                f"{iFomu}.xlsx",  # Default filename
                "Excel Files (*.xlsx);;All Files (*)"
            )

            if file_path:
                # Ensure the file has .xlsx extension
                if not file_path.lower().endswith('.xlsx'):
                    file_path += '.xlsx'

                # Save the XLSX data to the selected file
                with open(file_path, 'wb') as f:
                    f.write(response.content)

                QMessageBox.information(self, "Success", f"Form saved as {file_path}")

        except requests.exceptions.RequestException as e:
            QMessageBox.critical(self, "Download Failed", f"Error downloading XLSX: {str(e)}=>Chech Your Level of Access")

    # ====================================================================================================
    # Download Selected
    def shuda_selected(self):
        QMessageBox.warning(self, "Message", "Next Version")
    # ====================================================================================================
    # Download Main
    def shusha_main(self):
        QMessageBox.warning(self, "Message", "Next Version")
    # ====================================================================================================
    # Download All CSV
    def shudah_all(self):
        QMessageBox.warning(self, "Message", "Next Version")
    # ====================================================================================================
    # Pata parameta zilizocgaguliwa
    def get_checked_parameters(self, model):
        checked_items = []
        isRepeat = []
        isBinary = []
        def recurse(parent):
            for row in range(parent.rowCount()):
                item = parent.child(row, 0)  # Column 0: Name with checkbox
                jina = item.text()
                aina = parent.child(row, 1).text()  # Column 2: Type
                path = parent.child(row, 2).text()  # Column 3:
                if item.isCheckable() and item.checkState() == Qt.Checked:
                    checked_items.append({"name": jina, "type": aina,"path": path })
                if aina == "repeat":
                    isRepeat.append({"aina": path})
                if aina == "binary":
                    isBinary.append({"jina": jina})
                # Recurse into children
                recurse(parent.child(row, 0))
        recurse(model.invisibleRootItem())
        return checked_items, isRepeat,isBinary
    # ====================================================================================================
    def flatten_json(self, entry, parent_key='', sep='.'):
        """Recursively flattens nested dictionaries."""
        items = []
        for k, v in entry.items():
            new_key = f"{parent_key}{sep}{k}" if parent_key else k
            if isinstance(v, dict):
                items.extend(self.flatten_json(v, new_key, sep=sep).items())
            else:
                items.append((new_key, v))
        return dict(items)
    # ====================================================================================================
    # Flatten Nested Dictionary
    def flatten_dict(self, d):
        flat = {}
        for k, v in d.items():
            if isinstance(v, dict):
                # Recursively flatten the nested dictionary
                nested_flat = self.flatten_dict(v)
                flat.update(nested_flat)
            else:
                flat[k] = v
        return flat

    # ====================================================================================================
    def has_multiple_dicts(self, data):
        return isinstance(data, list) and len(data) > 1 and all(isinstance(item, dict) for item in data)

    # ====================================================================================================
    def process_nested_dict(self, data, listi):
        """
            Flatten nested dictionaries, especially for keys in listi
        """
        result = {}
        for key, value in data.items():
            key = key.strip().replace("-", "_").lower()
            if key in listi and isinstance(value, dict):
                # If key is in listi and has children, flatten the children into the main result
                for child_key, child_value in value.items():
                    child_key = child_key.strip().replace("-", "_").lower()
                    if isinstance(child_value, dict):
                        # Recursively process nested dictionaries
                        nested_result = self.process_nested_dict({child_key: child_value}, listi)
                        result.update(nested_result)
                    else:
                        result[child_key] = child_value
            elif isinstance(value, dict):
                # Recursively process other nested dictionaries
                nested_result = self.process_nested_dict(value, listi)
                if nested_result:  # Only add if we got something back
                    result[key] = nested_result
            else:
                # Keep leaf nodes as they are
                result[key] = value

        return result

    # ====================================================================================================
    def takwimu_pakia_meza(self, takwimu, headers, aina):
        try:
            meza_model = QStandardItemModel()
            meza_model.setHorizontalHeaderLabels(headers)
            for row in takwimu:
                chekiboksi = QStandardItem()
                chekiboksi.setCheckable(True)
                chekiboksi.setCheckState(Qt.Unchecked)
                chekiboksi.setEditable(False)
                # items = [QStandardItem(str(row.get(col, ""))) for col in headers]
                items = [QStandardItem(str(row.get(col, ""))) for col in headers[1:]]
                items.insert(0, chekiboksi)
                meza_model.appendRow(items)

            if aina == "kubwa":
                self.takwimu_meza.setModel(meza_model)
                self.takwimu_meza.resizeColumnsToContents()
            elif aina == "ndogo":
                self.takwimu_rmeza.setModel(meza_model)
                self.takwimu_rmeza.resizeColumnsToContents()
            else:
                QgsMessageLog.logMessage("Function Error", "FooODK", Qgis.Info)
        except KeyError as e:
            QgsMessageLog.logMessage(f"Error: {str(e)}", "FooODK", Qgis.Info)
        except Exception as e:
            QgsMessageLog.logMessage(f"Error JSON: {str(e)}", "FooODK", Qgis.Info)
    # ====================================================================================================
    # Pakia takwimu
    def pakia_takwimu_meza(self, meza):
        iFomu = self.fomu_listi.currentText()
        aina_roo = self.takwimu_kwa.currentText()
        ikurasa = self.idadi_listi.currentText()
        jkurasa = self.kurasa.currentText()
        tarehe = self.tarehe_listi.currentText()

        page, imwanzo, imwisho = self.kurasa.itemData(self.kurasa.currentIndex())
        jmwanzo = int(imwanzo) - 1
        jmwisho = int(imwisho) - jmwanzo

        tarehe_a = self.tarehemwanzo.date().toString("yyyy-MM-dd")
        tarehe_b = self.tarehemwisho.date().toString("yyyy-MM-dd")
        tarehe_anza = datetime.strptime(tarehe_a, "%Y-%m-%d").date()
        tarehe_isha = datetime.strptime(tarehe_b, "%Y-%m-%d").date()
        siku = (tarehe_isha - tarehe_anza).days

        jFomu = (msimbo_wa_mradi, f"/forms/{iFomu}.svc/{meza}")
        jURL = "".join(jFomu)

        kichwa = {"Authorization": f"Bearer {session_token}", "Accept": "application/json"}
        if aina_roo != "Please Select..." and ikurasa != "Select Records per Page":
            if aina_roo == "By Date" and siku > 0:
                kweri = {"$filter": f"{tarehe} ge {tarehe_a} and {tarehe} le {tarehe_b}",
                             #"$expand": "*",
                             "$top": jmwisho, "$skip": jmwanzo }
            elif aina_roo == "By Rows":
                kweri = {"$top": jmwisho, "$skip": jmwanzo }
            else:
                QgsMessageLog.logMessage(f"Make sure you selected all require parameters", "FooODK", Qgis.Info)
                return
            # -------------------------------------------------------------------------------------------------
            iMsimbo_Response = requests.get(str(jURL), headers=kichwa, params=kweri)
            if iMsimbo_Response.status_code == 200:
                iJson = iMsimbo_Response.json()['value']
                hakuna_grupu = []
                for row in iJson:
                    hakuna_grupv = self.process_nested_dict(row, grupu_vichwa)
                    hakuna_grupu.append(hakuna_grupv)
                    # Process each record in the list
                hakuna_grupu = [self.process_nested_dict(record, grupu_vichwa) for record in iJson]
                headers = sorted(set().union(*(row.keys() for row in hakuna_grupu)))
                headers = ["CB"] + headers
                self.takwimu_pakia_meza(hakuna_grupu, headers, "kubwa")
            else:
                QgsMessageLog.logMessage(f"Authorization Issues", f"Code: {iMsimbo_Response.status_code}", "FooODK", Qgis.Info)
        else:
            QgsMessageLog.logMessage(f"Error: Correct the selections ...", "FooODK", Qgis.Info)
        return None
    # ====================================================================================================
    # Sub-form / Repeat Questions
    def pakia_takwimu_meza_ndogo(self, fomu_a, fomu_b):
        modela = self.takwimu_meza.model()
        if not modela:
            return None
        uuids = []
        for row in range(modela.rowCount()):
            index = modela.index(row, 1)
            data = modela.data(index, Qt.DisplayRole)
            uuids.append(data)

        ifomu = (msimbo_wa_mradi, f"/forms/{fomu_a}.svc")
        imsimbo = "".join(ifomu)

        if uuids:
            hakuna_grupu = []
            for uuid in uuids:
                jmsimbo = f"{imsimbo}/Submissions('{uuid}')/{fomu_b}"
                # -------------------------------------------------------------------------------------------------
                kichwa = {"Authorization": f"Bearer {session_token}", "Accept": "application/json"}
                iMsimbo_Response = requests.get(str(jmsimbo), headers=kichwa)
                if iMsimbo_Response.status_code == 200:
                    iJson = iMsimbo_Response.json()['value']
                    hakuna_grupv = [self.process_nested_dict(record, grupu_vichwa) for record in iJson]
                    if hakuna_grupv:
                        hakuna_grupu.append(hakuna_grupv[0])
                else:
                    QgsMessageLog.logMessage(f"Authorization Issues", f"Code: {iMsimbo_Response.status_code}", "FooODK", Qgis.Info)
            if hakuna_grupu:
                headers = sorted(set().union(*(row.keys() for row in hakuna_grupu)))
                headers = ["CB"] + headers
                self.takwimu_pakia_meza(hakuna_grupu, headers, "ndogo")
            else:
                QgsMessageLog.logMessage(f"No repeats", "FooODK", Qgis.Info)
        else:
            QgsMessageLog.logMessage("Correct the selections ...", "FooODK", Qgis.Info)
        return None

    # ====================================================================================================
    # Pakia Viambata
    def pakia_viambata(self, aidi):
        try:
            ifomu = self.fomu_listi.currentText()
            jURL = f"{msimbo_wa_mradi}/forms/{ifomu}/Submissions/{aidi}/attachments"
            kichwa = {"Authorization": f"Bearer {session_token}", "Accept": "application/json"}
            nMsimbo_Response = requests.get(jURL, headers=kichwa)
            if nMsimbo_Response.status_code == 200:
                ljson = nMsimbo_Response.json()
                takwimu_tab2_model_parent = QStandardItem(aidi)
                for faili in ljson:
                    if faili['exists']:
                        cb_item = QStandardItem()
                        #cb_item.setCheckable(True)  # Make it checkable
                        #cb_item.setCheckState(Qt.Unchecked)  # Default to unchecked
                        takwimu_tab2_model_child = QStandardItem(faili['name'])
                        size_item = QStandardItem()
                        date_item = QStandardItem()
                        location_item = QStandardItem(aidi)
                        vrl_item = f"{jURL}/{faili['name']}"
                        url_item = QStandardItem(vrl_item)
                        takwimu_tab2_model_parent.appendRow(
                            [cb_item, takwimu_tab2_model_child, size_item, date_item, location_item, url_item])
                self.takwimu_tab2_model.appendRow(takwimu_tab2_model_parent)
                return True
            else:
                return False
        except Exception as e:
            QgsMessageLog.logMessage(f"Error loading attachments: {e}", "FooODK", Qgis.Info)
            return False
    # ====================================================================================================
    # Pakia Viambata Vote
    def pakia_viambata_vyote(self):
        global jibu
        col_idx = -1
        modeli = self.takwimu_meza.model()
        for col in range(modeli.columnCount()):
            header = modeli.headerData(col, Qt.Horizontal)  # 1 = Qt.Horizontal
            if header == "__id":
                col_idx = col
        if col_idx >= 0:
            for row in range(modeli.rowCount()):
                index = modeli.index(row, col_idx)
                id_value = modeli.data(index)
                jibu = self.pakia_viambata(id_value)
            if not jibu:
                QgsMessageLog.logMessage("There are some issue, Empty", "FooODK", Qgis.Info)
        else:
            QgsMessageLog.logMessage("No column __id", "FooODK", Qgis.Info)
        self.tab_takwimu.setCurrentIndex(2)
    # ====================================================================================================
    # Pakia Viambata Chaguliwa
    def pakia_viambata_chaguo(self):
        modeli = self.takwimu_meza.model()
        for row in range(modeli.rowCount()):
            checkbox_item = modeli.item(row, 0)  # Column 0: CB
            id_item = modeli.item(row, 1)  # Column 1: __id (assuming it's here)
            if checkbox_item.checkState() == Qt.Checked:
                self.pakia_viambata(id_item.text())
    # ====================================================================================================
    # Pakia Viambata_2kiliki
    def zoomDkliki(self, index):
        modeli = self.takwimu_meza.model()
        row = index.row()
        value = modeli.item(row, 1).text()
        self.pakia_viambata(value)

    # ====================================================================================================

    # ====================================================================================================
    # Pakia Picha au Auditi
    def pakia_1c_kiambata(self, index):
        roo = index.row()
        model = index.model()
        columns = ["__id", "Name", "Size", "Date", "UUID", "URL"]
        roo = columns.index("UUID")
        item = model.itemFromIndex(index.sibling(index.row(), roo))
        ndoo = columns.index("URL")
        jtem = model.itemFromIndex(index.sibling(index.row(), ndoo))
        inakili = str(item.text())
        jnakili = str(jtem.text())
        if session_token:
            kichwa = {"Authorization": f"Bearer {session_token}", "Accept": "application/json"}
            if jnakili.endswith(('.jpg')):
                try:
                    import PIL
                except:
                    QMessageBox.warning(self, "Error", f"Issues with plugin: {e}")
                    self.tab_widget.setCurrentIndex(4)
                    self.tab_kuhusu.setCurrentIndex(1)
                    return None
                # ----------------------------------------------------------------------------------------
                self.pakia_picha_faili(jnakili, inakili)
                self.tab_takwimu.setCurrentIndex(3)
            elif jnakili.endswith(('.csv')):
                modeli = self.takwimu_tab4_meza.model()
                headers = ['Event', 'Node', 'Start', 'End', 'Latitude', 'Longitude', 'Accuracy', 'Old Value',
                           'New Value', "Time(Minutes)"]
                modeli.setHorizontalHeaderLabels(headers)
                self.pakia_auditi_faili(jnakili)
                self.tab_takwimu.setCurrentIndex(4)
        else:
            QgsMessageLog.logMessage(f"Error: Format not supported", "FooODK", Qgis.Info)

    # ====================================================================================================
    # Pakia Auditi kwenye meza
    def pakia_1d_viambata(self):
        self.takwimu_tab4_meza.setModel(None)
        headers = ['Event', 'Node', 'Start', 'End', 'Latitude', 'Longitude', 'Accuracy', 'Old Value', 'New Value',
                   "Time(Minutes)"]
        modeli = self.takwimu_tab4_meza.model()
        if modeli is None:
            modeli = QStandardItemModel()
            self.takwimu_tab4_meza.setModel(modeli)

        if modeli.columnCount() < len(headers):
            modeli.setColumnCount(len(headers))
        modeli.setHorizontalHeaderLabels(headers)

        model = self.takwimu_tab2_meza.model()
        for row in range(model.rowCount()):
            parent_item = model.item(row, 0)  # first column (parent)
            for child_row in range(parent_item.rowCount()):
                msimbo = parent_item.child(child_row, 5).text()
                if msimbo.endswith(('.csv')):
                    self.pakia_auditi_faili(msimbo)

        self.tab_takwimu.setCurrentIndex(4)
        return None
    # ====================================================================================================
    # Pakia Auditi kwenye ramani
    def oditi_ploti_a(self):
        modeli = self.takwimu_tab4_meza.model()
        #headers = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
        headers = [str(modeli.headerData(col, Qt.Horizontal) or "") for col in range(modeli.columnCount())]
        # loop through rows
        modeli_meza = []
        for row in range(modeli.rowCount()):
            row_dict = {}
            for col in range(modeli.columnCount()):
                index = modeli.index(row, col)
                row_dict[headers[col]] = modeli.data(index)
            modeli_meza.append(row_dict)

        self.oditi_ploti_b(modeli_meza)
        return None
    # ====================================================================================================
    # ====================================================================================================
    # ====================================================================================================
    # Maneno Takwimu
    def takwimu_chakata_d(self):
        try:
            try:
                import wordcloud
                import matplotlib
            except:
                QMessageBox.warning(self, "Error", f"Issues with plugin: {e}")
                self.tab_widget.setCurrentIndex(4)
                self.tab_kuhusu.setCurrentIndex(1)
                return None
            # ----------------------------------------------------------------------------------------
            wc = self.wc_cb.currentText()
            wc = wc.strip().replace("-", "_").lower()

            modeli = self.takwimu_meza.model()
            # --- Extract column by name ---
            column_index = -1
            for i in range(modeli.columnCount()):
                if modeli.headerData(i, Qt.Horizontal) == wc:  # 1 = Qt.Horizontal
                    column_index = i
                    break
            wc_text = ""
            if column_index >= 0:
                values = []
                for row in range(modeli.rowCount()):
                    index = modeli.index(row, column_index)
                    value = modeli.data(index)
                    if value:
                        values.append(str(value))
                wc_text = " ".join(values)

            # Generate word cloud
            wc = WordCloud(width=800, height=400, background_color="white", colormap="viridis")
            wc.generate(wc_text)
            self.figure = Figure()
            self.canvas = FigureCanvas(self.figure)
            self.ax = self.figure.add_subplot(111)
            self.word_layout.addWidget(self.canvas)
            self.canvas.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
            self.canvas.updateGeometry()
            # Plot word cloud
            self.ax.clear()
            self.ax.imshow(wc, interpolation="bilinear")
            self.ax.axis("off")
            self.figure.tight_layout()
            # Redraw on canvas
            self.canvas.draw()

            self.tab_akaunti.setCurrentIndex(3)
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: {e}", "FooODK", Qgis.Info)
        return None
    # ====================================================================================================
    # Grafu Takwimu
    def takwimu_chakata_c(self):
        try:
            import matplotlib
            import pandas
        except:
            QMessageBox.warning(self, "Error", f"Issues with plugin: {e}")
            self.tab_widget.setCurrentIndex(4)
            self.tab_kuhusu.setCurrentIndex(1)
            return None
        # ----------------------------------------------------------------------------------------
        jina_fomu = self.fomu_listi.currentText()
        modeli = self.akaunti_tab1_tv.model()
        if modeli is None:
            QgsMessageLog.logMessage("Pivot Error, No model set", "FooODK", Qgis.Info)
            return

        # Extract data from QTableView → DataFrame
        rows = modeli.rowCount()
        cols = modeli.columnCount()
        headers = [modeli.headerData(c, 1) for c in range(cols)]
        x_values = [modeli.index(r, 0).data() for r in range(rows)]

        takwimu = []
        for row in range(rows):
            rtakwimu = []
            for col in range(cols):
                index = modeli.index(row, col)
                value = modeli.data(index)
                rtakwimu.append(value)
            takwimu.append(rtakwimu)
        df_from_table = pd.DataFrame(takwimu, columns=headers)
        # ------------------------------------------------------------------------------
        # Grafu
        # Create figure without fixed figsize
        self.figure = Figure()
        self.canvas = FigureCanvas(self.figure)
        self.ax = self.figure.add_subplot(111)
        # Add canvas to layout (inside QGroupBox or QVBoxLayout)
        self.grafu_layout.addWidget(self.canvas)
        self.canvas.setSizePolicy(QSizePolicy.Expanding,QSizePolicy.Expanding)
        self.canvas.updateGeometry()

        # Clear previous plot
        self.ax.clear()
        # Extract x (first column) and y (other columns)
        x = df_from_table.iloc[:, 0]  # first column as x-axis
        y_cols = df_from_table.columns[1:]  # all other columns as y
        # Plot each column as bar
        for col in y_cols:
            self.ax.bar(x, df_from_table[col], label=col)
        # Labels and title
        self.ax.set_xlabel(df_from_table.columns[0])
        self.ax.set_ylabel("Values")
        self.ax.set_title(jina_fomu)
        # Rotate x-axis labels
        self.ax.tick_params(axis="x", rotation=45)
        # Legend
        self.ax.legend(title="Legend")
        # Redraw on canvas
        self.canvas.draw()

        self.tab_akaunti.setCurrentIndex(2)
        return None

    # ====================================================================================================
    # Pakia Takwimu kwenye ramani
    def takwimu_chakata_b(self):
        self.akaunti_tab1_tv.setModel(None)
        agg_map = {"Sum": "sum", "Mean": "mean", "Count": "count", "Minimum": "min",
                   "Maximum": "max", "Median": "median", "std": "std", "var": "var", "size": len, }
        ia = self.chakatai.currentText()
        ja = re.sub(r"\s*\([^)]*\)", "", ia)
        ja = ja.strip().replace("-", "_").lower()
        ib = self.chakatei.currentText()
        jb = re.sub(r"\s*\([^)]*\)", "", ib).strip()
        jb = jb.strip().replace("-", "_").lower()
        ic = self.chakatoi.currentText()
        jc = re.sub(r"\s*\([^)]*\)", "", ic).strip()
        jc = jc.strip().replace("-", "_").lower()
        id = self.chakatoj.currentText()
        aggfunc = agg_map.get(id)
        # -------------------------------------------------------------------------------------------------------------
        modeli = self.takwimu_meza.model()
        if modeli is None:
            QgsMessageLog.logMessage("No data", "FooODK", Qgis.Info)
            return None
        rows = modeli.rowCount()
        cols = modeli.columnCount()
        headers = [modeli.headerData(c, 1) for c in range(cols)]

        takwimu = []
        for row in range(rows):
            rtakwimu = []
            for col in range(cols):
                index = modeli.index(row, col)
                value = modeli.data(index)
                rtakwimu.append(value)
            takwimu.append(rtakwimu)
        takwimu_pd = pd.DataFrame(takwimu, columns=headers)
        # -------------------------------------------------------------------------------------------------------------
        # Rows
        if "(Day)" in ia:
            ja_col_d = f"{ja}_day"
            takwimu_pd[ja_col_d] = takwimu_pd.to_datetime(takwimu_pd[ja], errors="coerce").dt.strftime("%Y-%m-%d")
            ja = ja_col_d
        if "(Month)" in ia:
            ja_col_m = f"{ja}_month"
            takwimu_pd[ja_col_m] = pd.to_datetime(takwimu_pd[ja], errors="coerce").dt.strftime("%B")
            ja = ja_col_m
        if "(Year)" in ia:
            ja_col_y = f"{ja}_year"
            takwimu_pd[ja_col_y] = pd.to_datetime(takwimu_pd[ja], errors="coerce").dt.strftime("%Y")
            ja = ja_col_y
        if "(Year-Month)" in ia:
            ja_col_ym = f"{ja}_ym"
            takwimu_pd[ja_col_ym] = pd.to_datetime(takwimu_pd[ja], errors="coerce").dt.strftime("%Y-%m")
            ja = ja_col_ym

        # Columns
        if "(Day)" in ib:
            jb_col_d = f"{jb}_day"
            takwimu_pd[jb_col_d] = takwimu_pd.to_datetime(takwimu_pd[jb], errors="coerce").dt.strftime("%Y-%m-%d")
            jb = jb_col_d
        if "(Month)" in ib:
            jb_col_m = f"{jb}_month"
            takwimu_pd[jb_col_m] = pd.to_datetime(takwimu_pd[jb], errors="coerce").dt.strftime("%B")
            jb = jb_col_m
        if "(Year)" in ib:
            jb_col_y = f"{jb}_year"
            takwimu_pd[jb_col_y] = pd.to_datetime(takwimu_pd[jb], errors="coerce").dt.strftime("%Y")
            jb = jb_col_y
        if "(Year-Month)" in ib:
            jb_col_ym = f"{jb}_ym"
            takwimu_pd[jb_col_ym] = pd.to_datetime(takwimu_pd[jb], errors="coerce").dt.strftime("%Y-%m")
            jb = jb_col_ym
        # -------------------------------------------------------------------------------------------------------------
        if all(x not in ("Null", "", None) for x in [ia, ib, ic, id]):
            pavoti_takwimu= pd.pivot_table(takwimu_pd, index=ja, columns=jb, values=jc,  aggfunc=aggfunc, fill_value=0).reset_index()
        elif all(x not in ("Null", "", None) for x in [ia, ic, id]):
            pavoti_takwimu = pd.pivot_table(takwimu_pd, index=ja, values=jc, aggfunc=aggfunc, fill_value=0).reset_index()
        elif all(x not in ("Null", "", None) for x in [ia, id]):
            pavoti_takwimu = pd.pivot_table(takwimu_pd, index=ja, aggfunc=aggfunc, fill_value=0).reset_index()
        else:
            QgsMessageLog.logMessage("Pivot Error", "FooODK", Qgis.Info)

        if pavoti_takwimu is None or pavoti_takwimu.empty:
            return None
        # -------------------------------------------------------------------------------------------------------------
        # pavoti_oditi = oditi_pd
        modelj = QStandardItemModel()
        modelj.setColumnCount(len(pavoti_takwimu.columns))
        modelj.setRowCount(len(pavoti_takwimu.index))
        modelj.setHorizontalHeaderLabels(pavoti_takwimu.columns.tolist())
        for row in range(len(pavoti_takwimu.index)):
            for col in range(len(pavoti_takwimu.columns)):
                value = str(pavoti_takwimu.iat[row, col])  # convert all values to string
                item = QStandardItem(value)
                modelj.setItem(row, col, item)
        self.akaunti_tab1_tv.setModel(modelj)

        return None
    # ====================================================================================================
    # Takwimu za Kuchakata
    def takwimu_chakata_a(self):
        self.chakatai.blockSignals(True)
        self.chakatei.blockSignals(True)
        self.chakatoi.blockSignals(True)
        self.chakatoj.blockSignals(True)
        self.wc_cb.blockSignals(True)


        self.akaunti_tab1_tv.setModel(None)

        self.chakatai.clear()
        self.chakatei.clear()
        self.chakatoi.clear()
        self.chakatoj.clear()
        self.wc_cb.clear()

        self.chakatai.addItem("Null")
        self.chakatei.addItem("Null")
        self.chakatoi.addItem("Null")
        self.chakatoj.addItem("Null")
        self.wc_cb.addItem("Null")

        vichwa = takwimu_vichwa
        for item in vichwa:
            jina = item["name"]
            aina = item["type"]
            if aina == "date" or aina == "dateTime":
                self.chakatai.addItem(f"{jina} (Day)")
                self.chakatai.addItem(f"{jina} (Month)")
                self.chakatai.addItem(f"{jina} (Year)")
                self.chakatai.addItem(f"{jina} (Year-Month)")
                self.chakatei.addItem(f"{jina} (Day)")
                self.chakatei.addItem(f"{jina} (Month))")
                self.chakatei.addItem(f"{jina} (Year)")
                self.chakatei.addItem(f"{jina} (Year-Month)")
                #self.chakatoi.addItem(f"{jina} ({aina})")
            elif item["type"] == "string":
                self.chakatai.addItem(f"{jina} ({aina})")
                self.chakatei.addItem(f"{jina} ({aina})")
                self.chakatoi.addItem(f"{jina} ({aina})")
                self.wc_cb.addItem(jina)
            elif item["type"] == "int" or item["type"] == "decimal":
                self.chakatai.addItem(f"{jina} ({aina})")
                self.chakatei.addItem(f"{jina} ({aina})")
                self.chakatoi.addItem(f"{jina} ({aina})")

        oditi_hesabu = ['Count', 'Sum', 'Minimum', 'Maximum', 'Mean', 'Median']
        self.chakatoj.addItems(oditi_hesabu)

        self.chakatai.blockSignals(False)
        self.chakatei.blockSignals(False)
        self.chakatoi.blockSignals(False)
        self.chakatoj.blockSignals(False)
        self.wc_cb.blockSignals(False)

        self.tab_widget.setCurrentIndex(3)
        self.tab_akaunti.setCurrentIndex(0)

    # ====================================================================================================
    # ====================================================================================================
    # Maneno Oditi
    def oditi_chakata_d(self):
        self.tab_akaunti.setCurrentIndex(3)
        return None
    # ====================================================================================================
    # Grafu Oditi
    def oditi_chakata_c(self):
        self.tab_akaunti.setCurrentIndex(2)
        return None

    # ====================================================================================================
    # Pakia Auditi kwenye Pavoti
    def oditi_chakata_b(self):
        try:
            import pandas
        except:
            QMessageBox.warning(self, "Error", f"Issues with plugin: {e}")
            self.tab_widget.setCurrentIndex(4)
            self.tab_kuhusu.setCurrentIndex(1)
            return None
        # ----------------------------------------------------------------------------------------
        self.audit_tab1_tv.setModel(None)
        agg_map = {"Sum": "sum", "Mean": "mean", "Count": "count", "Minimum": "min",
                   "Maximum": "max","Median": "median","std": "std","var": "var", "size": len, }
        ia = self.auditi.currentText()
        ib = self.auditk.currentText()
        id = self.auditn.currentText()
        aggfunc = agg_map.get(id, "count")

        modeli = self.takwimu_tab4_meza.model()
        if modeli is None:
            return None
        rows = modeli.rowCount()
        cols = modeli.columnCount()
        headers = [modeli.headerData(c, 1) for c in range(cols)]

        data = []
        for row in range(rows):
            row_data = []
            for col in range(cols):
                index = modeli.index(row, col)
                value = modeli.data(index)
                row_data.append(value)
            data.append(row_data)
        oditi_pd = pd.DataFrame(data, columns=headers)

        # if all(x not in ("Null", "", None) for x in [ia, ib, ic, id]):
        if ib != "Null" and ia != ib:
            pavoti_oditi = pd.pivot_table(oditi_pd, index=ia, values=ib, aggfunc=aggfunc, fill_value=0).reset_index()
        elif ib == "Null":
            pavoti_oditi = pd.pivot_table(oditi_pd, index=ia, aggfunc=aggfunc, fill_value=0).reset_index()
        else:
            QgsMessageLog.logMessage(f"Error: Pivot", "FooODK", Qgis.Info)

        if pavoti_oditi is None or pavoti_oditi.empty:
            return None

        #pavoti_oditi = oditi_pd
        modelj = QStandardItemModel()
        modelj.setColumnCount(len(pavoti_oditi.columns))
        modelj.setRowCount(len(pavoti_oditi.index))
        modelj.setHorizontalHeaderLabels(pavoti_oditi.columns.tolist())
        for row in range(len(pavoti_oditi.index)):
            for col in range(len(pavoti_oditi.columns)):
                value = str(pavoti_oditi.iat[row, col])  # convert all values to string
                item = QStandardItem(value)
                modelj.setItem(row, col, item)
        self.audit_tab1_tv.setModel(modelj)

        return None
    # ====================================================================================================
    # CHaka Weka sawa
    def oditi_chakata_a(self):
        self.audit_tab1_tv.setModel(None)
        self.auditi.clear()
        self.auditk.clear()
        self.auditn.clear()

        oditi_vichwa = ['Event', 'Node', 'Start', 'End', 'Latitude', 'Longitude', 'Accuracy', 'Old Value', 'New Value',
                        'Time(Minutes)']
        oditi_hesabu = ['Minimum', 'Maximum', 'Mean', 'Median', 'Count']
        self.auditi.addItems(oditi_vichwa)
        self.auditk.addItem("Null")
        self.auditk.addItems(oditi_vichwa)
        self.auditn.addItems(oditi_hesabu)

        self.auditi.setCurrentText("Event")
        self.auditk.setCurrentText("Node")
        self.auditn.setCurrentText("Count")
        self.oditi_chakata_b()

        self.tab_widget.setCurrentIndex(3)
        self.tab_akaunti.setCurrentIndex(1)

        return None

    # ====================================================================================================
    # ====================================================================================================
    def ch_pakia_parameta(self):
        self.tab_akaunti.setCurrentIndex(4)
        modeli = self.takwimu_tab4_meza.model()
        if modeli is None:
            return None

        rows = modeli.rowCount()
        cols = modeli.columnCount()

        # Extract headers
        headers = [modeli.headerData(c, 1) for c in range(cols)]  # 1 = Qt.Horizontal
        self.wc_cb.clear()
        self.wc_cb.addItem('Null')
        self.wc_cb.addItems(headers)
    # ====================================================================================================
    # ====================================================================================================
    def wc_pakia_parameta(self):
        oditi_vichwa = ['Null', 'Event', 'Node', 'Start', 'End', 'Latitude', 'Longitude', 'Accuracy', 'Old Value', 'New Value', 'Time(Minutes)']
        self.wc_cb.clear()
        self.wc_cb.addItems(oditi_vichwa)
    # ====================================================================================================
    # ====================================================================================================
    # Tunza picha zote zilizochaguliwa
    def tunza_3c_kiambata(self, index):
        modeli = self.takwimu_meza.model()
        selection_model = self.tree_view.selectionModel()
        selected_indexes = selection_model.selectedRows()
        nukta_data = []
        for index in selected_indexes:
            row_data = {}
            # Get data from all columns in this row
            for col in range(modeli.columnCount()):
                cell_index = modeli.index(index.row(), col, index.parent())
                header = modeli.headerData(col, Qt.Horizontal)  # Column header
                value = cell_index.data()  # Cell value
                row_data[header] = value
            nukta_data.append(row_data)
        self.addJiraNukta(nukta_data[0])

    # ====================================================================================================
    # ====================================================================================================
    # Zoom to Jira
    def zoom_to_wkt(self, geojson_data, geojson_aina):
        try:
            if geojson_aina == "Nukta":
                jira_data = ast.literal_eval(geojson_data)
                x = jira_data['coordinates'][0]  # longitude
                y = jira_data['coordinates'][1]  # longitude
                z = jira_data['coordinates'][2]  # elevation
                # accuracy = jira_data['properties']['accuracy']
                wkt_text = f"POINT({x} {y})"
                geometry = QgsGeometry.fromWkt(wkt_text)

                # Check if temp layer already exists
                layer_name = "Temp-Points"
                layer = None
                for lyr in QgsProject.instance().mapLayers().values():
                    if lyr.name() == layer_name:
                        layer = lyr
                        break

                # If not, create one
                if layer is None:
                    layer = QgsVectorLayer("Point?crs=EPSG:4326", f"{layer_name}-{geojson_aina}", "memory")
                    pr = layer.dataProvider()
                    pr.addAttributes([QgsField("id", QVariant.Int)])
                    layer.updateFields()
                    QgsProject.instance().addMapLayer(layer)

                # Add the point feature
                pr = layer.dataProvider()
                feat = QgsFeature()
                feat.setGeometry(geometry)
                feat.setAttributes([layer.featureCount() + 1])
                pr.addFeature(feat)
                layer.updateExtents()
                layer.triggerRepaint()

                # Zoom to geometry
                canvas = iface.mapCanvas()
                canvas.setExtent(geometry.boundingBox())
                canvas.zoomByFactor(0.9)  # optional zoom out
                canvas.refresh()

            #Mstari
            elif geojson_aina == "Mstari":
                jira_data = ast.literal_eval(geojson_data)
                coords = jira_data['coordinates']
                wkt_coords = [" ".join(map(str, coord)) for coord in coords]
                wkt_text = f"LINESTRING({', '.join(wkt_coords)})"
                geometry = QgsGeometry.fromWkt(wkt_text)
                # Check if temp layer already exists
                layer_name = "Temp-Lines"
                layer = None
                for lyr in QgsProject.instance().mapLayers().values():
                    if lyr.name() == layer_name:
                        layer = lyr
                        break

                # If not, create one
                if layer is None:
                    layer = QgsVectorLayer("LineString?crs=EPSG:4326", f"{layer_name}-{geojson_aina}", "memory")
                    pr = layer.dataProvider()
                    pr.addAttributes([QgsField("id", QVariant.Int)])
                    layer.updateFields()
                    QgsProject.instance().addMapLayer(layer)

                # Add the point feature
                pr = layer.dataProvider()
                feat = QgsFeature()
                feat.setGeometry(geometry)
                feat.setAttributes([layer.featureCount() + 1])
                pr.addFeature(feat)
                layer.updateExtents()
                layer.triggerRepaint()

                # Zoom to geometry
                canvas = iface.mapCanvas()
                canvas.setExtent(geometry.boundingBox())
                canvas.zoomByFactor(0.9)  # optional zoom out
                canvas.refresh()
            #Mzingo
            elif geojson_aina == "Mzingo":
                jira_data = ast.literal_eval(geojson_data)
                coords = jira_data['coordinates'][0]
                wkt_coords = [f"{x} {y}" for x, y, z in coords]
                wkt_text = f"POLYGON({', '.join(wkt_coords)})"
                geometry = QgsGeometry.fromWkt(wkt_text)
                # Check if temp layer already exists
                layer_name = "Temp-Polygon"
                layer = None
                for lyr in QgsProject.instance().mapLayers().values():
                    if lyr.name() == layer_name:
                        layer = lyr
                        break

                # If not, create one
                if layer is None:
                    layer = QgsVectorLayer("Polygon?crs=EPSG:4326", f"{layer_name}-{geojson_aina}", "memory")
                    pr = layer.dataProvider()
                    pr.addAttributes([QgsField("id", QVariant.Int)])
                    layer.updateFields()
                    QgsProject.instance().addMapLayer(layer)

                # Add the point feature
                pr = layer.dataProvider()
                feat = QgsFeature()
                feat.setGeometry(geometry)
                feat.setAttributes([layer.featureCount() + 1])
                pr.addFeature(feat)
                layer.updateExtents()
                layer.triggerRepaint()

                # Zoom to geometry
                canvas = iface.mapCanvas()
                canvas.setExtent(geometry.boundingBox())
                canvas.zoomByFactor(0.9)  # optional zoom out
                canvas.refresh()
            else:
                QgsMessageLog.logMessage(f"Error", "FooODK", Qgis.Info)
        except (TypeError, KeyError, IndexError) as e:
            QgsMessageLog.logMessage(f"Error: {str(e)}", "FooODK", Qgis.Info)
        return None
    # ====================================================================================================
    # Get jira to zoom to
    def onClicked_OnaJira(self):
        jira = self.jira_listi.currentText()
        aina = ""
        if '(Point)' in jira:
            jira = jira.replace("(Point)", "")
            jira = jira.strip().replace("-", "_").lower()
            aina = "Nukta"
        elif '(Line)' in jira:
            jira = jira.replace("(Line)", "")
            jira = jira.strip().replace("-", "_").lower()
            aina = "Mstari"
        elif '(Polyline)' in jira:
            jira = jira.replace("(Polyline)", "")
            jira = jira.strip().replace("-", "_").lower()
            aina = "Mzingo"

        modeli = self.takwimu_meza.model()
        selected_indexes = self.takwimu_meza.selectionModel().selectedRows()
        vichwa = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
        #values = [model.data(model.index(selected_row_index, col)) for col in range(model.columnCount())]
        jira_index = [i for i, x in enumerate(vichwa) if x == jira]

        if selected_indexes:
            selected_row_index = selected_indexes[0].row()
            if jira in vichwa:
                jira_value = modeli.index(selected_row_index, jira_index[0]).data(Qt.DisplayRole)
                jira_value = jira_value.replace("'", '"')
                self.zoom_to_wkt(jira_value, aina)
            else:
                QgsMessageLog.logMessage(f"Error: Location column", "FooODK", Qgis.Info)
        else:
            QgsMessageLog.logMessage(f"Error: No location", "FooODK", Qgis.Info)
    # ====================================================================================================
    # Get jira to zoom to - Repeat
    def onClicked_OnaJirar(self):
        jira = self.jira_rlisti.currentText()
        aina = ""
        if '(Point)' in jira:
            jira = jira.replace("(Point)", "")
            jira = jira.strip().replace("-", "_").lower()
            aina = "Nukta"
        elif '(Line)' in jira:
            jira = jira.replace("(Line)", "")
            jira = jira.strip().replace("-", "_").lower()
            aina = "Mstari"
        elif '(Polygon)' in jira:
            jira = jira.replace("(Polygon)", "")
            jira = jira.strip().replace("-", "_").lower()
            aina = "Mzingo"

        modeli = self.takwimu_rmeza.model()
        selected_indexes = self.takwimu_rmeza.selectionModel().selectedRows()
        vichwa = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
        # values = [model.data(model.index(selected_row_index, col)) for col in range(model.columnCount())]
        jira_index = [i for i, x in enumerate(vichwa) if x == jira]

        if selected_indexes:
            selected_row_index = selected_indexes[0].row()
            if jira in vichwa:
                jira_value = modeli.index(selected_row_index, jira_index[0]).data(Qt.DisplayRole)
                jira_value = jira_value.replace("'", '"')
                self.zoom_to_wkt(jira_value, aina)
            else:
                QgsMessageLog.logMessage(f"Error: Location column", "FooODK", Qgis.Info)
        else:
            QgsMessageLog.logMessage(f"Error: No location", "FooODK", Qgis.Info)
    # ====================================================================================================
    # Get jira to zoom to - Audit
    def onClicked_OnaJiraAudit(self):
        modeli = self.takwimu_tab4_meza.model()
        selected_indexes = self.takwimu_tab4_meza.selectionModel().selectedRows()
        if selected_indexes:
            selected_row_index = selected_indexes[0].row()
            jira_lat = modeli.index(selected_row_index, 4).data(Qt.DisplayRole)
            jira_lon = modeli.index(selected_row_index, 5).data(Qt.DisplayRole)
            jira_alt = modeli.index(selected_row_index, 6).data(Qt.DisplayRole) or 0
            if jira_lat and jira_lon:
                jira_value = {'type':'Point', 'coordinates': f"[{jira_lon}, {jira_lat}, {jira_alt}]" }
                self.zoom_to_wkt(jira_value, "Nukta")
            else:
                QgsMessageLog.logMessage(f"Error: Location column", "FooODK", Qgis.Info)
        else:
            QgsMessageLog.logMessage(f"Error: No location", "FooODK", Qgis.Info)
    # ====================================================================================================
    def data_ploti_a(self):
        try:
            modeli = self.takwimu_meza.model()  # get the model
            headers = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
            # loop through rows
            modeli_meza = []
            for row in range(modeli.rowCount()):
                row_dict = {}
                for col in range(modeli.columnCount()):
                    index = modeli.index(row, col)
                    row_dict[headers[col]] = modeli.data(index)
                modeli_meza.append(row_dict)

            jina = self.fomu_listi.currentText()
            ainaJira = self.jira_listi.currentText()
            if '(Point)' in ainaJira:
                jira_jina = ainaJira.split('(Point)')
                jira_jinb = jira_jina[0].strip().replace("-", "_").lower()
                self.data_ploti_b(modeli_meza, jira_jinb, jina)
            elif '(Line)' in ainaJira:
                jira_jina = ainaJira.split('(Line)')
                jira_jinb = jira_jina[0].strip().replace("-", "_").lower()
                self.data_ploti_c(modeli_meza, jira_jinb, jina)
            elif '(Polygon)' in ainaJira:
                jira_jina = ainaJira.split('(Polygon)')
                jira_jinb = jira_jina[0].strip().replace("-", "_").lower()
                self.data_ploti_d(modeli_meza, jira_jinb, jina)
            else:
                self.data_ploti_f(modeli_meza, jina)
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: {str(e)}", "FooODK", Qgis.Info)
        return None
    # ====================================================================================================
    def data_ploti_ar(self):
        try:
            modeli = self.takwimu_rmeza.model()  # get the model
            headers = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
            # loop through rows
            modeli_meza = []
            for row in range(modeli.rowCount()):
                row_dict = {}
                for col in range(modeli.columnCount()):
                    index = modeli.index(row, col)
                    row_dict[headers[col]] = modeli.data(index)
                modeli_meza.append(row_dict)

            jina = self.fomu_listi.currentText()
            jinar = self.rudia.currentText()
            ainaJira = self.jira_rlisti.currentText()
            if '(Point)' in ainaJira:
                jira_jina = ainaJira.split('(Point)')
                jira_jinb = jira_jina[0].strip().replace("-", "_").lower()
                self.data_ploti_b(modeli_meza, jira_jinb, f"{jina}_repeat-{jinar}")
            elif '(Line)' in ainaJira:
                jira_jina = ainaJira.split('(Line)')
                jira_jinb = jira_jina[0].strip().replace("-", "_").lower()
                self.data_ploti_c(modeli_meza, jira_jinb, f"{jina}_repeat-{jinar}")
            elif '(Polygon)' in ainaJira:
                jira_jina = ainaJira.split('(Polygon)')
                jira_jinb = jira_jina[0].strip().replace("-", "_").lower()
                self.data_ploti_d(modeli_meza, jira_jinb, f"{jina}_repeat-{jinar}")
            else:
                self.data_ploti_f(modeli_meza, f"{jina}_repeat-{jinar}")
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: {str(e)}", "FooODK", Qgis.Info)
        return None
    # ====================================================================================================
    def onClicked_shusha(self):
        QMessageBox.warning(self, "Error", "Ona kwa shuda")
    # ====================================================================================================
    # Tunza picha moja
    def save_img_jira_one(self):
        wekaFil = self.view_path.text()  # file pth
        viewUid = self.view_uuid.text()  # file pth
        wekaLat = self.latitude_edit.text().strip()  # Remove whitespace
        wekaLon = self.longitude_edit.text().strip()
        wekaAlt = self.altitude_edit.text().strip()
        wekaDat = self.datetime_edit.text().strip()
        wekaDes = self.decription_edit.text().strip()

        def is_number(s):
            # Check if string is a valid number (int or float, positive or negative)
            try:
                float(s)  # Try converting to float
                return True
            except ValueError:
                return False

        if wekaFil and viewUid and wekaDat and wekaDes and wekaFil.endswith('.jpg'):
            if not is_number(wekaLat):
                QgsMessageLog.logMessage(f"Error: No latitude", "FooODK", Qgis.Info)
            elif not is_number(wekaLon):
                QgsMessageLog.logMessage(f"Error: No longitude", "FooODK", Qgis.Info)
            elif not is_number(wekaAlt):
                QgsMessageLog.logMessage(f"Error: No altitude", "FooODK", Qgis.Info)
            else:
                # All inputs are valid numbers
                lat = float(wekaLat)
                lon = float(wekaLon)
                alt = float(wekaAlt)

                # Open file dialog
                view_uuid = viewUid.replace(":", "-")
                file_path, _ = QFileDialog.getSaveFileName(
                    None,  # Parent window
                    "Save Image As",  # Dialog title
                    view_uuid,  # Default file name
                    "Images (*.jpg *.jpeg *.png *.bmp *.tiff);;All Files (*)"  # File filters
                )

                if not file_path:  # User cancelled the dialog
                    return None

                # Ensure the file has an extension
                if '.' not in file_path.split('/')[-1]:
                    # If no extension provided, default to .jpg
                    file_path += ".jpg"

                self.set_exif_data(wekaFil, file_path, lat, lon, alt, wekaDat, wekaDes)
        else:
            QgsMessageLog.logMessage(f"Error: Some image metadata are missing", "FooODK", Qgis.Info)
    # ====================================================================================================
    # Tunza picha zote
    def save_img_jira_all(self):
        QMessageBox.warning(self, "Next Version", "Under Development")
    # ====================================================================================================
    # Pakia Picha Metadata
    def pakia_img_meta(self):
        vichwa = []
        aUUID = self.view_uuid.text()
        jina = self.pakia_mael_img.currentText()
        jira = self.pakia_jira_img.currentText()
        if aUUID:
            aModeli = self.takwimu_meza.model()
            if aModeli is None:
                QgsMessageLog.logMessage(f"Error: Problem with data table", "FooODK", Qgis.Info)
            else:
                for col in range(aModeli.columnCount()):
                    kichwa = aModeli.headerData(col, Qt.Horizontal)
                    vichwa.append(kichwa)
                for row in range(aModeli.rowCount()):
                    index = aModeli.index(row, 1)
                    value = aModeli.data(index)
                    #jina_value = ""
                    #jira_value = ""
                    if str(value) == str(aUUID):
                        if jina != "--Select Description--" and jira != "--Select Location--":
                            jina = jina.strip().replace("-", "_").lower()
                            jina_index = [i for i, x in enumerate(vichwa) if x == jina]
                            jina_value = aModeli.index(row, jina_index[0]).data()
                            if '(Point)' in jira:
                                jira = jira.replace("(Point)", "")
                                jira = jira.strip().replace("-", "_").lower()
                                jira_index = [i for i, x in enumerate(vichwa) if x == jira]
                                jira_value = aModeli.index(row, jira_index[0]).data()
                            elif '(Line)' in jira:
                                ainajiraA = None #aJira.replace("(Line)", "").strip()
                            elif '(Polyline)' in jira:
                                ainajiraA = None #aJira.replace("(Polyline)", "").strip()
                            else:
                                ainajiraA = None
                                QMessageBox.warning(self, "Warning", "No location Data Selected, Please enter below")
                                QgsMessageLog.logMessage(f"Error: o location Data Selected", "FooODK", Qgis.Info)
                            # If found, get the value
                            if jina_value and jira_value:
                                jira_value = jira_value.replace("'", '"')
                                jira_data = ast.literal_eval(jira_value)
                                x = jira_data['coordinates'][0]  # longitude
                                y = jira_data['coordinates'][1]  # longitude
                                z = jira_data['coordinates'][2]  # elevation
                                # longitude, latitude, altitude
                                self.latitude_edit.setText(f"{y:.6f}")
                                self.longitude_edit.setText(f"{x:.6f}")
                                self.altitude_edit.setText(f"{z:.2f}")
                                self.decription_edit.setText(jina_value)
                            else:
                                QgsMessageLog.logMessage(f"Error: No data 1", "FooODK", Qgis.Info)
                        else:
                            QgsMessageLog.logMessage(f"Error: No data 2", "FooODK", Qgis.Info)
        else:
            QgsMessageLog.logMessage(f"Error: No data 3", "FooODK", Qgis.Info)

    def convert_to_degrees(self, value):
        """Convert GPS coordinates stored in EXIF to degrees in float format"""
        d = Decimal(value[0][0]) / Decimal(value[0][1])
        m = Decimal(value[1][0]) / Decimal(value[1][1])
        s = Decimal(value[2][0]) / Decimal(value[2][1])
        return float(d + (m / 60) + (s / 3600))
    # =====================================================================================
    def get_metadata(self, picha_meta):
        try:
            # ----------------------------------------------------------------------------------------
            metadata = {}
            exif_dict = picha_meta
            gps_ifd = exif_dict.get("GPS", {})

            # --- GPS Coordinates ---
            if 'GPS' in exif_dict:
                # GPSLatitude (2) and GPSLatitudeRef (1) must be present
                if 2 in gps_ifd and 1 in gps_ifd:
                    gps_info = exif_dict['GPS']
                    # Latitude
                    lat = self.convert_to_degrees(gps_info[2])
                    if gps_info[1] == b'S':
                        lat = -lat

                    # Longitude
                    lon = self.convert_to_degrees(gps_info[4])
                    if gps_info[3] == b'W':
                        lon = -lon

                    metadata['latitude'] = lat
                    metadata['longitude'] = lon

                    # Altitude
                    if 6 in gps_info:  # GPSAltitude tag
                        alt_value = gps_info[6]
                        altitude = float(alt_value[0]) / float(alt_value[1])
                        if 5 in gps_info and gps_info[5] == 1:  # GPSAltitudeRef == 1 means below sea level
                            altitude = -altitude
                        metadata['altitude'] = altitude
                    else:
                        metadata['altitude'] = "N/A"
                else:
                    metadata['latitude'] = "N/A"
                    metadata['longitude'] = "N/A"
                    metadata['altitude'] = "N/A"

            else:
                metadata['latitude'] = "N/A"
                metadata['longitude'] = "N/A"
                metadata['altitude'] = "N/A"

            # --- Date Taken ---
            # Stored in 'Exif' section under tag 36867 = DateTimeOriginal
            if 'Exif' in exif_dict:
                exif_info = exif_dict['Exif']
                datetime_tag = 36867  # DateTimeOriginal
                if datetime_tag in exif_info:
                    metadata['date_taken'] = exif_info[datetime_tag].decode('utf-8')
                else:
                    metadata['date_taken'] = "N/A"
            else:
                metadata['date_taken'] = "N/A"

            description = None
            # Check IFD0 (Image) tags for ImageDescription
            if "0th" in exif_dict and piexif.ImageIFD.ImageDescription in exif_dict["0th"]:
                description = exif_dict["0th"][piexif.ImageIFD.ImageDescription]
                if isinstance(description, bytes):
                    metadata['description'] = description.decode('utf-8', errors='ignore')
                else:
                    metadata['description'] = "N/A"
            else:
                metadata['description'] = "N/A"
            return metadata
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: {e}", "FooODK", Qgis.Info)
            return None
    # =====================================================================================
    # =====================================================================================
    #
    def save_img_jira(self):
        wekaFil = self.view_path.text() # file pth
        wekaLat = self.latitude_edit.text().strip()  # Remove whitespace
        wekaLon = self.longitude_edit.text().strip()
        wekaAlt = self.altitude_edit.text().strip()
        wekaDat = self.datetime_edit.text().strip()
        wekaDes = self.decription_edit.text().strip()

        def is_number(s):
            # Check if string is a valid number (int or float, positive or negative)
            try:
                float(s)  # Try converting to float
                return True
            except ValueError:
                return False

        if not is_number(wekaLat):
            self.tab2_jumbe.setText("Latitude must be a number!")
            self.tab2_jumbe.setStyleSheet("background: red")
        elif not is_number(wekaLon):
            self.tab2_jumbe.setText("Longitude must be a number!")
            self.tab2_jumbe.setStyleSheet("background: red")
        elif not is_number(wekaAlt):
            self.tab2_jumbe.setText("Altitude must be a number!")
            self.tab2_jumbe.setStyleSheet("background: red")
        else:
            # All inputs are valid numbers
            lat = float(wekaLat)
            lon = float(wekaLon)
            alt = float(wekaAlt)

            self.tab2_jumbe.setText(f"Valid coordinates")
            self.tab2_jumbe.setStyleSheet("background: green")
            self.set_exif_data(wekaFil, lat, lon, alt, wekaDat, wekaDes, None)
    # ====================================================================================================
    # ====================================================================================================
    # ====================================================================================================
    # ====================================================================================================
    # ====================================================================================================
    # Chora Nukta
    def ChoraNukta_QGIS(self, Nukta):
        iGeoP = QgsVectorLayer("Point?crs=epsg:4326", "Jira-Nukta", "memory")
        jGeoP = iGeoP.dataProvider()
        jGeoP.addAttributes([QgsField('__id', QVariant.String)])
        jGeoP.addAttributes([QgsField('ziada', QVariant.String)])
        iGeoP.updateFields()
        # --------------------------------------------------------
        try:
            for iterms in Nukta:
                iterm = iterms.split('||')
                iChora = QgsFeature()
                iChora.setGeometry(QgsGeometry.fromWkt(iterm[1]))
                iChora.setAttributes([iterm[0], iterm[2]])
                jGeoP.addFeatures([iChora])
                iGeoP.commitChanges()
                iGeoP.updateFields()
                iGeoP.updateExtents()

            QgsProject.instance().addMapLayer(iGeoP)
            # --------------------------------------------------------
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: {e}", "FooODK", Qgis.Info)
        return None
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # Jira
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================

    # =====================================================================================
    # Onyesha jira nukta inapodondokes
    def addJiraNukta(self, jira):
        # Define your location (longitude, latitude)
        #jina = jira['File Name']
        if jira['Longitude'] and jira['Latitude']:
            jiraLon = float(jira['Longitude'])
            jiraLat = float(jira['Latitude'])

            # Create point in WGS 84
            wgs84 = QgsCoordinateReferenceSystem("EPSG:4326")
            map_crs = iface.mapCanvas().mapSettings().destinationCrs()
            transform = QgsCoordinateTransform(wgs84, map_crs, QgsProject.instance())
            projected_point = transform.transform(QgsPointXY(jiraLon, jiraLat))

            # Clear previous marker if any
            canvas = iface.mapCanvas()
            if hasattr(self, 'marker') and self.marker:
                canvas.scene().removeItem(self.marker)

            # Create a new marker
            self.marker = QgsVertexMarker(self.canvas)
            self.marker.setCenter(projected_point)
            self.marker.setColor(Qt.red)
            self.marker.setIconSize(20)
            self.marker.setIconType(QgsVertexMarker.ICON_CROSS)  # or ICON_BOX, ICON_CIRCLE

            # Zoom to the location
            self.canvas.setCenter(projected_point)
            self.canvas.zoomScale(5000)  # Adjust zoom level (smaller number = more zoomed in)
            self.canvas.refresh()
        else:
            QgsMessageLog.logMessage(f"Error: No coordinates", "FooODK", Qgis.Info)

    # =====================================================================================
    # Onyesha jira mstari inapodondokea
    def addJiraMstari(self, jira):
        if jira['Longitude'] and jira['Latitude']:
            jiraLon = float(jira['Longitude'])
            jiraLat = float(jira['Latitude'])

            # Create point in WGS 84
            wgs84 = QgsCoordinateReferenceSystem("EPSG:4326")
            map_crs = iface.mapCanvas().mapSettings().destinationCrs()
            transform = QgsCoordinateTransform(wgs84, map_crs, QgsProject.instance())
            projected_point = transform.transform(QgsPointXY(jiraLon, jiraLat))

            # Clear previous marker if any
            canvas = iface.mapCanvas()
            if hasattr(self, 'marker') and self.marker:
                canvas.scene().removeItem(self.marker)

            # Create a new marker
            self.marker = QgsVertexMarker(self.canvas)
            self.marker.setCenter(projected_point)
            self.marker.setColor(Qt.red)
            self.marker.setIconSize(20)
            self.marker.setIconType(QgsVertexMarker.ICON_CROSS)  # or ICON_BOX, ICON_CIRCLE

            # Zoom to the location
            self.canvas.setCenter(projected_point)
            self.canvas.zoomScale(5000)  # Adjust zoom level (smaller number = more zoomed in)
            self.canvas.refresh()
        else:
            QgsMessageLog.logMessage(f"Error: No coordinates", "FooODK", Qgis.Info)
    # =====================================================================================
    # Onyesha jira mzingo inapodondokea
    def addJiraMzingo(self, jira):
        if jira['Longitude'] and jira['Latitude']:
            jiraLon = float(jira['Longitude'])
            jiraLat = float(jira['Latitude'])

            # Create point in WGS 84
            wgs84 = QgsCoordinateReferenceSystem("EPSG:4326")
            map_crs = iface.mapCanvas().mapSettings().destinationCrs()
            transform = QgsCoordinateTransform(wgs84, map_crs, QgsProject.instance())
            projected_point = transform.transform(QgsPointXY(jiraLon, jiraLat))

            # Clear previous marker if any
            canvas = iface.mapCanvas()
            if hasattr(self, 'marker') and self.marker:
                canvas.scene().removeItem(self.marker)

            # Create a new marker
            self.marker = QgsVertexMarker(self.canvas)
            self.marker.setCenter(projected_point)
            self.marker.setColor(Qt.red)
            self.marker.setIconSize(20)
            self.marker.setIconType(QgsVertexMarker.ICON_CROSS)  # or ICON_BOX, ICON_CIRCLE

            # Zoom to the location
            self.canvas.setCenter(projected_point)
            self.canvas.zoomScale(5000)  # Adjust zoom level (smaller number = more zoomed in)
            self.canvas.refresh()
        else:
            QgsMessageLog.logMessage(f"Error: No coordinates", "FooODK", Qgis.Info)
    # =====================================================================================
    # =====================================================================================
    # Chora Nukta Takwimu
    def data_ploti_b(self, Nukta, jiraname, jina):
        try:
            point = QgsGeometry.fromWkt("POINT EMPTY")
            iGeoP = QgsVectorLayer("Point?crs=epsg:4326", f"Point-{jina}", "memory")
            jGeoP = iGeoP.dataProvider()
            # --------------------------------------------------------
            fields = QgsFields()
            vichwa = []
            if "repeat" in jina:
                modeli = self.takwimu_rmeza.model()
                vichwa = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
            else:
                modeli = self.takwimu_meza.model()
                vichwa = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
            for kichwa in vichwa:
                # fields.append(QgsField(kichwa, QVariant.String))
                fields.append(QgsField(kichwa, QMetaType.QString))
            jGeoP.addAttributes(fields)
            iGeoP.updateFields()
            # --------------------------------------------------------
            # Convert and add features
            features = []
            for row in Nukta:
                try:
                    location_str = row[jiraname]
                    location = ast.literal_eval(location_str)
                except Exception as e:
                    QgsMessageLog.logMessage(f"Invalid location format: {e}", "FooODK", Qgis.Warning)
                    continue
                if isinstance(location, dict) and 'coordinates' in location:
                    latlon = location
                    lon = float(latlon['coordinates'][0])
                    lat = float(latlon['coordinates'][1])
                    if lon and lat:
                        feat = QgsFeature()
                        feat.setFields(iGeoP.fields())
                        feat.setAttributes([row.get(f.name().lower(), None) for f in iGeoP.fields()])
                        point = QgsGeometry.fromWkt(f"POINT({lon} {lat})")
                        feat.setGeometry(point)
                        features.append(feat)
                    else:
                        QgsMessageLog.logMessage(f"Issues with Location info: Longitude:{lon}||Latitude:{lat}",
                                                 "FooODK", Qgis.Info)
                else:
                    QgsMessageLog.logMessage(f"No Location info: {row}", "FooODK", Qgis.Info)
            if features:
                jGeoP.addFeatures(features)
                iGeoP.updateExtents()
                QgsProject.instance().addMapLayer(iGeoP)
            else:
                QgsMessageLog.logMessage(f"Error: No data", "FooODK", Qgis.Info)
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: {e}", "FooODK", Qgis.Info)
        return None
    '''
        | Data Type | Replacement Constant |
        | --------- | -------------------- |
        | String    | `QMetaType.QString`  |
        | Integer   | `QMetaType.Int`      |
        | Double    | `QMetaType.Double`   |
        | Date      | `QMetaType.QDate`    |
        | Boolean   | `QMetaType.Bool`     |
        
        QgsMessageLog.logMessage("This is an info message", "MyPlugin", Qgis.Info)
        QgsMessageLog.logMessage("This is a warning", "MyPlugin", Qgis.Warning)
        QgsMessageLog.logMessage("This is a critical error", "MyPlugin", Qgis.Critical)
        
    '''
    # =====================================================================================
    # Chora Mstari Takwimu
    def data_ploti_c(self, Mstari, jiraname, jina):
        try:
            iGeoL = QgsVectorLayer("LineString?crs=epsg:4326", f"Line-{jina}", "memory")
            jGeoL = iGeoL.dataProvider()
            # --------------------------------------------------------
            fields = QgsFields()
            vichwa = []
            if "repeat" in jina:
                modeli = self.takwimu_rmeza.model()
                vichwa = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
            else:
                modeli = self.takwimu_meza.model()
                vichwa = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
            for kichwa in vichwa:
                # fields.append(QgsField(kichwa, QVariant.String))
                fields.append(QgsField(kichwa, QMetaType.QString))
            jGeoL.addAttributes(fields)
            iGeoL.updateFields()
            # --------------------------------------------------------
            # Convert and add features
            features = []
            for row in Mstari:
                try:
                    location_str = row[jiraname]
                    location = ast.literal_eval(location_str)
                except Exception as e:
                    QgsMessageLog.logMessage(f"Invalid location format: {e}", "FooODK", Qgis.Warning)
                    continue
                if isinstance(location, dict) and 'coordinates' in location:
                    feat = QgsFeature()
                    feat.setFields(iGeoL.fields())
                    feat.setAttributes([row.get(f.name().lower(), None) for f in iGeoL.fields()])
                    coords = location['coordinates']
                    wkt_coords = [" ".join(map(str, coord)) for coord in coords]
                    line_wkt = f"LINESTRING({', '.join(wkt_coords)})"
                    jira_mstari = QgsGeometry.fromWkt(line_wkt)
                    feat.setGeometry(jira_mstari)
                    features.append(feat)
                else:
                    QgsMessageLog.logMessage(f"Issues with Location info", "FooODK", Qgis.Info)
            else:
                QgsMessageLog.logMessage(f"No Location info: {row}", "FooODK", Qgis.Info)
            if features:
                jGeoL.addFeatures(features)
                iGeoL.updateExtents()
                QgsProject.instance().addMapLayer(iGeoL)
            else:
                QgsMessageLog.logMessage(f"Error: Empty", "FooODK", Qgis.Info)
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: Line/Polyline: {e}", "FooODK", Qgis.Info)
        return None
    # =====================================================================================
    # Chora Mzingo Takwimu
    def data_ploti_d(self, Mzingo, jiraname, jina):
        try:
            iGeoPo = QgsVectorLayer("Polygon?crs=epsg:4326", f"Polygon-{jina}", "memory")
            jGeoPo = iGeoPo.dataProvider()
            # --------------------------------------------------------
            fields = QgsFields()
            vichwa = []
            if "repeat" in jina:
                modeli = self.takwimu_rmeza.model()
                vichwa = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
            else:
                modeli = self.takwimu_meza.model()
                vichwa = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
            for kichwa in vichwa:
                fields.append(QgsField(kichwa, QMetaType.QString))
            jGeoPo.addAttributes(fields)
            iGeoPo.updateFields()
            # --------------------------------------------------------
            # Convert and add features
            features = []
            for row in Mzingo:
                try:
                    location_str = row[jiraname]
                    location = ast.literal_eval(location_str)
                except Exception as e:
                    QgsMessageLog.logMessage(f"Invalid location format: {e}", "FooODK", Qgis.Warning)
                    continue
                if location and isinstance(location, dict):
                    feat = QgsFeature()
                    feat.setFields(iGeoPo.fields())
                    feat.setAttributes([row.get(f.name().lower(), None) for f in iGeoPo.fields()])
                    coords = location['coordinates'][0]
                    wkt_coords = [f"{x} {y}" for x, y, z in coords]
                    mzingo_wkt = f"POLYGON(({', '.join(wkt_coords)}))"
                    jira_mzingo = QgsGeometry.fromWkt(mzingo_wkt)
                    if jira_mzingo.isGeosValid():
                        feat.setGeometry(jira_mzingo)
                        features.append(feat)
                    else:
                        QgsMessageLog.logMessage(f"Invalid geometry for row: {row}", "FooODK", Qgis.Info)
                else:
                    QgsMessageLog.logMessage(f"Issues with Location info in row: {row}", "FooODK", Qgis.Info)
            if features:
                jGeoPo.addFeatures(features)
                iGeoPo.updateExtents()
                QgsProject.instance().addMapLayer(iGeoPo)
            else:
                QgsMessageLog.logMessage(f"No Location info", "FooODK", Qgis.Info)
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: Polygon: {e}", "FooODK", Qgis.Info)
        return None
    # =====================================================================================
    # Angalia kati ya ploti na table
    def data_ploti_e(self, chaguo):
        try:
            if '(Point)' in chaguo or '(Line)' in chaguo or '(Polygon)' in chaguo:
                self.jira_chora.setText("Plot")
            else:
                self.jira_chora.setText("Table")
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: {e}", "FooODK", Qgis.Info)
        return None
    # =====================================================================================
    # Angalia kati ya ploti na subtable
    def data_ploti_er(self, chaguo):
        try:
            if '(Point)' in chaguo or '(Line)' in chaguo or '(Polygon)' in chaguo:
                self.jira_rchora.setText("Plot")
            else:
                self.jira_rchora.setText("Table")
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: {e}", "FooODK", Qgis.Info)
        return None
    # =====================================================================================
    # Chora Nukta Takwimu
    def data_ploti_f(self, Nukta, jina):
        try:
            # Create a table layer (no geometry)
            iGeoP = QgsVectorLayer("None", jina, "memory")
            jGeoP = iGeoP.dataProvider()
            # --------------------------------------------------------
            fields = QgsFields()
            vichwa = []
            if "repeat" in jina:
                modeli = self.takwimu_rmeza.model()
                vichwa = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
            else:
                modeli = self.takwimu_meza.model()
                vichwa = [modeli.headerData(col, Qt.Horizontal) for col in range(modeli.columnCount())]
            for kichwa in vichwa:
                fields.append(QgsField(kichwa, QMetaType.QString))
            jGeoP.addAttributes(fields)
            iGeoP.updateFields()
            # --------------------------------------------------------
            # Add attributes
            features = []
            for row in Nukta:
                feat = QgsFeature(iGeoP.fields())  # Pass fields to constructor
                attributes = []
                for field in iGeoP.fields():
                    # Handle different field name cases
                    attr_value = row.get(field.name().lower()) or row.get(field.name()) or None
                    attributes.append(attr_value)
                feat.setAttributes(attributes)
                features.append(feat)

            if features:
                jGeoP.addFeatures(features)
                iGeoP.updateExtents()
                QgsProject.instance().addMapLayer(iGeoP)
            else:
                QgsMessageLog.logMessage(f"No attribute info", "FooODK", Qgis.Info)
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: {e}", "FooODK", Qgis.Info)
        return None
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # Audits
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    # Plot Oditi
    def oditi_ploti_b(self, Nukta):
        try:
            point = QgsGeometry.fromWkt("POINT EMPTY")
            iGeoP = QgsVectorLayer("Point?crs=epsg:4326", "Audit Data (Point)", "memory")
            jGeoP = iGeoP.dataProvider()
            jtems = oditi_vichwa = ['Event', 'Node', 'Start', 'End', 'Latitude', 'Longitude', 'Accuracy',
                                    'Old Value', 'New Value', 'Time(Minutes)']
            # --------------------------------------------------------
            fields = QgsFields()
            fields.append(QgsField('event', QVariant.String))
            fields.append(QgsField('node', QVariant.String))
            fields.append(QgsField('start', QVariant.String))  # Double
            fields.append(QgsField('end', QVariant.String))  # Double
            fields.append(QgsField('latitude', QVariant.String))  # Double
            fields.append(QgsField('longitude', QVariant.String))  # Double
            fields.append(QgsField('accuracy', QVariant.String))  # Double
            fields.append(QgsField('old value', QVariant.String))  # Double
            fields.append(QgsField('new value', QVariant.String))  # Double
            fields.append(QgsField('time_minutes', QVariant.String))  # Double
            jGeoP.addAttributes(fields)
            iGeoP.updateFields()

            features = []
            for row in Nukta:
                ilat = row.get('Latitude', 'Null')
                ilon = row.get('Longitude', 'Null')
                if ilat and ilon:
                    # Create feature
                    feat = QgsFeature()
                    feat.setFields(iGeoP.fields())
                    # feat.setAttributes([row.get(f.name().lower(), None) for f in iGeoP.fields()])
                    for f in iGeoP.fields():
                        jina = f.name()
                        para = jina.capitalize()
                        if jina == 'Time(Minutes)':
                            feat.setAttribute('time_minutes', row.get(f.name(), "Null"))
                        else:
                            feat.setAttribute(jina, row.get(para, "Null"))

                    lon = float(ilon)
                    lat = float(ilat)
                    point = QgsGeometry.fromWkt(f"POINT({lon} {lat})")
                    feat.setGeometry(point)
                    features.append(feat)
                # Add features
                jGeoP.addFeatures(features)
                iGeoP.updateExtents()
                # Add layer to project
                QgsProject.instance().addMapLayer(iGeoP)
        except Exception as e:
            QgsMessageLog.logMessage(f"Error: Skipping feature {e}", "FooODK", Qgis.Info)
        return None

    # =====================================================================================
    def pakia_auditi_faili(self, auditimsimbo):
        #modeli = QStandardItemModel()
        modeli = self.takwimu_tab4_meza.model()
        headers = ['Event', 'Node', 'Start', 'End', 'Latitude', 'Longitude', 'Accuracy', 'Old Value', 'New Value',
                   "Time(Minutes)"]
        #modeli.setHorizontalHeaderLabels(headers)
        try:
            kichwa = {"Authorization": f"Bearer {session_token}", "Accept": "application/json"}
            auditi_response = requests.get(auditimsimbo, headers=kichwa)
            if auditi_response.status_code == 200:
                csv_data = auditi_response.content.decode('utf-8')

                csv_file = StringIO(csv_data)
                reader = csv.DictReader(csv_file)
                for row in reader:
                    row_items = []
                    for header in headers:
                        value = ""
                        if header == "Event":
                            value = row.get("event", "N/A")
                        elif header == "Node":
                            value = row.get("node", "N/A")
                        elif header == "Start":
                            value = row.get("start", "N/A")
                        elif header == "End":
                            value = row.get("end", "N/A")
                        elif header == "Latitude":
                            value = row.get("latitude", "N/A")
                        elif header == "Longitude":
                            value = row.get("longitude", "N/A")
                        elif header == "Old Value":
                            value = row.get("oldvalues", "N/A")
                        elif header == "New Value":
                            value = row.get("new value", "N/A")
                        elif header == "Time(Minutes)":
                            a3d = row['start']
                            a4d = row['end']
                            if a3d and a4d:
                                value = (float(a4d) - float(a3d)) / 60000
                            else:
                                value = "N/A"

                        row_items.append(QStandardItem(str(value)))
                    modeli.appendRow(row_items)
                #self.takwimu_tab4_meza.setModel(modeli)
                self.takwimu_tab4_meza.resizeColumnsToContents()
            else:
                QMessageBox.warning(self, "FooODK-Warning", "Connection issue")
        except Exception as e:
            QMessageBox.warning(self,"FooODK-Warning", f"Error loading CSV: {e}")

    '''
    Core audit file headers
        1. event → the type of action (form start, question, group, form save, form exit, etc.)
        2. node → the question or group name (relevant for question-related events)
        3. start → timestamp (milliseconds since epoch) when the event started
        4. end → timestamp when the event ended
        5. user → (optional) username if user tracking is enabled
        6. latitude → (optional) if location-tracking is enabled
        7. longitude → (optional) if location-tracking is enabled
        8. accuracy → (optional) GPS accuracy if location tracking is on
        9. old-value → (optional) previous answer when track-changes is enabled
        10. new-value → (optional) new answer when track-changes is enabled
    '''
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # Picha
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    def pakia_picha_faili(self, pichamsimbo, aidi):
        try:
            try:
                import piexif
            except:
                QMessageBox.warning(self, "Error", f"Issues with plugin: {e}")
                self.tab_widget.setCurrentIndex(4)
                self.tab_kuhusu.setCurrentIndex(1)
                return None
            # ------------------------------------------------------------------------------------------
            kichwa = {"Authorization": f"Bearer {session_token}", "Accept": "application/json"}
            picha_response = requests.get(pichamsimbo, headers=kichwa)
            if picha_response.status_code == 200:
                pil_image = Image.open(BytesIO(picha_response.content))
                pil_image = pil_image.convert("RGBA")
                data = pil_image.tobytes("raw", "RGBA")
                qimage = QImage(data, pil_image.width, pil_image.height, QImage.Format_RGBA8888)
                pixmap = QPixmap.fromImage(qimage)

                if pixmap.isNull():
                    QMessageBox.warning(self, "FooODK-Error", "Pillow Error")
                else:
                    #self.image_label.adjustSize()
                    # Scale with high-DPI support
                    scaled_pixmap = pixmap.scaled(self.image_label.size(), Qt.KeepAspectRatio, Qt.SmoothTransformation)
                    # Center and display the image
                    self.image_label.setPixmap(scaled_pixmap)
                    self.image_label.setAlignment(Qt.AlignCenter)  # Ensure centered

                    # Metadata
                    pil_image_info = piexif.load(pil_image.info.get("exif", b""))
                    if pil_image_info:
                        metadata = self.get_metadata(pil_image_info)
                        self.view_path.setText(pichamsimbo)
                        self.view_uuid.setText(aidi)
                        self.latitude_edit.setText(metadata.get("latitude"))
                        self.longitude_edit.setText(metadata.get("longitude"))
                        self.altitude_edit.setText(metadata.get("altitude"))

                        # self.datetime_edit.setText(metadata.get("date_taken"))
                        self.decription_edit.setText(metadata.get("description"))
                    else:
                        QgsMessageLog.logMessage(f"No EXIF metadata found.", "FooODK", Qgis.Info)

        except Exception as e:
            QMessageBox.warning(self,"FooODK-Warning", f"Error loading image via PIL: {e}")
    # =====================================================================================
    def has_latitude(image_path):
        try:
            exif_dict = piexif.load(image_path)
            gps_ifd = exif_dict.get("GPS", {})
            # GPSLatitude (2) and GPSLatitudeRef (1) must be present
            if 2 in gps_ifd and 1 in gps_ifd:
                return True
            else:
                return False
        except Exception as e:
            QMessageBox.warning("FooODK", f"Error reading EXIF from {image_path}: {e}")
            return False
    # =====================================================================================
    # Degreea => Decimal to DDMMSS
    def deg_to_dms_rational(self, deg):
        """Convert decimal degrees to degrees, minutes, seconds tuple for EXIF."""
        d = int(deg)
        md = abs(deg - d) * 60
        m = int(md)
        sd = (md - m) * 60
        return ((abs(d), 1), (m, 1), (int(sd * 100), 100))
    # =====================================================================================
    # Update location
    def set_gps_location(self, exif_dict, lat, lng, alt):
        # Latitude
        lat_ref = 'N' if lat >= 0 else 'S'
        exif_dict['GPS'][piexif.GPSIFD.GPSLatitudeRef] = lat_ref.encode()
        exif_dict['GPS'][piexif.GPSIFD.GPSLatitude] = self.deg_to_dms_rational(lat)

        # Longitude
        lng_ref = 'E' if lng >= 0 else 'W'
        exif_dict['GPS'][piexif.GPSIFD.GPSLongitudeRef] = lng_ref.encode()
        exif_dict['GPS'][piexif.GPSIFD.GPSLongitude] = self.deg_to_dms_rational(lng)

        # Altitude
        exif_dict['GPS'][piexif.GPSIFD.GPSAltitudeRef] = 0  # 0 = above sea level
        exif_dict['GPS'][piexif.GPSIFD.GPSAltitude] = (int(alt * 100), 100)  # meters

    def is_object(self, param):
        return not isinstance(param, (int, float, str, bool, list, tuple, dict, set, type(None)))

    def update_datetime(self, exif_dict, tarehe):
        exif_dict['Exif'][piexif.ExifIFD.DateTimeOriginal] = tarehe

    def update_description(self, exif_dict, description):
        user_comment = description.encode('utf-8')
        exif_dict['0th'][piexif.ImageIFD.ImageDescription] = user_comment

    # =====================================================================================
    def set_exif_data(self, img_msimbo, img_jina,  lat, lng, alt, idatetime, description):
        if session_token:
            kichwa = {"Authorization": f"Bearer {session_token}", "Accept": "application/json"}
            picha_response = requests.get(img_msimbo, headers=kichwa)

            if picha_response.status_code == 200:
                try:
                    # Create PIL image from response
                    pil_image = Image.open(BytesIO(picha_response.content))
                    pil_image = pil_image.convert("RGBA")

                    # Create Qt image for display (if needed)
                    data = pil_image.tobytes("raw", "RGBA")
                    qimage = QImage(data, pil_image.width, pil_image.height, QImage.Format_RGBA8888)
                    pixmap = QPixmap.fromImage(qimage)

                    # Initialize EXIF data
                    try:
                        exif_dict = piexif.load(pil_image.info.get("exif", b""))
                    except (KeyError, piexif.InvalidImageDataError, AttributeError):
                        exif_dict = {"0th": {}, "Exif": {}, "GPS": {}, "1st": {}, "thumbnail": None}

                    # Ensure required EXIF sections exist
                    exif_dict.setdefault('GPS', {})
                    exif_dict.setdefault('0th', {})

                    # Validate and set GPS data if coordinates are provided
                    if all(isinstance(v, (int, float)) for v in [lat, lng, alt]):
                        self.set_gps_location(exif_dict, lat, lng, alt)

                    # Set datetime if provided
                    if idatetime:
                        self.update_datetime(exif_dict, idatetime)

                    # Set description if provided
                    if description:
                        self.update_description(exif_dict, description)

                    # Convert back to RGB for JPEG saving (if needed)
                    if img_jina.lower().endswith('.jpg') or img_jina.lower().endswith('.jpeg'):
                        pil_image = pil_image.convert("RGB")

                    # Save with EXIF data
                    exif_bytes = piexif.dump(exif_dict)
                    pil_image.save(img_jina, exif=exif_bytes)

                except Exception as e:
                    QMessageBox.critical(self, "Error", f"Failed to process image: {str(e)}")
            else:
                QMessageBox.warning(self, "Connection",
                                    f"Connection Issues - Status Code: {picha_response.status_code}")
        else:
            QMessageBox.warning(self, "Token", "Invalid or missing session token")
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # About & Help
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    def load_help_page(self):
        icon_path = os.path.join(os.path.dirname(__file__), "help.html")
        self.help_browser.setSource(QUrl.fromLocalFile(icon_path))

    def load_about_page(self):
        icon_path = os.path.join(os.path.dirname(__file__), "about.html")
        self.about_browser.setSource(QUrl.fromLocalFile(icon_path))
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # Dependencies
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================
    def check_packages(self):
        maktaba_zilizokosekana = []
        try:
            import PIL
            self.bt_pillow.setEnabled(False)
        except ImportError:
            self.bt_pillow.setEnabled(True)
            maktaba_zilizokosekana.append("Pillow")
        # -------------------------------------------------------------------------------------
        try:
            import piexif
            self.bt_piexif.setEnabled(False)
        except ImportError:
            self.bt_piexif.setEnabled(True)
            maktaba_zilizokosekana.append("Piexif")
        # -------------------------------------------------------------------------------------
        try:
            import wordcloud
            self.bt_wordcount.setEnabled(False)
        except ImportError:
            self.bt_wordcount.setEnabled(True)
            maktaba_zilizokosekana.append("Wordcloud")
        # -------------------------------------------------------------------------------------
        try:
            import pandas
            self.bt_pandas.setEnabled(False)
        except ImportError:
            self.bt_pandas.setEnabled(True)
            maktaba_zilizokosekana.append("pandas")
        # -------------------------------------------------------------------------------------
        try:
            import matplotlib
            self.bt_matplotlib.setEnabled(False)
        except ImportError:
            self.bt_matplotlib.setEnabled(True)
            maktaba_zilizokosekana.append("matplotlib")
        # -------------------------------------------------------------------------------------
        if maktaba_zilizokosekana:
            maktaba = ", ".join(maktaba_zilizokosekana)
            QMessageBox.warning(self, "FooODK", f"Missing:  {maktaba} (Please Install)")
            self.tab_widget.setCurrentIndex(4)
            self.tab_kuhusu.setCurrentIndex(1)
    # =====================================================================================
    def weka_package(self, jina):
        qgis_python = os.path.join(os.path.dirname(sys.executable), 'bin', 'python3')
        try:
            #subprocess.check_call([qgis_python, "-m", "pip", "install", jina])
            subprocess.check_call([qgis_python, "-m", "pip", "install", "--upgrade", jina])
            QMessageBox.warning(self, "Success", f"{jina} installed successfully")
        except subprocess.CalledProcessError as e:
            QMessageBox.warning(self, "Success", f"Error installing {jina}: {e}")
    # -------------------------------------------------------------------------------------
    def chatu_toleo(self):
        toleo = sys.version
        QMessageBox.warning(self, "FooODK", f"QGIS Python: {toleo}")

    def weka_plagini_a(self):
        self.weka_package("piexif")

    def weka_plagini_b(self):
        self.weka_package("Pillow>=9.0.0")

    def weka_plagini_c(self):
        self.weka_package("wordcloud")

    def weka_plagini_d(self):
        self.weka_package("pandas")

    def weka_plagini_e(self):
        self.weka_package("matplotlib")
    # -------------------------------------------------------------------------------------
    # Pakia Modules, Libraries & plugins
    def load_list_modules(self):
        try:
            i = 1
            # ------------------------------------------------------------
            # Modules - Builtin
            plagini_modeli = QStandardItem("Modules (Built-in)")
            plagini_modelj = QStandardItem("Modules")
            for kii, value in sys.modules.items():
                if "built-in" in str(value):
                    mod_a = QStandardItem("A")
                    mod_b = QStandardItem(str(i))
                    mod_c = QStandardItem(str(value.__name__))
                    mod_d = QStandardItem(str("Module"))
                    mod_e = QStandardItem("N/A")
                    plagini_modeli.appendRow([mod_a, mod_b, mod_c, mod_d, mod_e])
                else:
                    mod_a = QStandardItem("B")
                    mod_b = QStandardItem(str(i))
                    mod_c = QStandardItem(str(kii))
                    mod_d = QStandardItem(str("Module"))
                    mod_e = QStandardItem("N/A")
                    plagini_modelj.appendRow([mod_a, mod_b, mod_c, mod_d, mod_e])
                i = i + 1
            self.modulu_model.appendRow(plagini_modeli)
            self.modulu_model.appendRow(plagini_modelj)
            # ------------------------------------------------------------
            # Plugins
            plagini_modelk = QStandardItem("Plugins")
            for plugin_name in available_plugins:
                metadata = pluginMetadata(plugin_name, 'name') or plugin_name
                version = pluginMetadata(plugin_name, 'version') or 'N/A'
                mod_a = QStandardItem("C")
                mod_b = QStandardItem(str(i))
                mod_c = QStandardItem(metadata)
                mod_d = QStandardItem(plugin_name)
                mod_e = QStandardItem(version)
                plagini_modelk.appendRow([mod_a, mod_b, mod_c, mod_d, mod_e])
                i = i + 1
            self.modulu_model.appendRow(plagini_modelk)
            # ------------------------------------------------------------
            # Env. Variables
            plagini_modell = QStandardItem("Environmental Variables")
            for kii, valu in os.environ.items():
                mod_a = QStandardItem("D")
                mod_b = QStandardItem(str(i))
                mod_c = QStandardItem(str(kii))
                mod_d = QStandardItem(str(valu))
                mod_e = QStandardItem("N/A")
                plagini_modell.appendRow([mod_a, mod_b, mod_c, mod_d, mod_e])
                i = i + 1
                self.modulu_model.appendRow(plagini_modell)
            # ------------------------------------------------------------
        except Exception as e:
            QMessageBox.warning(self, "FooODK", f"Error: {e}")
            return False
    # =====================================================================================
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # ???
    # =====================================================================================
    # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    # =====================================================================================
    # =====================================================================================


